package com.yeejoin.amos.boot.module.common.api.feign;

import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.amos.boot.module.common.api.dto.CreatExamDto;
import feign.codec.Encoder;
import feign.form.spring.SpringFormEncoder;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

@FeignClient(name = "${amosTraining.fegin.name:AMOS-TRAININGEXAM}", path = "trainingexam", configuration = {MultipartSupportConfig.class})
public interface AmosTrainingFeignClient {

		@RequestMapping(value = "/trainingProject/update/operation/number", method = RequestMethod.PUT)
	    @ApiOperation(httpMethod = "PUT", value = "修改人员编号", notes = "修改人员编号")
	    public ResponseModel<Boolean> updOperationNumber(@RequestParam String newNumber,@RequestParam String oldNumber) ;
		
		@RequestMapping(value = "/examTemplate/templateSelectSubject", method = RequestMethod.POST)
		ResponseModel<Long> doTemplateExam(@RequestBody CreatExamDto creatExamDto);

		class Configuration {
			@Bean
			Encoder feignFormEncoder(ObjectFactory<HttpMessageConverters> converters) {
				return new SpringFormEncoder(new SpringEncoder(converters));
			}
		}

		@RequestMapping(value = "/examTemplate/findExamTemplateBySubjectBankType", method = RequestMethod.GET)
		ResponseModel<List<Map<String, Object>>> getTemplateInSubjectBankType(@RequestParam String subjectBankType);

		/**
		 * 考试状态统计
		 * @param userId 用户
		 * @return List<Map<String, Object>>
		 */
		@GetMapping("/v1/examination/examStatistics/{userId}")
		ResponseModel<Map<String, Object>> getExamStatisticsData(@PathVariable String userId);

		/**
		 * 查询考试列表
		 * @return
		 */
		@GetMapping("/v1/examination/onlineExamPage?pageSize=10&pageNum=1&flag=online&examinationName=")
		ResponseModel<PageInfo> getExamStatisticsList();

		@RequestMapping(value = "/studyPlan/userId/list", method = RequestMethod.GET)
		ResponseModel<List<String>> getUserIdList();

}
