package com.yeejoin.amos.boot.module.common.api.feign;

import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.amos.boot.module.common.api.dto.OrgUserVO;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.GroupUserModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/3/29
 */
@FeignClient(name ="${privilege.fegin.name:AMOS-API-PRIVILEGE}", path = "", configuration = {MultipartSupportConfig.class})
public interface PrivilegeFeignClient {



    @RequestMapping(value = "/privilege/v1/agencyuser", method = RequestMethod.POST)
    ResponseModel<Object> create(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestBody OrgUserVO var1);

    @RequestMapping(value = "/privilege/v1/groupUser", method = RequestMethod.POST)
    ResponseModel<Object> groupUser(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestParam("groupSeq") Long groupSeq, @RequestBody List<String> var2);

}
