package com.yeejoin.equipmanage.common.entity.dto;

import lombok.Data;
import org.typroject.tyboot.core.foundation.utils.TreeNode;

import java.util.Collection;
import java.util.Date;
/**
 * 
 * <pre>
 * 
 * </pre>
 *
 * @author gwb
 * @version $Id: TopographyTreeDTO.java, v 0.1 2021年10月19日 下午1:46:23 gwb Exp $
 */
@Data
public class TopographyTreeDTO implements TreeNode<TopographyTreeDTO,String>  {

	
		/**
         * ID
         */
    private String id;
        /**
         * 编码
         */
    private String code;
        /**
         * 父编码
         */
    private String parentCode;
        /**
         * 名称
         */
    private String name;
        /**
         * 树字段
         */
    private String treeCode;
        /**
         * 分组
         */
    private String topoGroup;
    
    private Date createDate;
    private String createUser;
    private Boolean isDelete;
    private Date updateDate;
    private String updateUser;
        /**
         * 类型：1-网络拓扑图
         */
    private Integer type;
        /**
         * 终点ID   | b_bank_info
         */
    private String endId;
        /**
         * 起点ID   | b_bank_info 
         */
    private String startId;
        /**
         * 部门单位
         */
    private String orgCode;
        /**
         * 组织
         */
    private String authOrg;
    
    private Collection<TopographyTreeDTO> children;

	@Override
	public String getMyParentId()
	{
		return this.parentCode;
	}

	@Override
	public String getMyId()
	{
		return this.code;
	}
    


    @Override
    public int compareTo(TopographyTreeDTO o) {
        TopographyTreeDTO node =  o;
        return node.getMyId().equals(this.code)? 0 : 1;
    }
}
