package com.yeejoin.equipmanage.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author keyong
 * @title: UnitEnum
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2023/1/13 20:44
 */
@Getter
@AllArgsConstructor
public enum IndexStatusEnum {

    LOW("0",  "液位低", ""),
    NORMAL("1", "正常", ""),
    HIGH("2", "液位高", "");

    private String key;

    private String describe1;

    private String describe2;

    public static IndexStatusEnum getEnumByKey(String key) {
        IndexStatusEnum statusEnum = null;
        for (IndexStatusEnum u : IndexStatusEnum.values()) {
            if (u.getKey().equals(key)) {
                statusEnum = u;
                break;
            }
        }
        return statusEnum;
    }
}
