package com.yeejoin.amos.boot.module.jcs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 机场单位消防安全报告
 *
 * @author litw
 * @date 2021-10-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="OrgUsrSafeReportDto", description="机场单位消防安全报告")
public class OrgUsrSafeReportDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "报告名称")
    private String name;

    @ApiModelProperty(value = "报告类型")
    private String type;

    @ApiModelProperty(value = "报告类型code")
    private String typeCode;

    @ApiModelProperty(value = "生效年份")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date takeEffectYear;

    @ApiModelProperty(value = "签订时间")
    private Date signedDate;

    @ApiModelProperty(value = "机构代码用于权限过滤")
    private String orgCode;

    @ApiModelProperty(value = "所属机场单位名称")
    private String company;

    @ApiModelProperty(value = "所属机场单位id")
    private Long companyId;

    @ApiModelProperty(value = "单位类型（1机场单位，0机场部门）")
    private String companyType;

    @ApiModelProperty(value = "责任人")
    private String dutyPerson;

    @ApiModelProperty(value = "责任人Id")
    private String dutyPersonId;


    @ApiModelProperty(value = "附件")
    private Map<String, List<AttachmentDto>> attachments;

    @ApiModelProperty(value = "合同附件")
    private String attachment;
}
