package com.yeejoin.amos.boot.module.jcs.api.enums;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;
import java.util.Map;

/**
 * 
 * <pre>
 * 警情反馈状态枚举
 * </pre>
 *
 * @author tb
 * @version $Id: AlertStatusEnum.java, v 0.1 2021年6月23日 下午5:11:18 gwb Exp $
 */
@Getter
@AllArgsConstructor
public enum AlertFeedbackStatusEnum {

    /**
     * 执行中
     */
	执行中("executing", "执行中"),
    /**
     * 已完成
     */
	已完成("finished", "已完成");

    private String code;

    private String name;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    
	public static AlertFeedbackStatusEnum getEnum(String code)
	{
		for (AlertFeedbackStatusEnum status : AlertFeedbackStatusEnum.values())
		{
			if (status.getCode().equals(code))
			{
				return status;
			}
		}
		return null;
	}

    /**
     * 枚举转列表
     *
     * @return
     */
	public static List<Map<String, String>> toList() {
	    List<Map<String, String>> enumList = Lists.newArrayList();
	    for (AlertFeedbackStatusEnum item : AlertFeedbackStatusEnum.values()) {
	        Map<String, String> map = Maps.newHashMap();
	        map.put("key", item.getCode());
	        map.put("label", item.getName());
	        enumList.add(map);
        }
        return enumList;
    }
}
