package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.MenuFrom;
import com.yeejoin.amos.boot.module.common.api.dto.SpecialPositionStaffDto;
import com.yeejoin.amos.boot.module.common.api.entity.SpecialPositionStaff;
import com.yeejoin.amos.boot.module.common.api.mapper.SpecialPositionStaffMapper;
import com.yeejoin.amos.boot.module.common.api.service.ISpecialPositionStaffService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 特岗人员服务实现类
 *
 * @author system_generator
 * @date 2021-07-23
 */
@Service
public class SpecialPositionStaffServiceImpl extends BaseService<SpecialPositionStaffDto, SpecialPositionStaff,
        SpecialPositionStaffMapper> implements ISpecialPositionStaffService {

    @Autowired
    DataDictionaryServiceImpl dataDictionaryService;

    /**
     * 分页查询
     */
    public Page<SpecialPositionStaffDto> queryForSpecialPositionStaffPage(Page<SpecialPositionStaffDto> page,
                                                                          @Condition(Operator.eq) Long companyId,
                                                                          @Condition(Operator.eq) Boolean isDelete,
                                                                          @Condition(Operator.eq) String positionNameCode) {
        return this.queryForPage(page, null, false, companyId, isDelete, positionNameCode);
    }

    /**
     * 列表查询 示例
     */
    public List<SpecialPositionStaffDto> queryForSpecialPositionStaffList() {
        return this.queryForList("", false);
    }

    /**
     * 批量删除
     *
     * @param sequenceNbrList
     * @return
     */
    public Boolean batchDelete(List<Long> sequenceNbrList) {
        List<SpecialPositionStaff> positionStaffList =
                list(new LambdaQueryWrapper<SpecialPositionStaff>().in(SpecialPositionStaff::getSequenceNbr,
                        sequenceNbrList));
        positionStaffList.forEach(item -> item.setIsDelete(true));
        boolean update = updateBatchById(positionStaffList);
        return update;
    }

    public HashMap<Object, Object> getSpecialPositionStaffList(Long companyId) throws Exception {
        // 查询所有岗位类型
        List<MenuFrom> menuList = dataDictionaryService.getGWMCDataDictionary("GWMC");
        // 查询已有数据的岗位类型
        List<Long> positionStaffCodeList = this.baseMapper.getPositionStaffCodeList(false,companyId);
        // 排除已有数据的，返回
        /*bug 3483 陈召 2021-11-18 开始*/
        //排除父岗位是否已有 有就删除
        List<MenuFrom> dataList = menuList.stream().filter(e -> !positionStaffCodeList.contains(Long.valueOf(e.getKey()))).collect(Collectors.toList());
        for (ListIterator<MenuFrom> iterator = dataList.listIterator();iterator.hasNext();){
            MenuFrom next = iterator.next();
            if (null != next.getChildren() && next.getChildren().size() > 0) {
                //排除子岗位是否已有 有就删除
                List<MenuFrom> newChildren = next.getChildren().stream().filter(e -> !positionStaffCodeList.contains(Long.valueOf(e.getKey()))).collect(Collectors.toList());
                //当子岗位全部删除时 父岗位也删除
                if (ValidationUtil.isEmpty(newChildren)){
                    iterator.remove();
                } else {
                    next.setChildren(newChildren);
                }
            }
        }
        /*bug 3483 陈召 2021-11-18 结束*/
        HashMap<Object, Object> objectObjectHashMap = new HashMap<>();
        objectObjectHashMap.put("GWMC", dataList);
        return objectObjectHashMap;
    }
}