package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.vo.EquipCategoryVo;
import com.yeejoin.equipmanage.service.IStatisticsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 
 *
 * @author wujiang
 * @date 2020-07-07
 */
@RestController
@Api(tags = "统计Api")
@RequestMapping(value = "/statistics", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class StatisticsController {

	@Autowired
	private IStatisticsService iStatisticsService;

	@Value("${state.code:code}")
	private String stationCode;
	/**
	 * 根据基本类型统计总数(按仓库)
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/all-category-base/{warehouseId}", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public Map<String, String> getAllCategoryBaseByWarehouseId(HttpServletRequest request,
			@PathVariable Long warehouseId) {
		return iStatisticsService.getAllCategoryBaseByWarehouseId(warehouseId);
	}


	

	/**
	 * 根据装备状态统计总数(按仓库)
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/equipment-status/{warehouseId}", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public Map<String, String> getEquipmentStatusByWarehouseId(HttpServletRequest request,
			@PathVariable Long warehouseId) {
		return iStatisticsService.getEquipmentStatusByWarehouseId(warehouseId);
	}

	/**
	 * 根据消防车指定类别统计总数
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/car-category/{orgcode}", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public Map<String, String> getCarCategoryByOrgcode(HttpServletRequest request, @PathVariable String orgcode) {
		return iStatisticsService.getCarCategoryByOrgcode(orgcode);
	}

	/**
	 * 根据消防车指定类别统计总数
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/extinguishing-category/{warehouseId}", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public Map<String, String> getExtinguishingCategoryByWarehouseId(HttpServletRequest request,
			@PathVariable Long warehouseId) {
		return iStatisticsService.getExtinguishingCategoryByWarehouseId(warehouseId);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "按照消防系统统计设备台账", notes = "数字换流站系统大屏使用")
	@GetMapping(value = "/{systemCode}/equipCategoryCountList")
	public List<EquipCategoryVo> equipCategoryVoList(@PathVariable String systemCode) {
		return iStatisticsService.equipCategoryVoList(systemCode);
	}
}
