package com.yeejoin.amos.boot.module.jcs.biz.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertNewsDto;
import com.yeejoin.amos.boot.module.jcs.api.service.ICcsToStationUserInfo;
import com.yeejoin.amos.component.rule.config.ClazzUtils;
import com.yeejoin.amos.component.rule.config.RuleConfig;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.component.emq.EmqxListener;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2021/9/16
 */
@Component
public class StartLoader implements ApplicationRunner {
    private final Logger logger = LoggerFactory.getLogger(StartLoader.class);


    @Autowired
    private EmqKeeper emqKeeper;
    @Value("${mqtt.topic.alert.iot}")
    private String topic;
    @Value("${mqtt.topic.alert.iot.web}")
    private String topicweb;

    @Autowired
    ICcsToStationUserInfo ccsToStationUserInfo;

    @Override
    public void run(ApplicationArguments args) throws Exception {
        logger.info("開始監聽物聯警情======================================");
        loadSysParams();
        // 监听中心级登录信息
        ccsToStationUserInfo.saveUserInfoToRedis();

        ccsToStationUserInfo.test();
    }

    public void loadSysParams(){
        try {
            emqKeeper.subscript(topic, 1, new EmqxListener() {
                @Override
                public void processMessage(String s, MqttMessage mqttMessage) throws Exception {
                    byte[] payload = mqttMessage.getPayload();

                    String obj = new String(payload);
                    if (!ValidationUtil.isEmpty(obj)) {
                        JSONObject json = JSON.parseObject(obj);
                        AlertNewsDto alertNewsDto = new AlertNewsDto( "物联警情",
                                "物联设备发生警情，发生位置:"+(json.get("address")!=null?json.get("address").toString():"")+
                                        ",事发单位:"+(json.get("unitInvolvedName")!=null?json.get("unitInvolvedName").toString():"")
                                        +",联系人:"+(json.get("contactUser")!=null?json.get("contactUser").toString():"")
                                        +",联系电话:"+(json.get("contactPhone")!=null?json.get("contactPhone").toString():"")+".请尽快处理！",
                                json.get("id").toString(),  json);
                        emqKeeper.getMqttClient().publish(topicweb, JSON.toJSON(alertNewsDto).toString().getBytes("UTF-8"), 1, false);
                    }
                }
            });
        } catch (Exception e) {
            logger.info("订阅物联警情异常", e);
        }
    }

}
