/*
Navicat MySQL Data Transfer

Source Server         : 172.16.3.100
Source Server Version : 50721
Source Host           : 172.16.3.100:3306
Source Database       : autosys_business_v3.0.0.2

Target Server Type    : MYSQL
Target Server Version : 50721
File Encoding         : 65001

Date: 2021-06-09 16:30:40
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for contingency_original_data
-- ----------------------------
DROP TABLE IF EXISTS `contingency_original_data`;
CREATE TABLE `contingency_original_data` (
  `id` varchar(36) NOT NULL COMMENT 'rule',
  `fire_Equipment_Name` varchar(32) NOT NULL COMMENT '记录类型：消息MESSAGE，操作OPERATE',
  `fire_Equipment_Id` varchar(500) NOT NULL COMMENT '记录内容：文本信息或者json数据',
  `layer` int(11) NOT NULL COMMENT '一级分类',
  `fire_Equipment_Layer` int(11) NOT NULL COMMENT '二级分类',
  `fire_Equipment_Position` varchar(255) DEFAULT NULL COMMENT '图标,url，或者文件名',
  `equipment_Id` int(11) NOT NULL COMMENT '排序',
  `equipment_Name` varchar(255) DEFAULT NULL,
  `mobile` varchar(255) DEFAULT NULL,
  `admin_Name` varchar(255) DEFAULT NULL,
  `camera_Codes` varchar(255) DEFAULT NULL,
  `camera_Ids` varchar(255) DEFAULT NULL,
  `fire_Count` int(11) DEFAULT NULL,
  `confirm` varchar(255) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(50) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(50) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL,
  `batch_No` varchar(36) NOT NULL,
  `picture1` varchar(255) DEFAULT NULL,
  `picture2` varchar(255) DEFAULT NULL,
  `picture4` varchar(255) DEFAULT NULL,
  `picture3` varchar(255) DEFAULT NULL,
  `fire_Truck_Route` varchar(2000) DEFAULT NULL,
  `runstep` bit(1) DEFAULT NULL,
  `step_state` varchar(255) DEFAULT NULL,
  `step` varchar(255) DEFAULT NULL,
  `equipment_position3d` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `INDEX_BATCH_NO` (`batch_No`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='应急预案信息节点定义';

-- ----------------------------
-- Records of contingency_original_data
-- ----------------------------

-- ----------------------------
-- Table structure for contingency_plan
-- ----------------------------
DROP TABLE IF EXISTS `contingency_plan`;
CREATE TABLE `contingency_plan` (
  `id` varchar(36) NOT NULL COMMENT 'rule',
  `record_type` varchar(32) NOT NULL COMMENT '记录类型：消息MESSAGE，操作OPERATE',
  `content` varchar(500) NOT NULL COMMENT '记录内容：文本信息或者json数据',
  `category` varchar(36) NOT NULL COMMENT '一级分类',
  `sub_category` varchar(36) NOT NULL COMMENT '二级分类',
  `icon` varchar(255) DEFAULT NULL COMMENT '图标,url，或者文件名',
  `sort` int(11) NOT NULL COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='应急预案信息节点定义';

-- ----------------------------
-- Records of contingency_plan
-- ----------------------------

-- ----------------------------
-- Table structure for contingency_plan_instance
-- ----------------------------
DROP TABLE IF EXISTS `contingency_plan_instance`;
CREATE TABLE `contingency_plan_instance` (
  `id` varchar(36) NOT NULL COMMENT 'rule',
  `record_type` varchar(32) NOT NULL COMMENT '记录类型：消息MESSAGE，操作OPERATE',
  `category` varchar(36) DEFAULT NULL COMMENT '一级分类',
  `content` varchar(2000) NOT NULL COMMENT '记录内容：文本信息或者json数据',
  `icon` varchar(255) DEFAULT NULL COMMENT '图标,url，或者文件名',
  `sort` int(11) DEFAULT NULL COMMENT '所有节点一起的排序号',
  `sequence_num` int(11) DEFAULT NULL COMMENT '用于显示的序号',
  `batch_no` varchar(36) NOT NULL COMMENT '预案实例编号,暂时无法区分多个火灾，暂时存储报警设备id',
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(50) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(50) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL,
  `tips` varchar(255) DEFAULT NULL,
  `runstate` bit(1) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='应急预案执行记录实例';

-- ----------------------------
-- Records of contingency_plan_instance
-- ----------------------------

-- ----------------------------
-- Table structure for co_access_recording
-- ----------------------------
DROP TABLE IF EXISTS `co_access_recording`;
CREATE TABLE `co_access_recording` (
  `id` bigint(20) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `cardholder_avatar` varchar(100) DEFAULT NULL COMMENT '持卡人头像',
  `cardholder_name` varchar(100) DEFAULT NULL COMMENT '持卡人姓名',
  `cardholder_gender` varchar(100) DEFAULT NULL COMMENT '持卡人性别',
  `card_code` varchar(100) DEFAULT NULL COMMENT '卡号',
  `access_number` varchar(100) DEFAULT NULL COMMENT '门禁编号',
  `cardholder_department` varchar(100) DEFAULT NULL COMMENT '所属部门',
  `access_position` varchar(100) DEFAULT NULL COMMENT '门禁位置',
  `cardholder_character` varchar(100) DEFAULT NULL COMMENT '角色',
  `cross_time` varchar(100) DEFAULT NULL COMMENT '开门时间',
  `in_or_out` tinyint(1) DEFAULT NULL COMMENT '进/出，0-进',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='开门记录';

-- ----------------------------
-- Records of co_access_recording
-- ----------------------------

-- ----------------------------
-- Table structure for co_visitor_recording
-- ----------------------------
DROP TABLE IF EXISTS `co_visitor_recording`;
CREATE TABLE `co_visitor_recording` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `create_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `recording_code` varchar(100) DEFAULT NULL COMMENT '登记号',
  `visitor_time` datetime NOT NULL COMMENT '来访时间',
  `departure_time` datetime DEFAULT NULL COMMENT '离场时间',
  `visitor_name` varchar(100) NOT NULL COMMENT '访客姓名',
  `phone_number` varchar(100) DEFAULT NULL COMMENT '电话',
  `identity_number` varchar(50) DEFAULT NULL,
  `visitors_number` int(11) DEFAULT NULL,
  `visitor_company` varchar(200) DEFAULT NULL,
  `visit_cause` varchar(1023) DEFAULT NULL COMMENT '来访事由',
  `carrying_goods` varchar(1023) DEFAULT NULL COMMENT '携带物品',
  `car_plate` varchar(20) DEFAULT NULL COMMENT '车牌号',
  `target_department` varchar(100) DEFAULT NULL COMMENT '被访部门',
  `target_department_id` varchar(30) DEFAULT NULL COMMENT '被访部门id',
  `host_name` varchar(50) DEFAULT NULL,
  `deleted` bit(1) DEFAULT b'0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `record_code_idx` (`recording_code`) USING BTREE COMMENT '访问记录唯一索引'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='访客记录';

-- ----------------------------
-- Records of co_visitor_recording
-- ----------------------------

-- ----------------------------
-- Table structure for c_plan_classify_tree
-- ----------------------------
DROP TABLE IF EXISTS `c_plan_classify_tree`;
CREATE TABLE `c_plan_classify_tree` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `classify_name` varchar(255) DEFAULT NULL COMMENT '预案分类名称',
  `parent_id` bigint(20) DEFAULT NULL COMMENT '父类id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `creator` varchar(255) DEFAULT NULL COMMENT '创建人',
  `org_code` varchar(255) DEFAULT NULL COMMENT '组织机构',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='预案分类树';

-- ----------------------------
-- Records of c_plan_classify_tree
-- ----------------------------

-- ----------------------------
-- Table structure for c_plan_detail
-- ----------------------------
DROP TABLE IF EXISTS `c_plan_detail`;
CREATE TABLE `c_plan_detail` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '数字预案ID',
  `plan_name` varchar(255) DEFAULT NULL COMMENT '预案名称',
  `code` varchar(255) DEFAULT NULL COMMENT '预案编号',
  `classify_id` bigint(20) DEFAULT NULL COMMENT '预案类型',
  `plan_range` varchar(255) DEFAULT NULL COMMENT '适用范围',
  `edit_org_name` varchar(255) DEFAULT NULL COMMENT '编写部门',
  `edition` varchar(255) DEFAULT NULL COMMENT '版次',
  `implementation_time` datetime DEFAULT NULL COMMENT '实施时间',
  `create_date` datetime NOT NULL COMMENT '录入时间',
  `remark` text COMMENT '备注',
  `status` int(255) DEFAULT NULL COMMENT '预案状态',
  `creator` varchar(255) DEFAULT NULL COMMENT '创建人',
  `reviser` varchar(255) DEFAULT NULL COMMENT '修改人',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `org_code` varchar(255) DEFAULT NULL COMMENT '部门code',
  `is_delete` tinyint(1) DEFAULT '0' COMMENT '删除状态（0、正常，1、删除）',
  `input_time` datetime DEFAULT NULL COMMENT '录入时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='预案详情表';

-- ----------------------------
-- Records of c_plan_detail
-- ----------------------------

-- ----------------------------
-- Table structure for c_plan_doc
-- ----------------------------
DROP TABLE IF EXISTS `c_plan_doc`;
CREATE TABLE `c_plan_doc` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `plan_id` bigint(20) DEFAULT NULL COMMENT '预案ID',
  `doc_id` bigint(20) DEFAULT NULL COMMENT '文档ID',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `is_delete` tinyint(1) DEFAULT NULL COMMENT '删除状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='预案文档关系表';

-- ----------------------------
-- Records of c_plan_doc
-- ----------------------------

-- ----------------------------
-- Table structure for c_plan_equipment
-- ----------------------------
DROP TABLE IF EXISTS `c_plan_equipment`;
CREATE TABLE `c_plan_equipment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `plan_id` bigint(20) DEFAULT NULL COMMENT '预案ID',
  `fire_equipment_id` bigint(20) DEFAULT NULL COMMENT '电力装备ID',
  `create_date` datetime NOT NULL COMMENT '创建时间',
  `is_delete` tinyint(1) DEFAULT NULL COMMENT '删除状态',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='预案电力设备关系表';

-- ----------------------------
-- Records of c_plan_equipment
-- ----------------------------

-- ----------------------------
-- Table structure for c_plan_operation_record
-- ----------------------------
DROP TABLE IF EXISTS `c_plan_operation_record`;
CREATE TABLE `c_plan_operation_record` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT COMMENT '记录ID',
  `plan_id` bigint(20) DEFAULT NULL COMMENT '预案ID',
  `plan_pattern` tinyint(4) DEFAULT NULL COMMENT '运行模式（4、模拟，5、自动）',
  `status` tinyint(4) DEFAULT NULL COMMENT '运行状态（0、运行中，1、完毕，3、中断）',
  `execution_type` tinyint(4) DEFAULT NULL COMMENT '执行方式（0、预案验证 1、火灾处置）',
  `start_time` datetime DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '结束时间',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `batch_no` varchar(255) DEFAULT NULL COMMENT '批次号',
  `is_delete` tinyint(1) DEFAULT NULL COMMENT '是否删除',
  `start_user_name` varchar(255) DEFAULT NULL COMMENT '启动人名称',
  `start_user_id` varchar(255) DEFAULT NULL COMMENT '启动人id',
  `equipment_code` varchar(20) DEFAULT NULL COMMENT '装备code',
  `equipment_name` varchar(255) DEFAULT NULL COMMENT '装备名称',
  `equipment_id` bigint(11) DEFAULT NULL COMMENT '装备ID',
  `fire_equipment_id` bigint(255) DEFAULT NULL COMMENT '电力设备ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='预案运行记录表';

-- ----------------------------
-- Records of c_plan_operation_record
-- ----------------------------

-- ----------------------------
-- Table structure for c_plan_rule
-- ----------------------------
DROP TABLE IF EXISTS `c_plan_rule`;
CREATE TABLE `c_plan_rule` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `rule_id` varchar(32) DEFAULT NULL COMMENT '规则ID',
  `plan_id` bigint(20) DEFAULT NULL COMMENT '预案ID',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `is_delete` tinyint(1) DEFAULT NULL COMMENT '是否删除',
  `rule_name` varchar(100) DEFAULT NULL COMMENT '规则名称',
  `pic_url` varchar(100) DEFAULT NULL COMMENT '规则树形图路径',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of c_plan_rule
-- ----------------------------

-- ----------------------------
-- Table structure for databasechangelog
-- ----------------------------
DROP TABLE IF EXISTS `databasechangelog`;
CREATE TABLE `databasechangelog` (
  `ID` varchar(255) NOT NULL,
  `AUTHOR` varchar(255) NOT NULL,
  `FILENAME` varchar(255) NOT NULL,
  `DATEEXECUTED` datetime NOT NULL,
  `ORDEREXECUTED` int(11) NOT NULL,
  `EXECTYPE` varchar(10) NOT NULL,
  `MD5SUM` varchar(35) DEFAULT NULL,
  `DESCRIPTION` varchar(255) DEFAULT NULL,
  `COMMENTS` varchar(255) DEFAULT NULL,
  `TAG` varchar(255) DEFAULT NULL,
  `LIQUIBASE` varchar(20) DEFAULT NULL,
  `CONTEXTS` varchar(255) DEFAULT NULL,
  `LABELS` varchar(255) DEFAULT NULL,
  `DEPLOYMENT_ID` varchar(10) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of databasechangelog
-- ----------------------------
INSERT INTO `databasechangelog` VALUES ('18292829954-1', 'zjw', 'classpath:/db/changelog/fas-1.0.0.xml', '2020-09-04 14:52:15', '1', 'EXECUTED', '8:f1c19d20c27cc7fbc8e466a55dc770e4', 'sql', 'create f_equipment_manage', null, '3.6.3', null, null, '9202078205');
INSERT INTO `databasechangelog` VALUES ('18292829954-1', 'zjw', 'classpath:/db/changelog/fas-1.0.0.xml', '2020-09-04 14:52:15', '1', 'EXECUTED', '8:f1c19d20c27cc7fbc8e466a55dc770e4', 'sql', 'create f_equipment_manage', null, '3.6.3', null, null, '9202078205');
INSERT INTO `databasechangelog` VALUES ('18292829954-1', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-07 17:50:01', '2', 'MARK_RAN', '8:f1c19d20c27cc7fbc8e466a55dc770e4', 'sql', 'create f_equipment_manage', null, '3.6.3', null, null, '9471978175');
INSERT INTO `databasechangelog` VALUES ('18292829954-2', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-07 17:57:10', '3', 'EXECUTED', '8:7216703f2b424e4798067235538d2444', 'sql', '用于保存同步数据时源数据的ID和code', null, '3.6.3', null, null, '9472406365');
INSERT INTO `databasechangelog` VALUES ('18292829954-3', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-07 17:58:57', '4', 'EXECUTED', '8:11041cac198df0974198dcc5c8938168', 'sql', '用于保存同步数据时源数据的ID和code', null, '3.6.3', null, null, '9472513276');
INSERT INTO `databasechangelog` VALUES ('18292829955-1', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-08 16:45:27', '5', 'EXECUTED', '8:8a466b6829dd9b796e016b116db38c57', 'sql', '源数据表中ID，防止脏数据，添加唯一约束', null, '3.6.3', null, null, '9554501840');
INSERT INTO `databasechangelog` VALUES ('18292829955-2', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-08 16:45:27', '6', 'EXECUTED', '8:63ea0dabef6f704d57afc372b5720b19', 'sql', '源数据表中ID，防止脏数据，添加唯一约束', null, '3.6.3', null, null, '9554501840');
INSERT INTO `databasechangelog` VALUES ('18292829955-3', 'ZeHua Li', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-14 17:31:03', '7', 'EXECUTED', '8:2ec82e58bd4037da8fc789b08f3c4a73', 'sql', '修改视图中报错字段', null, '3.6.3', null, null, '0075632060');
INSERT INTO `databasechangelog` VALUES ('18292829955-4', 'ZeHua Li', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-23 09:24:45', '8', 'EXECUTED', '8:88621e7ff8e4b1e0d894897f08e42474', 'sql', '修改perf_group_code字段长度', null, '3.6.3', null, null, '0824045159');
INSERT INTO `databasechangelog` VALUES ('1602734081064-1', 'suhuiguang', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-15 12:01:52', '9', 'MARK_RAN', '8:745333daa51c53bc346e805f14ee9fc7', 'sql', '对站消防点位风险与组态关系表', null, '3.6.3', null, null, '2734257547');
INSERT INTO `databasechangelog` VALUES ('1603878601-1', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:04:07', '10', 'MARK_RAN', '8:7e9408ee0cdb68f2b02a760d1cf02b84', 'sql', '删除wl_equ_property表索引', null, '3.6.3', null, null, '3886377956');
INSERT INTO `databasechangelog` VALUES ('1603878601-2', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:04:07', '11', 'MARK_RAN', '8:b9fc2940f5882a6056a5211a53bfec7f', 'sql', '删除wl_equ_property表索引', null, '3.6.3', null, null, '3886377956');
INSERT INTO `databasechangelog` VALUES ('1603878601-3', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '12', 'MARK_RAN', '8:37930936cbd7c2aa6d5a2f11ec1fb0e4', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-4', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '13', 'MARK_RAN', '8:b9d54033a57d0fc2ce03d1446769d18f', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-5', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '14', 'MARK_RAN', '8:86d8ad24d9f2920777bebde304b5bae7', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-6', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '15', 'MARK_RAN', '8:9d7ae77b236f50106d182b1f702214ce', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-7', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '16', 'MARK_RAN', '8:e886325e55c7fda31bd7e016316bf36d', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-8', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:05', '17', 'MARK_RAN', '8:aea6ec2c22cdeaf8c0629715c2e05b59', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-9', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:26:42', '23', 'RERAN', '8:e4f5abbcb1e74d6c92273ddee23e344d', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3887730352');
INSERT INTO `databasechangelog` VALUES ('1603878601-10', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '19', 'EXECUTED', '8:5f7c102239747a7a821ef7d2bf98e2af', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('1603878601-11', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '20', 'MARK_RAN', '8:9570e307949d4316e2dea4964423d5c2', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('1603878601-12', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '21', 'MARK_RAN', '8:805fe24385ec8f380422cebdccfec76a', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('1603878601-13', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '22', 'MARK_RAN', '8:1985eda623f83f55a01dd3b75dceee2c', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('18292829954-1', 'zjw', 'classpath:/db/changelog/fas-1.0.0.xml', '2020-09-04 14:52:15', '1', 'EXECUTED', '8:f1c19d20c27cc7fbc8e466a55dc770e4', 'sql', 'create f_equipment_manage', null, '3.6.3', null, null, '9202078205');
INSERT INTO `databasechangelog` VALUES ('18292829954-1', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-07 17:50:01', '2', 'MARK_RAN', '8:f1c19d20c27cc7fbc8e466a55dc770e4', 'sql', 'create f_equipment_manage', null, '3.6.3', null, null, '9471978175');
INSERT INTO `databasechangelog` VALUES ('18292829954-2', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-07 17:57:10', '3', 'EXECUTED', '8:7216703f2b424e4798067235538d2444', 'sql', '用于保存同步数据时源数据的ID和code', null, '3.6.3', null, null, '9472406365');
INSERT INTO `databasechangelog` VALUES ('18292829954-3', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-07 17:58:57', '4', 'EXECUTED', '8:11041cac198df0974198dcc5c8938168', 'sql', '用于保存同步数据时源数据的ID和code', null, '3.6.3', null, null, '9472513276');
INSERT INTO `databasechangelog` VALUES ('18292829955-1', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-08 16:45:27', '5', 'EXECUTED', '8:8a466b6829dd9b796e016b116db38c57', 'sql', '源数据表中ID，防止脏数据，添加唯一约束', null, '3.6.3', null, null, '9554501840');
INSERT INTO `databasechangelog` VALUES ('18292829955-2', 'zhangzhanyi', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-08 16:45:27', '6', 'EXECUTED', '8:63ea0dabef6f704d57afc372b5720b19', 'sql', '源数据表中ID，防止脏数据，添加唯一约束', null, '3.6.3', null, null, '9554501840');
INSERT INTO `databasechangelog` VALUES ('18292829955-3', 'ZeHua Li', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-14 17:31:03', '7', 'EXECUTED', '8:2ec82e58bd4037da8fc789b08f3c4a73', 'sql', '修改视图中报错字段', null, '3.6.3', null, null, '0075632060');
INSERT INTO `databasechangelog` VALUES ('18292829955-4', 'ZeHua Li', 'classpath:/changelog/fas-1.0.0.xml', '2020-09-23 09:24:45', '8', 'EXECUTED', '8:88621e7ff8e4b1e0d894897f08e42474', 'sql', '修改perf_group_code字段长度', null, '3.6.3', null, null, '0824045159');
INSERT INTO `databasechangelog` VALUES ('1602734081064-1', 'suhuiguang', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-15 12:01:52', '9', 'MARK_RAN', '8:745333daa51c53bc346e805f14ee9fc7', 'sql', '对站消防点位风险与组态关系表', null, '3.6.3', null, null, '2734257547');
INSERT INTO `databasechangelog` VALUES ('1603878601-1', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:04:07', '10', 'MARK_RAN', '8:7e9408ee0cdb68f2b02a760d1cf02b84', 'sql', '删除wl_equ_property表索引', null, '3.6.3', null, null, '3886377956');
INSERT INTO `databasechangelog` VALUES ('1603878601-2', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:04:07', '11', 'MARK_RAN', '8:b9fc2940f5882a6056a5211a53bfec7f', 'sql', '删除wl_equ_property表索引', null, '3.6.3', null, null, '3886377956');
INSERT INTO `databasechangelog` VALUES ('1603878601-3', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '12', 'MARK_RAN', '8:37930936cbd7c2aa6d5a2f11ec1fb0e4', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-4', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '13', 'MARK_RAN', '8:b9d54033a57d0fc2ce03d1446769d18f', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-5', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '14', 'MARK_RAN', '8:86d8ad24d9f2920777bebde304b5bae7', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-6', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '15', 'MARK_RAN', '8:9d7ae77b236f50106d182b1f702214ce', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-7', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:04', '16', 'MARK_RAN', '8:e886325e55c7fda31bd7e016316bf36d', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-8', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:07:05', '17', 'MARK_RAN', '8:aea6ec2c22cdeaf8c0629715c2e05b59', 'sql', '修改wl_equ_property表结构', null, '3.6.3', null, null, '3886555354');
INSERT INTO `databasechangelog` VALUES ('1603878601-9', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:26:42', '23', 'RERAN', '8:e4f5abbcb1e74d6c92273ddee23e344d', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3887730352');
INSERT INTO `databasechangelog` VALUES ('1603878601-10', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '19', 'EXECUTED', '8:5f7c102239747a7a821ef7d2bf98e2af', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('1603878601-11', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '20', 'MARK_RAN', '8:9570e307949d4316e2dea4964423d5c2', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('1603878601-12', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '21', 'MARK_RAN', '8:805fe24385ec8f380422cebdccfec76a', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('1603878601-13', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-10-28 20:08:11', '22', 'MARK_RAN', '8:1985eda623f83f55a01dd3b75dceee2c', 'sql', '修改wl_car_property表结构', null, '3.6.3', null, null, '3886621682');
INSERT INTO `databasechangelog` VALUES ('1587349916716-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '24', 'MARK_RAN', '8:2669029069a3b68dd508e36fa8abf134', 'sql', 'f_risk_source add column ue4_location', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587349916716-2', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '25', 'MARK_RAN', '8:44a25694a7a133588b10350bf03fa0d3', 'sql', 'f_risk_source add column ue4_rotation', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587349916716-3', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '26', 'MARK_RAN', '8:e1372233a58586f63fca48c2d2fabe8d', 'sql', 'f_risk_source add column ue4_extent', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587351415717-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '27', 'MARK_RAN', '8:d676539991eb75081b4a853af44b6c36', 'sql', 'f_equipment add column ue4_location', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587351415717-2', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '28', 'MARK_RAN', '8:abe47d5f7f7a855b68ed77583a2cc86f', 'sql', 'f_equipment add column ue4_rotation', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350445716-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '29', 'MARK_RAN', '8:12f98cea4194a7173e75e3c2bd386d37', 'sql', 'f_fire_car add column ue4_location', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350445716-2', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '30', 'MARK_RAN', '8:7e1757b35d092394e57dc69d8f89c53b', 'sql', 'f_fire_car add column ue4_rotation', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350552716-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:46', '31', 'MARK_RAN', '8:465ecf308b0595f3ae875f250c484801', 'sql', 'f_fire_equipment add column ue4_location', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350552716-2', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:47', '32', 'MARK_RAN', '8:2298e8df7dd1cb70dc8455466e77c748', 'sql', 'f_fire_equipment add column ue4_rotation', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350593716-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:47', '33', 'MARK_RAN', '8:aaa60383619262ccd4a6e686d957eca9', 'sql', 'f_fire_station add column ue4_location', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350593716-2', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:47', '34', 'MARK_RAN', '8:37000e0c28f283c3c828de020fbd88b5', 'sql', 'f_fire_station add column ue4_rotation', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350759717-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:47', '35', 'MARK_RAN', '8:aff50ecdd58ec8964ae2d05667f33f6a', 'sql', 'f_water_resource add column ue4_location', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350759717-2', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:47', '36', 'MARK_RAN', '8:99c55eb0b48ab9af131f70d2d9f135dc', 'sql', 'f_water_resource add column ue4_rotation', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('1587350860716-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 11:20:47', '37', 'MARK_RAN', '8:173309ce0e26811ed9f8002810164006', 'sql', 'create f_safety_index_change_log', null, '3.6.3', null, null, '4373369991');
INSERT INTO `databasechangelog` VALUES ('0001', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-03 11:21:22', '38', 'MARK_RAN', '8:361a6342742209330e493b13d908364b', 'sql', 'create te_training_result', null, '3.6.3', null, null, '4373405268');
INSERT INTO `databasechangelog` VALUES ('0002', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-03 11:21:22', '39', 'MARK_RAN', '8:3816f69377b924a9f9aa7bd49127b5d4', 'sql', 'create te_training_subjects', null, '3.6.3', null, null, '4373405268');
INSERT INTO `databasechangelog` VALUES ('0003', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-03 11:21:22', '40', 'MARK_RAN', '8:5582db6cd4966f44ff371d650ac2558f', 'sql', 'create te_training_subjects_result', null, '3.6.3', null, null, '4373405268');
INSERT INTO `databasechangelog` VALUES ('0004', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-03 11:21:22', '41', 'MARK_RAN', '8:1ae6b15389cad8d0b078fa52da838c48', 'sql', 'create rpm_person', null, '3.6.3', null, null, '4373405268');
INSERT INTO `databasechangelog` VALUES ('0007', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-03 11:21:34', '42', 'EXECUTED', '8:4181e55856630cbc7e8b827a8b02b392', 'sqlFile', 'init data', null, '3.6.3', null, null, '4373405268');
INSERT INTO `databasechangelog` VALUES ('1587882668719-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:01', '43', 'MARK_RAN', '8:2118becfb5e533e049231ad23676c217', 'createIndex indexName=idx_type, tableName=f_fire_station', '', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1588067351000-1', 'shanqiyun', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:01', '44', 'MARK_RAN', '8:c0b9698c6b1bbe4086b6a0d1174ccde3', 'sql', 'f_risk_source add column route_path', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1588140925893-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:01', '45', 'MARK_RAN', '8:4f234df6f2f6fe23246e698265af1533', 'sql', 'f_safety_index_change_log add column create_date', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1588990926789-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:02', '46', 'MARK_RAN', '8:961301c7fc6234342a4f2d982d528ed5', 'sql', 'f_risk_level add column manage_level 管控级别', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1589165258908-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:02', '47', 'MARK_RAN', '8:fbc7bfb013e9058794e093853c9a008d', 'sql', 'f_rpn_change_log add column trigger_type 触发类型', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1589165258908-2', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:02', '48', 'MARK_RAN', '8:1b86f6920879b3959e82b15c39ed22f2', 'sql', 'f_risk_source add column flicker_frequency 闪烁频率', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1589444792914-1', 'maoying', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:02', '49', 'EXECUTED', '8:662c949630633790805455b730439d51', 'sql', 'create table f_alarm', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1589444792916-1', 'zhouyi', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:03', '50', 'EXECUTED', '8:317e00f0a9371dfcfad32e7f660884f1', 'sql', 'create table f_station_info', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1589769364577-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:03', '51', 'EXECUTED', '8:971031572a60dbd3d11573ed952f468d', 'sql', 'f_risk_level 增加管控级别 初始化数据', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('11590390304001-1', 'maoying', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:03', '52', 'EXECUTED', '8:bd161b4fa41e702fd9ccbe17e4b55921', 'sql', '修改fire_equipment_id可为空', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1591672147780-1', 'shanqiyun', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:03', '53', 'EXECUTED', '8:b9804e67b6f2ffa576add4772ef44619', 'sql', 'create view toip_biz_message', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1593309428780-1', 'shanqiyun', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:03', '54', 'MARK_RAN', '8:0bd96572033a1429f99624a83c4d1830', 'sql', 'create table contingency_original_data', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1593309428780-2', 'shanqiyun', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:03', '55', 'MARK_RAN', '8:dd499efb094231e964678972c5be6a76', 'sql', 'create table contingency_plan', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1593309428780-3', 'shanqiyun', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-03 12:04:03', '56', 'MARK_RAN', '8:4cb59cdc0cb5eedf8649bffae1a6a255', 'sql', 'create table contingency_plan_instance', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1561454393000-1', 'suhg', 'classpath:/db/changelog/fas-sql-task.xml', '2020-11-03 12:04:03', '57', 'EXECUTED', '8:8a1e7d1404a1b18afa384d2c9142189f', 'sql', 'update f_fmea_equipment_point 更新触发器创建', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1561454393000-2', 'suhg', 'classpath:/db/changelog/fas-sql-task.xml', '2020-11-03 12:04:03', '58', 'EXECUTED', '8:c7d50ea1c4b704d6168aa33d341daa93', 'sql', 'f_risk_source_point_inputitem  更新触发器创建', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1561717770000-1', 'tianbo', 'classpath:/db/changelog/fas-sql-task.xml', '2020-11-03 12:04:03', '59', 'EXECUTED', '8:78ebd22321cd9e8991566ce2f2e25837', 'sql', 'f_fire_equipment_point_update 触发器创建(修改判断条件为->value等于\'true\')', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1588901126338-1', 'shanqiyun', 'classpath:/db/changelog/fas-sql-task.xml', '2020-11-03 12:04:03', '60', 'EXECUTED', '8:1201d1531bd5235267b90b7424ac9bfb', 'sql', 'f_risk_source 查询所有子节点id', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1589954524000-1', 'maoying', 'classpath:/db/changelog/fas-sql-task.xml', '2020-11-03 12:04:04', '61', 'EXECUTED', '8:8d78b9fc0529776dbc5c8dc92bdc14f9', 'sql', 'updatePointConfig 触发器创建', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1597831211780-1', 'shanqiyun', 'classpath:/db/changelog/fas-sql-task.xml', '2020-11-03 12:04:04', '62', 'EXECUTED', '8:b0c68b6f304aa98e4466eef0d6d3239f', 'sql', 'create view toip_biz_message', null, '3.6.3', null, null, '4375962761');
INSERT INTO `databasechangelog` VALUES ('1604458366-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-04 10:58:16', '63', 'EXECUTED', '8:281fed82144b67a1d69472547fe56669', 'sqlFile', 'init data', null, '3.6.3', null, null, '4458412097');
INSERT INTO `databasechangelog` VALUES ('1587882668717-1', 'suhuiguang', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-06 09:29:46', '64', 'EXECUTED', '8:2118becfb5e533e049231ad23676c217', 'createIndex indexName=idx_type, tableName=f_fire_station', '', null, '3.6.3', null, null, '4625199529');
INSERT INTO `databasechangelog` VALUES ('1604885488-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-09 10:28:16', '65', 'EXECUTED', '8:221b8e76de41490cda07947d3b0ceb85', 'sqlFile', 'init data', null, '3.6.3', null, null, '4888606789');
INSERT INTO `databasechangelog` VALUES ('1587367587716-1', 'suhuiguang', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:29', '66', 'MARK_RAN', '8:d562d1c871f7cab400c7a3c31ccbfd16', 'sql', 'p_point add column ue4_rotation', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1587367889717-1', 'suhuiguang', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:29', '67', 'MARK_RAN', '8:12bc3c268cc3b3d3ffc0ba1a543227e3', 'sql', 'p_point add column ue4_location', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1590476067001-1', 'maoying', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:29', '68', 'MARK_RAN', '8:16c7282e662ade79555284b16f66952d', 'sql', 'p_task add column dep_id', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1587367889717-2', 'suhuiguang', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:29', '69', 'MARK_RAN', '8:7501e769788d582aaab6fbf819c5c50b', 'sql', 'p_point', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1587367889717-3', 'suhuiguang', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:29', '70', 'MARK_RAN', '8:a0e8b17d5709e165e267e58416706ff8', 'sql', 'p_point', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1591336116001-1', 'maoying', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:29', '71', 'EXECUTED', '8:7d2766d6a5bcfed3070598261c9507ac', 'sql', 'p_plan_task MODIFY user_id', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1590476067003-1', 'zhouyi', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:29', '72', 'MARK_RAN', '8:3eb44ab5fbae0cb360ef8f7ad9939b40', 'sql', 'p_plan add column user_dept', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1590476067004-1', 'zhouyi', 'classpath:/db/changelog/patrol-3.0.0.xml', '2020-11-09 18:31:30', '73', 'MARK_RAN', '8:1d19f2026a595a8c7d638a6eda0111f9', 'sql', 'p_plan_task add column user_dept', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1550832246000-1', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:30', '74', 'EXECUTED', '8:eedd1212da42d4b25f8fe4ec3672f2e1', 'createView viewName=v_msg_subscribe_check', '', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1553233487000-1', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:30', '75', 'EXECUTED', '8:080e589266355f71f31da9ccde71325d', 'createView viewName=vcheck', '', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1554111363112-2', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:30', '76', 'EXECUTED', '8:088881491e42558fea38730655b342d9', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1554111363112-3', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:30', '77', 'EXECUTED', '8:5bdee6c228dac400069e47d3d66d8130', 'sql', 'check_update 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1554111363112-7', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:31', '78', 'EXECUTED', '8:73eb4d154a3eac067ef69f122aa7ec0f', 'sql', 'plan_task_detail_insert 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1554190356000-1', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:31', '79', 'EXECUTED', '8:659436a2f3de94d9be4672826e09ea0a', 'createView viewName=v_point_last_check', '', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1554691494000-1', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:31', '80', 'EXECUTED', '8:24f34162531d41ee0eb0ca5f064cc60e', 'createView viewName=v_check_info', '', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1561097898000-1', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:31', '81', 'EXECUTED', '8:3a7948a02892f1356674d08f1f29e61d', 'sql', 'p_point_classify_delete 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1561355156000-1', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:31', '82', 'EXECUTED', '8:391e7a36a11722960d8f80bf92eca76c', 'sql', 'trigger_route_point_insert_update_point_route_info 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1561355156000-2', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:32', '83', 'EXECUTED', '8:652db0fa41a24b794da5501fc0c669bf', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1561355156000-3', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:32', '84', 'EXECUTED', '8:aff5eff2e525843fec5aa974e4670180', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('15640410855-2', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:32', '85', 'EXECUTED', '8:3e4be42ae49cc95fa5f2525577195b25', 'createProcedure procedureName=updatePlanTask', '', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('15640410888-3', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:32', '86', 'EXECUTED', '8:b68a12af990646631e647ef323e1c903', 'createProcedure procedureName=planTaskStatistics', '', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('15640410855-4', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:32', '87', 'EXECUTED', '8:ee0d716d5e29ac9f2eac8a050390b9bc', 'createProcedure procedureName=everyDayInitPlanTaskStatistics', '', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('15640410855000-5', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30706', 'RERAN', '8:834113f804109e5c1178893fba4aa2f4', 'sql', '', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1571298391000-1', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:33', '89', 'EXECUTED', '8:d13ae4f7f58f7ee19f3bf5b786f12f5d', 'sql', 'addPointConfig 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1571298391000-2', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2020-11-09 18:31:33', '90', 'EXECUTED', '8:821396c69666371df4d67ac4330f769c', 'sql', 'deletePointConfig 触发器创建', null, '3.6.3', null, null, '4916884726');
INSERT INTO `databasechangelog` VALUES ('1604885489-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-11 14:36:13', '96', 'EXECUTED', '8:b82abb71d09e07d5318dc1bb4c187baa', 'sqlFile', 'init data', null, '3.6.3', null, null, '5076279162');
INSERT INTO `databasechangelog` VALUES ('1604885490-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-11 17:20:53', '97', 'EXECUTED', '8:08b9e4a9ea54148546be62606d82c42b', 'sqlFile', 'init data', null, '3.6.3', null, null, '5086159526');
INSERT INTO `databasechangelog` VALUES ('1604454486-1', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-13 11:34:46', '98', 'MARK_RAN', '8:871b6139b018a5260694ffc1df2ae4a5', 'sql', '修改wl_equipment_specific表结构', null, '3.6.3', null, null, '5238198822');
INSERT INTO `databasechangelog` VALUES ('1604454486-2', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-13 11:34:47', '99', 'EXECUTED', '8:fe1efe4f61358d41d150e4ba37315b77', 'sql', '修改wl_equipment_specific_alarm表结构', null, '3.6.3', null, null, '5238198822');
INSERT INTO `databasechangelog` VALUES ('1604454486-3', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-13 11:34:47', '100', 'MARK_RAN', '8:1d0b81ca41e0fe6b4084551eb7119931', 'sql', '修改wl_car表结构', null, '3.6.3', null, null, '5238198822');
INSERT INTO `databasechangelog` VALUES ('1604454486-4', 'lizehua', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-18 10:58:48', '101', 'MARK_RAN', '8:5b623ab730b26da1b5b915e5f9756390', 'sql', '新增视频表以及关联表', null, '3.6.3', null, null, '5668034842');
INSERT INTO `databasechangelog` VALUES ('1605699890-1', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-19 11:09:14', '102', 'EXECUTED', '8:126c7b407f203f82808445c4476fbc24', 'sql', '修改wl_warehouse_structure表结构', null, '3.6.3', null, null, '5755057392');
INSERT INTO `databasechangelog` VALUES ('1605924681-1', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-21 10:45:47', '103', 'MARK_RAN', '8:1118e8f89be6379e00e19b4c39494200', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '5926450722');
INSERT INTO `databasechangelog` VALUES ('1605924681-2', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-21 10:45:47', '104', 'MARK_RAN', '8:52805ba4751ba783b42f20742fde1439', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '5926450722');
INSERT INTO `databasechangelog` VALUES ('1605924681-3', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-21 10:45:48', '105', 'MARK_RAN', '8:ef0c99d09e632e37d5c40577c5f55006', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '5926450722');
INSERT INTO `databasechangelog` VALUES ('1605951015-1', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-21 17:42:48', '107', 'EXECUTED', '8:4da86f734775f4c0d01a447b6fca0b21', 'sql', '修改wl_unit表结构', null, '3.6.3', null, null, '5950762652');
INSERT INTO `databasechangelog` VALUES ('1605951015-2', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-21 17:42:48', '108', 'EXECUTED', '8:99fc5b13b1ac1f75246653cc8a22adcc', 'sql', '修改wl_unit表结构', null, '3.6.3', null, null, '5950762652');
INSERT INTO `databasechangelog` VALUES ('1606216645-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-24 19:34:55', '136', 'EXECUTED', '8:fa4bce117855909e4bb296804dfa8fc8', 'sqlFile', 'init data', null, '3.6.3', null, null, '6217379107');
INSERT INTO `databasechangelog` VALUES ('1606290088-1', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-25 16:01:31', '155', 'MARK_RAN', '8:92f3488738e11ae7a8e3d13b36d9a37f', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '6290989552');
INSERT INTO `databasechangelog` VALUES ('1606290088-2', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-25 16:01:31', '156', 'MARK_RAN', '8:2a45a641a68edaa7ac002ed9cd444e79', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '6290989552');
INSERT INTO `databasechangelog` VALUES ('1606290088-3', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-11-25 16:01:31', '157', 'MARK_RAN', '8:734fe567933d74003a2eb69898222a3b', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '6290989552');
INSERT INTO `databasechangelog` VALUES ('1606296980-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-25 17:42:18', '158', 'EXECUTED', '8:81bc252beebce8ffaa8ed599dcb80faa', 'sqlFile', 'init data', null, '3.6.3', null, null, '6296997095');
INSERT INTO `databasechangelog` VALUES ('1606297588-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-25 17:52:11', '159', 'EXECUTED', '8:d1c079bc2ec2681323aa321907344bdf', 'sqlFile', 'init data', null, '3.6.3', null, null, '6297613839');
INSERT INTO `databasechangelog` VALUES ('1606385812-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-11-26 18:22:34', '160', 'EXECUTED', '8:7ba442d129ba93583858e01c0cfc56e5', 'sqlFile', 'init data', null, '3.6.3', null, null, '6385839971');
INSERT INTO `databasechangelog` VALUES ('1550832246001-1', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30682', 'RERAN', '8:eedd1212da42d4b25f8fe4ec3672f2e1', 'createView viewName=v_msg_subscribe_check', '', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1553233487001-1', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30683', 'RERAN', '8:080e589266355f71f31da9ccde71325d', 'createView viewName=vcheck', '', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1554111363113-2', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:48', '5327', 'RERAN', '8:088881491e42558fea38730655b342d9', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1554111363113-3', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:48', '5328', 'RERAN', '8:5bdee6c228dac400069e47d3d66d8130', 'sql', 'check_update 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1554111363113-7', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:49', '5329', 'RERAN', '8:73eb4d154a3eac067ef69f122aa7ec0f', 'sql', 'plan_task_detail_insert 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1554190356001-1', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30690', 'RERAN', '8:659436a2f3de94d9be4672826e09ea0a', 'createView viewName=v_point_last_check', '', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1554691494001-1', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30691', 'RERAN', '8:24f34162531d41ee0eb0ca5f064cc60e', 'createView viewName=v_check_info', '', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1561097898001-1', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:50', '5332', 'RERAN', '8:3a7948a02892f1356674d08f1f29e61d', 'sql', 'p_point_classify_delete 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1561355156001-1', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:50', '5333', 'RERAN', '8:391e7a36a11722960d8f80bf92eca76c', 'sql', 'trigger_route_point_insert_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1561355156001-2', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:51', '5334', 'RERAN', '8:652db0fa41a24b794da5501fc0c669bf', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1561355156001-3', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:51', '5335', 'RERAN', '8:aff5eff2e525843fec5aa974e4670180', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('15640410856-2', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:51', '5336', 'RERAN', '8:3e4be42ae49cc95fa5f2525577195b25', 'createProcedure procedureName=updatePlanTask', '', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('15640410889-3', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:52', '5337', 'RERAN', '8:b68a12af990646631e647ef323e1c903', 'createProcedure procedureName=planTaskStatistics', '', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('15640410856-4', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:52', '5338', 'RERAN', '8:ee0d716d5e29ac9f2eac8a050390b9bc', 'createProcedure procedureName=everyDayInitPlanTaskStatistics', '', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1571298391001-1', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:52', '5340', 'RERAN', '8:d13ae4f7f58f7ee19f3bf5b786f12f5d', 'sql', 'addPointConfig 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1571298391001-2', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-11 16:31:53', '5341', 'RERAN', '8:821396c69666371df4d67ac4330f769c', 'sql', 'deletePointConfig 触发器创建', null, '3.6.3', null, null, '0353906944');
INSERT INTO `databasechangelog` VALUES ('1607398689-1', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-09 11:35:07', '428', 'RERAN', '8:bc1712261a89f5aa2a0b9d963a3d9321', 'sql', '由于组态组件不支持复杂SQL语句业务因此添加此视图', null, '3.6.3', null, null, '7484586615');
INSERT INTO `databasechangelog` VALUES ('1607432736-5', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-08 21:18:10', '405', 'EXECUTED', '8:17cd05c5245e24dda20ceb9cac0ce718', 'sqlFile', 'init data', null, '3.6.3', null, null, '7433162685');
INSERT INTO `databasechangelog` VALUES ('1607432736-6', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-08 21:34:30', '406', 'MARK_RAN', '8:8d661b675b62bfe90ec20d24ae8014e2', 'sql', 'create st_study_plan', null, '3.6.3', null, null, '7434149207');
INSERT INTO `databasechangelog` VALUES ('1607432736-7', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-08 21:34:30', '407', 'MARK_RAN', '8:13722199a3df43c8cd247a5850449633', 'sql', 'create st_plan_user', null, '3.6.3', null, null, '7434149207');
INSERT INTO `databasechangelog` VALUES ('1607432736-8', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-08 21:34:30', '408', 'MARK_RAN', '8:b4e838bed302d4c1ec1cad89f6296459', 'sql', 'create st_plan_user_resource', null, '3.6.3', null, null, '7434149207');
INSERT INTO `databasechangelog` VALUES ('1607432736-9', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-08 21:34:30', '409', 'MARK_RAN', '8:c0a35d9ecfa8d7a5cae8310e6476ee92', 'sql', 'create st_plan_resource', null, '3.6.3', null, null, '7434149207');
INSERT INTO `databasechangelog` VALUES ('160595101501-1', 'maoying', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-09 10:44:09', '427', 'EXECUTED', '8:e67ef9e9d89c5b5f914413567e2f89e4', 'sql', '修改wl_car_property表value类型', null, '3.6.3', null, null, '7481528102');
INSERT INTO `databasechangelog` VALUES ('18292829954-1', 'zjw', 'classpath:/changelog/equipment-1.0.1.xml', '2020-12-10 11:52:44', '463', 'MARK_RAN', '8:f1c19d20c27cc7fbc8e466a55dc770e4', 'sql', 'create f_equipment_manage', null, '3.6.3', null, null, '7572041297');
INSERT INTO `databasechangelog` VALUES ('1607398689001-1', 'keyong', 'classpath:/changelog/sql-task.xml', '2021-04-28 16:09:24', '29156', 'RERAN', '8:9365b747b84987dd483864df66023a5b', 'sql', '由于组态组件不支持复杂SQL语句业务因此添加此视图', null, '3.6.3', null, null, '9597364213');
INSERT INTO `databasechangelog` VALUES ('1331790995458-1', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-11 11:53:39', '500', 'EXECUTED', '8:532ae5af8b0c387a809c9c000bb272d4', 'sql', 'create wl_common_tree', null, '3.6.3', null, null, '7658495793');
INSERT INTO `databasechangelog` VALUES ('1331790995458-2', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-11 11:53:40', '501', 'EXECUTED', '8:6cbf8d23778ccd8e8d3548a003d80bbe', 'sqlFile', 'init common_tree data', null, '3.6.3', null, null, '7658495793');
INSERT INTO `databasechangelog` VALUES ('1301232323152', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-15 21:48:17', '502', 'EXECUTED', '8:f3da3aed5c861ec6d136ea9cbf5b8ea7', 'sql', 'wl_equipment_specific_index 添加字段 update_date', null, '3.6.3', null, null, '8039763001');
INSERT INTO `databasechangelog` VALUES ('160595101501-2', 'maoying', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-15 21:48:17', '503', 'EXECUTED', '8:e55874b08983dc8e42a28e2f58bb73dd', 'sql', '修改wl_equipment_specific_index表update_date类型', null, '3.6.3', null, null, '8039763001');
INSERT INTO `databasechangelog` VALUES ('1605951015-3', 'lizehua', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-15 21:48:17', '504', 'MARK_RAN', '8:5606feefc4335fd8b11af09317f0d987', 'sql', '单据增加创建人名字段', null, '3.6.3', null, null, '8039763001');
INSERT INTO `databasechangelog` VALUES ('1301417995522152', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-15 21:48:18', '505', 'EXECUTED', '8:c28f6f26ce90b0d16524f73158bf6cf0', 'sql', '修改f_equipment_manage库名称tof_fire_fighting_system', null, '3.6.3', null, null, '8039763001');
INSERT INTO `databasechangelog` VALUES ('158890112635601-1', 'maoying', 'classpath:/changelog/sql-task.xml', '2021-04-28 16:09:24', '29158', 'RERAN', '8:ff480802d3c2ecc2f59df7e9a9490f3f', 'sql', '', null, '3.6.3', null, null, '9597364213');
INSERT INTO `databasechangelog` VALUES ('158890112635601-2', 'maoying', 'classpath:/changelog/sql-task.xml', '2020-12-24 20:59:58', '3374', 'RERAN', '8:60f2cfb647581119425b1da8982c09e2', 'sql', '', null, '3.6.3', null, null, '8814457163');
INSERT INTO `databasechangelog` VALUES ('1301443434322152', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-16 13:50:30', '530', 'EXECUTED', '8:d0f4ada9b1829a6dd0b44107fb2dc588', 'sql', '修改f_fire_fighting_system 表字段', null, '3.6.3', null, null, '8097498013');
INSERT INTO `databasechangelog` VALUES ('130454545454322152', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-16 17:23:13', '555', 'EXECUTED', '8:6e2439bd33ef43219b6c77a449403cf2', 'sql', '修改f_fire_fighting_system 表字段', null, '3.6.3', null, null, '8110261970');
INSERT INTO `databasechangelog` VALUES ('1304541343432225488', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-17 12:07:26', '712', 'EXECUTED', '8:c0c00539265e9229f18e3cccbe6462da', 'sql', '修改f_fire_fighting_system所有字段', null, '3.6.3', null, null, '8177713476');
INSERT INTO `databasechangelog` VALUES ('158890112635602-2', 'maoying', 'classpath:/changelog/sql-task.xml', '2021-04-28 16:09:24', '29159', 'RERAN', '8:b9fe9ddd3f8eb626c288a794b246dbca', 'sql', '', null, '3.6.3', null, null, '9597364213');
INSERT INTO `databasechangelog` VALUES ('1608798196836-1', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-24 17:04:41', '3289', 'EXECUTED', '8:f7a4615f71573e2c0fe087a9fefad6e6', 'sql', 'create 建筑分组表 wl_form_group 建筑模块使用', null, '3.6.3', null, null, '8800340296');
INSERT INTO `databasechangelog` VALUES ('1608798196836-2', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-24 17:04:41', '3290', 'EXECUTED', '8:72f68928e8ff60770d5eca16ae4f1adf', 'sql', 'create 分组字段表 wl_form_group_column 建筑模块使用', null, '3.6.3', null, null, '8800340296');
INSERT INTO `databasechangelog` VALUES ('1608798196836-3', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-24 17:04:41', '3291', 'EXECUTED', '8:771f8625169b17cf927f12e19ab44b08', 'sql', 'create 实例表 wl_form_instance 建筑模块使用', null, '3.6.3', null, null, '8800340296');
INSERT INTO `databasechangelog` VALUES ('1608798196836-4', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-24 17:04:42', '3292', 'EXECUTED', '8:7416889f99af9ef6eb2ca3fbc324d5b6', 'sql', 'create 资源与文件关联关系表 wl_source_file 建筑模块使用', null, '3.6.3', null, null, '8800340296');
INSERT INTO `databasechangelog` VALUES ('1608798196836-5', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-24 17:04:42', '3293', 'EXECUTED', '8:ca659ad4827cc49bf0347035f1f50b7d', 'sql', 'create 资源与场景关联关系表 wl_source_scene 建筑模块使用', null, '3.6.3', null, null, '8800340296');
INSERT INTO `databasechangelog` VALUES ('1608798196836-6', 'shg', 'classpath:/changelog/wl-1.0.1.xml', '2020-12-24 17:04:43', '3294', 'EXECUTED', '8:a56ddf1bae0053246d7a28967d1852b2', 'sqlFile', '初始话表单数据', null, '3.6.3', null, null, '8800340296');
INSERT INTO `databasechangelog` VALUES ('1608279637-1', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-12-29 15:36:13', '3776', 'EXECUTED', '8:d59e07fac5bc1c598cdcc40da4c7f14f', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '9227384840');
INSERT INTO `databasechangelog` VALUES ('1608279637-2', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-12-29 15:36:14', '3777', 'EXECUTED', '8:24e2b67057a0b1aed2d4dce6c2cb1171', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '9227384840');
INSERT INTO `databasechangelog` VALUES ('1608279637-3', 'keyong', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-12-29 15:36:14', '3778', 'EXECUTED', '8:df0905e25800b630bf9faebf0eb580ce', 'sql', '修改f_station_info表结构', null, '3.6.3', null, null, '9227384840');
INSERT INTO `databasechangelog` VALUES ('1609226808866-1', 'shg', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-12-29 15:36:14', '3779', 'EXECUTED', '8:5283d1dfc0122e597b1fe2ba716bdb35', 'sql', 'f_risk_source add column source_id', null, '3.6.3', null, null, '9227384840');
INSERT INTO `databasechangelog` VALUES ('1561717770001-1', 'tianbo', 'classpath:/db/changelog/fas-sql-task.xml', '2021-01-11 15:12:58', '5254', 'RERAN', '8:78ebd22321cd9e8991566ce2f2e25837', 'sql', 'f_fire_equipment_point_update 触发器创建(修改判断条件为->value等于\'true\')', null, '3.6.3', null, null, '0349186328');
INSERT INTO `databasechangelog` VALUES ('1597831211781-1', 'shanqiyun', 'classpath:/db/changelog/fas-sql-task.xml', '2021-06-07 10:26:37', '30559', 'RERAN', '8:b0c68b6f304aa98e4466eef0d6d3239f', 'sql', 'create view toip_biz_message', null, '3.6.3', null, null, '3032797109');
INSERT INTO `databasechangelog` VALUES ('12323232456565', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-29 21:51:18', '3978', 'EXECUTED', '8:88fba02bd0a02878c00e4a39a79749eb', 'sql', '添加 wl_equipment_system_source_statistics', null, '3.6.3', null, null, '9249890494');
INSERT INTO `databasechangelog` VALUES ('1609226808866-2', 'shg', 'classpath:/db/changelog/fas-2.0.1.xml', '2020-12-30 10:00:33', '4057', 'EXECUTED', '8:f4775fe284225ffbda5bab19a1971e76', 'sql', 'f_risk_source add UNIQUE source_id', null, '3.6.3', null, null, '9293633597');
INSERT INTO `databasechangelog` VALUES ('23123123231-1', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-31 09:43:53', '4326', 'EXECUTED', '8:bfc3f515485abff3e619be2e41b30d72', 'sql', '修改wl_car_property表value类型', null, '3.6.3', null, null, '9379033051');
INSERT INTO `databasechangelog` VALUES ('32323443543-1', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2020-12-31 09:43:53', '4327', 'MARK_RAN', '8:0f699520d2fa33b1b82bf8b2a21d028f', 'sql', '修改wl_car_property表value类型', null, '3.6.3', null, null, '9379033051');
INSERT INTO `databasechangelog` VALUES ('20210104-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:11', '4398', 'EXECUTED', '8:a9af669c8c15178480ff2815ddfa4f8a', 'sql', '修改wl_wastage_bill_detail 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-02', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4399', 'EXECUTED', '8:447e3d641b34b66e8f2f62b82dae9f0f', 'sql', '修改wl_wastage_bill 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-03', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4400', 'EXECUTED', '8:73bf1a7ef1960a82bb2affd17cfc2a81', 'sql', '修改wl_upload_file 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-04', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4401', 'EXECUTED', '8:dcf7ddcaf60a1cf3bd6c8ae4f0187535', 'sql', '修改wl_stock_detail 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-05', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4402', 'EXECUTED', '8:5aa2ef256cf85da922c001d46a033797', 'sql', '修改wl_stock_bill_detail 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-06', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4403', 'EXECUTED', '8:3dc054bd5487ca62fd363f85109ebcaa', 'sql', '修改wl_stock_bill 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-07', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4404', 'EXECUTED', '8:fb251da9d59fc718b6f4f3f21782ca89', 'sql', '修改wl_scrap_detail 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-08', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4405', 'EXECUTED', '8:3ddc38465c17d0828ea79fcf49f606fa', 'sql', '修改wl_scrap 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-09', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4406', 'EXECUTED', '8:289ef82ecc8b0dd55ea2200fabdfa4c0', 'sql', '修改wl_risk_source_scene 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-10', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:12', '4407', 'EXECUTED', '8:2be03ced1c7667f2b6c6314971eacc6f', 'sql', '修改wl_repair_detail 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-11', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:13', '4408', 'EXECUTED', '8:c2a903038c8f0e7dfe73ad99458c5541', 'sql', '修改wl_perf_quota_definition 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-12', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:13', '4409', 'EXECUTED', '8:e011fc29867303a547c767ae5ee032eb', 'sql', '修改wl_perf_quota 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-13', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:13', '4410', 'EXECUTED', '8:ce5999a1e5133f42e858fe26ceceff04', 'sql', '修改wl_notice 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-14', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:13', '4411', 'EXECUTED', '8:6cdf6a4d4ada84f184daf521700ea38a', 'sql', '修改wl_manufacturer_info 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-15', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:13', '4412', 'EXECUTED', '8:687ccc3d013568261bb538d40d977fe7', 'sql', '修改wl_journal 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-16', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:13', '4413', 'EXECUTED', '8:0eb2c1dda85bd9ff800c39e465b1269b', 'sql', '修改wl_extinguishant_on_car 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('20210104-17', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-04 16:02:14', '4414', 'EXECUTED', '8:f157c27d8f38a5c6ec25c0ce3766c087', 'sql', '修改wl_equipment_system_source_statistics 注释', null, '3.6.3', null, null, '9747341617');
INSERT INTO `databasechangelog` VALUES ('1609233028-9', 'gaojianqiang', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-05 16:45:20', '4569', 'EXECUTED', '8:e377324cc2961fc1d5fc565c83dd598c', 'sql', '用于保存考试记录评定结果', null, '3.6.3', null, null, '9836320026');
INSERT INTO `databasechangelog` VALUES ('1562323293001-1', 'suhg', 'classpath:/db/changelog/fas-sql-task.xml', '2021-01-05 17:03:19', '4571', 'RERAN', '8:e1ec28aedfe863fcbdadbaffb49acc19', 'sql', 'update f_fmea_equipment_point 更新触发器创建', null, '3.6.3', null, null, '9837411069');
INSERT INTO `databasechangelog` VALUES ('152323223001-1', 'suhg', 'classpath:/db/changelog/fas-sql-task.xml', '2021-01-05 17:03:19', '4572', 'EXECUTED', '8:b3206a1fc3cd7bd5c0460f07be7ce0b0', 'sql', 'update f_fmea_equipment_point 更新触发器创建', null, '3.6.3', null, null, '9837411069');
INSERT INTO `databasechangelog` VALUES ('20210104-18', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4812', 'EXECUTED', '8:57e63129b587d0c8d2ab01d793d4b9e0', 'sql', '修改wl_equipmentdef_qrcode 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-19', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4813', 'EXECUTED', '8:1d8c2fc06ff3dbfdc16568068e230635', 'sql', '修改wl_equipment_specific_index 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-20', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4814', 'EXECUTED', '8:a3a8ff9c00594d9f6f0f6ac26191b7d6', 'sql', '修改wl_equipment_qrcode 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-21', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4815', 'EXECUTED', '8:93bbc0d36ebb6bf89ce4f3375cecc684', 'sql', '修改wl_equipment_point 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-22', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4816', 'EXECUTED', '8:6bffa2de355a8cd0adf933f8e8ac294a', 'sql', '修改wl_equipment_on_car 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-23', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4817', 'EXECUTED', '8:4aaf292541ebf698f469f4be17400a45', 'sql', '修改wl_equipment_index 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-24', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4818', 'EXECUTED', '8:cef529ec5fb154f3bb767013467596fe', 'sql', '修改wl_equipment 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-25', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4819', 'EXECUTED', '8:8e26c28080d337b309a2e68583215c6d', 'sql', '修改wl_equ_property 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-26', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4820', 'EXECUTED', '8:cf758852aa7ec1634861b23c1626d047', 'sql', '修改wl_car_property 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210104-27', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:23', '4821', 'EXECUTED', '8:a3cc4d7baebf078c12c8537582d18393', 'sql', '修改wl_car_liquid_level 注释', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('20210106-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 15:46:24', '4822', 'EXECUTED', '8:e17aeb73a39741a5a70401737dba5d87', 'sql', '修改wl_source_scene', null, '3.6.3', null, null, '0005583743');
INSERT INTO `databasechangelog` VALUES ('1610006738717-1', 'shg', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 16:11:54', '4839', 'EXECUTED', '8:a99a7724575ff31ebdf7a20c55b2ba53', 'sql', 'wl_warehouse_structure code字段长度加长', null, '3.6.3', null, null, '0007116754');
INSERT INTO `databasechangelog` VALUES ('20210107-01', 'tiantao', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 16:13:26', '4848', 'MARK_RAN', '8:67626c7eb843c547f97840b404f6cc84', 'sql', '修改wl_equipment', null, '3.6.3', null, null, '0007209576');
INSERT INTO `databasechangelog` VALUES ('20210107-02', 'tiantao', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 16:13:26', '4849', 'MARK_RAN', '8:e388be490e7a537939222ed548833f0e', 'sql', '修改wl_equipment', null, '3.6.3', null, null, '0007209576');
INSERT INTO `databasechangelog` VALUES ('20210107-03', 'tiantao', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 16:13:27', '4850', 'MARK_RAN', '8:015531e6840ab746e8443ccb3e24e3af', 'sql', '修改wl_equipment', null, '3.6.3', null, null, '0007209576');
INSERT INTO `databasechangelog` VALUES ('20210107-04', 'tiantao', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-07 16:13:27', '4851', 'MARK_RAN', '8:4488e11fbd50fb3030f7dd1c2fd7f4f0', 'sql', '修改wl_equipment', null, '3.6.3', null, null, '0007209576');
INSERT INTO `databasechangelog` VALUES ('1580000025-2', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-11 09:31:13', '5070', 'EXECUTED', '8:bd262bb67f6f1546da869bd6943f04bf', 'sql', '', null, '3.6.3', null, null, '0328681643');
INSERT INTO `databasechangelog` VALUES ('1610345850-1', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-11 14:25:13', '5215', 'EXECUTED', '8:00f75f86561fd128db5f65af07cc7481', 'sql', '删除表wl_car_liquid_level', null, '3.6.3', null, null, '0346322991');
INSERT INTO `databasechangelog` VALUES ('1610345850-2', 'keyong', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-11 14:25:13', '5216', 'EXECUTED', '8:b2245457a02cca3e9602d045132c985d', 'sql', '删除表wl_equipmentdef_qrcode', null, '3.6.3', null, null, '0346322991');
INSERT INTO `databasechangelog` VALUES ('1609989898-1', 'gaojianqiang', 'classpath:/db/changelog/fas-2.0.1.xml', '2021-01-11 15:12:58', '5251', 'EXECUTED', '8:e745a6efb1e1dac2a2e73a3e80d93bc4', 'sql', '修改f_equipment表结构', null, '3.6.3', null, null, '0349186328');
INSERT INTO `databasechangelog` VALUES ('1580000026-2', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-12 09:43:07', '5422', 'MARK_RAN', '8:1b99fef6fe1bbe8d725dc3e333ccf73f', 'sql', '', null, '3.6.3', null, null, '0415797884');
INSERT INTO `databasechangelog` VALUES ('1580000026-3', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-12 09:43:07', '5423', 'MARK_RAN', '8:6b3d54ed536900ced84ec5e6886af207', 'sql', '', null, '3.6.3', null, null, '0415797884');
INSERT INTO `databasechangelog` VALUES ('1580000026-4', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-12 09:43:07', '5424', 'MARK_RAN', '8:1ca769430bf2a082a83c23380f30e2f9', 'sql', '', null, '3.6.3', null, null, '0415797884');
INSERT INTO `databasechangelog` VALUES ('1580000026-5', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-12 09:43:07', '5425', 'MARK_RAN', '8:cbf1aec24851aaa0cf88013743aa508f', 'sql', '', null, '3.6.3', null, null, '0415797884');
INSERT INTO `databasechangelog` VALUES ('1580000026-6', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-12 09:43:07', '5426', 'MARK_RAN', '8:12d504402103489e7f6015d0ed57e3e9', 'sql', '', null, '3.6.3', null, null, '0415797884');
INSERT INTO `databasechangelog` VALUES ('1580000026-8', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-12 09:43:07', '5427', 'MARK_RAN', '8:2f9701466f705cff3784c74dcc3a4a1f', 'sql', '', null, '3.6.3', null, null, '0415797884');
INSERT INTO `databasechangelog` VALUES ('1580000026-9', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-12 09:43:08', '5428', 'EXECUTED', '8:03d0855f17ca26fb942fffa295a8858c', 'sql', '', null, '3.6.3', null, null, '0415797884');
INSERT INTO `databasechangelog` VALUES ('1554111363113-4', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 09:51:47', '5435', 'EXECUTED', '8:e2768897108fc4e2644179fac41068b8', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '0416317451');
INSERT INTO `databasechangelog` VALUES ('15541113631138-2', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 10:59:34', '5451', 'EXECUTED', '8:c04d4a85061ee62d9f44960950a8550f', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '0420384736');
INSERT INTO `databasechangelog` VALUES ('15541113631139-1', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5472', 'RERAN', '8:a1aef2e0b4176d5766e4fc42034babd1', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-2', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5473', 'RERAN', '8:c04d4a85061ee62d9f44960950a8550f', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-3', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5474', 'RERAN', '8:7b5f631ea99bfbfd0bac4647445f4e28', 'sql', 'check_update 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-4', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5475', 'RERAN', '8:19ab0de6255da3dd628398e716655442', 'sql', 'check_update 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-5', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5476', 'RERAN', '8:a8bdee1c2d2c83ee7630303ccfe7c07f', 'sql', 'plan_task_detail_insert 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-6', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5477', 'RERAN', '8:1b3d09113a9e17de1d38430f03441111', 'sql', 'plan_task_detail_insert 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-7', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5480', 'RERAN', '8:19732aa4d6156fb23c489667653db9e7', 'sql', 'p_point_classify_delete 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-8', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5481', 'RERAN', '8:393e89ede95ceb53c80080fe6927f368', 'sql', 'p_point_classify_delete 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-10', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:51', '5482', 'RERAN', '8:579a8dcfe972b54c5e09d9a3f04fd1ca', 'sql', 'trigger_route_point_insert_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-11', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5483', 'RERAN', '8:c0e030f33907ce41c58717d33744ebba', 'sql', 'trigger_route_point_insert_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-12', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5484', 'RERAN', '8:05d3aa34603d59c3265614a4f9bcb4db', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-13', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5485', 'RERAN', '8:9035eed706219b6f7a4f5de098b05085', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-14', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5486', 'RERAN', '8:7d21c89d5b7e16261fc2b019711a98af', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-15', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5487', 'RERAN', '8:e2fd47543ee53e8ac2c0373931fc6483', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-20', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5488', 'EXECUTED', '8:ae36415d04b81fc32c7f4f1614e7169b', 'createProcedure procedureName=updatePlanTask', '', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-21', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5489', 'EXECUTED', '8:3119cbd45b548be5bfa00e55f0b34ab1', 'createProcedure procedureName=updatePlanTask', '', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-22', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5490', 'EXECUTED', '8:0aeaf538b80f16e9d17eb060c99ce379', 'createProcedure procedureName=planTaskStatistics', '', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-23', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5491', 'EXECUTED', '8:68fa1b5431afb6c73ddd85869576233b', 'createProcedure procedureName=planTaskStatistics', '', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-24', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5492', 'EXECUTED', '8:aafa72adc776aa914459206ce3a6b849', 'createProcedure procedureName=everyDayInitPlanTaskStatistics', '', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-25', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5493', 'EXECUTED', '8:a0d80840cd406c60c733b30828278bd4', 'createProcedure procedureName=everyDayInitPlanTaskStatistics', '', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-16', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5495', 'EXECUTED', '8:d9dba034c2d8bbdf83b862594dd6028d', 'sql', 'addPointConfig 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-17', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5496', 'EXECUTED', '8:9cebea1ef701192a90a5e86567c57611', 'sql', 'addPointConfig 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-18', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5497', 'EXECUTED', '8:54c4458cf3c3fb2d402f22d908782857', 'sql', 'deletePointConfig 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('15541113631139-19', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-01-12 11:13:52', '5498', 'EXECUTED', '8:d11c3d04496d304612c99ff1a588a0c1', 'sql', 'deletePointConfig 触发器创建', null, '3.6.3', null, null, '0421241510');
INSERT INTO `databasechangelog` VALUES ('1610421278000-1', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30684', 'RERAN', '8:a1aef2e0b4176d5766e4fc42034babd1', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-2', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30685', 'RERAN', '8:c04d4a85061ee62d9f44960950a8550f', 'sql', 'check_insert 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-3', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30686', 'RERAN', '8:7b5f631ea99bfbfd0bac4647445f4e28', 'sql', 'check_update 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-4', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30687', 'RERAN', '8:19ab0de6255da3dd628398e716655442', 'sql', 'check_update 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-5', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30688', 'RERAN', '8:a8bdee1c2d2c83ee7630303ccfe7c07f', 'sql', 'plan_task_detail_insert 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-6', 'maoying', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30689', 'RERAN', '8:1b3d09113a9e17de1d38430f03441111', 'sql', 'plan_task_detail_insert 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-7', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30692', 'RERAN', '8:19732aa4d6156fb23c489667653db9e7', 'sql', 'p_point_classify_delete 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-8', 'suhuiguang', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30693', 'RERAN', '8:393e89ede95ceb53c80080fe6927f368', 'sql', 'p_point_classify_delete 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-10', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30694', 'RERAN', '8:579a8dcfe972b54c5e09d9a3f04fd1ca', 'sql', 'trigger_route_point_insert_update_point_route_info 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-11', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30695', 'RERAN', '8:c0e030f33907ce41c58717d33744ebba', 'sql', 'trigger_route_point_insert_update_point_route_info 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-12', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30696', 'RERAN', '8:05d3aa34603d59c3265614a4f9bcb4db', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-13', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30697', 'RERAN', '8:9035eed706219b6f7a4f5de098b05085', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-14', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30698', 'RERAN', '8:7d21c89d5b7e16261fc2b019711a98af', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-15', 'tianbo', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30699', 'RERAN', '8:e2fd47543ee53e8ac2c0373931fc6483', 'sql', 'trigger_route_point_update_update_point_route_info 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-20', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30700', 'RERAN', '8:ae36415d04b81fc32c7f4f1614e7169b', 'createProcedure procedureName=updatePlanTask', '', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-21', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30701', 'RERAN', '8:3119cbd45b548be5bfa00e55f0b34ab1', 'createProcedure procedureName=updatePlanTask', '', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-22', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30702', 'RERAN', '8:0aeaf538b80f16e9d17eb060c99ce379', 'createProcedure procedureName=planTaskStatistics', '', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-23', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30703', 'RERAN', '8:68fa1b5431afb6c73ddd85869576233b', 'createProcedure procedureName=planTaskStatistics', '', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-24', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30704', 'RERAN', '8:aafa72adc776aa914459206ce3a6b849', 'createProcedure procedureName=everyDayInitPlanTaskStatistics', '', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-25', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30705', 'RERAN', '8:a0d80840cd406c60c733b30828278bd4', 'createProcedure procedureName=everyDayInitPlanTaskStatistics', '', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-16', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30707', 'RERAN', '8:d9dba034c2d8bbdf83b862594dd6028d', 'sql', 'addPointConfig 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-17', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30708', 'RERAN', '8:9cebea1ef701192a90a5e86567c57611', 'sql', 'addPointConfig 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-18', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30709', 'RERAN', '8:54c4458cf3c3fb2d402f22d908782857', 'sql', 'deletePointConfig 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('1610421278000-19', 'gaodongdong', 'classpath:/db/changelog/patrol-sql-task.xml', '2021-06-09 15:39:32', '30710', 'RERAN', '8:d11c3d04496d304612c99ff1a588a0c1', 'sql', 'deletePointConfig 触发器创建', null, '3.6.3', null, null, '3224372079');
INSERT INTO `databasechangelog` VALUES ('20210113-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-13 15:42:22', '5867', 'EXECUTED', '8:8db85a52c7b3000d65091587c9e6322a', 'sql', '修改 wl_equipment_specific_alarm', null, '3.6.3', null, null, '0523742002');
INSERT INTO `databasechangelog` VALUES ('1610523503355-1', 'shg', 'classpath:/changelog/wl-2.1.5.xml', '2021-01-13 15:47:22', '5876', 'EXECUTED', '8:1b08b81fad654451b60327ff83958101', 'sql', 'wl_form_group_column 可乐二期修改字段为非必输', null, '3.6.3', null, null, '0524042161');
INSERT INTO `databasechangelog` VALUES ('1610523503355-2', 'shg', 'classpath:/changelog/wl-2.1.5.xml', '2021-01-14 09:01:08', '5902', 'MARK_RAN', '8:94a45bb52e75371dfcb0b2111e564426', 'sql', '可乐需求增加部门字段', null, '3.6.3', null, null, '0586070535');
INSERT INTO `databasechangelog` VALUES ('20210114-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-14 09:28:59', '5915', 'EXECUTED', '8:78aebd7c2fe5c7ceb0d22168ed1b846b', 'sql', '修改 wl_equipment_specific_alarm', null, '3.6.3', null, null, '0587741213');
INSERT INTO `databasechangelog` VALUES ('20210114-02', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-14 09:30:12', '5920', 'EXECUTED', '8:1f42f37cfc45c365fc88dbbff78a2109', 'sql', '修改 wl_equipment_specific_alarm', null, '3.6.3', null, null, '0587814297');
INSERT INTO `databasechangelog` VALUES ('20210114-03', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-14 15:15:41', '6057', 'EXECUTED', '8:6c2ae3670c3e9d8a7434ddfc274af980', 'sql', '修改 wl_equipment_specific_alarm', null, '3.6.3', null, null, '0608543908');
INSERT INTO `databasechangelog` VALUES ('20210114-04', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-14 16:53:25', '6126', 'EXECUTED', '8:003bc62b771d22052d9b3be7c72f30ea', 'sql', '修改 wl_video', null, '3.6.3', null, null, '0614407908');
INSERT INTO `databasechangelog` VALUES ('20210115-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-15 09:31:31', '6247', 'EXECUTED', '8:6721b0e691ebe0a185b2d212a8863098', 'sql', '修改 wl_video', null, '3.6.3', null, null, '0674295121');
INSERT INTO `databasechangelog` VALUES ('1611041746-1', 'keyong', 'classpath:/changelog/wl-2.1.5.xml', '2021-01-19 15:39:44', '6988', 'MARK_RAN', '8:a74002eafe11921b55bcf0c66567f6cc', 'sql', '可乐需求新增行业表', null, '3.6.3', null, null, '1041997254');
INSERT INTO `databasechangelog` VALUES ('1611041746-2', 'keyong', 'classpath:/changelog/wl-2.1.5.xml', '2021-01-19 15:57:25', '7005', 'EXECUTED', '8:55c2b66a79590d21554aadf67caecf88', 'sql', '装备分类添加行业id列', null, '3.6.3', null, null, '1043057607');
INSERT INTO `databasechangelog` VALUES ('1611041746-3', 'keyong', 'classpath:/changelog/wl-2.1.5.xml', '2021-01-19 19:13:02', '7182', 'EXECUTED', '8:4b494bf1ee70e823f13dff7098de5025', 'sql', '装备分类添加行业编码列', null, '3.6.3', null, null, '1054795760');
INSERT INTO `databasechangelog` VALUES ('20210120-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-01-20 15:47:58', '7452', 'EXECUTED', '8:1ff553f34b0be99d2e96e5541322c0fe', 'sql', '修改 wl_equipment_detail', null, '3.6.3', null, null, '1128878067');
INSERT INTO `databasechangelog` VALUES ('1611092688-1', 'keyong', 'classpath:/changelog/wl-2.1.5.xml', '2021-01-20 17:37:28', '7601', 'EXECUTED', '8:27530b9d232f7b14adc2f0e8bd8ca63e', 'sql', '行业表添加排序字段', null, '3.6.3', null, null, '1135449994');
INSERT INTO `databasechangelog` VALUES ('1611092688-2', 'tb', 'classpath:/changelog/wl-2.1.5.xml', '2021-01-21 09:48:22', '7790', 'EXECUTED', '8:a0029b29d2ee265df36bde8704dae391', 'sql', '行业编码唯一索引', null, '3.6.3', null, null, '1193704919');
INSERT INTO `databasechangelog` VALUES ('1611716870-1', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 11:15:39', '8608', 'EXECUTED', '8:f76d8d81e71481242a9404992f3d1ec0', 'createIndex indexName=point_id_index, tableName=p_point_classify', '', null, '3.6.3', null, null, '1717339637');
INSERT INTO `databasechangelog` VALUES ('1611716870-2', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 11:15:40', '8609', 'EXECUTED', '8:6b71099067d601211ab25f6f2b7e1476', 'createIndex indexName=check_id_index, tableName=p_task', '', null, '3.6.3', null, null, '1717339637');
INSERT INTO `databasechangelog` VALUES ('1611716870-3', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 11:15:40', '8610', 'EXECUTED', '8:f1df4a6d76c704aba49aca941de398eb', 'createIndex indexName=check_time_index, tableName=p_check', '', null, '3.6.3', null, null, '1717339637');
INSERT INTO `databasechangelog` VALUES ('1611716870-4', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 11:15:41', '8611', 'EXECUTED', '8:af0ee8e356ac71debc563ec7e321e6f4', 'sql', '', null, '3.6.3', null, null, '1717339637');
INSERT INTO `databasechangelog` VALUES ('1611716870-5', 'tb', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 11:15:41', '8612', 'EXECUTED', '8:d255e2f874b99e6fbbf9d07d9d24d697', 'sql', '', null, '3.6.3', null, null, '1717339637');
INSERT INTO `databasechangelog` VALUES ('1611628333-1', 'keyong', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 18:19:42', '8703', 'EXECUTED', '8:f29d52bd7c034a8b4542a6df27fca7f4', 'sql', '创建隐患表p_latent_danger', null, '3.6.3', null, null, '1742784224');
INSERT INTO `databasechangelog` VALUES ('1611628333-2', 'keyong', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 18:19:42', '8704', 'EXECUTED', '8:43ffa32776154fbf8266c9811441e462', 'sql', '创建隐患工作流记录表p_latent_danger_flow_record', null, '3.6.3', null, null, '1742784224');
INSERT INTO `databasechangelog` VALUES ('1611628333-3', 'keyong', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 18:19:43', '8705', 'EXECUTED', '8:5db06d1cf5e94e8b88281582071aebcc', 'sql', '创建隐患巡检关系表p_latent_danger_patrol', null, '3.6.3', null, null, '1742784224');
INSERT INTO `databasechangelog` VALUES ('1611628333-4', 'keyong', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-27 18:19:43', '8706', 'EXECUTED', '8:897388d51d5d0b7102f8279551254f0c', 'sql', '创建隐患图片表p_latent_danger_photo', null, '3.6.3', null, null, '1742784224');
INSERT INTO `databasechangelog` VALUES ('1611890480-1', 'ky', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-29 11:25:16', '10783', 'EXECUTED', '8:c54f7b97e75c11079bfb03f029d155f4', 'sql', '', null, '3.6.3', null, null, '1890718254');
INSERT INTO `databasechangelog` VALUES ('1611890480-2', 'ky', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-29 11:25:17', '10784', 'EXECUTED', '8:887d6e5820f1954ea230ff72c5ecec66', 'sql', '', null, '3.6.3', null, null, '1890718254');
INSERT INTO `databasechangelog` VALUES ('1611890480-3', 'ky', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-01-29 19:21:38', '11353', 'EXECUTED', '8:bff9165516b1b46a890098392eed637c', 'sql', '', null, '3.6.3', null, null, '1919300804');
INSERT INTO `databasechangelog` VALUES ('1611716870-5', 'wjk', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-02-02 14:23:27', '11719', 'EXECUTED', '8:f311b79cf5c3c4e762091bfcd7b12fc7', 'sql', '', null, '3.6.3', null, null, '2247017341');
INSERT INTO `databasechangelog` VALUES ('1612272587000-1', 'wujunkai', 'classpath:/db/changelog/fas-2.0.1.xml', '2021-02-02 21:31:52', '12329', 'MARK_RAN', '8:f7770ca9622778cd6a0d61211fdddc52', 'sql', 'create table c_plan_classify_tree', null, '3.6.3', null, null, '2272721811');
INSERT INTO `databasechangelog` VALUES ('1612272587000-2', 'wujunkai', 'classpath:/db/changelog/fas-2.0.1.xml', '2021-02-02 21:31:52', '12330', 'MARK_RAN', '8:ab54313768f0cb818197f88b78fa75e0', 'sql', 'create table c_plan_detail', null, '3.6.3', null, null, '2272721811');
INSERT INTO `databasechangelog` VALUES ('1612272587000-3', 'wujunkai', 'classpath:/db/changelog/fas-2.0.1.xml', '2021-02-02 21:31:52', '12331', 'MARK_RAN', '8:20906b155791925a7a3a0789341ed33f', 'sql', 'create table c_plan_doc', null, '3.6.3', null, null, '2272721811');
INSERT INTO `databasechangelog` VALUES ('1612272587000-4', 'wujunkai', 'classpath:/db/changelog/fas-2.0.1.xml', '2021-02-02 21:31:52', '12332', 'MARK_RAN', '8:0ba0041db647780e7112f8d862b67ee1', 'sql', 'create table c_plan_equipment', null, '3.6.3', null, null, '2272721811');
INSERT INTO `databasechangelog` VALUES ('1612272587000-5', 'wujunkai', 'classpath:/db/changelog/fas-2.0.1.xml', '2021-02-02 21:31:52', '12333', 'MARK_RAN', '8:ed7ae73b12adb12b02324c68ec0565d5', 'sql', 'create table c_plan_operation_record', null, '3.6.3', null, null, '2272721811');
INSERT INTO `databasechangelog` VALUES ('1612272587000-6', 'wujunkai', 'classpath:/db/changelog/fas-2.0.1.xml', '2021-02-02 21:31:52', '12334', 'MARK_RAN', '8:b3f39018ff2f06c3903d8bfc884b04da', 'sql', 'create table c_plan_rule', null, '3.6.3', null, null, '2272721811');
INSERT INTO `databasechangelog` VALUES ('161195101-1', 'ky', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-02-07 14:56:04', '13082', 'EXECUTED', '8:46502fb23bbcec23dabdd52e4091a65e', 'sql', '', null, '3.6.3', null, null, '2680972912');
INSERT INTO `databasechangelog` VALUES ('1561454393001-1', 'suhg', 'classpath:/db/changelog/fas-sql-task.xml', '2021-06-07 10:26:37', '30556', 'RERAN', '8:8a1e7d1404a1b18afa384d2c9142189f', 'sql', 'update f_fmea_equipment_point 更新触发器创建', null, '3.6.3', null, null, '3032797109');
INSERT INTO `databasechangelog` VALUES ('1588901126339-1', 'shanqiyun', 'classpath:/db/changelog/fas-sql-task.xml', '2021-06-07 10:26:37', '30557', 'RERAN', '8:1201d1531bd5235267b90b7424ac9bfb', 'sql', 'f_risk_source 查询所有子节点id', null, '3.6.3', null, null, '3032797109');
INSERT INTO `databasechangelog` VALUES ('1589954524001-1', 'maoying', 'classpath:/db/changelog/fas-sql-task.xml', '2021-06-07 10:26:37', '30558', 'RERAN', '8:8d78b9fc0529776dbc5c8dc92bdc14f9', 'sql', 'updatePointConfig 触发器创建', null, '3.6.3', null, null, '3032797109');
INSERT INTO `databasechangelog` VALUES ('20210226-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-02-26 15:33:17', '14140', 'EXECUTED', '8:3e3a92530f1c9246c8f33f9fb6d05be5', 'sql', '修改 wl_video', null, '3.6.3', null, null, '4324801520');
INSERT INTO `databasechangelog` VALUES ('20210301-01', 'tiantao', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-01 14:34:36', '14516', 'MARK_RAN', '8:ae51b8971d0b2b4c2419b990ecf20687', 'sql', '创建 co_access_recording', null, '3.6.3', null, null, '4580485044');
INSERT INTO `databasechangelog` VALUES ('20210301-02', 'tiantao', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-01 14:34:36', '14517', 'MARK_RAN', '8:d72fbaf6134b721ff5057c8fd05b3191', 'sql', '创建 co_visitor_recording', null, '3.6.3', null, null, '4580485044');
INSERT INTO `databasechangelog` VALUES ('20210317-tb-1', 'tb', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-17 11:35:44', '17873', 'MARK_RAN', '8:647936acfd8dd5493f989d038d8ce552', 'sql', '访问记录唯一索引', null, '3.6.3', null, null, '5952141126');
INSERT INTO `databasechangelog` VALUES ('20210317-tb-2', 'tb', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-17 11:35:44', '17874', 'MARK_RAN', '8:8e6847e57eb73eb61a92e1b53be94a1d', 'addPrimaryKey tableName=co_visitor_recording', '', null, '3.6.3', null, null, '5952141126');
INSERT INTO `databasechangelog` VALUES ('1616047461-1', 'wjk', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-03-18 14:05:12', '18378', 'MARK_RAN', '8:ce89cbea0226f09c61766b1ce2a08ec8', 'sql', '', null, '3.6.3', null, null, '6047514072');
INSERT INTO `databasechangelog` VALUES ('20210318-tb-1', 'tb', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-18 14:26:47', '18474', 'EXECUTED', '8:82abdbeae13fa80e0c698217e93d2a3d', 'addColumn tableName=co_visitor_recording', '添加逻辑删除字段', null, '3.6.3', null, null, '6048808850');
INSERT INTO `databasechangelog` VALUES ('20210319-tb-1', 'tb', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-19 10:14:24', '18791', 'EXECUTED', '8:8308c25b223c0a99dd8e94f2d228e9e8', 'modifyDataType columnName=identity_number, tableName=co_visitor_recording; modifyDataType columnName=visitor_company, tableName=co_visitor_recording; modifyDataType columnName=visitors_number, tableName=co_visitor_recording; modifyDataType columnN...', '修改证件号码、访客单位、访客人数、员工姓名字段长度', null, '3.6.3', null, null, '6120064478');
INSERT INTO `databasechangelog` VALUES ('20210311-01', 'zjw', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-25 09:50:41', '20629', 'EXECUTED', '8:8fc55001a67791a118d20700ef31b1e9', 'sql', '修改 f_fire_fighting_system', null, '3.6.3', null, null, '6637041848');
INSERT INTO `databasechangelog` VALUES ('1616636836455-1', 'shg', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-25 09:54:14', '20641', 'EXECUTED', '8:74fe61ad526b72c44cec7ef846afbbb4', 'sql', 'create wl_dynamic_form_column 消防系统动态表单', null, '3.6.3', null, null, '6637256150');
INSERT INTO `databasechangelog` VALUES ('1616636836455-2', 'shg', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-25 09:54:14', '20642', 'EXECUTED', '8:d8d5dad8074042e5a2a3b8963b637788', 'sql', 'create wl_dynamic_form_group 消防系统动态表单', null, '3.6.3', null, null, '6637256150');
INSERT INTO `databasechangelog` VALUES ('1616636836455-3', 'shg', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-25 09:54:14', '20643', 'EXECUTED', '8:711faa3fa2436d48ebff3f0ff9745d07', 'sql', 'create wl_dynamic_form_instance 消防系统动态表单', null, '3.6.3', null, null, '6637256150');
INSERT INTO `databasechangelog` VALUES ('1616636836455-4', 'shg', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-25 13:01:09', '20714', 'EXECUTED', '8:2d9870034997ea1c8c88f4710c925e8f', 'sql', '消防系统管理,动态表单调整', null, '3.6.3', null, null, '6648471725');
INSERT INTO `databasechangelog` VALUES ('1616636836455-5', 'shg', 'classpath:/changelog/fas-1.0.0.xml', '2021-03-25 13:01:09', '20715', 'EXECUTED', '8:8e8f9b57811871cfb8b95dbabbb9627d', 'sql', '消防系统管理,动态表单调整', null, '3.6.3', null, null, '6648471725');
INSERT INTO `databasechangelog` VALUES ('1607398689001-2', 'keyong', 'classpath:/changelog/sql-task.xml', '2021-04-20 08:58:54', '27473', 'RERAN', '8:de4c0c92563107e33f69345c7f147f96', 'sql', '由于组态组件不支持复杂SQL语句业务因此添加此视图', null, '3.6.3', null, null, '8880345393');
INSERT INTO `databasechangelog` VALUES ('1618828879-1', 'xixinzhao', 'classpath:/db/changelog/patrol-3.0.0.xml', '2021-04-19 19:34:11', '27380', 'MARK_RAN', '8:305d93566fbb700952fe2f09b18219fa', 'sql', 'p_plan_task add column user_name', null, '3.6.3', null, null, '8832061051');
INSERT INTO `databasechangelog` VALUES ('1607398689001-3', 'keyong', 'classpath:/changelog/sql-task.xml', '2021-04-28 16:09:24', '29157', 'RERAN', '8:f42342fff5ad2a2bb233c5bd8f5b36c2', 'sql', '由于组态组件不支持复杂SQL语句业务因此添加此视图', null, '3.6.3', null, null, '9597364213');
INSERT INTO `databasechangelog` VALUES ('1619517821561-1', 'suhuiguang', 'classpath:/changelog/wl-3.0.1.xml', '2021-04-30 10:35:32', '29329', 'EXECUTED', '8:fc6bbdd545c5755eb8d1a9f834ad4386', 'sql', '插入动态表单数据 wl_form_group_column', null, '3.6.3', null, null, '9750132727');
INSERT INTO `databasechangelog` VALUES ('1619517821561-2', 'suhuiguang', 'classpath:/changelog/wl-3.0.1.xml', '2021-04-30 10:35:33', '29330', 'EXECUTED', '8:9ec3f17f21317adf665eb38a306553b7', 'sql', 'wl_equipment_specific add column area_id', null, '3.6.3', null, null, '9750132727');
INSERT INTO `databasechangelog` VALUES ('1619517821561-3', 'suhuiguang', 'classpath:/changelog/wl-3.0.1.xml', '2021-04-30 10:35:33', '29331', 'EXECUTED', '8:3a5303b648112c84a4f560fe365e19d7', 'sql', 'wl_equipment_specific modify column system_id', null, '3.6.3', null, null, '9750132727');
INSERT INTO `databasechangelog` VALUES ('1619520700565-1', 'shg', 'classpath:/db/changelog/patrol-3.0.1.xml', '2021-05-10 18:32:57', '29827', 'EXECUTED', '8:72a2750e61b52134dd81336220d6bb2c', 'sql', 'p_point add column area_id', null, '3.6.3', null, null, '0642777272');
INSERT INTO `databasechangelog` VALUES ('1619683142000-1', 'wjk', 'classpath:/db/changelog/patrol-3.0.1.xml', '2021-05-10 18:32:58', '29828', 'EXECUTED', '8:78a0e952d7a9c5f83e1fbf86b3155d7e', 'sql', 'p_point add column area_id', null, '3.6.3', null, null, '0642777272');
INSERT INTO `databasechangelog` VALUES ('1620610959379-1', 'suhuiguang', 'classpath:/changelog/wl-3.0.1.xml', '2021-05-17 15:37:59', '30097', 'EXECUTED', '8:edbf4320409dcb2da25b0f156b2273bf', 'createIndex indexName=idx_equipment_specific_id, tableName=wl_stock_detail', '', null, '3.6.3', null, null, '1237079607');
INSERT INTO `databasechangelog` VALUES ('1620800947757-1', 'suhuiguang', 'classpath:/changelog/wl-3.0.1.xml', '2021-05-17 15:37:59', '30098', 'EXECUTED', '8:76ae6351a60ca4475563ad0d3037cc08', 'sql', 'wl_equipment_specific_alarm add column confirm_user_name', null, '3.6.3', null, null, '1237079607');
INSERT INTO `databasechangelog` VALUES ('1621231410935-1', 'suhuiguang', 'classpath:/changelog/wl-3.0.1.xml', '2021-05-20 14:29:37', '30198', 'MARK_RAN', '8:160e4fd8e187a9f16a6b410d66d3b9b1', 'sql', '设备报警日报表 wl_equipment_alarm_report_day', null, '3.6.3', null, null, '1492177467');
INSERT INTO `databasechangelog` VALUES ('1621231410935-2', 'suhuiguang', 'classpath:/changelog/wl-3.0.1.xml', '2021-05-20 14:29:37', '30199', 'MARK_RAN', '8:931a66939b881d5642d3618806e11ad7', 'sql', '区域 wl_area', null, '3.6.3', null, null, '1492177467');
INSERT INTO `databasechangelog` VALUES ('1621826150001-1', 'gaojianqiang', 'classpath:/changelog/wl-3.0.1.xml', '2021-05-28 16:35:41', '30266', 'EXECUTED', '8:0804be402859bccda617c22104e7fcb0', 'sql', '插入动态表单数据 wl_form_group_column', null, '3.6.3', null, null, '2190941188');
INSERT INTO `databasechangelog` VALUES ('1621590618800-1', 'suhuiguang', 'classpath:/changelog/wl-3.0.1.xml', '2021-05-28 16:35:41', '30267', 'EXECUTED', '8:ec04b8324de90d093004c812c0bf130c', 'sql', 'f_fire_fighting_system add column charge_person_name', null, '3.6.3', null, null, '2190941188');
INSERT INTO `databasechangelog` VALUES ('1622011569539-1', 'suhuiguang', 'classpath:/changelog/wl-3.0.1.xml', '2021-05-28 16:35:41', '30268', 'EXECUTED', '8:a05b836caf0c35f5c42a4fb482b1c8ad', 'sql', 'wl_equipment_alarm_report_day add column equipment_detail_id', null, '3.6.3', null, null, '2190941188');
INSERT INTO `databasechangelog` VALUES ('1622011569539-2', 'suhuiguang', 'classpath:/changelog/wl-3.0.1.xml', '2021-05-28 16:35:41', '30269', 'EXECUTED', '8:0ca41a8d760d61825fdd2ab72a280d80', 'sql', 'wl_equipment_alarm_report_day add column equipment_id', null, '3.6.3', null, null, '2190941188');
INSERT INTO `databasechangelog` VALUES ('1622011569539-3', 'suhuiguang', 'classpath:/changelog/wl-3.0.1.xml', '2021-05-28 16:35:41', '30270', 'EXECUTED', '8:66190b56d82675a66f19895ac36aabce', 'sql', 'wl_equipment_alarm_report_day add column equipment_code', null, '3.6.3', null, null, '2190941188');
INSERT INTO `databasechangelog` VALUES ('1622088109840-1', 'suhuiguang', 'classpath:/changelog/wl-3.0.1.xml', '2021-05-28 16:35:41', '30271', 'EXECUTED', '8:941fdd9400b6d6c50b9374db08b9677a', 'sql', '报告流水表 wl_analysis_report_log', null, '3.6.3', null, null, '2190941188');
INSERT INTO `databasechangelog` VALUES ('1621590618802-1', 'suhuiguang', 'classpath:/changelog/wl-3.0.1.xml', '2021-05-28 17:45:42', '30272', 'MARK_RAN', '8:751165d50a908843f1f666430c8d804f', 'sql', 'f_fire_fighting_system add column charge_person_name', null, '3.6.3', null, null, '2194589882');
INSERT INTO `databasechangelog` VALUES ('1621826150001-2', 'gaojianqiang', 'classpath:/changelog/wl-3.0.1.xml', '2021-05-28 17:45:42', '30273', 'EXECUTED', '8:d60e57cf230dfaa41589c6e47f0bd48d', 'sql', '新增属性字段 f_fire_fighting_system', null, '3.6.3', null, null, '2194589882');
INSERT INTO `databasechangelog` VALUES ('1622519665128-4', 'xixinzhao', 'classpath:/changelog/wl-3.0.1.xml', '2021-06-02 18:08:49', '30303', 'EXECUTED', '8:5ab826887af788d36e5b2271d4a4945b', 'sql', 'wl_equipment_alarm_report_day add column alarm_type_name', null, '3.6.3', null, null, '2628529906');
INSERT INTO `databasechangelog` VALUES ('1607398689001-1', 'keyong', 'classpath:/changelog/sql-task-all.xml', '2021-06-09 14:11:07', '30618', 'RERAN', '8:9365b747b84987dd483864df66023a5b', 'sql', '由于组态组件不支持复杂SQL语句业务因此添加此视图', null, '3.6.3', null, null, '3218534481');
INSERT INTO `databasechangelog` VALUES ('1607398689001-3', 'keyong', 'classpath:/changelog/sql-task-all.xml', '2021-06-09 14:11:07', '30619', 'RERAN', '8:f42342fff5ad2a2bb233c5bd8f5b36c2', 'sql', '由于组态组件不支持复杂SQL语句业务因此添加此视图', null, '3.6.3', null, null, '3218534481');
INSERT INTO `databasechangelog` VALUES ('158890112635601-1', 'maoying', 'classpath:/changelog/sql-task-all.xml', '2021-06-09 14:11:07', '30620', 'RERAN', '8:ff480802d3c2ecc2f59df7e9a9490f3f', 'sql', '', null, '3.6.3', null, null, '3218534481');
INSERT INTO `databasechangelog` VALUES ('158890112635602-2', 'maoying', 'classpath:/changelog/sql-task-all.xml', '2021-06-09 14:11:07', '30621', 'RERAN', '8:b9fe9ddd3f8eb626c288a794b246dbca', 'sql', '', null, '3.6.3', null, null, '3218534481');
INSERT INTO `databasechangelog` VALUES ('1622621248843-1', 'suhuiguang', 'classpath:/changelog/wl-3.0.1.xml', '2021-06-02 19:00:39', '30308', 'EXECUTED', '8:f2b1df08d57487c1c156942d5c2e24ed', 'sql', 'wl_equipment_alarm_report_day add column index_true_num', null, '3.6.3', null, null, '2630860114');
INSERT INTO `databasechangelog` VALUES ('1622789789-1', 'keyong', 'classpath:/changelog/wl-3.0.1.xml', '2021-06-04 19:10:50', '30461', 'EXECUTED', '8:9e294a99c3d9238194aa33326e297ca2', 'sql', 'wl_equipment_alarm_report_day add column index_id', null, '3.6.3', null, null, '2805050667');
INSERT INTO `databasechangelog` VALUES ('1622789789-2', 'keyong', 'classpath:/changelog/wl-3.0.1.xml', '2021-06-04 19:10:50', '30462', 'EXECUTED', '8:f6e2f1c93824d042ea6e7df9da7b7f15', 'sql', 'wl_equipment_alarm_report_day add column index_name', null, '3.6.3', null, null, '2805050667');
INSERT INTO `databasechangelog` VALUES ('1622789789-3', 'keyong', 'classpath:/changelog/wl-3.0.1.xml', '2021-06-04 19:10:50', '30463', 'EXECUTED', '8:70f6ac85e5f605d0f285a11849ee8956', 'sql', 'wl_equipment_alarm_report_day add column index_type', null, '3.6.3', null, null, '2805050667');
INSERT INTO `databasechangelog` VALUES ('162260016600001-4', 'gaojianqiang', 'classpath:/changelog/sql-task-all.xml', '2021-06-09 14:11:07', '30622', 'RERAN', '8:699f5ed8c0a1903c3552ba9ff8db0601', 'sql', '创建视图v_fire_fightingsys_equip_index_status_mes_all', null, '3.6.3', null, null, '3218534481');
INSERT INTO `databasechangelog` VALUES ('162260016600001-5', 'gaojianqiang', 'classpath:/changelog/sql-task-all.xml', '2021-06-09 14:11:07', '30623', 'RERAN', '8:9e457095096c179136e0d167a48b4a15', 'sql', '创建视图v_fire_equip_alarm_60list', null, '3.6.3', null, null, '3218534481');
INSERT INTO `databasechangelog` VALUES ('1623060561-1', 'keyong', 'classpath:/changelog/wl-3.0.1.xml', '2021-06-09 10:13:11', '30601', 'EXECUTED', '8:71a9cc0b0f99bca0ecf18f5f79aefce0', 'sql', 'wl_equipment_specific_alarm add column system_ids', null, '3.6.3', null, null, '3204791827');
INSERT INTO `databasechangelog` VALUES ('1623060561-2', 'keyong', 'classpath:/changelog/wl-3.0.1.xml', '2021-06-09 10:13:11', '30602', 'EXECUTED', '8:8ad8793d9a71e342637900a8efb51bce', 'sql', 'wl_equipment_specific_alarm add column system_codes', null, '3.6.3', null, null, '3204791827');
INSERT INTO `databasechangelog` VALUES ('1623060561-3', 'keyong', 'classpath:/changelog/wl-3.0.1.xml', '2021-06-09 10:13:11', '30603', 'EXECUTED', '8:6fac0d8039f920cd715de4fdcfd805d5', 'sql', 'wl_equipment_specific_alarm add column equipment_code', null, '3.6.3', null, null, '3204791827');
INSERT INTO `databasechangelog` VALUES ('1623060561-4', 'keyong', 'classpath:/changelog/wl-3.0.1.xml', '2021-06-09 10:13:12', '30604', 'EXECUTED', '8:e34bfd737398b8c0102dde5440eb7396', 'sql', 'wl_equipment_specific_alarm add column equipment_id', null, '3.6.3', null, null, '3204791827');
INSERT INTO `databasechangelog` VALUES ('1623060561-5', 'keyong', 'classpath:/changelog/wl-3.0.1.xml', '2021-06-09 10:13:12', '30605', 'EXECUTED', '8:79a1a6e3677e4aa21a47c3237ced05c9', 'sql', 'wl_equipment_specific_alarm add column equipment_detail_id', null, '3.6.3', null, null, '3204791827');

-- ----------------------------
-- Table structure for databasechangeloglock
-- ----------------------------
DROP TABLE IF EXISTS `databasechangeloglock`;
CREATE TABLE `databasechangeloglock` (
  `ID` int(11) NOT NULL,
  `LOCKED` bit(1) NOT NULL,
  `LOCKGRANTED` datetime DEFAULT NULL,
  `LOCKEDBY` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of databasechangeloglock
-- ----------------------------
INSERT INTO `databasechangeloglock` VALUES ('1', '\0', null, null);

-- ----------------------------
-- Table structure for d_arrange
-- ----------------------------
DROP TABLE IF EXISTS `d_arrange`;
CREATE TABLE `d_arrange` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_code` varchar(255) DEFAULT NULL COMMENT '部门org_code',
  `name` varchar(255) DEFAULT NULL COMMENT '班次名称',
  `start_time` varchar(255) DEFAULT NULL COMMENT '开始时间',
  `end_time` varchar(255) DEFAULT NULL COMMENT '结束时间',
  `app_key` varchar(255) DEFAULT NULL COMMENT '系统标识',
  `creater` varchar(255) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `updater` varchar(255) DEFAULT NULL COMMENT '修改者',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='班次';

-- ----------------------------
-- Records of d_arrange
-- ----------------------------
INSERT INTO `d_arrange` VALUES ('36', '10', '早班', '当日: 08:00', '当日: 20:00', 'studio_normalapp_2681691', null, '2021-05-07 18:55:57', null, null);
INSERT INTO `d_arrange` VALUES ('37', '10', '晚班', '当日: 20:00', '次日: 08:00', 'studio_normalapp_2681691', null, null, null, null);

-- ----------------------------
-- Table structure for d_duty_details
-- ----------------------------
DROP TABLE IF EXISTS `d_duty_details`;
CREATE TABLE `d_duty_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL COMMENT '用户id',
  `duty_name` varchar(255) DEFAULT NULL COMMENT '值班人',
  `duty_date` datetime DEFAULT NULL COMMENT '值班日期',
  `arrange_id` bigint(20) DEFAULT NULL COMMENT '班次ID',
  `post_type` varchar(255) DEFAULT NULL COMMENT '岗位类型（来源数据字典）',
  `sort` int(10) DEFAULT NULL COMMENT '排序',
  `is_duty` bit(1) DEFAULT NULL COMMENT '是否值班【0：否；1：是】',
  `is_adjust` bit(1) DEFAULT NULL COMMENT '是否调班【0：否；1：是】',
  `creater` varchar(255) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `updater` varchar(255) DEFAULT NULL COMMENT '修改者',
  `update_date` datetime DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3956 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='值班表';

-- ----------------------------
-- Records of d_duty_details
-- ----------------------------
INSERT INTO `d_duty_details` VALUES ('3949', '1717342', '管理员', '2021-04-01 00:00:00', '36', 'safePerson', null, '', '\0', null, '2021-04-26 16:16:34', null, null);
INSERT INTO `d_duty_details` VALUES ('3950', '3094029', '马志胜', '2021-05-07 00:00:00', '36', 'dutyLeader', null, '', '\0', null, '2021-05-11 11:15:28', null, null);
INSERT INTO `d_duty_details` VALUES ('3951', '3095896', '王文轩', '2021-05-07 00:00:00', '37', 'deputyDutyLeader', null, '', '\0', null, '2021-05-11 11:15:28', null, null);
INSERT INTO `d_duty_details` VALUES ('3952', '3094029', '马志胜', '2021-05-08 00:00:00', '36', 'dutyLeader', null, '', '\0', null, '2021-05-11 11:15:28', null, null);
INSERT INTO `d_duty_details` VALUES ('3953', '3095896', '王文轩', '2021-05-08 00:00:00', '37', 'deputyDutyLeader', null, '', '\0', null, '2021-05-11 11:15:28', null, null);
INSERT INTO `d_duty_details` VALUES ('3954', '3106244', '黎向锋', '2021-05-17 00:00:00', '36', 'dutyLeader', null, '', '\0', null, null, null, null);
INSERT INTO `d_duty_details` VALUES ('3955', '1718015', '演示', '2021-05-17 00:00:00', '37', 'deputyDutyLeader', null, '', '\0', null, null, null, null);

-- ----------------------------
-- Table structure for elec_bills_alarm_info
-- ----------------------------
DROP TABLE IF EXISTS `elec_bills_alarm_info`;
CREATE TABLE `elec_bills_alarm_info` (
  `SEQUENCE_NBR` bigint(20) NOT NULL COMMENT '主键',
  `BILL_SEQ` bigint(20) NOT NULL COMMENT '登记单主键',
  `FIRE_EQUIPMENT_NAME` varchar(255) DEFAULT NULL COMMENT '探测器名称',
  `ALARM_DESC` varchar(255) DEFAULT NULL COMMENT '告警描述',
  `HANDLE_STATE` tinyint(4) DEFAULT NULL COMMENT '处理结果：0-未开始；1-已完成',
  `FILE_PATH` varchar(500) DEFAULT NULL COMMENT '附件照片路径',
  `ORIGIN_SEQ` bigint(20) DEFAULT NULL COMMENT '原始数据表主键（冗余追查数据用）',
  `CREATE_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `REC_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `REC_USER_ID` varchar(32) DEFAULT NULL COMMENT '最后更新者的id',
  `REMARK` varchar(255) DEFAULT NULL COMMENT '255',
  PRIMARY KEY (`SEQUENCE_NBR`) USING BTREE,
  KEY `idx_bill_warn_bill_seq` (`BILL_SEQ`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='安全监管单告警信息表';

-- ----------------------------
-- Records of elec_bills_alarm_info
-- ----------------------------

-- ----------------------------
-- Table structure for elec_bills_basic_info
-- ----------------------------
DROP TABLE IF EXISTS `elec_bills_basic_info`;
CREATE TABLE `elec_bills_basic_info` (
  `SEQUENCE_NBR` bigint(20) NOT NULL COMMENT '主键',
  `BILL_NO` varchar(20) NOT NULL COMMENT '单据编号',
  `STATION_SEQ` bigint(20) NOT NULL COMMENT '站编号',
  `STATION_NAME` varchar(255) DEFAULT NULL COMMENT '站名称',
  `DISTRIBUTION_USER_ID` bigint(20) DEFAULT NULL COMMENT '整改下发人员',
  `DISTRIBUTION_USER_NAME` varchar(50) DEFAULT NULL COMMENT '整改下发人员姓名',
  `STATION_CHARGE_PERSON` varchar(50) DEFAULT NULL COMMENT '换流站负责人',
  `CHARGE_PERSON_PHONE` varchar(20) DEFAULT NULL COMMENT '负责人联系电话',
  `SAFETY_CHARGE_PERSON` varchar(50) DEFAULT NULL COMMENT '安全负责人',
  `SAFETY_PERSON_PHONE` varchar(20) DEFAULT NULL COMMENT '安全负责人联系电话',
  `DISTRIBUTION_DATE` date DEFAULT NULL COMMENT '登记日期',
  `REQUIREMENT_DATE` date DEFAULT NULL COMMENT '要求完成时间',
  `ACTUAL_FINISH_DATE` date DEFAULT NULL COMMENT '实际完成日期',
  `FINISH_USER_NAME` varchar(50) DEFAULT NULL COMMENT '完成人员名称',
  `STATUS` tinyint(4) DEFAULT NULL COMMENT '当前状态：0-待下发；1-已下发；2-已完成；3-已关闭；',
  `REFORM_RESULT` varchar(255) DEFAULT NULL COMMENT '整改结果',
  `FEEDBACK_RESULT` varchar(255) DEFAULT NULL COMMENT '反馈结果',
  `VIEWS_AND_SUGGESTIONS` varchar(255) DEFAULT NULL COMMENT '意见及建议',
  `CREATE_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `REC_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `REC_USER_ID` varchar(32) DEFAULT NULL COMMENT '最后更新者的id',
  `REMARK` varchar(255) DEFAULT NULL COMMENT '255',
  PRIMARY KEY (`SEQUENCE_NBR`) USING BTREE,
  UNIQUE KEY `unique_key_basic_info_bill_no` (`BILL_NO`) USING BTREE,
  KEY `idx_base_bill_station_seq` (`STATION_SEQ`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='安全隐患整改单基本信息表';

-- ----------------------------
-- Records of elec_bills_basic_info
-- ----------------------------

-- ----------------------------
-- Table structure for elec_bills_danger_info
-- ----------------------------
DROP TABLE IF EXISTS `elec_bills_danger_info`;
CREATE TABLE `elec_bills_danger_info` (
  `SEQUENCE_NBR` bigint(20) NOT NULL COMMENT '主键',
  `BILL_SEQ` bigint(20) NOT NULL COMMENT '登记单主键',
  `DANGER_LEVEL` tinyint(4) DEFAULT NULL COMMENT '隐患等级（1：一般隐患；2：重大隐患） ',
  `DANGER_NAME` varchar(255) DEFAULT NULL COMMENT '风险点名称',
  `INPUT_ITEM_NAME` varchar(255) DEFAULT NULL COMMENT '检查项名称',
  `ORIGIN_SEQ` bigint(20) DEFAULT NULL COMMENT '原始数据表主键（冗余追查数据用）',
  `HANDLE_STATE` tinyint(4) DEFAULT NULL COMMENT '处理结果：0-未开始；1-已完成',
  `FILE_PATH` varchar(500) DEFAULT NULL COMMENT '附件照片路径',
  `CREATE_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `REC_USER_ID` varchar(32) DEFAULT NULL COMMENT '最后更新者的id',
  `REC_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `REMARK` varchar(255) DEFAULT NULL COMMENT '255',
  PRIMARY KEY (`SEQUENCE_NBR`) USING BTREE,
  KEY `idx_bill_danger_bill_seq` (`BILL_SEQ`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='安全监管表单隐患信息';

-- ----------------------------
-- Records of elec_bills_danger_info
-- ----------------------------

-- ----------------------------
-- Table structure for elec_bills_fire_safety_control
-- ----------------------------
DROP TABLE IF EXISTS `elec_bills_fire_safety_control`;
CREATE TABLE `elec_bills_fire_safety_control` (
  `SEQUENCE_NBR` bigint(20) NOT NULL COMMENT '主键',
  `BILL_SEQ` bigint(20) NOT NULL COMMENT '登记单主键',
  `TYPE` tinyint(4) DEFAULT NULL COMMENT '比较类型：0-消防应急预案；1-消防安全培训；2-消防日常训练；3-消防器材保养；',
  `ACTUAL_NUMBER` int(11) DEFAULT NULL COMMENT '实际数量',
  `THRESHOLD` int(11) DEFAULT NULL COMMENT '阈值',
  `STATE` tinyint(4) DEFAULT NULL COMMENT '状态:0-正常；1-异常（冗余字段）',
  `CREATE_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `REC_USER_ID` varchar(32) DEFAULT NULL COMMENT '最后更新者的id',
  `REC_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `REMARK` varchar(255) DEFAULT NULL COMMENT '255',
  PRIMARY KEY (`SEQUENCE_NBR`) USING BTREE,
  KEY `idx_bill_fire_bill_seq` (`BILL_SEQ`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='安全监管表单消防安全管理';

-- ----------------------------
-- Records of elec_bills_fire_safety_control
-- ----------------------------

-- ----------------------------
-- Table structure for elec_bills_risk_info
-- ----------------------------
DROP TABLE IF EXISTS `elec_bills_risk_info`;
CREATE TABLE `elec_bills_risk_info` (
  `SEQUENCE_NBR` bigint(20) NOT NULL COMMENT '主键',
  `BILL_SEQ` bigint(20) NOT NULL COMMENT '登记单主键',
  `POINT_NAME` varchar(255) DEFAULT NULL COMMENT '风险点名称',
  `LEVEL_NAME` varchar(32) DEFAULT NULL COMMENT '等级名称 ',
  `RISK_FACTOR_NAME` varchar(255) DEFAULT NULL COMMENT '危险因素名称',
  `ORIGIN_SEQ` bigint(20) DEFAULT NULL COMMENT '原始数据表主键（冗余追查数据用）',
  `CREATE_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `FEEDBACK` varchar(255) DEFAULT NULL COMMENT '反馈',
  `REC_USER_ID` varchar(32) DEFAULT NULL COMMENT '最后更新者的id',
  `REC_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `REMARK` varchar(255) DEFAULT NULL COMMENT '255',
  PRIMARY KEY (`SEQUENCE_NBR`) USING BTREE,
  KEY `idx_bill_risk_bill_seq` (`BILL_SEQ`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='安全监管风险信息表';

-- ----------------------------
-- Records of elec_bills_risk_info
-- ----------------------------

-- ----------------------------
-- Table structure for f_accident_type
-- ----------------------------
DROP TABLE IF EXISTS `f_accident_type`;
CREATE TABLE `f_accident_type` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `name` varchar(100) DEFAULT NULL COMMENT '事故类型',
  `evaluation_sid` bigint(32) DEFAULT NULL COMMENT 'evaluation_model 中 type 为s 的id',
  `influence` varchar(255) DEFAULT NULL COMMENT '失效/事故影响',
  `severity` varchar(255) DEFAULT NULL COMMENT '严重度',
  `dept_id` varchar(255) DEFAULT '0' COMMENT '维护部门',
  `create_by` varchar(255) DEFAULT '0' COMMENT '维护人员',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='事故类型表';

-- ----------------------------
-- Records of f_accident_type
-- ----------------------------
INSERT INTO `f_accident_type` VALUES ('1', '10', '设备故障', '26', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('2', '10', '断电设备突然停运', '27', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('3', '10', '其他', '30', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('4', '10', '电源短路', '25', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('5', '10', '火灾', '23', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('6', '10', '其他伤害', '29', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('7', '10', '触电事故', '25', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('11', '10', '人身触电', '25', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('12', '10', 'SF6气体防护', '25', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('13', '10', '高空坠落', '26', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('14', '10', '设备故障', '24', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('16', '10', '高空落物', '26', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('17', '10', '雷击事故', '22', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:10', null);
INSERT INTO `f_accident_type` VALUES ('18', '10', '静电及放射线事故', '26', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:11', null);
INSERT INTO `f_accident_type` VALUES ('19', '10', '小的事故类型', '22', null, null, '1245230062576365570', '1530151', '2020-06-28 09:45:11', null);
INSERT INTO `f_accident_type` VALUES ('23', '10', '测试世故', '23', null, null, '1232939516555915265', '1713102', '2021-02-04 13:03:53', null);

-- ----------------------------
-- Table structure for f_dict
-- ----------------------------
DROP TABLE IF EXISTS `f_dict`;
CREATE TABLE `f_dict` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `dict_name` varchar(255) DEFAULT NULL COMMENT '名称',
  `dict_code` varchar(255) DEFAULT NULL COMMENT '编码',
  `parent_id` bigint(11) DEFAULT NULL COMMENT '父ID',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否已经删除',
  `dict_value` varchar(255) DEFAULT NULL COMMENT '值',
  `dict_order` bigint(11) DEFAULT NULL COMMENT '序号',
  `remark` longtext COMMENT '说明',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of f_dict
-- ----------------------------
INSERT INTO `f_dict` VALUES ('1', '火警', 'fire_equipment_switch', '0', '\0', 'alarm_type_fire', '0', '火警');
INSERT INTO `f_dict` VALUES ('2', '开关', 'fire_equipment_switch', '0', '\0', 'alarm_type_power', '1', '开关');
INSERT INTO `f_dict` VALUES ('3', '液位', 'fire_equipment_analogue', '0', '\0', 'analogue_water_level', '0', '液位');
INSERT INTO `f_dict` VALUES ('4', '流量', 'fire_equipment_analogue', '0', '\0', 'analogue_water_flow', '1', '流量');
INSERT INTO `f_dict` VALUES ('5', '容量', 'fire_equipment_analogue', '0', '\0', 'analogue_water_capacity', '2', '容量');
INSERT INTO `f_dict` VALUES ('6', '换流变', 'fire_equipment_switch', '0', '\0', 'alarm_type_rheology', '2', '换流变');
INSERT INTO `f_dict` VALUES ('7', '故障', 'fire_equipment_switch', '0', '\0', 'alarm_type_trouble', '2', '故障告警');
INSERT INTO `f_dict` VALUES ('8', '消防车', 'plan_source_type', '0', '\0', 'fireCar', '0', null);
INSERT INTO `f_dict` VALUES ('9', '探测器', 'plan_source_type', '0', '\0', 'monitorEquipment', '1', null);
INSERT INTO `f_dict` VALUES ('10', '消防耗材', 'plan_source_type', '0', '\0', 'fireConsumables', '2', null);
INSERT INTO `f_dict` VALUES ('11', '视频监控', 'plan_source_type', '0', '\0', 'video', '3', null);
INSERT INTO `f_dict` VALUES ('12', '灭火器材', 'plan_source_type', '0', '\0', 'fireEquipment', '4', null);
INSERT INTO `f_dict` VALUES ('13', '重点装备', 'plan_source_type', '0', '\0', 'impEquipment', '5', null);
INSERT INTO `f_dict` VALUES ('14', '消防力量', 'plan_source_type', '0', '\0', 'fireStrength', '6', null);
INSERT INTO `f_dict` VALUES ('15', '消防小室', 'plan_source_type', '0', '\0', 'fireChamber', '7', null);
INSERT INTO `f_dict` VALUES ('16', '消防泡沫间', 'plan_source_type', '0', '\0', 'fireFoamRoom', '8', null);
INSERT INTO `f_dict` VALUES ('17', '消火栓', 'plan_source_type', '0', '\0', 'hydrant', '9', null);
INSERT INTO `f_dict` VALUES ('18', '消防水池', 'plan_source_type', '0', '\0', 'pool', '10', null);
INSERT INTO `f_dict` VALUES ('19', '名称', 'fireCar', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('20', '车牌号', 'fireCar', '0', '\0', 'car_num', '1', null);
INSERT INTO `f_dict` VALUES ('21', '发动机编号', 'fireCar', '0', '\0', 'engine_num', '2', null);
INSERT INTO `f_dict` VALUES ('22', '名称', 'monitorEquipment', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('23', '编号', 'monitorEquipment', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('24', '名称', 'fireConsumables', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('25', '编号', 'fireConsumables', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('26', '名称', 'video', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('27', '编号', 'video', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('30', '名称', 'fireEquipment', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('31', '编号', 'fireEquipment', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('32', '名称', 'impEquipment', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('33', '编号', 'impEquipment', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('34', '名称', 'fireStrength', '0', '\0', 'username', '0', null);
INSERT INTO `f_dict` VALUES ('35', '编号', 'fireStrength', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('36', '名称', 'fireChamber', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('37', '编号', 'fireChamber', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('38', '名称', 'fireFoamRoom', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('39', '编号', 'fireFoamRoom', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('40', '名称', 'hydrant', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('41', '编号', 'hydrant', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('42', '名称', 'pool', '0', '\0', 'name', '0', null);
INSERT INTO `f_dict` VALUES ('43', '编号', 'pool', '0', '\0', 'code', '1', null);
INSERT INTO `f_dict` VALUES ('44', '状态', 'fire_equipment_switch', '0', '\0', 'equipment_state', '3', null);
INSERT INTO `f_dict` VALUES ('45', '启停', 'fire_equipment_switch', '0', '\0', 'equipment_start_stop', '4', null);
INSERT INTO `f_dict` VALUES ('46', '警告', 'fire_equipment_switch', '0', '\0', 'equipment_warning', '5', null);

-- ----------------------------
-- Table structure for f_equipment
-- ----------------------------
DROP TABLE IF EXISTS `f_equipment`;
CREATE TABLE `f_equipment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `code` varchar(255) DEFAULT NULL COMMENT '编号',
  `name` varchar(255) DEFAULT NULL COMMENT '设备名称',
  `position3d` varchar(100) DEFAULT NULL COMMENT '3位坐标',
  `ue4_rotation` text COMMENT 'ue4旋转',
  `ue4_location` text COMMENT 'ue4位置',
  `floor3d` varchar(100) DEFAULT NULL COMMENT '3维楼层',
  `is_indoor` bit(1) NOT NULL DEFAULT b'1' COMMENT '是否室内:0-否；1-是',
  `building` varchar(255) DEFAULT NULL COMMENT '建筑物',
  `room` varchar(255) DEFAULT NULL COMMENT '房间号',
  `address` varchar(255) DEFAULT NULL COMMENT '位置',
  `charge_dept_id` varchar(255) DEFAULT '0' COMMENT '责任部门',
  `charge_user_id` varchar(255) DEFAULT '0' COMMENT '责任人',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `fire_station_id` bigint(20) DEFAULT NULL COMMENT '消防小室id',
  `reserve_plan` varchar(100) DEFAULT NULL COMMENT '预案配置',
  `sort_num` int(11) DEFAULT NULL,
  `fire_truck_route` varchar(255) DEFAULT NULL COMMENT '消防车到重点设备行车路线',
  `risk_source_id` bigint(20) DEFAULT '0' COMMENT '风险区域id',
  `status` tinyint(4) DEFAULT '0' COMMENT '预案状态：1-启动，0-未启动',
  `start_time` datetime DEFAULT NULL COMMENT '预案开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '预案结束时间',
  `reserve_source` tinyint(4) DEFAULT '0' COMMENT '预案来源：1-手动触发，0-自动触发（默认）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='重点设备表';

-- ----------------------------
-- Records of f_equipment
-- ----------------------------
INSERT INTO `f_equipment` VALUES ('1', '10', 'ZDSB0001', '极Ⅰ高端YY换流变A相', '', null, null, '', '', '极Ⅰ高端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:19:03', null, '', null, null, '1385155470456713217', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('2', '10', 'ZDSB0002', '极Ⅰ高端YY换流变B相', '', null, null, '', '', '极Ⅰ高端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:31:16', null, '', null, null, '1385155470456713217', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('3', '10', 'ZDSB0003', '极Ⅰ高端YY换流变C相', '', null, null, '', '', '极Ⅰ高端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:31:54', null, '', null, null, '1385155470456713217', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('4', '10', 'ZDSB0004', '极Ⅰ高端YD换流变A相', '', null, null, '', '', '极Ⅰ高端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:37:12', null, '', null, null, '1385155470456713217', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('5', '10', 'ZDSB0005', '极Ⅰ高端YD换流变B相', '', null, null, '', '', '极Ⅰ高端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:37:54', null, '', null, null, '1385155470456713217', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('6', '10', 'ZDSB0006', '极Ⅰ高端YD换流变C相', '', null, null, '', '', '极Ⅰ高端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:38:30', null, '', null, null, '1385155470456713217', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('7', '10', 'ZDSB0007', '极Ⅰ低端YY换流变A相', '', null, null, '', '', '极Ⅰ低端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:39:30', null, '', null, null, '1385155560999153666', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('8', '10', 'ZDSB0008', '极Ⅰ低端YY换流变B相', '', null, null, '', '', '极Ⅰ低端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:40:08', null, '', null, null, '1385155560999153666', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('9', '10', 'ZDSB0009', '极Ⅰ低端YY换流变C相', '', null, null, '', '', '极Ⅰ低端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:40:50', null, '', null, null, '1385155560999153666', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('10', '10', 'ZDSB0010', '极Ⅰ低端YD换流变A相', '', null, null, '', '', '极Ⅰ低端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:41:26', null, '', null, null, '1385155560999153666', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('11', '10', 'ZDSB0011', '极Ⅰ低端YD换流变B相', '', null, null, '', '', '极Ⅰ低端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:42:06', null, '', null, null, '1385155560999153666', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('12', '10', 'ZDSB0012', '极Ⅰ低端YD换流变C相', '', null, null, '', '', '极Ⅰ低端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:42:57', null, '', null, null, '1385155560999153666', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('13', '10', 'ZDSB0013', '极Ⅱ高端YY换流变A相', '', null, null, '', '', '极Ⅱ高端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:45:34', null, '', null, null, '1385155614413615105', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('14', '10', 'ZDSB0014', '极Ⅱ高端YY换流变B相', '', null, null, '', '', '极Ⅱ高端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:46:08', null, '', null, null, '1385155614413615105', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('15', '10', 'ZDSB0015', '极Ⅱ高端YY换流变C相', '', null, null, '', '', '极Ⅱ高端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:48:19', null, '', null, null, '1385155614413615105', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('16', '10', 'ZDSB0016', '极Ⅱ高端YD换流变A相', '', null, null, '', '', '极Ⅱ高端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:49:26', null, '', null, null, '1385155614413615105', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('17', '10', 'ZDSB0017', '极Ⅱ高端YD换流变B相', '', null, null, '', '', '极Ⅱ高端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:50:00', null, '', null, null, '1385155614413615105', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('18', '10', 'ZDSB0018', '极Ⅱ高端YD换流变C相', '', null, null, '', '', '极Ⅱ高端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:50:41', null, '', null, null, '1385155614413615105', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('19', '10', 'ZDSB0019', '极Ⅱ低端YY换流变A相', '', null, null, '', '', '极Ⅱ低端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:51:20', null, '', null, null, '1385155687834906626', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('20', '10', 'ZDSB0020', '极Ⅱ低端YY换流变B相', '', null, null, '', '', '极Ⅱ低端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:51:52', null, '', null, null, '1385155687834906626', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('21', '10', 'ZDSB0021', '极Ⅱ低端YY换流变C相', '', null, null, '', '', '极Ⅱ低端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:52:39', null, '', null, null, '1385155687834906626', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('22', '10', 'ZDSB0022', '极Ⅱ低端YD换流变A相', '', null, null, '', '', '极Ⅱ低端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:53:14', null, '', null, null, '1385155687834906626', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('23', '10', 'ZDSB0023', '极Ⅱ低端YD换流变B相', '', null, null, '', '', '极Ⅱ低端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:53:39', null, '', null, null, '1385155687834906626', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('24', '10', 'ZDSB0024', '极Ⅱ低端YD换流变C相', '', null, null, '', '', '极Ⅱ低端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:54:14', null, '', null, null, '1385155687834906626', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('25', '10', 'ZDSB0025', '极Ⅰ低端阀塔', '', null, null, '', '', '极Ⅰ低端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:56:14', null, '', null, null, '1385155560999153666', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('26', '10', 'ZDSB0026', '极Ⅰ高端阀塔', '', null, null, '', '', '极Ⅰ高端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:56:55', null, '', null, null, '1385155470456713217', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('27', '10', 'ZDSB0027', '极Ⅱ低端阀塔', '', null, null, '', '', '极Ⅱ低端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:57:39', null, '', null, null, '1385155687834906626', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('28', '10', 'ZDSB0028', '极Ⅱ高端阀塔', '', null, null, '', '', '极Ⅱ高端阀厅', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:58:16', null, '', null, null, '1385155614413615105', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('29', '10', 'ZDSB0029', '1#主变压器A相', '', null, null, '', '', '750kV交流场', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:59:14', null, '', null, null, '1385154464893300737', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('30', '10', 'ZDSB0030', '1#主变压器B相', '', null, null, '', '', '750kV交流场', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 17:59:39', null, '', null, null, '1385154464893300737', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('31', '10', 'ZDSB0031', '1#主变压器C相', '', null, null, '', '', '750kV交流场', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 18:00:04', null, '', null, null, '1385154464893300737', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('32', '10', 'ZDSB0032', '2#主变压器A相', '', null, null, '', '', '750kV交流场', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 18:00:44', null, '', null, null, '1385154464893300737', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('33', '10', 'ZDSB0033', '2#主变压器B相', '', null, null, '', '', '750kV交流场', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 18:01:17', null, '', null, null, '1385154464893300737', null, null, null, null);
INSERT INTO `f_equipment` VALUES ('34', '10', 'ZDSB0034', '2#主变压器C相', '', null, null, '', '', '750kV交流场', '', '', '1263370637087387649', null, '', '3013601', '2021-04-28 18:01:48', null, '', null, null, '1385154464893300737', null, null, null, null);

-- ----------------------------
-- Table structure for f_equipment_fire_equipment
-- ----------------------------
DROP TABLE IF EXISTS `f_equipment_fire_equipment`;
CREATE TABLE `f_equipment_fire_equipment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `equipment_id` bigint(20) NOT NULL COMMENT '设备id',
  `fire_equipment_id` bigint(20) NOT NULL COMMENT '消防装备id',
  `create_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='重点设备与消防设备关联中间表';

-- ----------------------------
-- Records of f_equipment_fire_equipment
-- ----------------------------

-- ----------------------------
-- Table structure for f_equipment_manage
-- ----------------------------
DROP TABLE IF EXISTS `f_equipment_manage`;
CREATE TABLE `f_equipment_manage` (
  `SEQUENCE_NBR` bigint(20) NOT NULL COMMENT '主键',
  `NAME` varchar(255) DEFAULT NULL COMMENT '名称',
  `CODE` varchar(32) NOT NULL COMMENT '编号',
  `SYSTEM_TYPE` tinyint(4) DEFAULT NULL COMMENT '系统类别',
  `INSTALL_DATE` datetime DEFAULT NULL COMMENT '安装日期',
  `CHARGE_PERSON` varchar(10) DEFAULT NULL COMMENT '负责人',
  `CONSTRUCTION_UNIT` varchar(10) DEFAULT NULL COMMENT '施工单位',
  `MAINTENANCE_UNIT` varchar(10) DEFAULT NULL COMMENT '维保单位',
  `MAINTENANCE_FREQUENCY` varchar(10) DEFAULT NULL COMMENT '维保频率',
  `FIRST_MAINTENANCE_DATE` datetime DEFAULT NULL COMMENT '首次维保日期',
  `REC_USER_ID` varchar(32) DEFAULT NULL COMMENT '最后更新者的id',
  `REC_DATE` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `REMARK` varchar(255) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`SEQUENCE_NBR`) USING BTREE,
  UNIQUE KEY `f_equipment_manage_uniq` (`CODE`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='消防设施管理';

-- ----------------------------
-- Records of f_equipment_manage
-- ----------------------------

-- ----------------------------
-- Table structure for f_evaluation_model
-- ----------------------------
DROP TABLE IF EXISTS `f_evaluation_model`;
CREATE TABLE `f_evaluation_model` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `name` varchar(100) DEFAULT NULL COMMENT '模型名称',
  `standard` text COMMENT '模型内容',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `coefficient` varchar(50) DEFAULT NULL COMMENT '系数',
  `influence` varchar(500) DEFAULT NULL COMMENT '影响',
  `describe` varchar(500) DEFAULT NULL COMMENT '描述',
  `type` varchar(50) DEFAULT NULL COMMENT '类型：S，D，O',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='评价模型表';

-- ----------------------------
-- Records of f_evaluation_model
-- ----------------------------
INSERT INTO `f_evaluation_model` VALUES ('22', '1', null, null, '2019-05-28 00:36:56', '0', null, '10', '无警告的危害', '在没有任何预兆的情况下发生，影响人员或设备安全，或违反有关法律法规的及严重的故障模式。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('23', '1', null, null, '2019-05-28 00:36:56', '0', null, '9', '有警告的危害', '在有故障预兆的情况下发生，影响人员或设备安全，或违反有关法律法规的及严重的故障模式。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('24', '1', null, null, '2019-05-28 00:36:56', '0', null, '8', '很大', '对生产造成较大的破坏，设备全部或主要功能无法正常运行，但设备是安全的。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('25', '1', null, null, '2019-05-28 00:36:56', '0', null, '7', '大', '设备性能受到影响，但仍可实现功能并是安全的。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('26', '1', null, null, '2019-05-28 00:36:56', '0', null, '6', '中等', '设备性能退化，但仍可以工作并是安全的。局部故障，但仍可以工作。不重要零件不能工作。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('27', '1', null, null, '2019-05-28 00:36:56', '0', null, '5', '小', '对设备性能有中等程度的影响，不重要零件故障需要维修', 'S');
INSERT INTO `f_evaluation_model` VALUES ('28', '1', null, null, '2019-05-28 00:36:56', '0', null, '4', '很小', '队产品性能有较小影响。故障不需要维修', 'S');
INSERT INTO `f_evaluation_model` VALUES ('29', '1', null, null, '2019-05-28 00:36:56', '0', null, '3', '轻微', '对设备性能有轻微影响。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('30', '1', null, null, '2019-05-28 00:36:56', '0', null, '2', '很轻微', '对设备性能有非常轻微的影响。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('31', '1', null, null, '2019-05-28 00:36:56', '0', null, '1', '无', '无影响。', 'S');
INSERT INTO `f_evaluation_model` VALUES ('32', '1', null, null, '2019-05-28 00:36:56', '0', null, '10', '几乎不可能', '不可能探测或没有检查', 'D');
INSERT INTO `f_evaluation_model` VALUES ('33', '1', null, null, '2019-05-28 00:36:56', '0', null, '9', '很微小', '只能再失效发生后才能检测出', 'D');
INSERT INTO `f_evaluation_model` VALUES ('34', '1', null, null, '2019-05-28 00:36:56', '0', null, '8', '微小', '只能通过相关设备来进行探测', 'D');
INSERT INTO `f_evaluation_model` VALUES ('35', '1', null, null, '2019-05-28 00:36:56', '0', null, '7', '很小', '已全部纳管进安全执行系统或进行自动信号采集', 'D');
INSERT INTO `f_evaluation_model` VALUES ('36', '1', null, null, '2019-05-28 00:36:56', '0', null, '6', '小', '只能通过目测或手触来进行探测', 'D');
INSERT INTO `f_evaluation_model` VALUES ('37', '1', null, null, '2019-05-28 00:36:56', '0', null, '5', '中等', '只通过目测即可进行探测', 'D');
INSERT INTO `f_evaluation_model` VALUES ('38', '1', null, null, '2019-05-28 00:36:56', '0', null, '4', '中等偏上', '可通过仪表读数进行探测', 'D');
INSERT INTO `f_evaluation_model` VALUES ('39', '1', null, null, '2019-05-28 00:36:56', '0', null, '3', '高', '可通过中控仪表盘进行探测', 'D');
INSERT INTO `f_evaluation_model` VALUES ('40', '1', null, null, '2019-05-28 00:36:56', '0', null, '2', '很高', '有相应报警提示，出现故障后可在中控仪表盘中不断闪红', 'D');
INSERT INTO `f_evaluation_model` VALUES ('41', '1', null, null, '2019-05-28 00:36:56', '0', null, '1', '几乎肯定能', '有相应报警装置一旦出现故障可报警提示', 'D');
INSERT INTO `f_evaluation_model` VALUES ('42', '1', null, null, '2020-02-14 14:35:53', '0', null, '10', '很高：故障几乎不可避免', '0.9<O&&O<=1', 'O');
INSERT INTO `f_evaluation_model` VALUES ('43', '1', null, null, '2020-02-14 14:35:53', '0', null, '9', '很高：故障几乎不可避免', '0.8<O&&O<=0.9', 'O');
INSERT INTO `f_evaluation_model` VALUES ('44', '1', null, null, '2020-02-14 14:35:53', '0', null, '8', '高：反复发生的故障', '0.7<O&&O<=0.8', 'O');
INSERT INTO `f_evaluation_model` VALUES ('45', '1', null, null, '2020-02-14 14:35:53', '0', null, '7', '高：反复发生的故障', '0.6<O&&O<=0.7', 'O');
INSERT INTO `f_evaluation_model` VALUES ('46', '1', null, null, '2020-02-14 14:35:53', '0', null, '6', '中等：偶尔发生的故障', '0.5<O&&O<=0.6', 'O');
INSERT INTO `f_evaluation_model` VALUES ('47', '1', null, null, '2020-02-14 14:35:54', '0', null, '5', '中等：偶尔发生的故障', '0.4<O&&O<=0.5', 'O');
INSERT INTO `f_evaluation_model` VALUES ('48', '1', null, null, '2020-02-14 14:35:54', '0', null, '4', '中等：偶尔发生的故障', '0.3<O&&O<=0.4', 'O');
INSERT INTO `f_evaluation_model` VALUES ('49', '1', null, null, '2020-02-14 14:35:54', '0', null, '3', '低：相对很少发生', '0.2<O&&O<=0.3', 'O');
INSERT INTO `f_evaluation_model` VALUES ('50', '1', null, null, '2020-02-14 14:35:54', '0', null, '2', '低：相对很少发生', '0.1<O&&O<=0.2', 'O');
INSERT INTO `f_evaluation_model` VALUES ('51', '1', null, null, '2020-02-14 14:35:54', '0', null, '1', '极低：几乎不可能发生', '0<=O&&O<=0.1', 'O');

-- ----------------------------
-- Table structure for f_fire_equipment
-- ----------------------------
DROP TABLE IF EXISTS `f_fire_equipment`;
CREATE TABLE `f_fire_equipment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `code` varchar(255) DEFAULT NULL COMMENT '编号',
  `equip_classify` int(11) DEFAULT '0' COMMENT '装备分类：0-设备类；1-耗材类;2-视频监控;3-灭火器材',
  `equip_type` varchar(255) DEFAULT NULL COMMENT '装备类型',
  `equip_code` varchar(255) DEFAULT NULL COMMENT '装备编码',
  `position3d` varchar(100) DEFAULT NULL COMMENT '3维坐标',
  `ue4_rotation` text COMMENT 'ue4旋转',
  `ue4_location` text COMMENT 'ue4位置',
  `floor3d` varchar(100) DEFAULT NULL COMMENT '3维楼层',
  `is_indoor` bit(1) NOT NULL DEFAULT b'1' COMMENT '是否室内:0-否；1-是',
  `name` varchar(255) DEFAULT NULL COMMENT '装备名称',
  `model` varchar(255) DEFAULT NULL COMMENT '规格型号',
  `maintenance_cycle` int(11) DEFAULT '0' COMMENT '保养周期',
  `manufacturer` varchar(255) DEFAULT NULL COMMENT '厂商',
  `brand` varchar(255) DEFAULT NULL COMMENT '品牌',
  `production_date` date DEFAULT NULL COMMENT '生产日期',
  `effective_date` date DEFAULT NULL COMMENT '有效时间',
  `number` int(11) DEFAULT '0' COMMENT '数量',
  `unit` varchar(255) DEFAULT NULL COMMENT '单位',
  `production_area` varchar(255) DEFAULT NULL COMMENT '区域',
  `room` varchar(255) DEFAULT NULL COMMENT '房间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `equip_status` int(11) DEFAULT '0' COMMENT '设备状态（1，告警； 0，正常; ）',
  `video_url` varchar(255) DEFAULT NULL COMMENT '视频路径',
  `weight` decimal(10,2) DEFAULT NULL COMMENT '重量',
  `action_state` varchar(50) DEFAULT '' COMMENT '动作状态',
  `eruption_state` varchar(50) DEFAULT '' COMMENT '喷发状态',
  `risk_source_id` bigint(20) DEFAULT '0' COMMENT '风险区域id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消防装备表';

-- ----------------------------
-- Records of f_fire_equipment
-- ----------------------------

-- ----------------------------
-- Table structure for f_fire_equipment_point
-- ----------------------------
DROP TABLE IF EXISTS `f_fire_equipment_point`;
CREATE TABLE `f_fire_equipment_point` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `code` varchar(255) DEFAULT NULL COMMENT '编号',
  `fire_equipment_id` bigint(20) NOT NULL COMMENT '消防装备id',
  `create_by` varchar(225) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建日期',
  `remark` varchar(255) DEFAULT NULL,
  `type` varchar(32) NOT NULL COMMENT '类型：模拟量ANALOGUE，开关量SWITCH',
  `value` varchar(50) DEFAULT NULL COMMENT '当前值保存时若为开关量（1,0）默认为1',
  `unit` varchar(50) DEFAULT NULL COMMENT '指标项名称',
  `org_code` varchar(50) DEFAULT NULL COMMENT '组织',
  `alarm_type` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消防装备点表';

-- ----------------------------
-- Records of f_fire_equipment_point
-- ----------------------------

-- ----------------------------
-- Table structure for f_fire_fighting_system
-- ----------------------------
DROP TABLE IF EXISTS `f_fire_fighting_system`;
CREATE TABLE `f_fire_fighting_system` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `code` varchar(32) NOT NULL COMMENT '编号',
  `system_type` bigint(20) DEFAULT NULL COMMENT '系统类别',
  `form_group_id` bigint(20) DEFAULT NULL COMMENT '动态表单分组id',
  `install_date` datetime DEFAULT NULL COMMENT '安装日期',
  `charge_person` varchar(20) DEFAULT NULL COMMENT '负责人',
  `construction_unit` bigint(20) DEFAULT NULL COMMENT '施工单位',
  `maintenance_unit` bigint(20) DEFAULT NULL COMMENT '维保单位',
  `maintenance_frequency` varchar(20) DEFAULT NULL COMMENT '维保频率',
  `first_maintenance_date` datetime DEFAULT NULL COMMENT '首次维保日期',
  `rec_user_id` varchar(32) DEFAULT NULL COMMENT '最后更新者的id',
  `rec_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '更新时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `scene_id` bigint(20) DEFAULT NULL COMMENT '画布id',
  `sort` bigint(20) DEFAULT NULL COMMENT '排序',
  `charge_person_phone` varchar(20) DEFAULT NULL COMMENT '负责人电话',
  `maintenance_phone` varchar(20) DEFAULT NULL COMMENT '维保电话',
  `org_code` varchar(20) DEFAULT NULL,
  `contro_box_build` bigint(20) DEFAULT NULL COMMENT '控制柜所在建筑',
  `pro_object` varchar(255) DEFAULT NULL COMMENT '保护对象',
  `instance_id` bigint(20) DEFAULT NULL COMMENT '动态表单实例id',
  `pro_code` varchar(32) DEFAULT NULL COMMENT '产品编码',
  `factory` bigint(20) DEFAULT NULL COMMENT '生产厂家',
  `contro_box_address` varchar(255) DEFAULT NULL COMMENT '控制柜安装位置',
  `charge_person_name` varchar(255) DEFAULT NULL COMMENT '负责人姓名',
  `core_component_ids` varchar(255) DEFAULT NULL COMMENT '核心部件Ids',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `f_equipment_manage_uniq` (`code`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1620383459229 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='消防系统管理';

-- ----------------------------
-- Records of f_fire_fighting_system
-- ----------------------------
INSERT INTO `f_fire_fighting_system` VALUES ('1619078778474', '其他系统', '029026401813010000000061', '1385138035104083969', '1385141413515292673', null, '1717342', null, null, null, null, '1718015', '2021-04-22 16:06:18', null, null, '1619078778474', null, null, '10', null, '', '1385142907329245186', null, null, null, null, null);
INSERT INTO `f_fire_fighting_system` VALUES ('1619085975042', '排油注氮系统', '029026401813010000000030', '1385138035104083969', '1385141413515292673', null, '1717342', null, null, null, null, '3092607', '2021-05-12 18:02:49', null, null, '1619085975042', null, null, '10', null, '', '1385173091918999554', null, null, null, null, null);
INSERT INTO `f_fire_fighting_system` VALUES ('1619086022531', '消防给水及消火栓系统', '029026401813010000000047', '1302870336149262337', '1385141294619357186', null, '1717342', null, null, null, null, '3092607', '2021-05-12 18:03:39', null, null, '1619086022531', null, null, '10', null, '', '1385173291102302209', null, null, null, null, null);
INSERT INTO `f_fire_fighting_system` VALUES ('1619086103649', '火灾自动报警系统', '029026401813010000000016', '1302870628873932802', '1385141358179840001', null, '1717342', null, null, null, null, '3092607', '2021-05-12 18:02:23', null, null, '1', null, null, '10', null, '', '1385173631340048386', null, null, null, null, null);
INSERT INTO `f_fire_fighting_system` VALUES ('1619086125285', '压缩空气泡沫灭火系统（CAFS）', '029026401813010000000023', '1302870567007948801', '1385141340366630914', null, '1717342', null, null, null, null, '3092607', '2021-05-12 18:03:21', null, null, '1619086125285', null, null, '10', null, '', '1385173722083815425', null, null, null, null, null);
INSERT INTO `f_fire_fighting_system` VALUES ('1620383459228', '泡沫灭火系统', '029026401813010000000054', '1390614748298629121', '1390614882323419138', null, '1717342', null, null, null, null, '3092607', '2021-05-12 18:08:13', null, null, '1620383459228', null, null, '10', null, '', null, null, null, null, null, null);

-- ----------------------------
-- Table structure for f_fmea
-- ----------------------------
DROP TABLE IF EXISTS `f_fmea`;
CREATE TABLE `f_fmea` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `risk_source_id` bigint(20) NOT NULL COMMENT '风险点id',
  `risk_factors_id` bigint(20) DEFAULT '0' COMMENT '危险因素id',
  `evaluation_sid` bigint(20) DEFAULT '0' COMMENT '危险程度',
  `evaluation_oid` bigint(20) DEFAULT '0' COMMENT '故障频数',
  `evaluation_did` bigint(20) DEFAULT '0' COMMENT '探测度',
  `rpni` decimal(10,2) DEFAULT NULL COMMENT '固有rpn',
  `rpn` decimal(10,2) DEFAULT NULL COMMENT '实时rpn',
  `new_evaluation_oid` bigint(20) DEFAULT NULL COMMENT '最新故障频数',
  `engineering` text COMMENT '工程措施',
  `management` text COMMENT '管理措施',
  `train` text COMMENT '培训教育',
  `protection` text COMMENT '个体防护',
  `disposal` text COMMENT '应急处置',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `company_leader` varchar(255) DEFAULT NULL COMMENT '公司负责人',
  `department_leader` varchar(255) DEFAULT NULL COMMENT '部门负责人',
  `group_leader` varchar(255) DEFAULT NULL COMMENT '班组负责人',
  `person_leader` varchar(255) DEFAULT NULL COMMENT '个人负责人',
  `identify_user` varchar(255) DEFAULT NULL COMMENT '辨识人',
  `identify_method` varchar(255) DEFAULT NULL COMMENT '辨识方法',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `risk_level_id` bigint(20) DEFAULT NULL COMMENT '风险等级id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=292 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='FEMA表';

-- ----------------------------
-- Records of f_fmea
-- ----------------------------
INSERT INTO `f_fmea` VALUES ('1', '28', '17', '23', '51', '37', '45.00', '45.00', '51', '', '', '', '运行人员进入阀厅巡视走道前，应佩戴防毒面具、防火服等防火器具\n', '必要时，运行人员应拨打119，请求消防部门协助灭火。\n', '', '', '', '', '', '', '', null, '', null);
INSERT INTO `f_fmea` VALUES ('2', '28', '19', '30', '51', '37', '10.00', '10.00', '51', '观察漏水点，确定水迹来源和泄漏程度\n', '', '', '', '如阀塔水管漏水严重，或者发现阀塔已经有放电、灼烧现象时，应紧急停运该阀组，同时汇报值班调控人员。后做好隔离、接地措施，联系专业人员处理。\n', '', '', '', '', '', '', '', null, '', null);
INSERT INTO `f_fmea` VALUES ('3', '28', '12', '26', '51', '37', '30.00', '30.00', '51', '', '', '巡视检查时应与带电设备保持足够的安全距离，10kV—0.7m，35（20）kV—1m，110（66） kV—1.5m，220kV—3m, 330kV—4m，500kV-5m，750kV-7.2m，1000kV-8.7m。\n', '巡视中运维人员应按照巡视路线进行，在进入设备室、打开机构箱、屏柜门时不得进行其他工作（严禁进行电气工作）。不得移开或越过遮栏\n', '', '', '', '', '', '', '', '', null, '', null);
INSERT INTO `f_fmea` VALUES ('4', '28', '20', '26', '51', '37', '30.00', '30.00', '51', '', '检查在线检测装置和阀避雷器有无异常现象，检查阀塔悬吊结构有无异常\n', '', '', '必要时将换流阀停运登塔检查\n', '', '', '', '', '', '', '', null, '', null);
INSERT INTO `f_fmea` VALUES ('5', '29', '46', '30', '51', '38', '8.00', '8.00', '51', '', '对供暖设备检查维护\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:15:17', '1959569', null);
INSERT INTO `f_fmea` VALUES ('6', '29', '45', '30', '51', '36', '12.00', '12.00', '51', '', '对喷头定期清理\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:15:14', '1959569', null);
INSERT INTO `f_fmea` VALUES ('7', '29', '43', '30', '51', '37', '10.00', '10.00', '51', '对故障设备进行维修或者跟换\n', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:15:12', '1959569', null);
INSERT INTO `f_fmea` VALUES ('8', '29', '42', '26', '51', '36', '36.00', '36.00', '51', '', '对管道定期检查维护', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:15:09', '1959569', null);
INSERT INTO `f_fmea` VALUES ('9', '30', '27', '26', '51', '38', '24.00', '24.00', '51', '检查冷却器是否全部投入、运行是否正常 检查换流变压器的负荷情况和环境温度				', '', '', '', '降低负荷，必要时申请将换流变压器停运\n', '', '', '', '', '', '', '', '2020-10-15 23:15:41', '1959569', null);
INSERT INTO `f_fmea` VALUES ('10', '30', '26', '26', '51', '37', '30.00', '30.00', '51', '采取在线补气，\n', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:15:38', '1959569', null);
INSERT INTO `f_fmea` VALUES ('11', '30', '25', '26', '51', '37', '30.00', '30.00', '51', '', '检查运行阀组或极是否过负荷		', '', '', '	隔离故障换流变压器\n', '', '', '', '', '', '', '', '2020-10-15 23:15:35', '1959569', null);
INSERT INTO `f_fmea` VALUES ('12', '30', '24', '26', '51', '37', '30.00', '30.00', '51', '检查是否为过电压、过负荷、铁磁共振、谐波或直流偏磁作用引起	', '定期检查冷却器、风扇等附件是否存在不平衡或剐蹭引起的振动\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:15:30', '1959569', null);
INSERT INTO `f_fmea` VALUES ('13', '30', '23', '23', '51', '37', '45.00', '45.00', '51', '', '', '', '', '断开换流变压器辅助电源上级开关\n', '', '', '', '', '', '', '', '2020-10-15 23:15:26', '1959569', null);
INSERT INTO `f_fmea` VALUES ('14', '30', '21', '24', '51', '37', '40.00', '40.00', '51', '现场检查滤油机漏油处密封情况，若为紧固螺丝松动则按对角线逐个拧紧螺丝，若为密封圈老化则更换密封圈\n', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:15:24', '1959569', null);
INSERT INTO `f_fmea` VALUES ('15', '31', '12', '26', '51', '33', '54.00', '54.00', '51', '', '', '', '佩戴安全帽\n', '', '', '', '', '', '', '', '', '2020-10-15 23:15:45', '1959569', null);
INSERT INTO `f_fmea` VALUES ('16', '32', '17', '23', '51', '37', '45.00', '45.00', '51', '', '', '', '运行人员进入阀厅巡视走道前，应佩戴防毒面具、防火服等防火器具\n', '必要时，运行人员应拨打119，请求消防部门协助灭火。\n', '', '', '', '', '', '', '', null, '', null);
INSERT INTO `f_fmea` VALUES ('17', '32', '19', '30', '51', '37', '10.00', '10.00', '51', '观察漏水点，确定水迹来源和泄漏程度\n', '', '', '', '如阀塔水管漏水严重，或者发现阀塔已经有放电、灼烧现象时，应紧急停运该阀组，同时汇报值班调控人员。后做好隔离、接地措施，联系专业人员处理。\n', '', '', '', '', '', '', '', null, '', null);
INSERT INTO `f_fmea` VALUES ('18', '32', '12', '26', '51', '37', '30.00', '30.00', '51', '', '', '巡视检查时应与带电设备保持足够的安全距离，10kV—0.7m，35（20）kV—1m，110（66） kV—1.5m，220kV—3m, 330kV—4m，500kV-5m，750kV-7.2m，1000kV-8.7m。\n', '巡视中运维人员应按照巡视路线进行，在进入设备室、打开机构箱、屏柜门时不得进行其他工作（严禁进行电气工作）。不得移开或越过遮栏\n', '', '', '', '', '', '', '', '', null, '', null);
INSERT INTO `f_fmea` VALUES ('19', '32', '20', '26', '51', '37', '30.00', '30.00', '51', '', '检查在线检测装置和阀避雷器有无异常现象，检查阀塔悬吊结构有无异常\n', '', '', '必要时将换流阀停运登塔检查\n', '', '', '', '', '', '', '', null, '', null);
INSERT INTO `f_fmea` VALUES ('20', '33', '27', '26', '51', '38', '24.00', '24.00', '51', '检查冷却器是否全部投入、运行是否正常 检查换流变压器的负荷情况和环境温度				', '', '', '', '降低负荷，必要时申请将换流变压器停运\n', '', '', '', '', '', '', '', '2020-10-15 23:17:11', '1959569', null);
INSERT INTO `f_fmea` VALUES ('21', '33', '26', '26', '51', '37', '30.00', '30.00', '51', '采取在线补气，\n', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:17:08', '1959569', null);
INSERT INTO `f_fmea` VALUES ('22', '33', '25', '26', '51', '37', '30.00', '30.00', '51', '', '检查运行阀组或极是否过负荷		', '', '', '	隔离故障换流变压器\n', '', '', '', '', '', '', '', '2020-10-15 23:17:05', '1959569', null);
INSERT INTO `f_fmea` VALUES ('23', '33', '24', '26', '51', '37', '30.00', '30.00', '51', '检查是否为过电压、过负荷、铁磁共振、谐波或直流偏磁作用引起	', '定期检查冷却器、风扇等附件是否存在不平衡或剐蹭引起的振动\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:17:03', '1959569', null);
INSERT INTO `f_fmea` VALUES ('24', '33', '23', '23', '51', '37', '45.00', '45.00', '51', '', '', '', '', '断开换流变压器辅助电源上级开关\n', '', '', '', '', '', '', '', '2020-10-15 23:17:00', '1959569', null);
INSERT INTO `f_fmea` VALUES ('25', '33', '21', '24', '51', '37', '40.00', '40.00', '51', '现场检查滤油机漏油处密封情况，若为紧固螺丝松动则按对角线逐个拧紧螺丝，若为密封圈老化则更换密封圈\n', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:16:57', '1959569', null);
INSERT INTO `f_fmea` VALUES ('26', '34', '12', '26', '51', '33', '54.00', '54.00', '51', '', '', '', '佩戴安全帽\n', '', '', '', '', '', '', '', '', '2020-10-15 23:17:15', '1959569', null);
INSERT INTO `f_fmea` VALUES ('27', '35', '17', '23', '51', '37', '45.00', '45.00', '51', '', '', '', '运行人员进入阀厅巡视走道前，应佩戴防毒面具、防火服等防火器具\n', '必要时，运行人员应拨打119，请求消防部门协助灭火。\n', '', '', '', '', '', '', '', null, '', null);
INSERT INTO `f_fmea` VALUES ('28', '35', '19', '30', '51', '37', '10.00', '10.00', '51', '观察漏水点，确定水迹来源和泄漏程度\n', '', '', '', '如阀塔水管漏水严重，或者发现阀塔已经有放电、灼烧现象时，应紧急停运该阀组，同时汇报值班调控人员。后做好隔离、接地措施，联系专业人员处理。\n', '', '', '', '', '', '', '', null, '', null);
INSERT INTO `f_fmea` VALUES ('29', '35', '12', '26', '51', '37', '30.00', '30.00', '51', '', '', '巡视检查时应与带电设备保持足够的安全距离，10kV—0.7m，35（20）kV—1m，110（66） kV—1.5m，220kV—3m, 330kV—4m，500kV-5m，750kV-7.2m，1000kV-8.7m。\n', '巡视中运维人员应按照巡视路线进行，在进入设备室、打开机构箱、屏柜门时不得进行其他工作（严禁进行电气工作）。不得移开或越过遮栏\n', '', '', '', '', '', '', '', '', null, '', null);
INSERT INTO `f_fmea` VALUES ('30', '35', '20', '26', '51', '37', '30.00', '30.00', '51', '', '检查在线检测装置和阀避雷器有无异常现象，检查阀塔悬吊结构有无异常\n', '', '', '必要时将换流阀停运登塔检查\n', '', '', '', '', '', '', '', '2020-10-15 23:17:21', '1959569', null);
INSERT INTO `f_fmea` VALUES ('31', '36', '46', '30', '51', '38', '16.00', '16.00', '50', '', '对供暖设备检查维护\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:12:08', '1959569', null);
INSERT INTO `f_fmea` VALUES ('32', '36', '45', '30', '51', '36', '72.00', '72.00', '46', '', '对喷头定期清理\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:12:08', '1959569', null);
INSERT INTO `f_fmea` VALUES ('33', '36', '43', '30', '51', '37', '10.00', '10.00', '51', '对故障设备进行维修或者跟换\n', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:08:05', '1959569', null);
INSERT INTO `f_fmea` VALUES ('34', '36', '42', '26', '51', '36', '72.00', '36.00', '51', '', '对管道定期检查维护', '', '', '', '', '', '', '', '', '', '', '2020-10-23 12:03:37', '1959569', null);
INSERT INTO `f_fmea` VALUES ('35', '37', '27', '26', '51', '38', '24.00', '24.00', '51', '检查冷却器是否全部投入、运行是否正常 检查换流变压器的负荷情况和环境温度				', '', '', '', '降低负荷，必要时申请将换流变压器停运\n', '', '', '', '', '', '', '', '2020-10-15 23:17:46', '1959569', null);
INSERT INTO `f_fmea` VALUES ('36', '37', '26', '26', '51', '37', '30.00', '30.00', '51', '采取在线补气，\n', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:17:43', '1959569', null);
INSERT INTO `f_fmea` VALUES ('37', '37', '25', '26', '51', '37', '30.00', '30.00', '51', '', '检查运行阀组或极是否过负荷		', '', '', '	隔离故障换流变压器\n', '', '', '', '', '', '', '', '2020-10-15 23:17:38', '1959569', null);
INSERT INTO `f_fmea` VALUES ('38', '37', '24', '26', '51', '37', '30.00', '30.00', '51', '检查是否为过电压、过负荷、铁磁共振、谐波或直流偏磁作用引起	', '定期检查冷却器、风扇等附件是否存在不平衡或剐蹭引起的振动\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:17:35', '1959569', null);
INSERT INTO `f_fmea` VALUES ('39', '37', '23', '23', '51', '37', '45.00', '45.00', '51', '', '', '', '', '断开换流变压器辅助电源上级开关\n', '', '', '', '', '', '', '', '2020-10-15 23:17:32', '1959569', null);
INSERT INTO `f_fmea` VALUES ('40', '37', '21', '24', '51', '37', '40.00', '40.00', '51', '现场检查滤油机漏油处密封情况，若为紧固螺丝松动则按对角线逐个拧紧螺丝，若为密封圈老化则更换密封圈\n', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:17:29', '1959569', null);
INSERT INTO `f_fmea` VALUES ('41', '38', '12', '26', '51', '33', '54.00', '54.00', '51', '', '', '', '佩戴安全帽\n', '', '', '', '', '', '', '', '', '2020-10-15 23:17:50', '1959569', null);
INSERT INTO `f_fmea` VALUES ('42', '39', '17', '23', '51', '37', '45.00', '45.00', '51', '', '', '', '运行人员进入阀厅巡视走道前，应佩戴防毒面具、防火服等防火器具\n', '必要时，运行人员应拨打119，请求消防部门协助灭火。\n', '', '', '', '', '', '', '', null, '', null);
INSERT INTO `f_fmea` VALUES ('43', '39', '19', '30', '51', '37', '10.00', '10.00', '51', '观察漏水点，确定水迹来源和泄漏程度\n', '', '', '', '如阀塔水管漏水严重，或者发现阀塔已经有放电、灼烧现象时，应紧急停运该阀组，同时汇报值班调控人员。后做好隔离、接地措施，联系专业人员处理。\n', '', '', '', '', '', '', '', null, '', null);
INSERT INTO `f_fmea` VALUES ('44', '39', '12', '26', '51', '37', '30.00', '30.00', '51', '', '', '巡视检查时应与带电设备保持足够的安全距离，10kV—0.7m，35（20）kV—1m，110（66） kV—1.5m，220kV—3m, 330kV—4m，500kV-5m，750kV-7.2m，1000kV-8.7m。\n', '巡视中运维人员应按照巡视路线进行，在进入设备室、打开机构箱、屏柜门时不得进行其他工作（严禁进行电气工作）。不得移开或越过遮栏\n', '', '', '', '', '', '', '', '', null, '', null);
INSERT INTO `f_fmea` VALUES ('45', '39', '20', '26', '51', '37', '30.00', '30.00', '51', '', '检查在线检测装置和阀避雷器有无异常现象，检查阀塔悬吊结构有无异常\n', '', '', '必要时将换流阀停运登塔检查\n', '', '', '', '', '', '', '', null, '', null);
INSERT INTO `f_fmea` VALUES ('46', '40', '27', '26', '51', '38', '24.00', '24.00', '51', '检查冷却器是否全部投入、运行是否正常 检查换流变压器的负荷情况和环境温度				', '', '', '', '降低负荷，必要时申请将换流变压器停运\n', '', '', '', '', '', '', '', '2020-10-15 23:18:09', '1959569', null);
INSERT INTO `f_fmea` VALUES ('47', '40', '26', '26', '51', '37', '30.00', '30.00', '51', '采取在线补气，\n', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:18:07', '1959569', null);
INSERT INTO `f_fmea` VALUES ('48', '40', '25', '26', '51', '37', '30.00', '30.00', '51', '', '检查运行阀组或极是否过负荷		', '', '', '	隔离故障换流变压器\n', '', '', '', '', '', '', '', '2020-10-15 23:18:04', '1959569', null);
INSERT INTO `f_fmea` VALUES ('49', '40', '24', '26', '51', '37', '30.00', '30.00', '51', '检查是否为过电压、过负荷、铁磁共振、谐波或直流偏磁作用引起	', '定期检查冷却器、风扇等附件是否存在不平衡或剐蹭引起的振动\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:18:01', '1959569', null);
INSERT INTO `f_fmea` VALUES ('50', '40', '23', '23', '51', '37', '45.00', '45.00', '51', '', '', '', '', '断开换流变压器辅助电源上级开关\n', '', '', '', '', '', '', '', '2020-10-15 23:17:59', '1959569', null);
INSERT INTO `f_fmea` VALUES ('51', '40', '21', '24', '51', '37', '40.00', '40.00', '51', '现场检查滤油机漏油处密封情况，若为紧固螺丝松动则按对角线逐个拧紧螺丝，若为密封圈老化则更换密封圈\n', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:17:57', '1959569', null);
INSERT INTO `f_fmea` VALUES ('52', '41', '12', '26', '51', '33', '54.00', '54.00', '51', '', '', '', '佩戴安全帽\n', '', '', '', '', '', '', '', '', '2020-10-15 23:18:13', '1959569', null);
INSERT INTO `f_fmea` VALUES ('87', '53', '37', '26', '51', '40', '12.00', '12.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:22:16', '1959569', null);
INSERT INTO `f_fmea` VALUES ('88', '53', '41', '30', '51', '37', '10.00', '10.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:22:11', '1959569', null);
INSERT INTO `f_fmea` VALUES ('89', '54', '37', '26', '51', '40', '12.00', '12.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:22:24', '1959569', null);
INSERT INTO `f_fmea` VALUES ('90', '54', '41', '30', '51', '37', '10.00', '10.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:22:21', '1959569', null);
INSERT INTO `f_fmea` VALUES ('91', '55', '7', '25', '51', '37', '35.00', '35.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:22:28', '1959569', null);
INSERT INTO `f_fmea` VALUES ('92', '56', '53', '26', '51', '39', '18.00', '18.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:22:32', '1959569', null);
INSERT INTO `f_fmea` VALUES ('93', '57', '41', '30', '51', '35', '14.00', '14.00', '51', '', '检查表计，查看故障原因\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:22:36', '1959569', null);
INSERT INTO `f_fmea` VALUES ('94', '58', '89', '26', '51', '38', '24.00', '24.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:23:03', '1959569', null);
INSERT INTO `f_fmea` VALUES ('95', '58', '90', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:22:59', '1959569', null);
INSERT INTO `f_fmea` VALUES ('96', '58', '91', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:22:56', '1959569', null);
INSERT INTO `f_fmea` VALUES ('97', '58', '92', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:22:54', '1959569', null);
INSERT INTO `f_fmea` VALUES ('98', '58', '93', '23', '51', '37', '45.00', '45.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:22:50', '1959569', null);
INSERT INTO `f_fmea` VALUES ('99', '58', '94', '24', '51', '37', '40.00', '40.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:22:47', '1959569', null);
INSERT INTO `f_fmea` VALUES ('100', '58', '95', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:22:44', '1959569', null);
INSERT INTO `f_fmea` VALUES ('101', '59', '2', '26', '51', '36', '36.00', '36.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:23:23', '1959569', null);
INSERT INTO `f_fmea` VALUES ('102', '59', '3', '26', '51', '36', '36.00', '36.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:23:21', '1959569', null);
INSERT INTO `f_fmea` VALUES ('103', '59', '4', '26', '51', '36', '36.00', '36.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:23:15', '1959569', null);
INSERT INTO `f_fmea` VALUES ('104', '60', '109', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:23:50', '1959569', null);
INSERT INTO `f_fmea` VALUES ('105', '60', '108', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:23:48', '1959569', null);
INSERT INTO `f_fmea` VALUES ('106', '60', '105', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:23:44', '1959569', null);
INSERT INTO `f_fmea` VALUES ('107', '60', '104', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:23:42', '1959569', null);
INSERT INTO `f_fmea` VALUES ('108', '60', '107', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:23:30', '1959569', null);
INSERT INTO `f_fmea` VALUES ('109', '61', '82', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:24:03', '1959569', null);
INSERT INTO `f_fmea` VALUES ('110', '61', '78', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:24:00', '1959569', null);
INSERT INTO `f_fmea` VALUES ('111', '61', '76', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:23:58', '1959569', null);
INSERT INTO `f_fmea` VALUES ('112', '61', '76', '26', '51', '38', '24.00', '24.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:23:55', '1959569', null);
INSERT INTO `f_fmea` VALUES ('113', '62', '133', '26', '51', '36', '36.00', '36.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:24:10', '1959569', null);
INSERT INTO `f_fmea` VALUES ('114', '62', '134', '30', '51', '37', '10.00', '10.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:24:07', '1959569', null);
INSERT INTO `f_fmea` VALUES ('115', '63', '85', '26', '51', '38', '24.00', '24.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:24:22', '1959569', null);
INSERT INTO `f_fmea` VALUES ('116', '63', '84', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:24:19', '1959569', null);
INSERT INTO `f_fmea` VALUES ('117', '63', '83', '26', '51', '38', '24.00', '24.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:24:15', '1959569', null);
INSERT INTO `f_fmea` VALUES ('118', '63', '81', '26', '51', '38', '24.00', '24.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:24:13', '1959569', null);
INSERT INTO `f_fmea` VALUES ('119', '64', '66', '26', '51', '36', '36.00', '36.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:24:26', '1959569', null);
INSERT INTO `f_fmea` VALUES ('120', '65', '126', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:24:35', '1959569', null);
INSERT INTO `f_fmea` VALUES ('121', '65', '61', '30', '51', '37', '10.00', '10.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:24:32', '1959569', null);
INSERT INTO `f_fmea` VALUES ('122', '65', '62', '30', '51', '37', '10.00', '10.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:24:30', '1959569', null);
INSERT INTO `f_fmea` VALUES ('123', '66', '135', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:24:53', '1959569', null);
INSERT INTO `f_fmea` VALUES ('124', '66', '136', '30', '51', '37', '10.00', '10.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:24:50', '1959569', null);
INSERT INTO `f_fmea` VALUES ('125', '66', '137', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:24:47', '1959569', null);
INSERT INTO `f_fmea` VALUES ('126', '67', '110', '26', '51', '36', '36.00', '36.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:25:04', '1959569', null);
INSERT INTO `f_fmea` VALUES ('133', '70', '37', '26', '51', '40', '12.00', '12.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:25:33', '1959569', null);
INSERT INTO `f_fmea` VALUES ('134', '70', '41', '30', '51', '37', '10.00', '10.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:25:30', '1959569', null);
INSERT INTO `f_fmea` VALUES ('176', '83', '42', '26', '51', '36', '36.00', '36.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:28:34', '1959569', null);
INSERT INTO `f_fmea` VALUES ('177', '84', '42', '26', '51', '36', '36.00', '36.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:28:38', '1959569', null);
INSERT INTO `f_fmea` VALUES ('178', '89', '53', '26', '51', '38', '24.00', '24.00', '51', '', '', '', '排查故障原因，消除设备隐患\n', '', '', '', '', '', '', '', '', '2020-10-15 23:02:37', '1959569', null);
INSERT INTO `f_fmea` VALUES ('179', '89', '52', '26', '51', '38', '24.00', '24.00', '51', '', '', '', '', '由专业维修人员对异常设备进行检查维修\n', '', '', '', '', '', '', '', '2020-10-15 23:02:31', '1959569', null);
INSERT INTO `f_fmea` VALUES ('180', '90', '53', '26', '51', '38', '24.00', '24.00', '51', '', '', '', '排查故障原因，消除设备隐患\n', '', '', '', '', '', '', '', '', '2020-10-15 23:02:49', '1959569', null);
INSERT INTO `f_fmea` VALUES ('181', '90', '52', '26', '51', '38', '24.00', '24.00', '51', '', '', '', '', '由专业维修人员对异常设备进行检查维修\n', '', '', '', '', '', '', '', '2020-10-15 23:02:44', '1959569', null);
INSERT INTO `f_fmea` VALUES ('182', '91', '41', '30', '51', '35', '14.00', '14.00', '51', '', '检查表计，查看故障原因\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:02:58', '1959569', null);
INSERT INTO `f_fmea` VALUES ('183', '92', '41', '30', '51', '35', '14.00', '14.00', '51', '', '检查表计，查看故障原因\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:03:08', '1959569', null);
INSERT INTO `f_fmea` VALUES ('184', '93', '48', '26', '51', '38', '24.00', '24.00', '51', '', '排查故障原因，消除故障隐患\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:03:17', '1959569', null);
INSERT INTO `f_fmea` VALUES ('185', '93', '47', '26', '51', '40', '72.00', '12.00', '51', '', '排查故障原因，消除故障隐患\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:12:09', '', null);
INSERT INTO `f_fmea` VALUES ('186', '94', '48', '26', '51', '38', '24.00', '24.00', '51', '', '排查故障原因，消除故障隐患\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:03:29', '1959569', null);
INSERT INTO `f_fmea` VALUES ('187', '94', '47', '26', '51', '40', '72.00', '12.00', '51', '', '排查故障原因，消除故障隐患\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:12:09', '', null);
INSERT INTO `f_fmea` VALUES ('188', '97', '53', '26', '51', '38', '48.00', '48.00', '50', '', '', '', '排查故障原因，消除设备隐患\n', '', '', '', '', '', '', '', '', '2020-10-15 23:12:09', '1959569', null);
INSERT INTO `f_fmea` VALUES ('189', '97', '52', '26', '51', '38', '24.00', '24.00', '51', '', '', '', '', '由专业维修人员对异常设备进行检查维修\n', '', '', '', '', '', '', '', '2020-12-17 14:31:34', '1959569', null);
INSERT INTO `f_fmea` VALUES ('190', '98', '1', '26', '51', '36', '36.00', '36.00', '51', '', '定期对设备进行检查维护\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:03:49', '1959569', null);
INSERT INTO `f_fmea` VALUES ('191', '99', '33', '26', '51', '41', '6.00', '6.00', '51', '', '当出现异常停机时，重新开启除湿机\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:04:11', '1959569', null);
INSERT INTO `f_fmea` VALUES ('192', '99', '32', '26', '51', '39', '18.00', '18.00', '51', '', '用摇杆手动打开风阀\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:04:08', '1959569', null);
INSERT INTO `f_fmea` VALUES ('193', '99', '29', '26', '51', '40', '12.00', '12.00', '51', '', '将空调机组转至检修，通知专业人员进行过滤网更换\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:04:04', '1959569', null);
INSERT INTO `f_fmea` VALUES ('194', '99', '28', '26', '51', '36', '36.00', '36.00', '51', '', '专业人员检查处理分析\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:04:00', '1959569', null);
INSERT INTO `f_fmea` VALUES ('195', '99', '41', '30', '51', '37', '10.00', '10.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:03:55', '1959569', null);
INSERT INTO `f_fmea` VALUES ('196', '100', '33', '26', '51', '41', '18.00', '18.00', '49', '', '当出现异常停机时，重新开启除湿机\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:12:09', '1959569', null);
INSERT INTO `f_fmea` VALUES ('197', '100', '32', '26', '51', '39', '18.00', '18.00', '51', '', '用摇杆手动打开风阀\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:04:33', '1959569', null);
INSERT INTO `f_fmea` VALUES ('198', '100', '29', '26', '51', '40', '48.00', '48.00', '48', '', '将空调机组转至检修，通知专业人员进行过滤网更换\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:12:09', '1959569', null);
INSERT INTO `f_fmea` VALUES ('199', '100', '28', '26', '51', '36', '36.00', '36.00', '51', '', '专业人员检查处理分析\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:04:21', '1959569', null);
INSERT INTO `f_fmea` VALUES ('200', '100', '41', '30', '51', '37', '20.00', '20.00', '50', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:12:09', '1959569', null);
INSERT INTO `f_fmea` VALUES ('201', '101', '115', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:06:21', '1959569', null);
INSERT INTO `f_fmea` VALUES ('202', '102', '115', '26', '51', '37', '30.00', '30.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:06:27', '1959569', null);
INSERT INTO `f_fmea` VALUES ('203', '103', '115', '26', '51', '37', '180.00', '180.00', '46', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:12:09', '1959569', null);
INSERT INTO `f_fmea` VALUES ('204', '104', '39', '30', '51', '36', '12.00', '12.00', '51', '', '定期检查空调外机运行状况\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:06:38', '1959569', null);
INSERT INTO `f_fmea` VALUES ('205', '105', '39', '30', '51', '36', '12.00', '12.00', '51', '', '定期检查空调外机运行状况\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:06:44', '1959569', null);
INSERT INTO `f_fmea` VALUES ('209', '107', '51', '30', '51', '37', '10.00', '10.00', '51', '', '定期检查阀门位置\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:13:14', '1959569', null);
INSERT INTO `f_fmea` VALUES ('210', '107', '50', '30', '51', '37', '10.00', '10.00', '51', '', '确定异常原因，排除故障隐患\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:13:08', '1959569', null);
INSERT INTO `f_fmea` VALUES ('211', '107', '49', '30', '51', '36', '12.00', '12.00', '51', '', '确定管道渗漏位置，对故障点进行维护\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:12:27', '1959569', null);
INSERT INTO `f_fmea` VALUES ('212', '108', '51', '30', '51', '37', '10.00', '10.00', '51', '', '定期检查阀门位置\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:13:24', '1959569', null);
INSERT INTO `f_fmea` VALUES ('213', '108', '50', '30', '51', '37', '10.00', '10.00', '51', '', '确定异常原因，排除故障隐患\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:13:21', '1959569', null);
INSERT INTO `f_fmea` VALUES ('214', '108', '49', '30', '51', '36', '12.00', '12.00', '51', '', '确定管道渗漏位置，对故障点进行维护\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:13:18', '1959569', null);
INSERT INTO `f_fmea` VALUES ('216', '110', '53', '26', '51', '38', '24.00', '24.00', '51', '', '', '', '', '排查故障原因，消除设备隐患\n', '', '', '', '', '', '', '', '2020-10-15 23:13:32', '1959569', null);
INSERT INTO `f_fmea` VALUES ('217', '110', '52', '26', '51', '38', '24.00', '24.00', '51', '', '', '', '', '由专业维修人员对异常设备进行检查维修\n', '', '', '', '', '', '', '', '2020-10-15 23:13:35', '1959569', null);
INSERT INTO `f_fmea` VALUES ('218', '111', '33', '26', '51', '41', '6.00', '6.00', '51', '', '当出现异常停机时，重新开启除湿机\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:13:52', '1959569', null);
INSERT INTO `f_fmea` VALUES ('219', '111', '32', '26', '51', '39', '18.00', '18.00', '51', '', '用摇杆手动打开风阀\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:13:50', '1959569', null);
INSERT INTO `f_fmea` VALUES ('220', '111', '29', '26', '51', '40', '12.00', '12.00', '51', '', '将空调机组转至检修，通知专业人员进行过滤网更换\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:13:47', '1959569', null);
INSERT INTO `f_fmea` VALUES ('221', '111', '28', '26', '51', '36', '36.00', '36.00', '51', '', '专业人员检查处理分析\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:13:44', '1959569', null);
INSERT INTO `f_fmea` VALUES ('222', '111', '41', '30', '51', '37', '10.00', '10.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:13:41', '1959569', null);
INSERT INTO `f_fmea` VALUES ('223', '112', '39', '30', '51', '36', '12.00', '12.00', '51', '', '定期检查空调外机运行状况\n', '', '', '', '', '', '', '', '', '', '', '2020-10-16 15:47:53', '1959569', null);
INSERT INTO `f_fmea` VALUES ('224', '113', '51', '30', '51', '37', '10.00', '10.00', '51', '', '定期检查阀门位置\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:14:09', '1959569', null);
INSERT INTO `f_fmea` VALUES ('225', '113', '50', '30', '51', '37', '10.00', '10.00', '51', '', '确定异常原因，排除故障隐患\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:14:06', '1959569', null);
INSERT INTO `f_fmea` VALUES ('226', '113', '49', '30', '51', '36', '12.00', '12.00', '51', '', '确定管道渗漏位置，对故障点进行维护\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:14:03', '1959569', null);
INSERT INTO `f_fmea` VALUES ('227', '114', '51', '30', '51', '37', '10.00', '10.00', '51', '', '定期检查阀门位置\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:14:21', '1959569', null);
INSERT INTO `f_fmea` VALUES ('228', '114', '50', '30', '51', '37', '10.00', '10.00', '51', '', '确定异常原因，排除故障隐患\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:14:18', '1959569', null);
INSERT INTO `f_fmea` VALUES ('229', '114', '49', '30', '51', '36', '12.00', '12.00', '51', '', '确定管道渗漏位置，对故障点进行维护\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:14:13', '1959569', null);
INSERT INTO `f_fmea` VALUES ('231', '116', '53', '26', '51', '38', '24.00', '24.00', '51', '', '', '', '', '排查故障原因，消除设备隐患\n', '', '', '', '', '', '', '', '2020-10-15 23:14:38', '1959569', null);
INSERT INTO `f_fmea` VALUES ('232', '116', '52', '26', '51', '38', '24.00', '24.00', '51', '', '', '', '', '由专业维修人员对异常设备进行检查维修\n', '', '', '', '', '', '', '', '2020-10-15 23:14:35', '1959569', null);
INSERT INTO `f_fmea` VALUES ('233', '117', '33', '26', '51', '41', '6.00', '6.00', '51', '', '当出现异常停机时，重新开启除湿机\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:14:53', '1959569', null);
INSERT INTO `f_fmea` VALUES ('234', '117', '32', '26', '51', '39', '18.00', '18.00', '51', '', '用摇杆手动打开风阀\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:14:51', '1959569', null);
INSERT INTO `f_fmea` VALUES ('235', '117', '29', '26', '51', '40', '12.00', '12.00', '51', '', '将空调机组转至检修，通知专业人员进行过滤网更换\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:14:48', '1959569', null);
INSERT INTO `f_fmea` VALUES ('236', '117', '28', '26', '51', '36', '36.00', '36.00', '51', '', '专业人员检查处理分析\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:14:45', '1959569', null);
INSERT INTO `f_fmea` VALUES ('237', '117', '41', '30', '51', '37', '10.00', '10.00', '51', '', '', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:14:43', '1959569', null);
INSERT INTO `f_fmea` VALUES ('238', '118', '39', '30', '51', '36', '12.00', '12.00', '51', '', '定期检查空调外机运行状况\n', '', '', '', '', '', '', '', '', '', '', '2020-10-15 23:14:59', '1959569', null);
INSERT INTO `f_fmea` VALUES ('250', '127', '1', '25', '51', '38', '28.00', '28.00', '51', null, null, null, null, null, null, null, null, null, null, '2566474', '测试', '2020-12-17 18:58:18', '2566474', null);
INSERT INTO `f_fmea` VALUES ('251', '128', '119', '26', '51', '40', '12.00', '12.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-15 11:19:18', '1740481', null);
INSERT INTO `f_fmea` VALUES ('252', '128', '118', '26', '51', '40', '12.00', '12.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-15 11:19:02', '1740481', null);
INSERT INTO `f_fmea` VALUES ('253', '128', '117', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-15 11:18:44', '1740481', null);
INSERT INTO `f_fmea` VALUES ('254', '129', '15', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:09:28', '1718015', null);
INSERT INTO `f_fmea` VALUES ('255', '129', '1', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:09:28', '1718015', null);
INSERT INTO `f_fmea` VALUES ('256', '130', '114', '24', '51', '37', '40.00', '40.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:19:53', '1718015', null);
INSERT INTO `f_fmea` VALUES ('257', '130', '112', '23', '51', '37', '45.00', '45.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:19:44', '1718015', null);
INSERT INTO `f_fmea` VALUES ('258', '130', '113', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:19:31', '1718015', null);
INSERT INTO `f_fmea` VALUES ('259', '74', '113', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:21:07', '1718015', null);
INSERT INTO `f_fmea` VALUES ('260', '74', '112', '23', '51', '37', '45.00', '45.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:21:00', '1718015', null);
INSERT INTO `f_fmea` VALUES ('261', '74', '114', '24', '51', '37', '40.00', '40.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:20:52', '1718015', null);
INSERT INTO `f_fmea` VALUES ('262', '73', '89', '26', '51', '38', '24.00', '24.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:22:54', '1718015', null);
INSERT INTO `f_fmea` VALUES ('263', '73', '90', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:22:44', '1718015', null);
INSERT INTO `f_fmea` VALUES ('264', '73', '91', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:22:30', '1718015', null);
INSERT INTO `f_fmea` VALUES ('265', '73', '92', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:22:23', '1718015', null);
INSERT INTO `f_fmea` VALUES ('266', '73', '94', '23', '51', '37', '45.00', '45.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:22:17', '1718015', null);
INSERT INTO `f_fmea` VALUES ('267', '73', '95', '24', '51', '37', '40.00', '40.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:22:10', '1718015', null);
INSERT INTO `f_fmea` VALUES ('268', '72', '89', '26', '51', '38', '24.00', '24.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:24:14', '1718015', null);
INSERT INTO `f_fmea` VALUES ('269', '72', '90', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:24:06', '1718015', null);
INSERT INTO `f_fmea` VALUES ('270', '72', '91', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:23:59', '1718015', null);
INSERT INTO `f_fmea` VALUES ('271', '72', '92', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:23:51', '1718015', null);
INSERT INTO `f_fmea` VALUES ('272', '72', '94', '23', '51', '37', '45.00', '45.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:23:43', '1718015', null);
INSERT INTO `f_fmea` VALUES ('273', '72', '95', '24', '51', '37', '40.00', '40.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:23:35', '1718015', null);
INSERT INTO `f_fmea` VALUES ('274', '71', '89', '26', '51', '38', '24.00', '24.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:26:04', '1718015', null);
INSERT INTO `f_fmea` VALUES ('275', '71', '90', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:25:55', '1718015', null);
INSERT INTO `f_fmea` VALUES ('276', '71', '91', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:25:47', '1718015', null);
INSERT INTO `f_fmea` VALUES ('277', '71', '92', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:25:39', '1718015', null);
INSERT INTO `f_fmea` VALUES ('278', '71', '94', '23', '51', '37', '45.00', '45.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:25:32', '1718015', null);
INSERT INTO `f_fmea` VALUES ('279', '71', '95', '24', '51', '37', '40.00', '40.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:25:22', '1718015', null);
INSERT INTO `f_fmea` VALUES ('280', '69', '89', '26', '51', '38', '24.00', '24.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:27:12', '1718015', null);
INSERT INTO `f_fmea` VALUES ('281', '69', '90', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:27:02', '1718015', null);
INSERT INTO `f_fmea` VALUES ('282', '69', '91', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:26:56', '1718015', null);
INSERT INTO `f_fmea` VALUES ('283', '69', '92', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:26:50', '1718015', null);
INSERT INTO `f_fmea` VALUES ('284', '69', '94', '23', '51', '37', '45.00', '45.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:26:43', '1718015', null);
INSERT INTO `f_fmea` VALUES ('285', '69', '95', '24', '51', '37', '40.00', '40.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:26:35', '1718015', null);
INSERT INTO `f_fmea` VALUES ('286', '68', '89', '26', '51', '38', '24.00', '24.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:28:09', '1718015', null);
INSERT INTO `f_fmea` VALUES ('287', '68', '90', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:28:02', '1718015', null);
INSERT INTO `f_fmea` VALUES ('288', '68', '91', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:27:55', '1718015', null);
INSERT INTO `f_fmea` VALUES ('289', '68', '92', '26', '51', '37', '30.00', '30.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:27:48', '1718015', null);
INSERT INTO `f_fmea` VALUES ('290', '68', '94', '23', '51', '37', '45.00', '45.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:27:41', '1718015', null);
INSERT INTO `f_fmea` VALUES ('291', '68', '95', '24', '51', '37', '40.00', '40.00', '51', null, null, null, null, null, null, null, null, null, null, '', '', '2021-01-19 15:27:35', '1718015', null);

-- ----------------------------
-- Table structure for f_fmea_equipment_point
-- ----------------------------
DROP TABLE IF EXISTS `f_fmea_equipment_point`;
CREATE TABLE `f_fmea_equipment_point` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `fmea_id` bigint(20) NOT NULL COMMENT 'fmea编号',
  `equipment_point_id` bigint(20) NOT NULL COMMENT '装备指标编号',
  `state` tinyint(4) NOT NULL DEFAULT '0' COMMENT '装备指标状态（0：正常；1：告警）',
  `important_equipment_id` bigint(20) NOT NULL COMMENT '所属重点设备id',
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='fmea和装备指标的关系';

-- ----------------------------
-- Records of f_fmea_equipment_point
-- ----------------------------

-- ----------------------------
-- Table structure for f_fmea_point_inputitem
-- ----------------------------
DROP TABLE IF EXISTS `f_fmea_point_inputitem`;
CREATE TABLE `f_fmea_point_inputitem` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `fmea_id` bigint(20) NOT NULL COMMENT 'fmea编号',
  `point_inputitem_id` bigint(20) NOT NULL COMMENT '检查点和项关系编号',
  `state` tinyint(4) NOT NULL DEFAULT '0' COMMENT '检查项状态（0：正常；1：不合格）',
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='fmea和检查项的关系';

-- ----------------------------
-- Records of f_fmea_point_inputitem
-- ----------------------------

-- ----------------------------
-- Table structure for f_preplan_picture
-- ----------------------------
DROP TABLE IF EXISTS `f_preplan_picture`;
CREATE TABLE `f_preplan_picture` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `equipment_id` bigint(20) NOT NULL COMMENT '设备编号',
  `type` int(11) NOT NULL COMMENT '类型',
  `name` varchar(255) DEFAULT NULL COMMENT '装备名称',
  `picture` text COMMENT '图片路径地址',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='重点设备预案图';

-- ----------------------------
-- Records of f_preplan_picture
-- ----------------------------

-- ----------------------------
-- Table structure for f_risk_factor
-- ----------------------------
DROP TABLE IF EXISTS `f_risk_factor`;
CREATE TABLE `f_risk_factor` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `accident_type_id` bigint(20) NOT NULL COMMENT '失效/事故影响',
  `type` varchar(255) DEFAULT NULL COMMENT '分类',
  `dept_id` varchar(255) DEFAULT '0' COMMENT '维护部门',
  `create_by` varchar(255) DEFAULT '0' COMMENT '维护人员',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=135 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='危险因素表';

-- ----------------------------
-- Records of f_risk_factor
-- ----------------------------
INSERT INTO `f_risk_factor` VALUES ('1', '10', '设备老化产生故障', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:24', null);
INSERT INTO `f_risk_factor` VALUES ('2', '10', '可能电源短路', '5', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:24', null);
INSERT INTO `f_risk_factor` VALUES ('3', '10', '设备运行故障，不能及时感知火灾', '6', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:24', null);
INSERT INTO `f_risk_factor` VALUES ('4', '10', '电线老化', '7', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:25', null);
INSERT INTO `f_risk_factor` VALUES ('5', '10', '电线接地', '7', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:25', null);
INSERT INTO `f_risk_factor` VALUES ('7', '10', '误碰、误动、误登运行设备，\n误入带电间隔。', '11', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:25', null);
INSERT INTO `f_risk_factor` VALUES ('8', '10', '误碰、误动、误登运行设备，\n误入带电间隔。', '11', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:25', null);
INSERT INTO `f_risk_factor` VALUES ('9', '10', '设备有接地故障时，巡视人员误入产生跨步电压。\n', '11', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:26', null);
INSERT INTO `f_risk_factor` VALUES ('12', '10', '登高检查设备，如登上开关机构平台检查设备时，感应电造成人员失去平衡，造成人员碰伤、摔伤。\n', '13', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:26', null);
INSERT INTO `f_risk_factor` VALUES ('13', '10', '高空落物伤人。\n', '16', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:26', null);
INSERT INTO `f_risk_factor` VALUES ('14', '10', '使用无线通讯设备，造成保护误动。\n', '14', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:27', null);
INSERT INTO `f_risk_factor` VALUES ('15', '10', '小动物进入，造成事故。\n', '14', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:29', null);
INSERT INTO `f_risk_factor` VALUES ('16', '10', 'OWS上报出换流阀故障告警信号', '14', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:30', null);
INSERT INTO `f_risk_factor` VALUES ('17', '10', '阀塔设备冒烟、着火', '5', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:30', null);
INSERT INTO `f_risk_factor` VALUES ('18', '10', '阀塔设备、阀塔下方地面有水迹或阀塔水管喷水', '3', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:31', null);
INSERT INTO `f_risk_factor` VALUES ('19', '10', '阀塔设备、阀塔下方地面有水迹或阀塔水管喷水', '3', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:32', null);
INSERT INTO `f_risk_factor` VALUES ('20', '10', '换流阀运行声音有异常变化', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:33', null);
INSERT INTO `f_risk_factor` VALUES ('21', '10', '换流变压器喷油、漏油、冒烟', '14', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:34', null);
INSERT INTO `f_risk_factor` VALUES ('22', '10', '换流变压器冒烟着火', '5', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:34', null);
INSERT INTO `f_risk_factor` VALUES ('23', '10', '换流变压器冒烟着火', '5', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:34', null);
INSERT INTO `f_risk_factor` VALUES ('24', '10', '换流变压器声音与正常运行时对比有明显增大且伴有各种噪音', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:35', null);
INSERT INTO `f_risk_factor` VALUES ('25', '10', '换流变压器套管炸裂、严重漏油', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:35', null);
INSERT INTO `f_risk_factor` VALUES ('26', '10', '套管SF6压力低', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:35', null);
INSERT INTO `f_risk_factor` VALUES ('27', '10', '绕组温度/油温异常升高', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:35', null);
INSERT INTO `f_risk_factor` VALUES ('28', '10', '空调机组停止运行', '1', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:36', null);
INSERT INTO `f_risk_factor` VALUES ('29', '10', '空调控制系统发压差传感器报警', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:36', null);
INSERT INTO `f_risk_factor` VALUES ('30', '10', '空调控制系统发压差传感器报警', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:36', null);
INSERT INTO `f_risk_factor` VALUES ('31', '10', '风挡卡住', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:37', null);
INSERT INTO `f_risk_factor` VALUES ('32', '10', '风挡卡住', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:37', null);
INSERT INTO `f_risk_factor` VALUES ('33', '10', '除湿机不工作', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:37', null);
INSERT INTO `f_risk_factor` VALUES ('34', '10', '站间通讯中断', '14', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:37', null);
INSERT INTO `f_risk_factor` VALUES ('35', '10', '站间通讯中断', '14', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:37', null);
INSERT INTO `f_risk_factor` VALUES ('36', '10', '服务器死机', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:38', null);
INSERT INTO `f_risk_factor` VALUES ('37', '10', '控制保护屏柜、板卡电源显示异常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:38', null);
INSERT INTO `f_risk_factor` VALUES ('38', '10', 'UPS装置面板异常故障报警', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:38', null);
INSERT INTO `f_risk_factor` VALUES ('39', '10', '空调外机异响、通风口异物、柜门密封差', '3', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:38', null);
INSERT INTO `f_risk_factor` VALUES ('41', '10', '实际位置与电气、机械位置指示不相符', '3', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('42', '10', '压力管道渗漏', '1', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('43', '10', '氮气动力源铅封破损，气体压力指示不是0MPa；氮气启动源源铅封破损，气体压力压力小于4MPa', '3', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('44', '10', '电磁控制阀有碰撞变形及其它机械性损伤，表盘非“SHUT”状态；减压阀有碰撞变形及其它机械性损伤', '3', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('45', '10', '水雾喷头异物堵塞', '3', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('46', '10', '冬季检查泡沫消防间温度低于0℃', '3', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('47', '10', '装置运行不正常、液晶显示不正确、有异常声音及气味', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('48', '10', '运行指示不正常，电源开关位置不正常，装置告警信号', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('49', '10', '主水回路管道及法兰连接处、仪表及传感器安装处、管道阀门及主水过滤器有渗漏', '3', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:39', null);
INSERT INTO `f_risk_factor` VALUES ('50', '10', '表计（压力表、压差表、氮气瓶压力等）指示不在正常范围内', '3', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:40', null);
INSERT INTO `f_risk_factor` VALUES ('51', '10', '各回路阀门位置未在指定正确方向', '3', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:40', null);
INSERT INTO `f_risk_factor` VALUES ('52', '10', '火灾报警控制器各指示灯显示异常，异常报警', '1', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:40', null);
INSERT INTO `f_risk_factor` VALUES ('53', '10', '控制柜各指示灯显示异常，有异常及告警信号，工作状态不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:40', null);
INSERT INTO `f_risk_factor` VALUES ('54', '10', '蓄电池有变形、凸出、漏液爆炸裂开、烧焦、螺丝连接处氧化物渗出', '1', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:40', null);
INSERT INTO `f_risk_factor` VALUES ('55', '10', '消防砂池开裂、漏砂', '3', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:40', null);
INSERT INTO `f_risk_factor` VALUES ('56', '10', '消防室杂乱有渗、漏雨；门窗有破损', '3', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:41', null);
INSERT INTO `f_risk_factor` VALUES ('57', '10', '消防箱、消防桶、消防铲、消防斧损旧、锈蚀、破损', '3', '1', '1245230062576365570', '1530151', '2020-06-28 09:48:41', null);
INSERT INTO `f_risk_factor` VALUES ('58', '10', '进入户内SF6设备室或SF6设备发生故障气体外逸，巡视人员窒息或中毒。', '12', '3', '1245230062576365570', '1530151', '2020-06-28 09:48:41', null);
INSERT INTO `f_risk_factor` VALUES ('59', '10', '机构箱、端子箱内加热器故障、防火封堵未到位', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:42', null);
INSERT INTO `f_risk_factor` VALUES ('60', '10', '母线存在变形，异物，跨接线过大弧垂和摆动\n', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:43', null);
INSERT INTO `f_risk_factor` VALUES ('61', '10', '母线终端、连接金具破损，接头松动，软连接有断片。\n', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:44', null);
INSERT INTO `f_risk_factor` VALUES ('62', '10', '母线均压环外观不正常、母线有异常声音。', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:45', null);
INSERT INTO `f_risk_factor` VALUES ('63', '10', '断路器分合状态指示正常，蝶（弹）簧在压缩位置，液压机构油位未在1/2处。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:49', null);
INSERT INTO `f_risk_factor` VALUES ('64', '10', '断路器压力指示指针未在绿色区域，SF6压力不正常。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:49', null);
INSERT INTO `f_risk_factor` VALUES ('65', '10', '断路器套管和液压机构观察孔污秽现象，断路器套管破损、裂纹。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:49', null);
INSERT INTO `f_risk_factor` VALUES ('66', '10', '基础有破损或开裂，基础有无下沉，支架是否锈蚀或变形。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:49', null);
INSERT INTO `f_risk_factor` VALUES ('67', '10', '汇控柜、端子箱、机构箱、动力箱温湿度控制器显示不正常、加热器运行不正常。（冬季）', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:49', null);
INSERT INTO `f_risk_factor` VALUES ('68', '10', '实际位置与电气、机械位置指示不相符。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:49', null);
INSERT INTO `f_risk_factor` VALUES ('69', '10', '瓷柱无裂纹和破损，无污秽现象、无放电和闪络的痕迹。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:49', null);
INSERT INTO `f_risk_factor` VALUES ('70', '10', '连杆无弯曲、无松动、无锈蚀，开口销齐全。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('71', '10', '引线连接部分无过热现象，引线弧度适中。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('72', '10', '无影响设备安全运行的障碍物、附着物。\n', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('73', '10', '操作机构箱柜门密封良好，箱门锁紧，基础构架无变形。\n热器运行正常。（冬季）', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('74', '10', '构架及机构上无鸟巢、蜂巢。\n', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('75', '10', '机构箱温湿度控制器显示正常、加热器运行正常。（冬季）', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('76', '10', '电流互感器伞群、法兰等无破损、裂纹及放电闪络痕迹', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('77', '10', '电流互感器伞群污秽、不完整、存在裂纹、老化迹象。', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:50', null);
INSERT INTO `f_risk_factor` VALUES ('78', '10', '电流互感器油位不正常，有渗、漏油现象', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:51', null);
INSERT INTO `f_risk_factor` VALUES ('79', '10', '电流互感器引线异物，接头连接不牢固', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:51', null);
INSERT INTO `f_risk_factor` VALUES ('80', '10', '电流互感器套管运行声音不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:51', null);
INSERT INTO `f_risk_factor` VALUES ('81', '10', '本体存在破损、污秽、有锈蚀、裂纹', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:51', null);
INSERT INTO `f_risk_factor` VALUES ('82', '10', '电流互感器接线板发热松动，放电声不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:51', null);
INSERT INTO `f_risk_factor` VALUES ('83', '10', '平波电抗器顶部油温、绕组温度不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:51', null);
INSERT INTO `f_risk_factor` VALUES ('84', '10', '平波电抗器本体、阀门、冷却器有渗、漏油现象，有异物挂落,套管油位不在正常区域，油枕油位不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:51', null);
INSERT INTO `f_risk_factor` VALUES ('85', '10', '平波电抗器呼吸器外壳破裂现象，硅胶变色部分超过3/4', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:52', null);
INSERT INTO `f_risk_factor` VALUES ('86', '10', '平波电抗器呼吸器外壳破裂现象，硅胶变色部分超过3/4', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:52', null);
INSERT INTO `f_risk_factor` VALUES ('87', '10', '平波电抗器冷却器运行不正常, 散热片严重污秽现象,油流指示器指示不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:52', null);
INSERT INTO `f_risk_factor` VALUES ('88', '10', '电抗器冷却器控制柜内冷却器切换把手位置不正确', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:52', null);
INSERT INTO `f_risk_factor` VALUES ('89', '10', '主变压器顶部油温、绕组温度正常。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:52', null);
INSERT INTO `f_risk_factor` VALUES ('90', '10', '主变压器本体、阀门、冷却器有渗、漏油现象，异物挂落,套管油位在非正常区域，本体油枕油位不正常；\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:53', null);
INSERT INTO `f_risk_factor` VALUES ('91', '10', '主变压器呼吸器外壳存在破裂现象，硅胶变色部分超过2/3；', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:53', null);
INSERT INTO `f_risk_factor` VALUES ('92', '10', '主变压器套管污秽现象, 闪络放电痕迹；\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:53', null);
INSERT INTO `f_risk_factor` VALUES ('93', '10', '变压器冷却器运行不正常, 散热片严重污秽现象。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:54', null);
INSERT INTO `f_risk_factor` VALUES ('94', '10', '主变压器本体、冷却器运行声音不正常。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:54', null);
INSERT INTO `f_risk_factor` VALUES ('95', '10', '主变压器冷却器控制柜内冷却器操作把手位置不正确；\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:54', null);
INSERT INTO `f_risk_factor` VALUES ('96', '10', '电容器存在渗漏油、生锈、鼓肚变形。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:54', null);
INSERT INTO `f_risk_factor` VALUES ('97', '10', '运行声音异常及其它异常现象。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:54', null);
INSERT INTO `f_risk_factor` VALUES ('98', '10', '各引线和接头有无松动、变色、过热现象。', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:54', null);
INSERT INTO `f_risk_factor` VALUES ('99', '10', '电抗器本体存在破损、污秽、锈蚀、开裂。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:54', null);
INSERT INTO `f_risk_factor` VALUES ('100', '10', '电抗器接地良好。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:55', null);
INSERT INTO `f_risk_factor` VALUES ('101', '10', '电抗器接地良好。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:55', null);
INSERT INTO `f_risk_factor` VALUES ('102', '10', '电抗器各引线和接头有松动、变色、过热现象', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:55', null);
INSERT INTO `f_risk_factor` VALUES ('103', '10', '避雷器引流线松股、断股和弛度过紧及过松现象；接头松动、发热或变色等现象。', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:55', null);
INSERT INTO `f_risk_factor` VALUES ('104', '10', '\n避雷器均压环存在位移、变形、锈蚀现象，有放电痕迹。', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:55', null);
INSERT INTO `f_risk_factor` VALUES ('105', '10', '避雷器瓷套部分裂纹、破损、放电现象，防污闪涂层有破裂、起皱、鼓泡、脱落；硅橡胶复合绝缘外套伞裙破损、变形。\n密封结构金属件和法兰盘裂纹、锈蚀。\n压力释放装置封闭破损异物。', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:55', null);
INSERT INTO `f_risk_factor` VALUES ('106', '10', '避雷器设备基础有塌陷；底座固定牢固、整体倾斜；绝缘底座表面破损、积污。', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:55', null);
INSERT INTO `f_risk_factor` VALUES ('107', '10', '避雷器接地引下线连接不可靠，锈蚀、断裂。\n引下线支持小套管碎裂，螺栓松动情况', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:57', null);
INSERT INTO `f_risk_factor` VALUES ('108', '10', '避雷器运行时异常声响。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:57', null);
INSERT INTO `f_risk_factor` VALUES ('109', '10', '避雷器监测装置外观不完整、密封较差、连接不紧固，表计指示不正常，数值超标；放电计数器而问题，内部无受潮、进水。\n接地标识、设备铭牌、设备标示牌不齐全、模糊。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:58', null);
INSERT INTO `f_risk_factor` VALUES ('110', '10', '电阻器箱体破损变形，接头引线放电现象，运行声音不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:58', null);
INSERT INTO `f_risk_factor` VALUES ('111', '10', '电阻器箱体破损变形，接头引线放电现象，运行声音不正常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:48:59', null);
INSERT INTO `f_risk_factor` VALUES ('112', '10', '联络变油色谱在线监测柜灯状态异常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:00', null);
INSERT INTO `f_risk_factor` VALUES ('113', '10', '联络变风冷控制柜状态显示异常', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:00', null);
INSERT INTO `f_risk_factor` VALUES ('114', '10', '呼吸器油杯油位、套管油位、开关油位、油枕油位调补变端子箱油温油位未在规定范围内', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:00', null);
INSERT INTO `f_risk_factor` VALUES ('115', '10', '故障录波指示灯指示运行状态异常，打印机异常常，打印纸缺失', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:01', null);
INSERT INTO `f_risk_factor` VALUES ('116', '10', '很大的危险因素', '19', '1', '1245230062576365570', '1530151', '2020-06-28 09:49:01', null);
INSERT INTO `f_risk_factor` VALUES ('117', '10', 'SCADA-系统\n1.中央报警系统故障告警。\n2.OWS上各界面显示异常。\n3.站控制监视系统屏柜内设备运行声音异常\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:01', null);
INSERT INTO `f_risk_factor` VALUES ('118', '10', '消防系统-火灾检测：火灾报警后台上有报警。\n', '1', '1', '1245230062576365570', '1530151', '2020-06-28 09:49:02', null);
INSERT INTO `f_risk_factor` VALUES ('119', '10', '\"图像监控系统：\n1.视频监控显示器显示、切换异常，摄像机控制不灵活。\n2.视频主机屏上指示灯异常，网络连接断开，交换机（网桥）指示灯异常。\n3.视频主机屏内设备存在发热、死机等现象。\n\n\"\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:02', null);
INSERT INTO `f_risk_factor` VALUES ('120', '10', '直流控制保护系统面板、板卡等指示灯异常告警。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:02', null);
INSERT INTO `f_risk_factor` VALUES ('121', '10', '直流控制保护系统屏柜内有杂物，凝结水现象\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:03', null);
INSERT INTO `f_risk_factor` VALUES ('122', '10', '\"直流控制保护系统电源开关异常，电源指示异常，接点抖动，异常声响，焦糊味，防火封堵有损。\n\"\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:03', null);
INSERT INTO `f_risk_factor` VALUES ('123', '10', '直流控制保护系统压板、转换开关、按钮有损坏，位置偏移。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:03', null);
INSERT INTO `f_risk_factor` VALUES ('124', '10', '直流控制保护系统屏柜端子排存在放电现象。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:03', null);
INSERT INTO `f_risk_factor` VALUES ('125', '10', '直流控制保护系统OWS中央发出告警信号。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:03', null);
INSERT INTO `f_risk_factor` VALUES ('126', '10', '母线变形，有异物，跨接线存在过大弧垂和摆动。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:04', null);
INSERT INTO `f_risk_factor` VALUES ('127', '10', '母线终端、连接金具有破损、生锈，接头松动，软连接存在断片。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:04', null);
INSERT INTO `f_risk_factor` VALUES ('128', '10', '母线均压环外观正常。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:04', null);
INSERT INTO `f_risk_factor` VALUES ('129', '10', '瓷裙放电现象。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:04', null);
INSERT INTO `f_risk_factor` VALUES ('130', '10', '瓷裙、法兰裂纹、破损现象。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:04', null);
INSERT INTO `f_risk_factor` VALUES ('131', '10', '高压瓷柱绝缘支柱倾斜。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:04', null);
INSERT INTO `f_risk_factor` VALUES ('132', '10', '设备法兰及铁件等部分出现裂纹、裂缝现象。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:04', null);
INSERT INTO `f_risk_factor` VALUES ('133', '10', '互感器本体有异常声响、震动和气味有渗漏油现象。\n', '1', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:05', null);
INSERT INTO `f_risk_factor` VALUES ('134', '10', '互感器本体有异物悬挂\n', '3', '2', '1245230062576365570', '1530151', '2020-06-28 09:49:05', null);

-- ----------------------------
-- Table structure for f_risk_level
-- ----------------------------
DROP TABLE IF EXISTS `f_risk_level`;
CREATE TABLE `f_risk_level` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `level` varchar(100) DEFAULT NULL COMMENT '等级',
  `evaluation_model_id` bigint(20) DEFAULT '1' COMMENT '评价模型id',
  `severity` varchar(255) DEFAULT NULL COMMENT '严重度',
  `name` varchar(255) DEFAULT NULL COMMENT '结果描述',
  `color` varchar(255) DEFAULT NULL COMMENT '图标颜色',
  `create_by` varchar(255) DEFAULT '0' COMMENT '维护人员',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '维护时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `top_limit` decimal(10,2) DEFAULT NULL COMMENT '上限',
  `down_limit` decimal(10,2) DEFAULT NULL COMMENT '下限',
  `manage_level` tinyint(4) DEFAULT NULL COMMENT '管控级别',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='风险等级表';

-- ----------------------------
-- Records of f_risk_level
-- ----------------------------
INSERT INTO `f_risk_level` VALUES ('1', '10', '1', null, '大', '1级', '红色', '1666891', '2020-08-03 09:29:07', null, '1000.00', '501.00', '1');
INSERT INTO `f_risk_level` VALUES ('2', '10', '2', null, '较大', '2级', '橙色', '1666891', '2020-06-28 09:42:37', null, '500.00', '101.00', '2');
INSERT INTO `f_risk_level` VALUES ('3', '10', '3', null, '中等', '3级', '黄色', '1666891', '2020-06-28 09:42:38', null, '100.00', '51.00', '3');
INSERT INTO `f_risk_level` VALUES ('4', '10', '4', null, '小', '4级', '蓝色', '2362673', '2020-12-09 14:34:13', null, '50.00', '10.00', '4');
INSERT INTO `f_risk_level` VALUES ('24', '10', '5', null, '很小', '5级', '蓝色', '1713102', '2021-02-04 13:02:30', null, '9.00', '1.00', '4');

-- ----------------------------
-- Table structure for f_risk_source
-- ----------------------------
DROP TABLE IF EXISTS `f_risk_source`;
CREATE TABLE `f_risk_source` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `code` varchar(255) DEFAULT NULL COMMENT '编号',
  `name` varchar(255) DEFAULT NULL COMMENT '装备名称',
  `position3d` varchar(100) DEFAULT NULL COMMENT '3维坐标',
  `route_path` varchar(2000) DEFAULT NULL COMMENT '路径坐标',
  `ue4_extent` text COMMENT 'ue4缩放',
  `ue4_rotation` text COMMENT 'ue4旋转',
  `ue4_location` text COMMENT 'ue4位置',
  `floor3d` varchar(100) DEFAULT NULL COMMENT '3维楼层',
  `is_indoor` bit(1) NOT NULL DEFAULT b'1' COMMENT '是否室内:0-否；1-是',
  `parent_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '上级编号id',
  `risk_level_id` bigint(20) DEFAULT '0' COMMENT '风险等级id',
  `rpn` decimal(10,2) DEFAULT NULL COMMENT '实时rpn',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_by` varchar(255) DEFAULT '0' COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_region` varchar(16) DEFAULT NULL,
  `status` varchar(16) DEFAULT NULL COMMENT '状态(正常NORMAL，异常ANOMALY)',
  `source_id` bigint(20) DEFAULT NULL,
  `flicker_frequency` int(11) DEFAULT '0' COMMENT '闪烁频率',
  `increment` decimal(10,2) DEFAULT NULL COMMENT 'rpn增量',
  `rpni` decimal(10,2) DEFAULT NULL COMMENT 'rpni属性',
  `sort_num` int(10) DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `unique_idx_source_id` (`source_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='风险点表';

-- ----------------------------
-- Records of f_risk_source
-- ----------------------------
INSERT INTO `f_risk_source` VALUES ('1', '10', '100000', '灵州换流站', null, null, null, null, null, '1', '\0', '0', '3', '88.29', null, '1740481', '2020-10-14 16:51:43', 'TRUE', 'NORMAL', null, null, '0.00', '81.00', '0');
INSERT INTO `f_risk_source` VALUES ('2', '10', '101000', '主控楼', null, '{\"routePath\":[[45.9353589223634,0.5517000019550892,52.69491880770631],[45.9353589223634,0.5517000019550892,52.69491880770631],[45.60054583999061,2.985543124230708,77.14097792904965],[45.60054583999061,2.985543124230708,77.14097792904965],[95.09955582779372,1.3668989904865954,77.90740557440687],[95.09955582779372,1.3668989904865954,77.90740557440687],[94.90817542471522,1.1321614537439246,55.337800773051235],[94.90817542471522,1.1321614537439246,55.337800773051235],[46.43477008007451,1.845085530257029,53.18235675336064]],\"regionHeigth\":50}', null, null, null, '1', '\0', '1', '3', '67.62', null, '1959569', '2020-10-16 16:34:45', 'TRUE', 'NORMAL', null, '0', '0.00', '49.00', '0');
INSERT INTO `f_risk_source` VALUES ('3', '10', '102000', '极Ⅰ辅控楼', null, '{\"routePath\":[[-75.93476886017781,0.2774999946356388,58.671593014345554],[-75.93476886017781,0.2774999946356388,58.671593014345554],[-45.784974453124576,1.666958482276732,59.093166421866975],[-45.784974453124576,1.666958482276732,59.093166421866975],[-45.40623584184768,2.053433878573776,73.98630850827672],[-45.40623584184768,2.053433878573776,73.98630850827672],[-74.4894556778299,6.347073337408494,73.61314900644125],[-74.4894556778299,6.347073337408494,73.61314900644125],[-76.215303685121,0.5857026444792041,59.58134607197569],[-76.215303685121,0.5857026444792041,59.58134607197569],[-76.12889071334607,1.0806388476816893,59.83404978924504]],\"regionHeigth\":10}', null, null, null, '1', '\0', '1', '4', '36.00', null, '1959569', '2020-10-16 16:42:12', 'TRUE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('4', '10', '103000', '极Ⅱ辅控楼', null, '{\"routePath\":[[181.94781785562748,0.27749999463558195,59.13062779925025],[181.94781785562748,0.27749999463558195,59.13062779925025],[211.187733990996,0.9677911178771182,59.981394925227974],[211.187733990996,0.9677911178771182,59.981394925227974],[210.86870347709385,2.842056098830858,73.9659704411139],[210.86870347709385,2.842056098830858,73.9659704411139],[181.4146052743871,14.794121030054816,71.10937043878934],[181.4146052743871,14.794121030054816,71.10937043878934],[182.25849914736062,0.3610544851958707,60.394162638202786],[182.25849914736062,0.3610544851958707,60.394162638202786],[179.66273542106777,28.95382158049828,54.50320141465577],[179.66273542106777,28.95382158049828,54.50320141465577],[179.2148596400332,30.44235043308678,55.168042584829315]],\"regionHeigth\":10}', null, null, null, '1', '\0', '1', '4', '36.00', null, '1959569', '2020-10-16 16:42:46', 'TRUE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('5', '10', '104000', '极Ⅰ高端阀厅', null, '{\"routePath\":[[-78.22783821667957,0.27749999463558195,-25.22973576727643],[-78.22783821667957,0.27749999463558195,-25.22973576727643],[-27.44074052050638,0.9926924627767789,-24.692275378375598],[-27.44074052050638,0.9926924627767789,-24.692275378375598],[-28.867884022156098,2.5867407815241905,56.65273349087518],[-28.867884022156098,2.5867407815241905,56.65273349087518],[-9.852433136508795,1.7257959763995587,56.82530417667868],[-9.852433136508795,1.7257959763995587,56.82530417667868],[-9.32348880647937,0.519535831632686,78.98541264091052],[-9.32348880647937,0.519535831632686,78.98541264091052],[-42.88867749344282,2.7200058958379487,78.16182236074447],[-42.88867749344282,2.7200058958379487,78.16182236074447],[-43.28638884453798,1.4108879922372126,59.61768774049744],[-43.28638884453798,1.4108879922372126,59.61768774049744],[-72.15362565799731,28.591978038406218,54.999701988871635],[-72.15362565799731,28.591978038406218,54.999701988871635],[-77.52095655061238,0.648785875433623,-24.56416664759368],[-77.52095655061238,0.648785875433623,-24.56416664759368],[-77.52095655061238,0.648785875433623,-24.56416664759368]],\"regionHeigth\":10}', null, null, null, '1', '\0', '1', '3', '81.00', null, '1959569', '2020-10-16 17:21:13', 'TRUE', 'NORMAL', null, '0', '0.00', '81.00', '0');
INSERT INTO `f_risk_source` VALUES ('6', '10', '105000', '极Ⅰ低端阀厅', null, '{\"routePath\":[[32.5122092909138,0.27749999463558195,-28.36995454529901],[32.5122092909138,0.27749999463558195,-28.36995454529901],[75.18561080796474,0.7801058528664043,-28.507313370819986],[75.18561080796474,0.7801058528664043,-28.507313370819986],[69.44411722379192,32.37680496611163,49.67170848909549],[69.44411722379192,32.37680496611163,49.67170848909549],[43.40329822645017,0.36787882157969987,52.07062116228774],[43.40329822645017,0.36787882157969987,52.07062116228774],[43.452846421969106,2.252593691253742,76.94562439653362],[43.452846421969106,2.252593691253742,76.94562439653362],[23.811026550429496,1.308846723708689,76.72645274832105],[23.811026550429496,1.308846723708689,76.72645274832105],[23.9361266999085,1.0887554175796255,42.68690126510296],[23.9361266999085,1.0887554175796255,42.68690126510296],[32.87860479655542,0.7462201012226956,42.74843430531472],[32.87860479655542,0.7462201012226956,42.74843430531472],[32.083347516970505,1.778432372394525,-27.30160228077546],[32.083347516970505,1.778432372394525,-27.30160228077546],[32.083347516970505,1.778432372394525,-27.30160228077546]],\"regionHeigth\":10}', null, null, null, '1', '\0', '1', '3', '81.00', null, '1959569', '2020-10-16 17:23:11', 'TRUE', 'NORMAL', null, '0', '0.00', '81.00', '0');
INSERT INTO `f_risk_source` VALUES ('7', '10', '106000', '极Ⅱ高端阀厅', null, '{\"routePath\":[[163.25563092135206,0.27749999463558195,-25.977764412911892],[163.25563092135206,0.27749999463558195,-25.977764412911892],[212.89369145105704,1.5771844183355825,-25.385561350233637],[212.89369145105704,1.5771844183355825,-25.385561350233637],[212.5108043469133,2.5574912742640437,57.52786962189101],[212.5108043469133,2.5574912742640437,57.52786962189101],[178.8830781911108,2.1469188075948638,56.82779636745163],[178.8830781911108,2.1469188075948638,56.82779636745163],[179.42704518280365,2.937148231323056,77.34946959515173],[179.42704518280365,2.937148231323056,77.34946959515173],[146.43070458479826,2.560444668466437,77.61836504373917],[146.43070458479826,2.560444668466437,77.61836504373917],[146.45367884408006,1.757432573887661,58.67193030445473],[146.45367884408006,1.757432573887661,58.67193030445473],[163.6268550806574,2.017430555081012,58.6983458727428],[163.6268550806574,2.017430555081012,58.6983458727428],[163.26789240854535,1.56215957412403,-25.55258241158608],[163.26789240854535,1.56215957412403,-25.55258241158608],[163.26789240854535,1.56215957412403,-25.55258241158608]],\"regionHeigth\":10}', null, null, null, '1', '\0', '1', '2', '113.40', null, '1959569', '2020-10-16 17:24:01', 'TRUE', 'NORMAL', null, '0', '0.00', '81.00', '0');
INSERT INTO `f_risk_source` VALUES ('8', '10', '107000', '极Ⅱ低端阀厅\r\n', null, '{\"routePath\":[[61.473884481282866,0.2774999946355251,-29.827937702161023],[61.473884481282866,0.2774999946355251,-29.827937702161023],[70.58893962116747,32.66285556069952,50.02761743138909],[70.58893962116747,32.66285556069952,50.02761743138909],[96.07072066418418,2.648984411066215,51.734153027929814],[96.07072066418418,2.648984411066215,51.734153027929814],[96.20679077053488,2.1034966363191416,78.1612760149039],[96.20679077053488,2.1034966363191416,78.1612760149039],[113.96519791490434,1.8259490216375753,77.6308789109165],[113.96519791490434,1.8259490216375753,77.6308789109165],[113.8488470393324,2.5167057107022743,43.872131882021925],[113.8488470393324,2.5167057107022743,43.872131882021925],[106.25357923569122,2.6682507045614785,43.83402021144522],[106.25357923569122,2.6682507045614785,43.83402021144522],[106.01243532136505,1.5516782092442782,-28.289804869236335],[106.01243532136505,1.5516782092442782,-28.289804869236335],[62.52556683775961,3.194246111535995,-28.606390741874236],[62.52556683775961,3.194246111535995,-28.606390741874236],[62.52556683775961,3.194246111535995,-28.606390741874236]],\"regionHeigth\":10}', null, null, null, '1', '\0', '1', '3', '81.00', null, '1959569', '2020-10-16 17:26:33', 'TRUE', 'NORMAL', null, '0', '0.00', '81.00', '0');
INSERT INTO `f_risk_source` VALUES ('10', '10', '109000', '750kVGIS区', null, null, null, null, null, '1', '\0', '1', '3', '63.00', null, '1740481', '2020-10-16 16:52:09', 'TRUE', 'NORMAL', null, null, '0.00', '63.00', '0');
INSERT INTO `f_risk_source` VALUES ('11', '10', '110000', '直流场', null, '{\"routePath\":[[-82.2409082998374,0.11269999984651805,-154.76526945288884],[-82.2409082998374,0.11269999984651805,-154.76526945288884],[219.6744879143016,1.2120478199111404,-153.82962331136795],[219.6744879143016,1.2120478199111404,-153.82962331136795],[219.35354766828033,2.8165285165169167,-39.60579569677569],[219.35354766828033,2.8165285165169167,-39.60579569677569],[-81.76578738798277,1.608505806084088,-39.28007685208351],[-81.76578738798277,1.608505806084088,-39.28007685208351],[-75.94759085619542,18.340838550906803,-150.06364002528733],[-75.94759085619542,18.340838550906803,-150.06364002528733],[-75.94759085619542,18.340838550906803,-150.06364002528733]],\"regionHeigth\":10}', null, null, null, '1', '\0', '1', '4', '36.00', null, '1959569', '2020-10-16 17:02:24', 'TRUE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('12', '10', '111000', '750kV交流场', null, '{\"routePath\":[[-283.4009399254611,0.1126999998464612,-154.69363149590419],[-283.4009399254611,0.1126999998464612,-154.69363149590419],[-185.19300430778276,2.7804001936019973,-152.18047521421656],[-185.19300430778276,2.7804001936019973,-152.18047521421656],[-185.5761522932437,4.471904469634671,-125.70091380351286],[-185.5761522932437,4.471904469634671,-125.70091380351286],[-178.7717505928543,0.20347826640929725,-126.22668142187023],[-178.7717505928543,0.20347826640929725,-126.22668142187023],[-177.09556605677022,1.808747389010398,153.79910262949394],[-177.09556605677022,1.808747389010398,153.79910262949394],[-267.4999914694946,0.21336692117851044,153.35497957043475],[-267.4999914694946,0.21336692117851044,153.35497957043475],[-268.25672348281563,0.611508359830259,104.81948510206422],[-268.25672348281563,0.611508359830259,104.81948510206422],[-294.7090324284373,2.40197486624229,103.58267109094302],[-294.7090324284373,2.40197486624229,103.58267109094302],[-294.5553764526765,2.1558402156867715,-78.36895547683625],[-294.5553764526765,2.1558402156867715,-78.36895547683625],[-283.046715040283,0.9704675184867483,-78.50409638007926],[-283.046715040283,0.9704675184867483,-78.50409638007926],[-282.61983470272844,1.4168684752017726,-154.2502227654286],[-282.61983470272844,1.4168684752017726,-154.2502227654286],[-282.61983470272844,1.4168684752017726,-154.2502227654286]],\"regionHeigth\":10}', null, null, null, '1', '\0', '1', '4', '45.00', null, '1959569', '2020-10-16 17:39:31', 'TRUE', 'NORMAL', null, '0', '0.00', '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('14', '10', '113000', '综合水泵房', null, '{\"routePath\":[[-175.88223345266945,0.1126999998464612,80.32181751038623],[-175.88223345266945,0.1126999998464612,80.32181751038623],[-85.50173912706136,1.803929740256399,81.74420647739173],[-85.50173912706136,1.803929740256399,81.74420647739173],[-85.28287996575862,2.6543241349226947,100.58765293800468],[-85.28287996575862,2.6543241349226947,100.58765293800468],[-173.88030083341096,2.863720419749177,99.89516522414577],[-173.88030083341096,2.863720419749177,99.89516522414577],[-175.05348115867963,1.2225336106718943,80.84057783162912],[-175.05348115867963,1.2225336106718943,80.84057783162912],[-175.03308340283297,1.3946914937929251,80.45834771168619]],\"regionHeigth\":10}', null, null, null, '1', '\0', '1', '4', '36.00', null, '1959569', '2020-10-16 17:00:52', 'TRUE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('16', '10', '115000', '综合楼', null, '{\"routePath\":[[-173.81354865076918,0.2774999946355251,101.50966484300163],[-173.81354865076918,0.2774999946355251,101.50966484300163],[-86.78000485037848,3.7227435754217937,102.10736257195715],[-86.78000485037848,3.7227435754217937,102.10736257195715],[-86.55889239194764,7.765104018254737,147.47989110256339],[-86.55889239194764,7.765104018254737,147.47989110256339],[-173.8245648792426,4.899478593965261,149.50491335101037],[-173.8245648792426,4.899478593965261,149.50491335101037],[-174.42087806825936,1.1917462976381672,101.66255868691667],[-174.42087806825936,1.1917462976381672,101.66255868691667],[-174.42087806825936,1.1917462976381672,101.66255868691667]],\"regionHeigth\":null}', null, null, null, '1', '\0', '1', '0', null, null, '1959569', '2020-10-16 17:16:20', 'TRUE', 'NORMAL', null, '0', '0.00', '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('17', '10', '1010100', '主控楼一层', null, '{\"routePath\":[[58.18429060855958,17.588038260929785,52.511639277656144],[58.18429060855958,17.588038260929785,52.511639277656144],[57.97961082663529,19.681746643276973,74.48381354412238],[57.97961082663529,19.681746643276973,74.48381354412238],[82.49020198927772,20.42288111454142,74.3247406901181],[82.49020198927772,20.42288111454142,74.3247406901181],[82.47793343135558,21.462416354183382,52.931070790757786],[82.47793343135558,21.462416354183382,52.931070790757786],[57.69727330887753,20.99666423146065,52.70629835277281],[57.69727330887753,20.99666423146065,52.70629835277281],[57.69727330887753,20.99666423146065,52.70629835277281]],\"regionHeigth\":10}', null, null, null, '1', '\0', '2', '4', '49.00', null, '1959569', '2020-10-16 17:05:52', 'TRUE', 'NORMAL', null, null, null, '49.00', '0');
INSERT INTO `f_risk_source` VALUES ('18', '10', '1010200', '主控楼二层', null, '{\"routePath\":[[57.69727330887753,21.09666423146065,52.70629835277281],[57.69727330887753,21.09666423146065,52.70629835277281],[81.91893279033842,22.77663924691965,52.46033673736719],[81.91893279033842,22.77663924691965,52.46033673736719],[81.74921365146585,22.682914464202135,73.31521512358309],[81.74921365146585,22.682914464202135,73.31521512358309],[58.441954601631835,20.7226757493925,74.31449994534661],[58.441954601631835,20.7226757493925,74.31449994534661],[57.93827402393329,21.39207558010802,52.96800871899369],[57.93827402393329,21.39207558010802,52.96800871899369],[57.93827402393329,21.39207558010802,52.96800871899369]],\"regionHeigth\":20}', null, null, null, '1', '\0', '2', '3', '55.44', null, '1959569', '2020-10-16 17:07:46', 'TRUE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('19', '10', '1010300', '主控楼三层', null, '{\"routePath\":[[57.93827402393329,21.492075580108022,52.96800871899369],[57.93827402393329,21.492075580108022,52.96800871899369],[81.9969929311392,23.784235191785832,53.24763238483166],[81.9969929311392,23.784235191785832,53.24763238483166],[81.76571493181136,24.106181414132983,73.0735519336702],[81.76571493181136,24.106181414132983,73.0735519336702],[58.69480260468132,21.182273799395922,73.63432067244379],[58.69480260468132,21.182273799395922,73.63432067244379],[58.30762253841023,22.970021472245925,53.391440966338564],[58.30762253841023,22.970021472245925,53.391440966338564],[58.30762253841023,22.970021472245925,53.391440966338564]],\"regionHeigth\":30}', null, null, null, '1', '\0', '2', '3', '58.68', null, '1959569', '2020-10-16 17:07:46', 'TRUE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('21', '10', '1020100', '极1辅控楼一层', null, '{\"routePath\":[[-70.70715042178544,18.575417530013898,56.65885889307282],[-70.70715042178544,18.575417530013898,56.65885889307282],[-49.702654271482736,15.804914368089305,57.367263113259305],[-49.702654271482736,15.804914368089305,57.367263113259305],[-49.822336397814674,15.243713840930218,71.59648188453231],[-49.822336397814674,15.243713840930218,71.59648188453231],[-70.91307412749043,16.03530677610835,72.00748019553862],[-70.91307412749043,16.03530677610835,72.00748019553862],[-70.41902028859582,18.47525835081274,56.66641615117393],[-70.41902028859582,18.47525835081274,56.66641615117393],[-70.41902028859582,18.47525835081274,56.66641615117393]],\"regionHeigth\":10}', null, null, null, '1', '\0', '3', '4', '12.00', null, '1959569', '2020-10-16 17:08:54', 'TRUE', 'NORMAL', null, '0', '0.00', '12.00', '0');
INSERT INTO `f_risk_source` VALUES ('22', '10', '1020200', '极1辅控楼二层', null, '{\"routePath\":[[-70.08453293934068,18.593293984110232,56.67985748542036],[-70.08453293934068,18.593293984110232,56.67985748542036],[-50.41284344026345,17.42504722982651,57.45588537129229],[-50.41284344026345,17.42504722982651,57.45588537129229],[-49.98303281687257,18.69326374852873,69.79693659153355],[-49.98303281687257,18.69326374852873,69.79693659153355],[-49.89253709096061,19.41716181815307,70.8961961938945],[-49.89253709096061,19.41716181815307,70.8961961938945],[-70.40483120682873,18.822528930232103,70.9274157196902],[-70.40483120682873,18.822528930232103,70.9274157196902],[-70.65842374447402,18.66899045780063,56.66050226426325],[-70.65842374447402,18.66899045780063,56.66050226426325],[-70.28186058709727,19.253068901942733,57.450127647615766]],\"regionHeigth\":10}', null, null, null, '1', '\0', '3', '4', '36.00', null, '1959569', '2020-10-16 17:09:21', 'TRUE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('23', '10', '1020300', '极1辅控楼三层', null, '{\"routePath\":[[-70.44461277489856,19.100627730337102,57.10884822033638],[-70.44461277489856,19.100627730337102,57.10884822033638],[-50.49269385896582,19.138082969453286,57.22691708217944],[-50.49269385896582,19.138082969453286,57.22691708217944],[-50.09774757269726,20.149902318173964,69.86063803331169],[-50.09774757269726,20.149902318173964,69.86063803331169],[-49.6488727624668,21.274523968047482,70.28232536176843],[-49.6488727624668,21.274523968047482,70.28232536176843],[-70.21337488140456,21.544714127409613,70.47143790566629],[-70.21337488140456,21.544714127409613,70.47143790566629],[-70.29956426590932,20.821975252244933,56.9359391690442],[-70.29956426590932,20.821975252244933,56.9359391690442],[-69.29583322991442,21.340443153619596,56.87007337728103]],\"regionHeigth\":10}', null, null, null, '1', '\0', '3', '4', '12.00', null, '1959569', '2020-10-16 17:09:38', 'TRUE', 'NORMAL', null, null, null, '12.00', null);
INSERT INTO `f_risk_source` VALUES ('24', '10', '1030100', '极2辅控楼一层', null, '{\"routePath\":[[185.657767600056,14.776300048828068,57.11831055459396],[185.657767600056,14.776300048828068,57.11831055459396],[205.9860714153931,15.276216390364004,57.30440712184934],[205.9860714153931,15.276216390364004,57.30440712184934],[206.02353771516445,16.222013950017676,71.3248018937866],[206.02353771516445,16.222013950017676,71.3248018937866],[185.43205620955766,15.611260897771421,71.48080776072521],[185.43205620955766,15.611260897771421,71.48080776072521],[185.70535083767578,16.016720990540342,56.680326773803124],[185.70535083767578,16.016720990540342,56.680326773803124],[185.70535083767578,16.016720990540342,56.680326773803124]],\"regionHeigth\":10}', null, null, null, '1', '\0', '4', '4', '12.00', null, '1959569', '2020-10-16 17:16:40', 'TRUE', 'NORMAL', null, '0', '0.00', '12.00', '0');
INSERT INTO `f_risk_source` VALUES ('25', '10', '1030200', '极2辅控楼二层', null, '{\"routePath\":[[185.6829018402263,16.08341564293395,57.89606951347689],[185.6829018402263,16.08341564293395,57.89606951347689],[205.65235203938494,18.118926844095803,57.920467578320356],[205.65235203938494,18.118926844095803,57.920467578320356],[206.00374399885848,17.81433722159344,70.48864102681448],[206.00374399885848,17.81433722159344,70.48864102681448],[186.69115180892905,16.43709415798552,71.05318973386241],[186.69115180892905,16.43709415798552,71.05318973386241],[186.70246034020823,17.843084014181535,58.93185169023907],[186.70246034020823,17.843084014181535,58.93185169023907],[186.70246034020823,17.843084014181535,58.93185169023907]],\"regionHeigth\":10}', null, null, null, '1', '\0', '4', '4', '36.00', null, '1959569', '2020-10-16 17:16:56', 'TRUE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('26', '10', '1030300', '极2辅控楼三层', null, '{\"routePath\":[[186.70246034020823,17.943084014181537,58.93185169023907],[186.70246034020823,17.943084014181537,58.93185169023907],[205.03855102995914,18.78803654740657,58.76508709636671],[205.03855102995914,18.78803654740657,58.76508709636671],[205.0755286801947,18.933894521643403,70.03059378051586],[205.0755286801947,18.933894521643403,70.03059378051586],[187.32934049060148,17.221893064993857,70.02223112413589],[187.32934049060148,17.221893064993857,70.02223112413589],[187.6685156116766,19.224009115997582,59.08042083625176],[187.6685156116766,19.224009115997582,59.08042083625176],[187.6685156116766,19.224009115997582,59.08042083625176]],\"regionHeigth\":null}', null, null, null, '1', '\0', '4', '4', '12.00', null, '1959569', '2020-10-16 17:20:35', 'TRUE', 'NORMAL', null, '0', '0.00', '12.00', '0');
INSERT INTO `f_risk_source` VALUES ('28', '10', '1040100', '极Ⅰ高端阀厅', null, null, null, null, null, '1', '', '5', '4', '45.00', null, '1718015', '2020-10-23 11:59:43', 'FALSE', 'NORMAL', null, null, null, '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('29', '10', '1040200', '极Ⅰ高端泡沫消防间', '-36.6811630169949,1.5852181294566776,40.99475959530105', null, null, null, null, '1', '', '5', '4', '36.00', null, '1959569', '2020-10-15 23:15:09', 'FALSE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('30', '10', '1040300', '极Ⅰ高端换流变6台', '-35.81578184671736,10.798327155938921,8.275205951597684', null, null, null, null, '1', '', '5', '4', '45.00', null, '1959569', '2020-10-15 23:15:26', 'FALSE', 'NORMAL', null, '0', '0.00', '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('31', '10', '1040400', '极Ⅰ高端阀冷却空冷器', '-29.00324034666215,11.933300018310547,66.24853416677018', null, null, null, null, '1', '', '5', '3', '54.00', null, '1718015', '2020-10-15 23:15:45', 'FALSE', 'NORMAL', null, null, '0.00', '54.00', '0');
INSERT INTO `f_risk_source` VALUES ('32', '10', '1050100', '极Ⅰ低端阀厅', '60.69236971718497,30.609645939336247,12.608425194580661', null, null, null, null, '1', '', '6', '4', '45.00', null, '1718015', '2020-10-23 12:01:11', 'FALSE', 'NORMAL', null, null, '0.00', '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('33', '10', '1050200', '极Ⅰ低端换流变6台', '41.99209758358006,10.93372961232808,4.365300178527775', null, null, null, null, '1', '', '6', '4', '45.00', null, '1959569', '2020-10-15 23:17:00', 'FALSE', 'NORMAL', null, '0', '0.00', '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('34', '10', '1050300', '极Ⅰ低端阀冷却空冷器', '32.48605350191848,11.933300018310547,55.81332177892685', null, null, null, null, '1', '', '6', '3', '54.00', null, '1718015', '2020-10-15 23:17:15', 'FALSE', 'NORMAL', null, null, '0.00', '54.00', '0');
INSERT INTO `f_risk_source` VALUES ('35', '10', '1060100', '极Ⅱ高端阀厅', '189.40661874049835,30.530275420811193,19.09708093999052', null, null, null, null, '1', '', '7', '4', '45.00', null, '1718015', '2020-10-15 23:17:21', 'FALSE', 'NORMAL', null, null, '0.00', '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('36', '10', '1060200', '极Ⅱ高端泡沫消防间', '171.26806068302605,2.963646198983014,40.07080078125', null, null, null, null, '1', '', '7', '3', '90.00', null, '1959569', '2020-10-23 12:03:37', 'FALSE', 'NORMAL', null, '3', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('37', '10', '1060300', '极Ⅱ高端换流变6台', '170.79597430696631,9.416939474875505,3.594399929046631', null, null, null, null, '1', '', '7', '4', '45.00', null, '1959569', '2020-10-15 23:17:46', 'FALSE', 'NORMAL', null, '0', '0.00', '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('38', '10', '1060400', '极Ⅱ高端阀冷却空冷器', '160.99664751776533,11.933300018310547,64.17258256804561', null, null, null, null, '1', '', '7', '3', '54.00', null, '1740481', '2020-10-15 23:08:35', 'FALSE', 'NORMAL', null, null, '0.00', '54.00', '0');
INSERT INTO `f_risk_source` VALUES ('39', '10', '1070100', '极Ⅱ低端阀厅', '82.25213579773784,30.077717936620843,8.950807476545378', null, null, null, null, '1', '', '8', '4', '45.00', null, '1718015', '2020-10-23 12:04:30', 'FALSE', 'NORMAL', null, null, '0.00', '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('40', '10', '1070200', '极Ⅱ低端换流变6台', '97.47030132073245,9.946200370788603,1.14069468574462', null, null, null, null, '1', '', '8', '4', '45.00', null, '1959569', '2020-10-15 23:18:09', 'FALSE', 'NORMAL', null, '0', '0.00', '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('41', '10', '1070300', '极Ⅱ低端阀冷却空冷器', '107.0187966879812,11.933099746704102,56.557858149020205', null, null, null, null, '1', '', '8', '3', '54.00', null, '1740481', '2020-10-15 23:18:13', 'FALSE', 'NORMAL', null, null, '0.00', '54.00', '0');
INSERT INTO `f_risk_source` VALUES ('53', '10', '1090100', '继电器室', '-63.76340815211967,5.777599811553955,103.12724060693014', null, null, null, null, '1', '', '10', '4', '30.00', null, '1718015', '2020-10-15 23:22:16', 'FALSE', 'NORMAL', null, null, '0.00', '30.00', '0');
INSERT INTO `f_risk_source` VALUES ('54', '10', '1090200', '750kVGIS配电装置', '198.08894347070122,5.777599811553955,99.72242280365853', null, null, null, null, '1', '', '10', '4', '30.00', null, '1718015', '2020-10-15 23:22:24', 'FALSE', 'NORMAL', null, null, '0.00', '30.00', '0');
INSERT INTO `f_risk_source` VALUES ('55', '10', '1090300', '750kVGIS母线高压电抗器', '12.761707732173537,1.8337930109351532,142.08747628263825', null, null, null, null, '1', '', '10', '4', '35.00', null, '1740481', '2020-10-15 23:22:28', 'FALSE', 'NORMAL', null, null, '0.00', '35.00', '0');
INSERT INTO `f_risk_source` VALUES ('56', '10', '1090400', '10kV及站公用400V配电室', '74.06438033513423,5.777599811553955,99.46680385158837', null, null, null, null, '1', '', '10', '4', '18.00', null, '1718015', '2020-10-15 23:22:32', 'FALSE', 'NORMAL', null, null, '0.00', '18.00', '0');
INSERT INTO `f_risk_source` VALUES ('57', '10', '1090500', '750kVGIS高压电抗备用相', '-72.16453012412273,1.1055501369189642,134.32429272127584', null, null, null, null, '1', '', '10', '4', '14.00', null, '1718015', '2020-10-15 23:22:36', 'FALSE', 'NORMAL', null, null, '0.00', '14.00', '0');
INSERT INTO `f_risk_source` VALUES ('58', '10', '1090600', '事故油池', '-73.46972622073903,1.19431831818315,138.49301598647656', null, null, null, null, '1', '', '10', '4', '45.00', null, '1718015', '2020-10-15 23:22:50', 'FALSE', 'NORMAL', null, null, '0.00', '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('59', '10', '1090700', '消防器材室', '-56.32813806176588,1.347782321660418,144.26036276886643', null, null, null, null, '1', '', '10', '4', '36.00', null, '1718015', '2020-10-15 23:23:15', 'FALSE', 'NORMAL', null, null, '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('60', '10', '1100100', '避雷器', '-33.546727298359976,13.948411539151437,-138.04946194439765', null, null, null, null, '1', '', '11', '4', '30.00', null, '1959569', '2020-10-15 23:23:30', 'FALSE', 'NORMAL', null, '0', '0.00', '30.00', '0');
INSERT INTO `f_risk_source` VALUES ('61', '10', '1100200', '电流互感器', '42.16332804088859,7.422131199184207,-125.13736144064057', null, null, null, null, '1', '', '11', '4', '30.00', null, '1959569', '2020-10-15 23:23:58', 'FALSE', 'NORMAL', null, '0', '0.00', '30.00', '0');
INSERT INTO `f_risk_source` VALUES ('62', '10', '1100300', '电压互感器', '84.61947597946637,3.7302654541091442,-117.68838089214853', null, null, null, null, '1', '', '11', '4', '36.00', null, '1959569', '2020-10-15 23:24:10', 'FALSE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('63', '10', '1100400', '电抗器', '17.795845992563592,10.851223067603655,-83.3345574002247', null, null, null, null, '1', '', '11', '4', '30.00', null, '1959569', '2020-10-15 23:24:19', 'FALSE', 'NORMAL', null, '0', '0.00', '30.00', '0');
INSERT INTO `f_risk_source` VALUES ('64', '10', '1100500', '刀闸/地刀', '-30.638917142863722,9.10001891244417,-107.73343177422151', null, null, null, null, '1', '', '11', '4', '36.00', null, '1959569', '2020-10-15 23:24:26', 'FALSE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('65', '10', '1100600', '母线', '161.3393613857295,2.2734075906218436,-61.62145380685047', null, null, null, null, '1', '', '11', '4', '30.00', null, '1959569', '2020-10-15 23:24:35', 'FALSE', 'NORMAL', null, '0', '0.00', '30.00', '0');
INSERT INTO `f_risk_source` VALUES ('66', '10', '1100700', '直流滤波器', '11.235741462161565,21.595300674438477,-103.22609612959292', null, null, null, null, '1', '', '11', '0', null, null, '1959569', '2020-10-14 18:23:41', 'FALSE', 'NORMAL', null, '0', '0.00', '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('67', '10', '1100800', '电阻器', '163.0728669909334,10.937522075528875,-110.80139984310256', null, null, null, null, '1', '', '11', '4', '36.00', null, '1959569', '2020-10-15 23:25:04', 'FALSE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('68', '10', '1110100', '1#主变压器A相', '-253.06832796105797,0.7163209575061273,124.14417833952001', null, null, null, null, '1', '', '12', '4', '45.00', null, '1718015', '2021-01-19 15:27:41', 'FALSE', 'NORMAL', null, '0', '0.00', '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('69', '10', '1110200', '1#主变压器B相', '-191.97596404766597,6.174300193786621,0.2865621057276826', null, null, null, null, '1', '', '12', '4', '45.00', null, '1718015', '2021-01-19 15:26:43', 'FALSE', 'NORMAL', null, '0', '0.00', '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('70', '10', '1110300', '继电器室', '-247.58486281907267,6.174300193786621,3.018989860178408', null, null, null, null, '1', '', '12', '4', '30.00', null, '1718015', '2020-10-15 23:25:33', 'FALSE', 'NORMAL', null, null, '0.00', '30.00', '0');
INSERT INTO `f_risk_source` VALUES ('71', '10', '1110400', '2#主变压器A相', '-230.12764208389027,8.274399757385254,-96.37172801932525', null, null, null, null, '1', '', '12', '4', '45.00', null, '1718015', '2021-01-19 15:25:32', 'FALSE', 'NORMAL', null, '0', '0.00', '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('72', '10', '1110500', '2#主变压器B相', '-290.9545029838188,1.9083774544355947,19.09479035742254', null, null, null, null, '1', '', '12', '4', '45.00', null, '1718015', '2021-01-19 15:23:43', 'FALSE', 'NORMAL', null, '0', '0.00', '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('73', '10', '1110600', '2#主变压器C相', '-260.1445395149358,0.5636193543574564,127.39128798167357', null, null, null, null, '1', '', '12', '4', '45.00', null, '1718015', '2021-01-19 15:22:17', 'FALSE', 'NORMAL', null, '0', '0.00', '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('74', '10', '1110700', '750kV联络变', '-182.72054745211872,2.149629437150054,109.67646611212541', null, null, null, null, '1', '', '12', '4', '45.00', null, '1718015', '2021-01-19 15:21:00', 'FALSE', 'NORMAL', null, '0', '0.00', '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('83', '10', '1130100', '35kV交流配电室', null, null, null, null, null, '1', '', '14', '4', '36.00', null, '1718015', '2020-10-15 23:28:34', 'FALSE', 'NORMAL', null, null, '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('84', '10', '1130200', '综合水泵房', null, null, null, null, null, '1', '', '14', '4', '36.00', null, '1959569', '2020-10-15 23:28:38', 'FALSE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('87', '10', '1150100', '综合楼一层', null, null, null, null, null, '1', '', '16', '0', null, null, '1959569', '2020-10-14 20:55:29', 'TRUE', 'NORMAL', null, '0', '0.00', '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('88', '10', '1150200', '综合楼二层', null, null, null, null, null, '1', '', '16', '0', null, null, '1959569', '2020-10-14 20:55:29', 'TRUE', 'NORMAL', null, '0', '0.00', '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('89', '10', '1010101', '极1低端阀组辅助设备室', '69.29719299423523,23.72651847702457,67.92291632412116', null, null, null, null, '1', '', '17', '4', '24.00', null, '1959569', '2020-10-15 23:02:31', 'FALSE', 'NORMAL', null, '0', '0.00', '24.00', '0');
INSERT INTO `f_risk_source` VALUES ('90', '10', '1010102', '极2低端阀组辅助设备室', '75.66494278060287,24.25921732947765,71.60635066779923', null, null, null, null, '1', '', '17', '4', '24.00', null, '1959569', '2020-10-15 23:02:44', 'FALSE', 'NORMAL', null, '0', '0.00', '24.00', '0');
INSERT INTO `f_risk_source` VALUES ('91', '10', '1010103', '极1低端阀组交流配电室', '61.58189800201443,29.18533726443107,67.92291632412116', null, null, null, null, '1', '', '17', '4', '14.00', null, '1718015', '2020-10-15 23:02:58', 'FALSE', 'NORMAL', null, null, '0.00', '14.00', '0');
INSERT INTO `f_risk_source` VALUES ('92', '10', '1010104', '极2低端阀组交流配电室', '62.343975391440416,23.167712889283592,66.36010931426534', null, null, null, null, '1', '', '17', '4', '14.00', null, '1718015', '2020-10-15 23:03:08', 'FALSE', 'NORMAL', null, null, '0.00', '14.00', '0');
INSERT INTO `f_risk_source` VALUES ('93', '10', '1010105', '极1低端阀组VCCP室', '75.07206184937425,31.950866481367143,71.60635066779923', null, null, null, null, '1', '', '17', '4', '24.00', null, '1959569', '2020-10-15 23:03:17', 'FALSE', 'NORMAL', null, '0', '0.00', '84.00', '0');
INSERT INTO `f_risk_source` VALUES ('94', '10', '1010106', '极2低端阀组VCCP室', '65.2826081055283,23.321047179190913,67.38920666459677', null, null, null, null, '1', '', '17', '4', '24.00', null, '1740481', '2020-10-15 23:03:29', 'FALSE', 'NORMAL', null, null, '0.00', '84.00', '0');
INSERT INTO `f_risk_source` VALUES ('97', '10', '1010201', '站辅助设备室', '60.36404441391133,27.840064703789125,70.28087875275153', null, null, null, null, '1', '', '18', '4', '36.00', null, '1718015', '2020-12-17 14:31:35', 'FALSE', 'NORMAL', null, null, '0.00', '24.00', '0');
INSERT INTO `f_risk_source` VALUES ('98', '10', '1010202', '通信机房', '74.22052862831052,24.301592629618767,66.78729153552584', null, null, null, null, '1', '', '18', '4', '36.00', null, '1959569', '2020-10-15 23:03:49', 'FALSE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('99', '10', '1010203', '检修工具室', '71.99157867906956,24.128403703337312,65.17392803458984', null, null, null, null, '1', '', '18', '4', '36.00', null, '1718015', '2020-10-15 23:04:00', 'FALSE', 'NORMAL', null, null, '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('100', '10', '1010204', '极2低端阀厅空调设备室', '72.55332415882756,24.01199540636094,69.48710929398302', null, null, null, null, '1', '', '18', '3', '79.20', null, '1959569', '2020-10-15 23:04:36', 'FALSE', 'NORMAL', null, '0', '0.00', '79.20', '0');
INSERT INTO `f_risk_source` VALUES ('101', '10', '1010301', '站控制保护设备室', '67.51087856427976,29.963980213940943,71.60635066779923', null, null, null, null, '1', '', '19', '4', '30.00', null, '1718015', '2020-10-15 23:06:21', 'FALSE', 'NORMAL', null, null, '0.00', '30.00', '0');
INSERT INTO `f_risk_source` VALUES ('102', '10', '1010302', '极1低端阀组控制保护设备室', '73.2229049785653,24.13837259132893,68.15703995774655', null, null, null, null, '1', '', '19', '4', '30.00', null, '1718015', '2020-10-15 23:06:27', 'FALSE', 'NORMAL', null, null, '0.00', '30.00', '0');
INSERT INTO `f_risk_source` VALUES ('103', '10', '1010303', '极2低端阀组控制保护设备室', '70.96765702526487,23.88786753370735,68.36186909457709', null, null, null, null, '1', '', '19', '2', '180.00', null, '1718015', '2020-10-15 23:06:31', 'FALSE', 'NORMAL', null, null, '0.00', '180.00', '0');
INSERT INTO `f_risk_source` VALUES ('104', '10', '1010304', '极1低端阀厅巡视走道', '67.72358702715701,23.4236015178044,71.19309178387704', null, null, null, null, '1', '', '19', '4', '12.00', null, '1718015', '2020-10-15 23:06:38', 'FALSE', 'NORMAL', null, null, '0.00', '12.00', '0');
INSERT INTO `f_risk_source` VALUES ('105', '10', '1010305', '极2低端阀厅巡视走道', '79.98247115299088,24.78625912612509,70.05569125327062', null, null, null, null, '1', '', '19', '4', '12.00', null, '1718015', '2020-10-15 23:06:44', 'FALSE', 'NORMAL', null, null, '0.00', '12.00', '0');
INSERT INTO `f_risk_source` VALUES ('107', '10', '1020101', '极1高端阀组冷却控制设备室', '-64.60459802488154,21.21045445344805,65.54727763654381', null, null, null, null, '1', '', '21', '4', '12.00', null, '1959569', '2020-10-15 23:12:27', 'FALSE', 'NORMAL', null, '0', '0.00', '12.00', '0');
INSERT INTO `f_risk_source` VALUES ('108', '10', '1020102', '极1高端阀组冷却设备室', '-61.02061152112417,21.42393346455052,70.38690063583797', null, null, null, null, '1', '', '21', '4', '12.00', null, '1959569', '2020-10-15 23:13:18', 'FALSE', 'NORMAL', null, '0', '0.00', '12.00', '0');
INSERT INTO `f_risk_source` VALUES ('110', '10', '1020201', '极1高端阀组控制保护及辅助设备室', '-56.592705452750884,15.966346520813843,71.56003412761609', null, null, null, null, '1', '', '23', '4', '24.00', null, '1959569', '2020-11-18 10:59:40', 'FALSE', 'NORMAL', null, '0', '0.00', '24.00', '0');
INSERT INTO `f_risk_source` VALUES ('111', '10', '1020202', '极1高端阀组空调设备间', '-65.04609370301442,14.80426957181772,70.05918106933176', null, null, null, null, '1', '', '22', '4', '36.00', null, '1959569', '2020-10-15 23:13:44', 'FALSE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('112', '10', '1020301', '极1高端阀厅空调室外机', '-65.24785185817034,29.48080148873976,70.38690063583795', null, null, null, null, '1', '', '23', '4', '12.00', null, '1959569', '2020-10-16 15:47:53', 'FALSE', 'NORMAL', null, '0', '0.00', '12.00', '0');
INSERT INTO `f_risk_source` VALUES ('113', '10', '1030101', '极2高端阀组冷却控制设备室', '199.22173921840297,19.7460247587951,68.90720953799347', null, null, null, null, '1', '', '24', '4', '12.00', null, '1959569', '2020-11-18 10:40:09', 'FALSE', 'NORMAL', null, '0', '0.00', '12.00', '0');
INSERT INTO `f_risk_source` VALUES ('114', '10', '1030102', '极2高端阀组冷却设备室', '195.86891335170836,18.045718498444025,70.0262552848574', null, null, null, null, '1', '', '24', '4', '12.00', null, '1959569', '2020-11-18 10:40:12', 'FALSE', 'NORMAL', null, '0', '0.00', '12.00', '0');
INSERT INTO `f_risk_source` VALUES ('116', '10', '1030201', '极2高端阀组控制保护及辅助设备室', '189.4646454356507,18.0165143977437,65.37008920638495', null, null, null, null, '1', '', '26', '4', '24.00', null, '1959569', '2020-11-18 11:01:15', 'FALSE', 'NORMAL', null, '0', '0.00', '24.00', '0');
INSERT INTO `f_risk_source` VALUES ('117', '10', '1030202', '极2高端阀组空调设备间', '193.7495455714242,18.059634421384885,64.47283436113601', null, null, null, null, '1', '', '25', '4', '36.00', null, '1959569', '2020-11-18 10:39:51', 'FALSE', 'NORMAL', null, '0', '0.00', '36.00', '0');
INSERT INTO `f_risk_source` VALUES ('118', '10', '1030301', '极2高端阀厅空调室外机', '192.47500185393386,17.895217675876886,65.56421268250159', null, null, null, null, '1', '', '26', '4', '12.00', null, '1959569', '2020-11-18 10:39:50', 'FALSE', 'NORMAL', null, '0', '0.00', '12.00', '0');
INSERT INTO `f_risk_source` VALUES ('127', '10', '1010107', '安全工器具室', null, null, null, null, null, '1', '', '17', '4', '28.00', null, '1740481', '2020-12-17 18:58:19', 'FALSE', 'NORMAL', null, null, null, '28.00', '0');
INSERT INTO `f_risk_source` VALUES ('128', '10', '1010306', '主控室', '76.04150045160281,28.63692231921283,71.19309178387701', null, null, null, null, '1', '', '19', '4', '30.00', null, '1740481', '2021-01-15 11:18:44', 'FALSE', 'NORMAL', null, '0', null, '30.00', '0');
INSERT INTO `f_risk_source` VALUES ('129', '10', '1110900', '检修备品库', null, null, null, null, null, '1', '', '12', null, '0.00', null, '1718015', '2021-01-19 15:08:48', 'FALSE', 'NORMAL', null, null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('130', '10', '1110800', '750kV联络变备用', null, null, null, null, null, '1', '', '12', '4', '45.00', null, '1718015', '2021-01-19 15:19:44', 'FALSE', 'NORMAL', null, '0', null, '45.00', '0');
INSERT INTO `f_risk_source` VALUES ('131', '10', '1111000', '低压电容器', null, null, null, null, null, '1', '', '12', null, '0.00', null, '1718015', '2021-01-19 15:30:21', 'FALSE', 'NORMAL', null, null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('132', '10', '1010205', '二次备品库', null, null, null, null, null, '1', '', '18', null, '0.00', null, '1718015', '2021-01-19 15:39:54', 'FALSE', 'NORMAL', null, null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('133', '10', '1010206', '资料室', null, null, null, null, null, '1', '', '18', null, '0.00', null, '1718015', '2021-01-19 15:40:14', 'FALSE', 'NORMAL', null, null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('134', '10', '1150300', '站外水泵房', null, null, null, null, null, '1', '\0', '16', null, '0.00', null, '1718015', '2021-01-20 12:02:44', 'TRUE', 'NORMAL', null, null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('136', '10', '1010400', '主控楼四层', null, null, null, null, null, '1', '', '17', null, '0.00', null, '1718015', '2021-01-22 10:52:35', 'FALSE', 'NORMAL', null, null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('137', '10', '1150400', '综合楼三层', null, null, null, null, null, '1', '', '16', null, '0.00', null, '1718015', '2021-01-22 10:55:58', 'TRUE', 'NORMAL', null, null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('138', '10', '1150500', '警卫值班室', null, null, null, null, null, '1', '', '16', null, '0.00', null, '1718015', '2021-01-22 10:58:26', 'TRUE', 'NORMAL', null, null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('139', '10', '1090800', '330kV配电装置', null, null, null, null, null, '1', '', '10', null, '0.00', null, '1718015', '2021-01-22 11:12:53', 'FALSE', 'NORMAL', null, null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('140', '10', '1010400', '主控楼四层', null, null, null, null, null, '1', '', '2', null, '0.00', null, '1718015', '2021-01-26 19:09:16', 'TRUE', 'NORMAL', null, null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('141', '10', '1110900', '1#主变压器C相', null, null, null, null, null, '1', '\0', '12', null, '0.00', null, '1740481', '2021-02-02 17:50:24', 'FALSE', 'NORMAL', null, null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('142', '10', '738877290806482292111205', '111', null, null, null, null, null, null, '\0', '87', null, null, null, '3108130', '2021-05-17 16:51:47', 'TRUE', 'NORMAL', '1394214045330100226', null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('143', '10', '082645665705412227281094', '综合楼', null, null, null, null, null, null, '\0', '16', null, null, null, '3092607', '2021-05-20 18:06:12', 'TRUE', 'NORMAL', '1395319936792125441', null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('144', '10', '759182283576179242831551', '123', null, null, null, null, null, null, '\0', '2', null, null, null, '1805525', '2021-05-21 16:12:09', 'TRUE', 'NORMAL', null, null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('145', '10', '236709812712677276530295', '1234', null, null, null, null, null, null, '\0', '3', null, null, null, '1805525', '2021-05-21 16:15:17', 'TRUE', 'NORMAL', '1395654412713746433', null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('146', '10', '198058586871918409949867', '123', null, null, null, null, null, null, '\0', '138', null, null, null, '3108130', '2021-05-24 11:26:56', 'TRUE', 'NORMAL', '1395653622330712066', null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('147', '10', 'pool052601', '消防水池05526', null, null, null, null, null, null, '\0', '7', null, null, null, '2278365', '2021-05-26 18:42:49', 'TRUE', 'NORMAL', '1397503477869174786', null, null, '0.00', '0');
INSERT INTO `f_risk_source` VALUES ('148', '10', '330896744814427111090193', '456', null, null, null, null, null, null, '\0', '8', null, null, null, '1805525', '2021-06-08 16:41:40', 'TRUE', 'NORMAL', '1402184034238590977', null, null, '0.00', '0');

-- ----------------------------
-- Table structure for f_rpn_change_log
-- ----------------------------
DROP TABLE IF EXISTS `f_rpn_change_log`;
CREATE TABLE `f_rpn_change_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `risk_source_id` bigint(20) NOT NULL COMMENT '风险点id',
  `fmea_id` bigint(20) NOT NULL COMMENT 'fmeaId',
  `rpn` decimal(10,2) DEFAULT NULL COMMENT '实时rpn',
  `rpni` decimal(10,2) DEFAULT NULL COMMENT '固有rpn',
  `type` int(11) DEFAULT '0' COMMENT '变化类型：0-上升；1-下降',
  `trigger_by` bigint(20) DEFAULT '0' COMMENT '触发风险id',
  `trigger_type` varchar(20) DEFAULT NULL COMMENT '触发类型：巡检、告警、评价、删除',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='rpn变化流水表';

-- ----------------------------
-- Records of f_rpn_change_log
-- ----------------------------

-- ----------------------------
-- Table structure for f_safety_index_change_log
-- ----------------------------
DROP TABLE IF EXISTS `f_safety_index_change_log`;
CREATE TABLE `f_safety_index_change_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '物理主键',
  `safety_index` decimal(4,1) DEFAULT NULL COMMENT '安全指数',
  `collect_date` date DEFAULT NULL COMMENT '统计日期',
  `org_code` varchar(100) DEFAULT NULL COMMENT '机构',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `Index_org_code` (`org_code`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=420 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='安全指数日流水';

-- ----------------------------
-- Records of f_safety_index_change_log
-- ----------------------------
INSERT INTO `f_safety_index_change_log` VALUES ('382', '60.0', '2021-04-22', '10', null, '2021-04-23 02:00:01');
INSERT INTO `f_safety_index_change_log` VALUES ('383', '60.0', '2021-04-23', '10', null, '2021-04-24 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('384', '60.0', '2021-04-24', '10', null, '2021-04-25 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('385', '60.0', '2021-04-25', '10', null, '2021-04-26 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('386', '100.0', '2021-04-26', '10', null, '2021-04-27 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('387', '100.0', '2021-04-27', '10', null, '2021-04-28 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('388', '100.0', '2021-04-28', '10', null, '2021-04-29 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('389', '91.2', '2021-04-30', '10', null, '2021-05-01 02:00:01');
INSERT INTO `f_safety_index_change_log` VALUES ('390', '91.2', '2021-05-01', '10', null, '2021-05-02 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('391', '91.2', '2021-05-02', '10', null, '2021-05-03 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('392', '91.2', '2021-05-03', '10', null, '2021-05-04 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('393', '91.2', '2021-05-04', '10', null, '2021-05-05 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('394', '91.2', '2021-05-05', '10', null, '2021-05-06 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('395', '91.2', '2021-05-06', '10', null, '2021-05-07 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('396', '91.2', '2021-05-07', '10', null, '2021-05-08 02:00:01');
INSERT INTO `f_safety_index_change_log` VALUES ('397', '91.2', '2021-05-08', '10', null, '2021-05-09 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('398', '91.2', '2021-05-09', '10', null, '2021-05-10 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('399', '91.2', '2021-05-10', '10', null, '2021-05-11 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('400', '91.2', '2021-05-11', '10', null, '2021-05-12 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('401', '91.2', '2021-05-12', '10', null, '2021-05-13 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('402', '91.2', '2021-05-13', '10', null, '2021-05-14 02:00:01');
INSERT INTO `f_safety_index_change_log` VALUES ('403', '91.2', '2021-05-14', '10', null, '2021-05-15 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('404', '91.2', '2021-05-17', '10', null, '2021-05-18 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('405', '91.2', '2021-05-18', '10', null, '2021-05-19 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('406', '91.2', '2021-05-21', '10', null, '2021-05-22 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('407', '91.2', '2021-05-23', '10', null, '2021-05-24 09:14:38');
INSERT INTO `f_safety_index_change_log` VALUES ('408', '91.2', '2021-05-24', '10', null, '2021-05-25 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('409', '91.2', '2021-05-26', '10', null, '2021-05-27 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('410', '91.2', '2021-05-27', '10', null, '2021-05-28 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('411', '91.2', '2021-05-28', '10', null, '2021-05-29 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('412', '91.2', '2021-05-29', '10', null, '2021-05-30 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('413', '91.2', '2021-05-30', '10', null, '2021-05-31 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('414', '91.2', '2021-05-31', '10', null, '2021-06-01 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('415', '91.2', '2021-06-01', '10', null, '2021-06-02 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('416', '91.2', '2021-06-02', '10', null, '2021-06-03 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('417', '91.2', '2021-06-03', '10', null, '2021-06-04 02:00:00');
INSERT INTO `f_safety_index_change_log` VALUES ('418', '91.2', '2021-06-07', '10', null, '2021-06-08 02:00:01');
INSERT INTO `f_safety_index_change_log` VALUES ('419', '91.2', '2021-06-08', '10', null, '2021-06-09 02:00:00');

-- ----------------------------
-- Table structure for f_station_info
-- ----------------------------
DROP TABLE IF EXISTS `f_station_info`;
CREATE TABLE `f_station_info` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(20) DEFAULT NULL COMMENT '名称',
  `station_code` varchar(32) NOT NULL COMMENT '环流站编码',
  `code` varchar(10) DEFAULT NULL COMMENT '后三位编码',
  `elec_type` tinyint(4) DEFAULT NULL COMMENT '换流站类型：1-发电类型；2-收电类型',
  `use_type` tinyint(4) NOT NULL COMMENT '用途类型:1-电厂升压变电站；2-公用普通变电站；3-公用换流变电站；4-企业自备变电站；5-其他',
  `province_code` varchar(32) DEFAULT NULL COMMENT '省份编码',
  `city_code` varchar(32) DEFAULT NULL COMMENT '市区编码',
  `district_code` varchar(32) DEFAULT NULL COMMENT '区县编码',
  `address` varchar(255) DEFAULT NULL COMMENT '详细地址',
  `status` bit(1) NOT NULL DEFAULT b'0' COMMENT '0-启用；1-停用',
  `longitude` double DEFAULT NULL COMMENT '经度',
  `latitude` double DEFAULT NULL COMMENT '纬度',
  `station_charge_user_id` varchar(50) DEFAULT NULL COMMENT '换流站负责人',
  `safety_charge_user_id` varchar(50) DEFAULT NULL COMMENT '安全负责人',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建日期',
  `create_by` varchar(255) DEFAULT NULL COMMENT '创建人',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `station_charge_user_name` varchar(20) DEFAULT NULL COMMENT '换流站负责人姓名',
  `safety_charge_user_name` varchar(20) DEFAULT NULL COMMENT '安全负责人姓名',
  `create_user_name` varchar(20) DEFAULT NULL COMMENT '创建人姓名',
  `create_user_phone_num` varchar(20) DEFAULT NULL COMMENT '创建人联系方式',
  `station_user_phone_num` varchar(20) DEFAULT NULL COMMENT '换流站负责人联系方式',
  `safety_user_phone_num` varchar(20) DEFAULT NULL COMMENT '安全负责人联系方式',
  `fire_captain_name` varchar(20) DEFAULT NULL COMMENT '驻站消防队队长姓名',
  `fire_captain_phone_num` varchar(20) DEFAULT NULL COMMENT '驻站消防队队长电话',
  `fire_captain_user_id` varchar(20) DEFAULT NULL COMMENT '驻站消防队队长',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `f_station_info_uniq` (`station_code`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='站端信息表';

-- ----------------------------
-- Records of f_station_info
-- ----------------------------
INSERT INTO `f_station_info` VALUES ('21', '灵州换流站', '3640323305', '305', '1', '3', '1296739850631958530', '1296743492260864001', '1296746163067822081', '唐延路35号', '', '102.140137', '36.357685', '3106244', '1746069', '2021-05-11 11:56:09', '1785601', null, '黎向锋', '王海涛', 'hjf', null, null, null, '田涛', '', '2795766');

-- ----------------------------
-- Table structure for f_text_plan
-- ----------------------------
DROP TABLE IF EXISTS `f_text_plan`;
CREATE TABLE `f_text_plan` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `app_id` varchar(255) NOT NULL COMMENT '预案id',
  `text_name` varchar(255) NOT NULL DEFAULT '' COMMENT '文本预案名称',
  `file_path` varchar(255) NOT NULL COMMENT '预案路径',
  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='文本预案';

-- ----------------------------
-- Records of f_text_plan
-- ----------------------------

-- ----------------------------
-- Table structure for f_topography_line
-- ----------------------------
DROP TABLE IF EXISTS `f_topography_line`;
CREATE TABLE `f_topography_line` (
  `id` varchar(36) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(255) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(255) DEFAULT NULL,
  `app_id` varchar(32) DEFAULT NULL COMMENT 'appid',
  `clickable` bit(1) DEFAULT NULL COMMENT '可点击',
  `from` varchar(32) DEFAULT NULL COMMENT '起点',
  `has_arrow` bit(1) DEFAULT NULL COMMENT '有箭头',
  `is_dash` bit(1) DEFAULT NULL COMMENT '是虚线',
  `line_color` int(11) DEFAULT NULL COMMENT '线颜色',
  `to` varchar(32) DEFAULT NULL COMMENT '终点',
  `from_port` varchar(32) DEFAULT NULL,
  `to_port` varchar(32) DEFAULT NULL,
  `type` varchar(32) DEFAULT NULL COMMENT '1 领导架构 | 2 任务流程',
  `category` varchar(32) DEFAULT '' COMMENT '类别',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of f_topography_line
-- ----------------------------

-- ----------------------------
-- Table structure for f_topography_node
-- ----------------------------
DROP TABLE IF EXISTS `f_topography_node`;
CREATE TABLE `f_topography_node` (
  `id` varchar(36) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(255) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(255) DEFAULT NULL,
  `category` varchar(32) DEFAULT NULL COMMENT '类别',
  `group` varchar(32) DEFAULT '' COMMENT '分组',
  `is_group` bit(1) DEFAULT NULL COMMENT '是否是组',
  `key` varchar(32) DEFAULT NULL COMMENT 'key',
  `loc` varchar(255) DEFAULT NULL COMMENT '位置',
  `picture` varchar(32) DEFAULT NULL COMMENT '图片',
  `size` varchar(32) DEFAULT NULL COMMENT '大小',
  `source_id` varchar(32) DEFAULT NULL COMMENT '资源id',
  `text` varchar(32) DEFAULT NULL COMMENT '文本',
  `app_id` varchar(32) DEFAULT NULL COMMENT 'appid',
  `type` varchar(32) DEFAULT NULL COMMENT '1 领导架构 | 2 任务流程',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of f_topography_node
-- ----------------------------

-- ----------------------------
-- Table structure for f_topography_node_detail
-- ----------------------------
DROP TABLE IF EXISTS `f_topography_node_detail`;
CREATE TABLE `f_topography_node_detail` (
  `id` varchar(36) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(255) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(255) DEFAULT NULL,
  `node_detail` text COMMENT '详情',
  `nodeid` varchar(36) DEFAULT NULL,
  `nodekey` varchar(32) DEFAULT NULL COMMENT '节点key',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of f_topography_node_detail
-- ----------------------------

-- ----------------------------
-- Table structure for p_app_version
-- ----------------------------
DROP TABLE IF EXISTS `p_app_version`;
CREATE TABLE `p_app_version` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `version` varchar(255) DEFAULT NULL COMMENT '版本号',
  `remark` longtext COMMENT '说明',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `publisher` int(255) DEFAULT NULL COMMENT '发布者id',
  `publisher_name` varchar(255) DEFAULT NULL COMMENT '发布者名称',
  `update_type` int(11) DEFAULT NULL COMMENT '版本更新类型：1.强制更新，2.非强制更新',
  `is_latest_version` bit(1) DEFAULT NULL COMMENT '是否为最新版本',
  `url` longtext COMMENT 'app文件保存路径',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_app_version
-- ----------------------------

-- ----------------------------
-- Table structure for p_catalog_tree
-- ----------------------------
DROP TABLE IF EXISTS `p_catalog_tree`;
CREATE TABLE `p_catalog_tree` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `name` varchar(100) NOT NULL COMMENT '分类名称',
  `order_no` int(11) NOT NULL COMMENT '排序号',
  `parent_id` bigint(20) NOT NULL COMMENT '上级分类id',
  `create_by` bigint(20) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_catalog_tree
-- ----------------------------

-- ----------------------------
-- Table structure for p_check
-- ----------------------------
DROP TABLE IF EXISTS `p_check`;
CREATE TABLE `p_check` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录编号',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `user_id` varchar(200) NOT NULL COMMENT '巡检人id，有可能有多个以,隔开',
  `point_id` bigint(20) NOT NULL COMMENT '巡检点id',
  `point_name` varchar(500) DEFAULT '' COMMENT '巡检点名称',
  `check_time` datetime DEFAULT NULL COMMENT '检查时间',
  `upload_time` datetime DEFAULT NULL COMMENT '记录上传时间',
  `error` varchar(1000) DEFAULT NULL COMMENT '不合格项目',
  `device_id` varchar(100) DEFAULT NULL COMMENT '设备编号',
  `longitude` varchar(50) DEFAULT NULL COMMENT '经度',
  `latitude` varchar(50) DEFAULT NULL COMMENT '纬度',
  `address` varchar(500) DEFAULT NULL COMMENT '参考地址',
  `shot_number` int(11) NOT NULL COMMENT '拍照数量',
  `remark` varchar(1000) DEFAULT NULL COMMENT '巡检备注说明',
  `plan_task_id` bigint(20) DEFAULT NULL COMMENT '计划执行编号',
  `route_id` bigint(20) DEFAULT NULL COMMENT '路线编号',
  `route_name` varchar(500) DEFAULT '' COMMENT '线路名称',
  `is_ok` varchar(6) DEFAULT NULL COMMENT '是否合格',
  `score` int(11) DEFAULT NULL COMMENT '评分',
  `plan_id` bigint(20) DEFAULT NULL COMMENT '计划编号',
  `plan_name` varchar(500) DEFAULT '' COMMENT '计划名称',
  `check_mode` varchar(10) DEFAULT NULL COMMENT '巡检方式',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `plan_task_detail_id` bigint(20) DEFAULT NULL COMMENT '执行计划详情id',
  `error_classify` varchar(200) DEFAULT NULL COMMENT '不合格检查项分类',
  `user_name` varchar(200) DEFAULT '' COMMENT '执行人名称',
  `dep_id` varchar(200) DEFAULT '' COMMENT '执行部门ids',
  `dep_name` varchar(200) DEFAULT '' COMMENT '执行部门名称',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `plan_task_id` (`plan_task_id`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE,
  KEY `complex_id_index` (`user_id`,`point_id`,`plan_task_id`,`route_id`,`plan_id`,`plan_task_detail_id`) USING BTREE,
  KEY `check_time_index` (`check_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1300 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_check
-- ----------------------------
INSERT INTO `p_check` VALUES ('943', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:03:07', null, null, null, null, null, '0', null, '1656', '10', null, '3', '0', '12', null, '', '2021-05-11 16:04:32', '2280', null, '吴俊凯5', '1263370637087387649', '安全保障部,');
INSERT INTO `p_check` VALUES ('944', '10-14', '1893479', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:03:07', null, null, null, null, null, '0', null, '1657', '10', null, '3', '0', '12', null, '', '2021-05-11 16:04:32', '2281', null, '卢阳', '1232939516555915265', '信息化部,');
INSERT INTO `p_check` VALUES ('945', '10', '1746069', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:03:09', null, null, null, null, null, '0', null, '1658', '10', null, '3', '0', '12', null, '', '2021-05-11 16:04:32', '2282', null, '王海涛', '-1', '其他,');
INSERT INTO `p_check` VALUES ('946', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:04:11', null, null, null, null, null, '0', null, '1659', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2283', null, '吴俊凯5', '1263370637087387649', '安全保障部,');
INSERT INTO `p_check` VALUES ('947', '10-14', '1893479', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:04:12', null, null, null, null, null, '0', null, '1660', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2284', null, '卢阳', '1232939516555915265', '信息化部,');
INSERT INTO `p_check` VALUES ('948', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:10:49', null, null, null, null, null, '0', null, '1661', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2285', null, '吴俊凯5', '1263370637087387649', '安全保障部,');
INSERT INTO `p_check` VALUES ('949', '10-14', '1893479', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:10:51', null, null, null, null, null, '0', null, '1662', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2286', null, '卢阳', '1232939516555915265', '信息化部,');
INSERT INTO `p_check` VALUES ('950', '10', '1746069', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:10:51', null, null, null, null, null, '0', null, '1663', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2287', null, '王海涛', '-1', '其他,');
INSERT INTO `p_check` VALUES ('951', '10-42', '2723602', '15', null, '2021-04-23 10:00:00', '2021-04-23 11:10:52', null, null, null, null, null, '0', null, '1664', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2288', null, '吴俊凯5', '1263370637087387649', '安全保障部,');
INSERT INTO `p_check` VALUES ('952', '10-14', '1893479', '15', null, '2021-04-23 10:00:00', '2021-04-23 11:10:53', null, null, null, null, null, '0', null, '1665', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2289', null, '卢阳', '1232939516555915265', '信息化部,');
INSERT INTO `p_check` VALUES ('953', '10', '1746069', '15', null, '2021-04-23 10:00:00', '2021-04-23 11:10:54', null, null, null, null, null, '0', null, '1666', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2290', null, '王海涛', '-1', '其他,');
INSERT INTO `p_check` VALUES ('954', '10-42', '2723602', '15', null, '2021-04-23 11:00:00', '2021-04-23 11:10:55', null, null, null, null, null, '0', null, '1667', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2291', null, '吴俊凯5', '1263370637087387649', '安全保障部,');
INSERT INTO `p_check` VALUES ('955', '10-14', '1893479', '15', null, '2021-04-23 11:00:00', '2021-04-23 11:10:56', null, null, null, null, null, '0', null, '1668', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2292', null, '卢阳', '1232939516555915265', '信息化部,');
INSERT INTO `p_check` VALUES ('956', '10', '1746069', '15', null, '2021-04-23 11:00:00', '2021-04-23 11:10:56', null, null, null, null, null, '0', null, '1669', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2293', null, '王海涛', '-1', '其他,');
INSERT INTO `p_check` VALUES ('957', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:11:38', null, null, null, null, null, '0', null, '1691', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2315', null, '吴俊凯5', '1263370637087387649', '安全保障部,');
INSERT INTO `p_check` VALUES ('958', '10-14', '1893479', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:11:42', null, null, null, null, null, '0', null, '1692', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2316', null, '卢阳', '1232939516555915265', '信息化部,');
INSERT INTO `p_check` VALUES ('959', '10', '1746069', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:11:44', null, null, null, null, null, '0', null, '1693', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2317', null, '王海涛', '-1', '其他,');
INSERT INTO `p_check` VALUES ('960', '10-42', '2723602', '15', null, '2021-04-23 10:00:00', '2021-04-23 11:11:44', null, null, null, null, null, '0', null, '1694', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2318', null, '吴俊凯5', '1263370637087387649', '安全保障部,');
INSERT INTO `p_check` VALUES ('961', '10-14', '1893479', '15', null, '2021-04-23 10:00:00', '2021-04-23 11:11:45', null, null, null, null, null, '0', null, '1695', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2319', null, '卢阳', '1232939516555915265', '信息化部,');
INSERT INTO `p_check` VALUES ('962', '10', '1746069', '15', null, '2021-04-23 10:00:00', '2021-04-23 11:11:46', null, null, null, null, null, '0', null, '1696', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2320', null, '王海涛', '-1', '其他,');
INSERT INTO `p_check` VALUES ('963', '10-42', '2723602', '15', null, '2021-04-23 11:00:00', '2021-04-23 11:11:46', null, null, null, null, null, '0', null, '1697', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2321', null, '吴俊凯5', '1263370637087387649', '安全保障部,');
INSERT INTO `p_check` VALUES ('964', '10-14', '1893479', '15', null, '2021-04-23 11:00:00', '2021-04-23 11:11:46', null, null, null, null, null, '0', null, '1698', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2322', null, '卢阳', '1232939516555915265', '信息化部,');
INSERT INTO `p_check` VALUES ('965', '10', '1746069', '15', null, '2021-04-23 11:00:00', '2021-04-23 11:11:47', null, null, null, null, null, '0', null, '1699', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:32', '2323', null, '王海涛', '-1', '其他,');
INSERT INTO `p_check` VALUES ('966', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:13:46', null, null, null, null, null, '0', null, '1721', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:32', '2345', null, '吴俊凯5', '1263370637087387649', '安全保障部,');
INSERT INTO `p_check` VALUES ('967', '10-14', '2064235', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:13:47', null, null, null, null, null, '0', null, '1722', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:32', '2346', null, '吴江', '1232939516555915265', '信息化部,');
INSERT INTO `p_check` VALUES ('968', '10', '2083389', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:13:47', null, null, null, null, null, '0', null, '1723', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:32', '2347', null, '宁天庆', '-1', '其他,');
INSERT INTO `p_check` VALUES ('969', '10-42', '2723602', '15', null, '2021-04-23 10:00:00', '2021-04-23 11:13:48', null, null, null, null, null, '0', null, '1724', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2348', null, '吴俊凯5', '1263370637087387649', '安全保障部,');
INSERT INTO `p_check` VALUES ('970', '10-14', '2064235', '15', null, '2021-04-23 10:00:00', '2021-04-23 11:13:49', null, null, null, null, null, '0', null, '1725', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2349', null, '吴江', '1232939516555915265', '信息化部,');
INSERT INTO `p_check` VALUES ('971', '10', '2083389', '15', null, '2021-04-23 10:00:00', '2021-04-23 11:13:50', null, null, null, null, null, '0', null, '1726', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2350', null, '宁天庆', '-1', '其他,');
INSERT INTO `p_check` VALUES ('972', '10-42', '2723602', '15', null, '2021-04-23 11:00:00', '2021-04-23 11:13:50', null, null, null, null, null, '0', null, '1727', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2351', null, '吴俊凯5', '1263370637087387649', '安全保障部,');
INSERT INTO `p_check` VALUES ('973', '10-14', '2064235', '15', null, '2021-04-23 11:00:00', '2021-04-23 11:13:51', null, null, null, null, null, '0', null, '1728', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2352', null, '吴江', '1232939516555915265', '信息化部,');
INSERT INTO `p_check` VALUES ('974', '10', '2083389', '15', null, '2021-04-23 11:00:00', '2021-04-23 11:13:52', null, null, null, null, null, '0', null, '1729', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2353', null, '宁天庆', '-1', '其他,');
INSERT INTO `p_check` VALUES ('975', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:14:29', null, null, null, null, null, '0', null, '1751', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2375', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('976', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 10:00:00', '2021-04-23 11:14:31', null, null, null, null, null, '0', null, '1752', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2376', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('977', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 11:00:00', '2021-04-23 11:14:33', null, null, null, null, null, '0', null, '1753', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2377', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('978', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:17:23', null, null, null, null, null, '0', null, '1761', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2385', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('979', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 10:00:00', '2021-04-23 11:17:24', null, null, null, null, null, '0', null, '1762', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2386', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('980', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 11:00:00', '2021-04-23 11:17:27', null, null, null, null, null, '0', null, '1763', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2387', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('981', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:28:28', null, null, null, null, null, '0', null, '1771', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2395', null, '吴俊凯5', '1263370637087387649', '安全保障部,');
INSERT INTO `p_check` VALUES ('982', '10-14', '1893479', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:28:31', null, null, null, null, null, '0', null, '1772', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2396', null, '卢阳', '1232939516555915265', '信息化部,');
INSERT INTO `p_check` VALUES ('983', '10', '1746069', '15', null, '2021-04-23 09:00:00', '2021-04-23 11:28:37', null, null, null, null, null, '0', null, '1773', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2397', null, '王海涛', '-1', '其他,');
INSERT INTO `p_check` VALUES ('984', '10-42', '2723602', '15', null, '2021-04-23 10:00:00', '2021-04-23 11:28:38', null, null, null, null, null, '0', null, '1774', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2398', null, '吴俊凯5', '1263370637087387649', '安全保障部,');
INSERT INTO `p_check` VALUES ('985', '10-14', '1893479', '15', null, '2021-04-23 10:00:00', '2021-04-23 11:28:38', null, null, null, null, null, '0', null, '1775', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2399', null, '卢阳', '1232939516555915265', '信息化部,');
INSERT INTO `p_check` VALUES ('986', '10', '1746069', '15', null, '2021-04-23 10:00:00', '2021-04-23 11:28:39', null, null, null, null, null, '0', null, '1776', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2400', null, '王海涛', '-1', '其他,');
INSERT INTO `p_check` VALUES ('987', '10-42', '2723602', '15', null, '2021-04-23 11:00:00', '2021-04-23 11:28:40', null, null, null, null, null, '0', null, '1777', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2401', null, '吴俊凯5', '1263370637087387649', '安全保障部,');
INSERT INTO `p_check` VALUES ('988', '10-14', '1893479', '15', null, '2021-04-23 11:00:00', '2021-04-23 11:28:40', null, null, null, null, null, '0', null, '1778', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2402', null, '卢阳', '1232939516555915265', '信息化部,');
INSERT INTO `p_check` VALUES ('989', '10', '1746069', '15', null, '2021-04-23 11:00:00', '2021-04-23 11:28:42', null, null, null, null, null, '0', null, '1779', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2403', null, '王海涛', '-1', '其他,');
INSERT INTO `p_check` VALUES ('990', '10', '2723602', '15', 'A0001', '2021-04-23 11:38:31', '2021-04-23 11:38:39', '空库头盔-shg-A004=;', null, null, null, null, '1', '', '0', '0', null, '2', '0', '0', null, 'QR', '2021-05-11 16:04:33', '0', '空库头盔-shg', '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('991', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 09:00:00', '2021-04-23 15:20:40', null, null, null, null, null, '0', null, '1803', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2427', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('992', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 09:00:00', '2021-04-23 15:20:48', null, null, null, null, null, '0', null, '1804', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2428', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('993', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 09:00:00', '2021-04-23 15:30:57', null, null, null, null, null, '0', null, '1805', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2429', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('994', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 15:41:10', null, null, null, null, null, '0', null, '1806', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2430', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('995', '10-14', '1893479', '15', null, '2021-04-23 09:00:00', '2021-04-23 15:41:17', null, null, null, null, null, '0', null, '1807', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2431', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('996', '10', '1746069', '15', null, '2021-04-23 09:00:00', '2021-04-23 15:41:18', null, null, null, null, null, '0', null, '1808', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2432', null, '王海涛', '-1', '其他,');
INSERT INTO `p_check` VALUES ('997', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 09:00:00', '2021-04-23 15:45:42', null, null, null, null, null, '0', null, '1809', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2433', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('998', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 09:00:00', '2021-04-23 15:49:50', null, null, null, null, null, '0', null, '1810', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2434', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('999', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 09:00:00', '2021-04-23 15:51:02', null, null, null, null, null, '0', null, '1811', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2435', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1000', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 09:00:00', '2021-04-23 15:53:54', null, null, null, null, null, '0', null, '1812', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2436', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1001', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:06:02', null, null, null, null, null, '0', null, '1813', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2437', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1002', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:11:09', null, null, null, null, null, '0', null, '1814', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2438', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1003', '10-42,10-14,10', '2723602,2064235,2083389', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:12:18', null, null, null, null, null, '0', null, '1815', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2439', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1004', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:15:51', null, null, null, null, null, '0', null, '1816', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2440', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1005', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:16:24', null, null, null, null, null, '0', null, '1817', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2441', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1006', '10-14', '1893479', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:16:25', null, null, null, null, null, '0', null, '1818', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2442', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1007', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:19:24', null, null, null, null, null, '0', null, '1819', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2443', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1008', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:20:18', null, null, null, null, null, '0', null, '1820', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2444', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1009', '10-14', '1893479', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:20:33', null, null, null, null, null, '0', null, '1821', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2445', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1010', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:26:12', null, null, null, null, null, '0', null, '1822', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2446', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1011', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:27:36', null, null, null, null, null, '0', null, '1823', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2447', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1012', '10-42', '2210960', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:30:20', null, null, null, null, null, '0', null, '1824', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2448', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1013', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:30:21', null, null, null, null, null, '0', null, '1825', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2449', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1014', '10-14', '1893479', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:30:21', null, null, null, null, null, '0', null, '1826', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2450', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1015', '10-42', '2210960', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:31:36', null, null, null, null, null, '0', null, '1827', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2451', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1016', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:31:43', null, null, null, null, null, '0', null, '1828', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2452', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1017', '10-14', '1893479', '15', null, '2021-04-23 09:00:00', '2021-04-23 16:31:48', null, null, null, null, null, '0', null, '1829', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2453', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1018', '10-42', '2210960', '15', null, '2021-04-23 10:00:00', '2021-04-23 16:31:56', null, null, null, null, null, '0', null, '1830', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2454', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1019', '10-42', '2723602', '15', null, '2021-04-23 10:00:00', '2021-04-23 16:32:01', null, null, null, null, null, '0', null, '1831', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2455', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1020', '10-14', '1893479', '15', null, '2021-04-23 10:00:00', '2021-04-23 16:32:10', null, null, null, null, null, '0', null, '1832', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2456', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1021', '10-42', '2210960', '15', null, '2021-04-23 11:00:00', '2021-04-23 16:32:16', null, null, null, null, null, '0', null, '1833', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2457', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1022', '10-42', '2723602', '15', null, '2021-04-23 11:00:00', '2021-04-23 16:32:22', null, null, null, null, null, '0', null, '1834', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2458', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1023', '10-14', '1893479', '15', null, '2021-04-23 11:00:00', '2021-04-23 16:32:28', null, null, null, null, null, '0', null, '1835', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2459', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1024', '10-42', '2210960', '15', null, '2021-04-23 12:00:00', '2021-04-23 16:32:32', null, null, null, null, null, '0', null, '1836', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2460', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1025', '10-42', '2723602', '15', null, '2021-04-23 12:00:00', '2021-04-23 16:32:35', null, null, null, null, null, '0', null, '1837', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2461', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1026', '10-14', '1893479', '15', null, '2021-04-23 12:00:00', '2021-04-23 16:32:36', null, null, null, null, null, '0', null, '1838', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2462', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1027', '10-42', '2210960', '15', null, '2021-04-23 13:00:00', '2021-04-23 16:32:36', null, null, null, null, null, '0', null, '1839', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2463', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1028', '10-42', '2723602', '15', null, '2021-04-23 13:00:00', '2021-04-23 16:32:37', null, null, null, null, null, '0', null, '1840', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2464', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1029', '10-14', '1893479', '15', null, '2021-04-23 13:00:00', '2021-04-23 16:32:38', null, null, null, null, null, '0', null, '1841', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2465', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1030', '10-42', '2210960', '15', null, '2021-04-23 14:00:00', '2021-04-23 16:32:39', null, null, null, null, null, '0', null, '1842', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2466', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1031', '10-42', '2210960', '15', null, '2021-04-23 09:00:00', '2021-04-23 18:17:26', null, null, null, null, null, '0', null, '1843', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2467', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1032', '10-14', '1893479', '15', null, '2021-04-23 09:00:00', '2021-04-23 18:17:26', null, null, null, null, null, '0', null, '1845', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2469', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1033', '10-42', '2723602', '15', null, '2021-04-23 10:00:00', '2021-04-23 18:17:28', null, null, null, null, null, '0', null, '1847', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2471', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1034', '10-14', '1893479', '15', null, '2021-04-23 10:00:00', '2021-04-23 18:17:28', null, null, null, null, null, '0', null, '1848', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2472', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1035', '10-42', '2210960', '15', null, '2021-04-23 11:00:00', '2021-04-23 18:17:28', null, null, null, null, null, '0', null, '1849', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2473', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1036', '10-14', '1893479', '15', null, '2021-04-23 11:00:00', '2021-04-23 18:17:29', null, null, null, null, null, '0', null, '1851', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2475', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1037', '10-42', '2210960', '15', null, '2021-04-23 12:00:00', '2021-04-23 18:17:30', null, null, null, null, null, '0', null, '1852', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2476', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1038', '10-42', '2723602', '15', null, '2021-04-23 12:00:00', '2021-04-23 18:17:30', null, null, null, null, null, '0', null, '1853', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2477', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1039', '10-42', '2210960', '15', null, '2021-04-23 13:00:00', '2021-04-23 18:17:31', null, null, null, null, null, '0', null, '1855', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2479', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1040', '10-42', '2723602', '15', null, '2021-04-23 13:00:00', '2021-04-23 18:17:31', null, null, null, null, null, '0', null, '1856', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2480', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1041', '10-14', '1893479', '15', null, '2021-04-23 13:00:00', '2021-04-23 18:17:31', null, null, null, null, null, '0', null, '1857', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2481', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1042', '10-42', '2210960', '15', null, '2021-04-23 14:00:00', '2021-04-23 18:17:32', null, null, null, null, null, '0', null, '1858', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2482', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1043', '10-42', '2723602', '15', null, '2021-04-23 14:00:00', '2021-04-23 18:17:32', null, null, null, null, null, '0', null, '1859', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2483', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1044', '10-14', '1893479', '15', null, '2021-04-23 14:00:00', '2021-04-23 18:17:33', null, null, null, null, null, '0', null, '1860', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2484', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1045', '10-42', '2210960', '15', null, '2021-04-23 15:00:00', '2021-04-23 18:17:33', null, null, null, null, null, '0', null, '1861', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2485', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1046', '10-42', '2723602', '15', null, '2021-04-23 15:00:00', '2021-04-23 18:17:34', null, null, null, null, null, '0', null, '1862', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2486', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1047', '10-14', '1893479', '15', null, '2021-04-23 15:00:00', '2021-04-23 18:17:34', null, null, null, null, null, '0', null, '1863', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2487', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1048', '10-42', '2210960', '15', null, '2021-04-23 16:00:00', '2021-04-23 18:17:36', null, null, null, null, null, '0', null, '1864', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2488', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1049', '10-42', '2723602', '15', null, '2021-04-23 16:00:00', '2021-04-23 18:17:36', null, null, null, null, null, '0', null, '1865', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2489', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1050', '10-14', '1893479', '15', null, '2021-04-23 16:00:00', '2021-04-23 18:17:38', null, null, null, null, null, '0', null, '1866', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2490', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1051', '10-42', '2210960', '15', null, '2021-04-23 17:00:00', '2021-04-23 18:17:39', null, null, null, null, null, '0', null, '1867', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2491', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1052', '10-42', '2723602', '15', null, '2021-04-23 17:00:00', '2021-04-23 18:17:39', null, null, null, null, null, '0', null, '1868', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2492', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1053', '10-14', '1893479', '15', null, '2021-04-23 17:00:00', '2021-04-23 18:17:39', null, null, null, null, null, '0', null, '1869', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2493', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1054', '10-42', '2210960', '15', null, '2021-04-23 18:00:00', '2021-04-23 18:17:39', null, null, null, null, null, '0', null, '1870', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2494', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1055', '10-42', '2723602', '15', null, '2021-04-23 18:00:00', '2021-04-23 18:17:41', null, null, null, null, null, '0', null, '1871', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2495', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1056', '10-14', '1893479', '15', null, '2021-04-23 18:00:00', '2021-04-23 18:17:41', null, null, null, null, null, '0', null, '1872', '10', null, '3', '0', '0', null, '', '2021-05-11 16:04:33', '2496', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1057', '10-42', '2210960', '15', null, '2021-04-23 09:00:00', '2021-04-23 18:34:51', null, null, null, null, null, '0', null, '1873', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2497', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1058', '10-42', '2723602', '15', null, '2021-04-23 09:00:00', '2021-04-23 18:34:53', null, null, null, null, null, '0', null, '1874', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2498', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1059', '10-14', '1893479', '15', null, '2021-04-23 09:00:00', '2021-04-23 18:34:54', null, null, null, null, null, '0', null, '1875', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2499', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1060', '10-42', '2723602', '15', null, '2021-04-23 10:00:00', '2021-04-23 18:34:55', null, null, null, null, null, '0', null, '1877', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2501', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1061', '10-42', '2210960', '15', null, '2021-04-23 11:00:00', '2021-04-23 18:34:56', null, null, null, null, null, '0', null, '1879', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2503', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1062', '10-42', '2723602', '15', null, '2021-04-23 11:00:00', '2021-04-23 18:34:56', null, null, null, null, null, '0', null, '1880', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2504', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1063', '10-14', '1893479', '15', null, '2021-04-23 11:00:00', '2021-04-23 18:34:57', null, null, null, null, null, '0', null, '1881', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2505', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1064', '10-42', '2210960', '15', null, '2021-04-23 12:00:00', '2021-04-23 18:34:57', null, null, null, null, null, '0', null, '1882', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2506', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1065', '10-42', '2723602', '15', null, '2021-04-23 12:00:00', '2021-04-23 18:34:57', null, null, null, null, null, '0', null, '1883', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2507', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1066', '10-14', '1893479', '15', null, '2021-04-23 12:00:00', '2021-04-23 18:34:58', null, null, null, null, null, '0', null, '1884', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2508', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1067', '10-42', '2210960', '15', null, '2021-04-23 13:00:00', '2021-04-23 18:34:58', null, null, null, null, null, '0', null, '1885', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2509', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1068', '10-42', '2723602', '15', null, '2021-04-23 13:00:00', '2021-04-23 18:34:59', null, null, null, null, null, '0', null, '1886', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2510', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1069', '10-14', '1893479', '15', null, '2021-04-23 13:00:00', '2021-04-23 18:34:59', null, null, null, null, null, '0', null, '1887', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2511', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1070', '10-42', '2210960', '15', null, '2021-04-23 14:00:00', '2021-04-23 18:35:00', null, null, null, null, null, '0', null, '1888', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2512', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1071', '10-42', '2723602', '15', null, '2021-04-23 14:00:00', '2021-04-23 18:35:00', null, null, null, null, null, '0', null, '1889', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2513', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1072', '10-14', '1893479', '15', null, '2021-04-23 14:00:00', '2021-04-23 18:35:01', null, null, null, null, null, '0', null, '1890', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2514', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1073', '10-42', '2210960', '15', null, '2021-04-23 15:00:00', '2021-04-23 18:35:01', null, null, null, null, null, '0', null, '1891', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2515', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1074', '10-42', '2723602', '15', null, '2021-04-23 15:00:00', '2021-04-23 18:35:02', null, null, null, null, null, '0', null, '1892', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2516', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1075', '10-14', '1893479', '15', null, '2021-04-23 15:00:00', '2021-04-23 18:35:03', null, null, null, null, null, '0', null, '1893', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2517', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1076', '10-42', '2210960', '15', null, '2021-04-23 16:00:00', '2021-04-23 18:35:03', null, null, null, null, null, '0', null, '1894', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2518', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1077', '10-42', '2723602', '15', null, '2021-04-23 16:00:00', '2021-04-23 18:35:03', null, null, null, null, null, '0', null, '1895', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2519', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1078', '10-14', '1893479', '15', null, '2021-04-23 16:00:00', '2021-04-23 18:35:04', null, null, null, null, null, '0', null, '1896', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2520', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1079', '10-42', '2210960', '15', null, '2021-04-23 17:00:00', '2021-04-23 18:35:05', null, null, null, null, null, '0', null, '1897', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2521', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1080', '10-42', '2723602', '15', null, '2021-04-23 17:00:00', '2021-04-23 18:35:06', null, null, null, null, null, '0', null, '1898', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2522', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1081', '10-14', '1893479', '15', null, '2021-04-23 17:00:00', '2021-04-23 18:35:07', null, null, null, null, null, '0', null, '1899', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2523', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1082', '10-42', '2210960', '15', null, '2021-04-23 18:00:00', '2021-04-23 18:35:07', null, null, null, null, null, '0', null, '1900', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2524', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1083', '10-42', '2723602', '15', null, '2021-04-23 18:00:00', '2021-04-23 18:35:08', null, null, null, null, null, '0', null, '1901', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2525', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1084', '10-14', '1893479', '15', null, '2021-04-23 18:00:00', '2021-04-23 18:35:09', null, null, null, null, null, '0', null, '1902', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2526', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1085', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 09:00:00', '2021-04-23 18:35:38', null, null, null, null, null, '0', null, '1903', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2527', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1086', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 10:00:00', '2021-04-23 18:35:38', null, null, null, null, null, '0', null, '1904', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2528', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1087', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 11:00:00', '2021-04-23 18:35:38', null, null, null, null, null, '0', null, '1905', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2529', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1088', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 12:00:00', '2021-04-23 18:35:40', null, null, null, null, null, '0', null, '1906', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2530', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1089', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 13:00:00', '2021-04-23 18:35:41', null, null, null, null, null, '0', null, '1907', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2531', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1090', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 14:00:00', '2021-04-23 18:35:43', null, null, null, null, null, '0', null, '1908', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2532', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1091', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 15:00:00', '2021-04-23 18:35:43', null, null, null, null, null, '0', null, '1909', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2533', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1092', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 16:00:00', '2021-04-23 18:35:44', null, null, null, null, null, '0', null, '1910', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2534', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1093', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 17:00:00', '2021-04-23 18:35:45', null, null, null, null, null, '0', null, '1911', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2535', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1094', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 18:00:00', '2021-04-23 18:35:46', null, null, null, null, null, '0', null, '1912', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2536', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1095', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 13:00:00', '2021-04-23 18:39:35', null, null, null, null, null, '0', null, '1913', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2537', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1096', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 14:00:00', '2021-04-23 18:39:36', null, null, null, null, null, '0', null, '1914', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2538', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1097', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 15:00:00', '2021-04-23 18:39:38', null, null, null, null, null, '0', null, '1915', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2539', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1098', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 16:00:00', '2021-04-23 18:39:39', null, null, null, null, null, '0', null, '1916', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2540', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1099', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 17:00:00', '2021-04-23 18:39:39', null, null, null, null, null, '0', null, '1917', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2541', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1100', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 18:00:00', '2021-04-23 18:39:40', null, null, null, null, null, '0', null, '1918', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2542', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1101', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 19:00:00', '2021-04-23 19:00:01', null, null, null, null, null, '0', null, '1919', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2543', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1102', '10', '2810078', '15', 'A0001', '2021-04-23 19:23:37', '2021-04-23 19:23:39', '', null, null, null, null, '2', '', '0', '0', null, '1', '0', '0', null, 'OTHER', '2021-05-11 16:04:33', '0', '', 'tb6', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1103', '10', '2810078', '15', 'A0001', '2021-04-23 19:24:52', '2021-04-23 19:24:56', '头骨振动-文本检查项目=;空库头盔-shg-A004=;', null, null, null, null, '2', '', '0', '0', null, '2', '0', '0', null, 'OTHER', '2021-05-11 16:04:33', '0', '头骨振动,空库头盔-shg', 'tb6', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1104', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-23 20:00:00', '2021-04-23 20:00:00', null, null, null, null, null, '0', null, '1920', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2544', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1105', '10-14', '1893479', '15', null, '2021-04-24 10:00:00', '2021-04-24 10:00:01', null, null, null, null, null, '0', null, '1929', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2553', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1106', '10-42', '2210960', '15', null, '2021-04-24 10:00:00', '2021-04-24 10:00:01', null, null, null, null, null, '0', null, '1927', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2551', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1107', '10-42', '2723602', '15', null, '2021-04-24 10:00:00', '2021-04-24 10:00:01', null, null, null, null, null, '0', null, '1928', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2552', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1108', '10-42', '2210960', '15', null, '2021-04-24 11:00:00', '2021-04-24 11:00:01', null, null, null, null, null, '0', null, '1930', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2554', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1109', '10-42', '2723602', '15', null, '2021-04-24 11:00:00', '2021-04-24 11:00:01', null, null, null, null, null, '0', null, '1931', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2555', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1110', '10-14', '1893479', '15', null, '2021-04-24 11:00:00', '2021-04-24 11:00:01', null, null, null, null, null, '0', null, '1932', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2556', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1111', '10-14', '1893479', '15', null, '2021-04-24 12:00:00', '2021-04-24 12:00:01', null, null, null, null, null, '0', null, '1935', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2559', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1112', '10-42', '2210960', '15', null, '2021-04-24 12:00:00', '2021-04-24 12:00:01', null, null, null, null, null, '0', null, '1933', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2557', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1113', '10-42', '2723602', '15', null, '2021-04-24 12:00:00', '2021-04-24 12:00:01', null, null, null, null, null, '0', null, '1934', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2558', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1114', '10-42', '2210960', '15', null, '2021-04-24 13:00:00', '2021-04-24 13:00:00', null, null, null, null, null, '0', null, '1936', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2560', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1115', '10-42', '2723602', '15', null, '2021-04-24 13:00:00', '2021-04-24 13:00:00', null, null, null, null, null, '0', null, '1937', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2561', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1116', '10-14', '1893479', '15', null, '2021-04-24 13:00:00', '2021-04-24 13:00:00', null, null, null, null, null, '0', null, '1938', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2562', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1117', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-24 13:00:00', '2021-04-24 13:00:00', null, null, null, null, null, '0', null, '1954', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2578', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1118', '10-42', '2210960', '15', null, '2021-04-24 14:00:00', '2021-04-24 14:00:01', null, null, null, null, null, '0', null, '1939', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2563', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1119', '10-42', '2723602', '15', null, '2021-04-24 14:00:00', '2021-04-24 14:00:01', null, null, null, null, null, '0', null, '1940', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2564', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1120', '10-14', '1893479', '15', null, '2021-04-24 14:00:00', '2021-04-24 14:00:01', null, null, null, null, null, '0', null, '1941', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2565', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1121', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-24 14:00:00', '2021-04-24 14:00:01', null, null, null, null, null, '0', null, '1955', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2579', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1122', '10-42', '2210960', '15', null, '2021-04-24 15:00:00', '2021-04-24 15:00:01', null, null, null, null, null, '0', null, '1942', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2566', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1123', '10-14', '1893479', '15', null, '2021-04-24 15:00:00', '2021-04-24 15:00:01', null, null, null, null, null, '0', null, '1944', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2568', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1124', '10-42', '2723602', '15', null, '2021-04-24 15:00:00', '2021-04-24 15:00:01', null, null, null, null, null, '0', null, '1943', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2567', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1125', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-24 15:00:00', '2021-04-24 15:00:01', null, null, null, null, null, '0', null, '1956', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2580', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1126', '10-42', '2210960', '15', null, '2021-04-24 16:00:00', '2021-04-24 16:00:01', null, null, null, null, null, '0', null, '1945', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2569', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1127', '10-14', '1893479', '15', null, '2021-04-24 16:00:00', '2021-04-24 16:00:01', null, null, null, null, null, '0', null, '1947', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2571', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1128', '10-42', '2723602', '15', null, '2021-04-24 16:00:00', '2021-04-24 16:00:01', null, null, null, null, null, '0', null, '1946', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2570', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1129', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-24 16:00:00', '2021-04-24 16:00:01', null, null, null, null, null, '0', null, '1957', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2581', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1130', '10-14', '1893479', '15', null, '2021-04-24 17:00:00', '2021-04-24 17:00:00', null, null, null, null, null, '0', null, '1950', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2574', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1131', '10-42', '2723602', '15', null, '2021-04-24 17:00:00', '2021-04-24 17:00:00', null, null, null, null, null, '0', null, '1949', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2573', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1132', '10-42', '2210960', '15', null, '2021-04-24 17:00:00', '2021-04-24 17:00:00', null, null, null, null, null, '0', null, '1948', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2572', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1133', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-24 17:00:00', '2021-04-24 17:00:00', null, null, null, null, null, '0', null, '1958', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2582', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1134', '10-14', '1893479', '15', null, '2021-04-24 18:00:00', '2021-04-24 18:00:01', null, null, null, null, null, '0', null, '1953', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2577', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1135', '10-42', '2210960', '15', null, '2021-04-24 18:00:00', '2021-04-24 18:00:01', null, null, null, null, null, '0', null, '1951', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2575', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1136', '10-42', '2723602', '15', null, '2021-04-24 18:00:00', '2021-04-24 18:00:01', null, null, null, null, null, '0', null, '1952', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2576', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1137', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-24 18:00:00', '2021-04-24 18:00:01', null, null, null, null, null, '0', null, '1959', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2583', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1138', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-24 19:00:00', '2021-04-24 19:00:01', null, null, null, null, null, '0', null, '1960', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2584', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1139', '10-42', '2795766', '15', null, '2021-04-24 20:00:00', '2021-04-24 20:00:01', null, null, null, null, null, '0', null, '1962', '10', null, '3', '0', '15', null, '', '2021-05-11 16:04:33', '2586', null, '田涛', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1140', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-24 20:00:00', '2021-04-24 20:00:01', null, null, null, null, null, '0', null, '1961', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2585', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1141', '10-42', '2723602', '15', null, '2021-04-25 09:00:00', '2021-04-25 09:00:01', null, null, null, null, null, '0', null, '1966', '10', null, '3', '0', '12', null, '', '2021-05-11 16:04:33', '2590', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1142', '10-42', '2723602', '15', null, '2021-04-25 09:00:00', '2021-04-25 09:00:01', null, null, null, null, null, '0', null, '1970', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2594', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1143', '10-42', '2210960', '15', null, '2021-04-25 09:00:00', '2021-04-25 09:00:01', null, null, null, null, null, '0', null, '1969', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2593', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1144', '10-14', '1893479', '15', null, '2021-04-25 09:00:00', '2021-04-25 09:00:01', null, null, null, null, null, '0', null, '1971', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2595', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1145', '10-14', '1893479', '15', null, '2021-04-25 09:00:00', '2021-04-25 09:00:01', null, null, null, null, null, '0', null, '1967', '10', null, '3', '0', '12', null, '', '2021-05-11 16:04:33', '2591', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1146', '10-14', '1893479', '15', null, '2021-04-25 10:00:00', '2021-04-25 10:00:00', null, null, null, null, null, '0', null, '1974', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2598', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1147', '10-42', '2723602', '15', null, '2021-04-25 10:00:00', '2021-04-25 10:00:00', null, null, null, null, null, '0', null, '1973', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2597', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1148', '10-42', '2210960', '15', null, '2021-04-25 10:00:00', '2021-04-25 10:00:00', null, null, null, null, null, '0', null, '1972', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2596', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1149', '10', '2723602', '15', 'A0001', '2021-04-25 10:12:47', '2021-04-25 10:12:54', '', null, null, null, null, '1', '', '1976', '10', 'A0001', '1', '120', '13', 'A0001多次', 'QR', '2021-05-11 16:04:33', '2600', '', '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1150', '10', '2723602', '15', 'A0001', '2021-04-25 10:19:00', '2021-04-25 10:19:03', '', null, null, null, null, '0', '', '0', '0', null, '1', '0', '0', null, 'QR', '2021-05-11 16:04:33', '0', '', '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1151', '10', '2723602', '15', 'A0001', '2021-04-25 10:25:26', '2021-04-25 10:25:28', '', null, null, null, null, '2', '', '0', '0', null, '1', '0', '0', null, 'QR', '2021-05-11 16:04:33', '0', '', '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1152', '10', '2723602', '15', 'A0001', '2021-04-25 10:29:11', '2021-04-25 10:30:01', '', null, null, null, null, '2', '', '0', '0', null, '1', '0', '0', null, 'QR', '2021-05-11 16:04:33', '0', '', '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1153', '10-42', '2210960', '15', null, '2021-04-25 11:00:00', '2021-04-25 11:00:01', null, null, null, null, null, '0', null, '1975', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2599', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1154', '10-14', '1893479', '15', null, '2021-04-25 11:00:00', '2021-04-25 11:00:01', null, null, null, null, null, '0', null, '1977', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2601', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1155', '10', '2723602', '15', 'A0002', '2021-04-25 11:06:05', '2021-04-25 11:06:07', '', null, null, null, null, '0', '', '0', '0', null, '1', '0', '0', null, 'OTHER', '2021-05-11 16:04:33', '0', '', '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1156', '10-14', '1893479', '15', null, '2021-04-25 12:00:00', '2021-04-25 12:00:01', null, null, null, null, null, '0', null, '1980', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2604', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1157', '10-42', '2210960', '15', null, '2021-04-25 12:00:00', '2021-04-25 12:00:01', null, null, null, null, null, '0', null, '1978', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2602', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1158', '10-42', '2723602', '15', null, '2021-04-25 12:00:00', '2021-04-25 12:00:01', null, null, null, null, null, '0', null, '1979', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2603', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1159', '10-14', '1893479', '15', null, '2021-04-25 13:00:00', '2021-04-25 13:00:01', null, null, null, null, null, '0', null, '1983', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2607', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1160', '10-42', '2210960', '15', null, '2021-04-25 13:00:00', '2021-04-25 13:00:01', null, null, null, null, null, '0', null, '1981', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2605', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1161', '10-42', '2723602', '15', null, '2021-04-25 13:00:00', '2021-04-25 13:00:01', null, null, null, null, null, '0', null, '1982', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2606', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1162', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-25 13:00:00', '2021-04-25 13:00:01', null, null, null, null, null, '0', null, '1999', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2623', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1163', '10-42', '2210960', '15', null, '2021-04-25 14:00:00', '2021-04-25 14:00:00', null, null, null, null, null, '0', null, '1984', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2608', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1164', '10-14', '1893479', '15', null, '2021-04-25 14:00:00', '2021-04-25 14:00:00', null, null, null, null, null, '0', null, '1986', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2610', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1165', '10-42', '2723602', '15', null, '2021-04-25 14:00:00', '2021-04-25 14:00:00', null, null, null, null, null, '0', null, '1985', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2609', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1166', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-25 14:00:00', '2021-04-25 14:00:00', null, null, null, null, null, '0', null, '2000', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2624', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1167', '10-42', '2723602', '15', null, '2021-04-25 15:00:00', '2021-04-25 15:00:01', null, null, null, null, null, '0', null, '1988', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2612', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1168', '10-42', '2210960', '15', null, '2021-04-25 15:00:00', '2021-04-25 15:00:01', null, null, null, null, null, '0', null, '1987', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2611', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1169', '10-14', '1893479', '15', null, '2021-04-25 15:00:00', '2021-04-25 15:00:01', null, null, null, null, null, '0', null, '1989', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2613', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1170', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-25 15:00:00', '2021-04-25 15:00:01', null, null, null, null, null, '0', null, '2001', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2625', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1171', '10-42', '2210960', '15', null, '2021-04-25 16:00:00', '2021-04-25 16:00:00', null, null, null, null, null, '0', null, '1990', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2614', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1172', '10-42', '2723602', '15', null, '2021-04-25 16:00:00', '2021-04-25 16:00:00', null, null, null, null, null, '0', null, '1991', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2615', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1173', '10-14', '1893479', '15', null, '2021-04-25 16:00:00', '2021-04-25 16:00:00', null, null, null, null, null, '0', null, '1992', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2616', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1174', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-25 16:00:00', '2021-04-25 16:00:00', null, null, null, null, null, '0', null, '2002', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2626', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1175', '10-14', '1893479', '15', null, '2021-04-25 17:00:00', '2021-04-25 17:00:00', null, null, null, null, null, '0', null, '1995', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2619', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1176', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-25 17:00:00', '2021-04-25 17:00:00', null, null, null, null, null, '0', null, '2003', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2627', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1177', '10-42', '2210960', '15', null, '2021-04-25 17:00:00', '2021-04-25 17:00:00', null, null, null, null, null, '0', null, '1993', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2617', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1178', '10-42', '2723602', '15', null, '2021-04-25 17:00:00', '2021-04-25 17:00:00', null, null, null, null, null, '0', null, '1994', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2618', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1179', '10-14', '1893479', '15', null, '2021-04-25 18:00:00', '2021-04-25 18:00:01', null, null, null, null, null, '0', null, '1998', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2622', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1180', '10-42', '2723602', '15', null, '2021-04-25 18:00:00', '2021-04-25 18:00:01', null, null, null, null, null, '0', null, '1997', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2621', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1181', '10-42', '2210960', '15', null, '2021-04-25 18:00:00', '2021-04-25 18:00:01', null, null, null, null, null, '0', null, '1996', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2620', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1182', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-25 18:00:00', '2021-04-25 18:00:02', null, null, null, null, null, '0', null, '2004', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2628', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1183', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-25 19:00:00', '2021-04-25 19:00:01', null, null, null, null, null, '0', null, '2005', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2629', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1184', '10-42', '2795766', '15', null, '2021-04-25 20:00:00', '2021-04-25 20:00:00', null, null, null, null, null, '0', null, '2007', '10', null, '3', '0', '15', null, '', '2021-05-11 16:04:33', '2631', null, '田涛', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1185', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-25 20:00:00', '2021-04-25 20:00:00', null, null, null, null, null, '0', null, '2006', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2630', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1186', '10-42', '2210960', '15', null, '2021-04-26 09:00:00', '2021-04-26 09:00:01', null, null, null, null, null, '0', null, '2011', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2635', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1187', '10-14', '1893479', '15', null, '2021-04-26 09:00:00', '2021-04-26 09:00:01', null, null, null, null, null, '0', null, '2013', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2637', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1188', '10-14', '1893479', '15', null, '2021-04-26 09:00:00', '2021-04-26 09:00:01', null, null, null, null, null, '0', null, '2009', '10', null, '3', '0', '12', null, '', '2021-05-11 16:04:33', '2633', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1189', '10-42', '2723602', '15', null, '2021-04-26 09:00:00', '2021-04-26 09:00:01', null, null, null, null, null, '0', null, '2012', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2636', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1190', '10-42', '2723602', '15', null, '2021-04-26 09:00:00', '2021-04-26 09:00:01', null, null, null, null, null, '0', null, '2008', '10', null, '3', '0', '12', null, '', '2021-05-11 16:04:33', '2632', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1191', '10-42', '3059845,3058148', '15', null, '2021-04-26 09:00:00', '2021-04-26 09:00:01', null, null, null, null, null, '0', null, '2050', '12', null, '3', '0', '18', null, '', '2021-05-11 16:04:33', '2674', null, 'xxz2,xxz', '1263370637087387649,1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1192', '10-14', '1893479', '15', null, '2021-04-26 10:00:00', '2021-04-26 10:00:01', null, null, null, null, null, '0', null, '2016', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2640', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1193', '10-42', '2723602', '15', null, '2021-04-26 10:00:00', '2021-04-26 10:00:01', null, null, null, null, null, '0', null, '2015', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2639', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1194', '10-42', '2210960', '15', null, '2021-04-26 10:00:00', '2021-04-26 10:00:01', null, null, null, null, null, '0', null, '2014', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2638', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1195', '10-42', '2210960', '15', null, '2021-04-26 11:00:00', '2021-04-26 11:00:00', null, null, null, null, null, '0', null, '2017', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2641', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1196', '10-14', '1893479', '15', null, '2021-04-26 11:00:00', '2021-04-26 11:00:00', null, null, null, null, null, '0', null, '2019', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2643', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1197', '10-42', '2723602', '15', null, '2021-04-26 11:00:00', '2021-04-26 11:00:00', null, null, null, null, null, '0', null, '2018', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2642', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1198', '10-42', '2723602', '15', null, '2021-04-26 12:00:00', '2021-04-26 12:00:00', null, null, null, null, null, '0', null, '2021', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2645', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1199', '10-42', '2210960', '15', null, '2021-04-26 12:00:00', '2021-04-26 12:00:00', null, null, null, null, null, '0', null, '2020', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2644', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1200', '10-14', '1893479', '15', null, '2021-04-26 12:00:00', '2021-04-26 12:00:00', null, null, null, null, null, '0', null, '2022', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2646', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1201', '10-14', '1893479', '15', null, '2021-04-26 13:00:00', '2021-04-26 13:00:00', null, null, null, null, null, '0', null, '2025', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2649', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1202', '10-42', '2210960', '15', null, '2021-04-26 13:00:00', '2021-04-26 13:00:01', null, null, null, null, null, '0', null, '2023', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2647', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1203', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-26 13:00:00', '2021-04-26 13:00:01', null, null, null, null, null, '0', null, '2041', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2665', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1204', '10-42', '2723602', '15', null, '2021-04-26 13:00:00', '2021-04-26 13:00:01', null, null, null, null, null, '0', null, '2024', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2648', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1205', '10-42, 10-14', '2723602,2064235,2083389', '15', null, '2021-04-26 14:00:00', '2021-04-26 14:00:00', null, null, null, null, null, '0', null, '2042', '10', null, '3', '0', '14', null, '', '2021-05-11 16:04:33', '2666', null, '吴俊凯5,吴江,宁天庆', '1263370637087387649,1232939516555915265,-1', '信息化部,安全保障部');
INSERT INTO `p_check` VALUES ('1206', '10-42', '2210960', '15', null, '2021-04-26 14:00:00', '2021-04-26 14:00:00', null, null, null, null, null, '0', null, '2026', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2650', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1207', '10-14', '1893479', '15', null, '2021-04-26 14:00:00', '2021-04-26 14:00:00', null, null, null, null, null, '0', null, '2028', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2652', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1208', '10-42', '2723602', '15', null, '2021-04-26 14:00:00', '2021-04-26 14:00:00', null, null, null, null, null, '0', null, '2027', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2651', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1209', '10-14', '1893479', '15', null, '2021-04-27 09:00:00', '2021-04-27 09:00:01', null, null, null, null, null, '0', null, '2056', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2685', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1210', '10-14', '1893479', '15', null, '2021-04-27 09:00:00', '2021-04-27 09:00:01', null, null, null, null, null, '0', null, '2056', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2686', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1211', '10-42', '2723602', '15', null, '2021-04-27 09:00:00', '2021-04-27 09:00:01', null, null, null, null, null, '0', null, '2051', '10', null, '3', '0', '12', null, '', '2021-05-11 16:04:33', '2675', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1212', '10-42', '2723602', '15', null, '2021-04-27 09:00:00', '2021-04-27 09:00:01', null, null, null, null, null, '0', null, '2055', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2683', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1213', '10-42', '2723602', '15', null, '2021-04-27 09:00:00', '2021-04-27 09:00:01', null, null, null, null, null, '0', null, '2051', '10', null, '3', '0', '12', null, '', '2021-05-11 16:04:33', '2676', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1214', '10-42', '2723602', '15', null, '2021-04-27 09:00:00', '2021-04-27 09:00:01', null, null, null, null, null, '0', null, '2055', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2684', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1215', '10-42', '2723602', '15', null, '2021-04-27 10:00:00', '2021-04-27 10:00:00', null, null, null, null, null, '0', null, '2058', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2689', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1216', '10-42', '2210960', '15', null, '2021-04-27 10:00:00', '2021-04-27 10:00:00', null, null, null, null, null, '0', null, '2057', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2687', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1217', '10-14', '1893479', '15', null, '2021-04-27 10:00:00', '2021-04-27 10:00:00', null, null, null, null, null, '0', null, '2059', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2691', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1218', '10-42', '2723602', '15', null, '2021-04-27 10:00:00', '2021-04-27 10:00:00', null, null, null, null, null, '0', null, '2058', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2690', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1219', '10-42', '2210960', '15', null, '2021-04-27 10:00:00', '2021-04-27 10:00:00', null, null, null, null, null, '0', null, '2057', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2688', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1220', '10-14', '1893479', '15', null, '2021-04-27 10:00:00', '2021-04-27 10:00:01', null, null, null, null, null, '0', null, '2059', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2692', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1221', '10-42', '2210960', '15', null, '2021-04-27 11:00:00', '2021-04-27 11:00:01', null, null, null, null, null, '0', null, '2060', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2693', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1222', '10-14', '1893479', '15', null, '2021-04-27 11:00:00', '2021-04-27 11:00:01', null, null, null, null, null, '0', null, '2062', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2697', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1223', '10-42', '2723602', '15', null, '2021-04-27 11:00:00', '2021-04-27 11:00:01', null, null, null, null, null, '0', null, '2061', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2695', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1224', '10-42', '2210960', '15', null, '2021-04-27 11:00:00', '2021-04-27 11:00:01', null, null, null, null, null, '0', null, '2060', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2694', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1225', '10-14', '1893479', '15', null, '2021-04-27 11:00:00', '2021-04-27 11:00:01', null, null, null, null, null, '0', null, '2062', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2698', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1226', '10-42', '2723602', '15', null, '2021-04-27 11:00:00', '2021-04-27 11:00:01', null, null, null, null, null, '0', null, '2061', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2696', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1227', '10-42', '2210960', '15', null, '2021-04-27 14:05:00', '2021-04-27 14:10:32', null, null, null, null, null, '0', null, '2093', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2759', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1228', '10-42', '2210960', '15', null, '2021-04-27 14:05:00', '2021-04-27 14:10:32', null, null, null, null, null, '0', null, '2093', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2760', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1229', '10-42', '2723602', '15', null, '2021-04-27 14:05:00', '2021-04-27 14:10:32', null, null, null, null, null, '0', null, '2094', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2761', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1230', '10-42', '2723602', '15', null, '2021-04-27 14:05:00', '2021-04-27 14:10:32', null, null, null, null, null, '0', null, '2094', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2762', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1231', '10-14', '1893479', '15', null, '2021-04-27 14:05:00', '2021-04-27 14:10:33', null, null, null, null, null, '0', null, '2095', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2763', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1232', '10-14', '1893479', '15', null, '2021-04-27 14:05:00', '2021-04-27 14:10:33', null, null, null, null, null, '0', null, '2095', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2764', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1233', '10-42', '2723602', '15', null, '2021-04-27 14:10:00', '2021-04-27 14:10:33', null, null, null, null, null, '0', null, '2097', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2767', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1234', '10-42', '2723602', '15', null, '2021-04-27 14:10:00', '2021-04-27 14:10:33', null, null, null, null, null, '0', null, '2097', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2768', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1235', '10-14', '1893479', '15', null, '2021-04-27 14:10:00', '2021-04-27 14:10:34', null, null, null, null, null, '0', null, '2098', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2769', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1236', '10-14', '1893479', '15', null, '2021-04-27 14:10:00', '2021-04-27 14:10:34', null, null, null, null, null, '0', null, '2098', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2770', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1237', '10-14', '1893479', '15', null, '2021-04-27 14:15:00', '2021-04-27 14:15:45', null, null, null, null, null, '0', null, '2101', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2775', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1238', '10-14', '1893479', '15', null, '2021-04-27 14:15:00', '2021-04-27 14:15:57', null, null, null, null, null, '0', null, '2101', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2776', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1239', '10-42', '2210960', '15', null, '2021-04-27 14:15:00', '2021-04-27 14:16:13', null, null, null, null, null, '0', null, '2099', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2771', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1240', '10-42', '2210960', '15', null, '2021-04-27 14:15:00', '2021-04-27 14:16:45', null, null, null, null, null, '0', null, '2099', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2772', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1241', '10-42', '2723602', '15', null, '2021-04-27 14:20:00', '2021-04-27 14:20:51', null, null, null, null, null, '0', null, '2103', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2779', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1242', '10-42', '2723602', '15', null, '2021-04-27 14:20:00', '2021-04-27 14:20:51', null, null, null, null, null, '0', null, '2103', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2780', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1243', '10-14', '1893479', '15', null, '2021-04-27 14:25:00', '2021-04-27 14:25:01', null, null, null, null, null, '0', null, '2107', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2787', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1244', '10-14', '1893479', '15', null, '2021-04-27 14:25:00', '2021-04-27 14:25:01', null, null, null, null, null, '0', null, '2107', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2788', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1245', '10-42', '2210960', '15', null, '2021-04-27 14:30:00', '2021-04-27 14:30:00', null, null, null, null, null, '0', null, '2108', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2789', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1246', '10-42', '2723602', '15', null, '2021-04-27 14:30:00', '2021-04-27 14:30:00', null, null, null, null, null, '0', null, '2109', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2791', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1247', '10-14', '1893479', '15', null, '2021-04-27 14:30:00', '2021-04-27 14:30:00', null, null, null, null, null, '0', null, '2110', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2793', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1248', '10-42', '2210960', '15', null, '2021-04-27 14:30:00', '2021-04-27 14:30:00', null, null, null, null, null, '0', null, '2108', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2790', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1249', '10-42', '2723602', '15', null, '2021-04-27 14:30:00', '2021-04-27 14:30:00', null, null, null, null, null, '0', null, '2109', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2792', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1250', '10-14', '1893479', '15', null, '2021-04-27 14:30:00', '2021-04-27 14:30:00', null, null, null, null, null, '0', null, '2110', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2794', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1251', '10-14', '1893479', '15', null, '2021-04-27 14:35:00', '2021-04-27 14:35:00', null, null, null, null, null, '0', null, '2113', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2799', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1252', '10-42', '2723602', '15', null, '2021-04-27 14:35:00', '2021-04-27 14:35:00', null, null, null, null, null, '0', null, '2112', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2797', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1253', '10-42', '2210960', '15', null, '2021-04-27 14:35:00', '2021-04-27 14:35:00', null, null, null, null, null, '0', null, '2111', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2795', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1254', '10-14', '1893479', '15', null, '2021-04-27 14:35:00', '2021-04-27 14:35:00', null, null, null, null, null, '0', null, '2113', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2800', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1255', '10-42', '2723602', '15', null, '2021-04-27 14:35:00', '2021-04-27 14:35:00', null, null, null, null, null, '0', null, '2112', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2798', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1256', '10-42', '2210960', '15', null, '2021-04-27 14:35:00', '2021-04-27 14:35:00', null, null, null, null, null, '0', null, '2111', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2796', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1257', '10-42', '2723602', '15', null, '2021-04-27 14:40:00', '2021-04-27 14:40:00', null, null, null, null, null, '0', null, '2115', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:33', '2803', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1258', '10-42', '2210960', '15', null, '2021-04-27 14:40:00', '2021-04-27 14:40:00', null, null, null, null, null, '0', null, '2114', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2801', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1259', '10-14', '1893479', '15', null, '2021-04-27 14:40:00', '2021-04-27 14:40:00', null, null, null, null, null, '0', null, '2116', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2805', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1260', '10-42', '2210960', '15', null, '2021-04-27 14:40:00', '2021-04-27 14:40:00', null, null, null, null, null, '0', null, '2114', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2802', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1261', '10-42', '2723602', '15', null, '2021-04-27 14:40:00', '2021-04-27 14:40:00', null, null, null, null, null, '0', null, '2115', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2804', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1262', '10-14', '1893479', '15', null, '2021-04-27 14:40:00', '2021-04-27 14:40:00', null, null, null, null, null, '0', null, '2116', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2806', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1263', '10-14', '1893479', '15', null, '2021-04-27 14:45:00', '2021-04-27 14:45:00', null, null, null, null, null, '0', null, '2119', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2811', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1264', '10-42', '2723602', '15', null, '2021-04-27 14:45:00', '2021-04-27 14:45:00', null, null, null, null, null, '0', null, '2118', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2809', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1265', '10-42', '2210960', '15', null, '2021-04-27 14:45:00', '2021-04-27 14:45:00', null, null, null, null, null, '0', null, '2117', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2807', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1266', '10-14', '1893479', '15', null, '2021-04-27 14:45:00', '2021-04-27 14:45:00', null, null, null, null, null, '0', null, '2119', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2812', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1267', '10-42', '2723602', '15', null, '2021-04-27 14:45:00', '2021-04-27 14:45:00', null, null, null, null, null, '0', null, '2118', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2810', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1268', '10-42', '2210960', '15', null, '2021-04-27 14:45:00', '2021-04-27 14:45:01', null, null, null, null, null, '0', null, '2117', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2808', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1269', '10-14', '1893479', '15', null, '2021-04-27 14:50:00', '2021-04-27 14:50:01', null, null, null, null, null, '0', null, '2122', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2817', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1270', '10-14', '1893479', '15', null, '2021-04-27 14:50:00', '2021-04-27 14:50:01', null, null, null, null, null, '0', null, '2122', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2818', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1271', '10-42', '2210960', '15', null, '2021-04-27 14:50:00', '2021-04-27 14:50:01', null, null, null, null, null, '0', null, '2120', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2813', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1272', '10-42', '2723602', '15', null, '2021-04-27 14:50:00', '2021-04-27 14:50:01', null, null, null, null, null, '0', null, '2121', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2815', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1273', '10-42', '2210960', '15', null, '2021-04-27 14:50:00', '2021-04-27 14:50:01', null, null, null, null, null, '0', null, '2120', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2814', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1274', '10-42', '2723602', '15', null, '2021-04-27 14:50:00', '2021-04-27 14:50:01', null, null, null, null, null, '0', null, '2121', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2816', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1275', '10-42', '2210960', '15', null, '2021-04-27 14:55:00', '2021-04-27 14:55:00', null, null, null, null, null, '0', null, '2123', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2819', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1276', '10-14', '1893479', '15', null, '2021-04-27 14:55:00', '2021-04-27 14:55:00', null, null, null, null, null, '0', null, '2125', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2823', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1277', '10-42', '2723602', '15', null, '2021-04-27 14:55:00', '2021-04-27 14:55:00', null, null, null, null, null, '0', null, '2124', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2821', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1278', '10-42', '2210960', '15', null, '2021-04-27 14:55:00', '2021-04-27 14:55:00', null, null, null, null, null, '0', null, '2123', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2820', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1279', '10-14', '1893479', '15', null, '2021-04-27 14:55:00', '2021-04-27 14:55:00', null, null, null, null, null, '0', null, '2125', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2824', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1280', '10-42', '2723602', '15', null, '2021-04-27 14:55:00', '2021-04-27 14:55:00', null, null, null, null, null, '0', null, '2124', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2822', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1281', '10-42', '2210960', '15', null, '2021-04-27 15:00:00', '2021-04-27 15:00:01', null, null, null, null, null, '0', null, '2126', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2825', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1282', '10-42', '2723602', '15', null, '2021-04-27 15:00:00', '2021-04-27 15:00:01', null, null, null, null, null, '0', null, '2127', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2827', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1283', '10-42', '2210960', '15', null, '2021-04-27 15:00:00', '2021-04-27 15:00:01', null, null, null, null, null, '0', null, '2126', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2826', null, '郑家文', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1284', '10-14', '1893479', '15', null, '2021-04-27 15:00:00', '2021-04-27 15:00:01', null, null, null, null, null, '0', null, '2128', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2829', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1285', '10-42', '2723602', '15', null, '2021-04-27 15:00:00', '2021-04-27 15:00:01', null, null, null, null, null, '0', null, '2127', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2828', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1286', '10-14', '1893479', '15', null, '2021-04-27 15:00:00', '2021-04-27 15:00:01', null, null, null, null, null, '0', null, '2128', '10', null, '3', '0', '13', null, '', '2021-05-11 16:04:34', '2830', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1287', '10-42', '2723602', '15', null, '2021-04-28 09:00:00', '2021-04-28 09:00:00', null, null, null, null, null, '0', null, '2129', '10', null, '3', '0', '12', null, '', '2021-05-11 16:04:34', '2831', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1288', '10-14', '1893479', '15', null, '2021-04-28 09:00:00', '2021-04-28 09:00:00', null, null, null, null, null, '0', null, '2130', '10', null, '3', '0', '12', null, '', '2021-05-11 16:04:34', '2833', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1289', '10-42', '2723602', '15', null, '2021-04-28 09:00:00', '2021-04-28 09:00:00', null, null, null, null, null, '0', null, '2129', '10', null, '3', '0', '12', null, '', '2021-05-11 16:04:34', '2832', null, '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1290', '10-14', '1893479', '15', null, '2021-04-28 09:00:00', '2021-04-28 09:00:00', null, null, null, null, null, '0', null, '2130', '10', null, '3', '0', '12', null, '', '2021-05-11 16:04:34', '2834', null, '卢阳', '1232939516555915265', '信息化部');
INSERT INTO `p_check` VALUES ('1291', '10', '2723602', '15', 'A0002', '2021-05-06 14:04:18', '2021-05-06 14:04:37', '', null, null, null, null, '0', '', '0', '0', null, '1', '0', '0', null, 'QR', '2021-05-11 16:04:34', '0', '', '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1292', '10', '2723602', '15', 'A0506', '2021-05-06 14:06:55', '2021-05-06 14:06:56', '空库头盔-shg-A005=;空库头盔-shg-A001=;空库头盔-shg-A002=B;', null, null, null, null, '0', '', '0', '0', null, '2', '0', '0', null, 'QR', '2021-05-11 16:04:34', '0', '空库头盔-shg', '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1293', '10', '2723602', '15', 'A0506', '2021-05-06 16:28:02', '2021-05-06 16:28:04', '空库头盔-shg-A005=;', null, null, null, null, '1', '', '2289', '13', '11', '2', '0', '19', 'A0506', 'QR', '2021-05-11 16:04:34', '3135', '空库头盔-shg', '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1294', '10', '2723602', '15', 'A0506', '2021-05-06 16:44:20', '2021-05-06 16:44:19', '空库头盔-shg-A005=;', null, null, null, null, '1', '', '2290', '13', '11', '2', '0', '19', 'A0506', 'QR', '2021-05-11 16:04:34', '3136', '空库头盔-shg', '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1295', '10', '2723602', '15', 'A050801', '2021-05-08 16:47:10', '2021-05-08 16:47:13', 'H消防头盔-标题1111=选择2;', null, null, null, null, '1', '', '0', '0', null, '2', '0', '0', null, 'QR', '2021-05-11 16:04:34', '0', 'H消防头盔', '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1296', '10', '2723602', '15', 'A050801', '2021-05-08 17:56:03', '2021-05-08 17:56:58', 'H消防头盔-标题1111=选择2;', null, null, null, null, '4', '', '0', '0', null, '2', '0', '0', null, 'QR', '2021-05-11 16:04:34', '0', 'H消防头盔', '吴俊凯5', '1263370637087387649', '安全保障部');
INSERT INTO `p_check` VALUES ('1297', '10', '2201454', '15', 'A0002', '2021-05-11 14:27:11', '2021-05-11 14:27:02', '', null, null, null, null, '4', '', '0', '0', null, '1', '0', '0', null, 'OTHER', '2021-05-11 16:04:34', '0', '', '翟鹏鹏', '1308950460886958081', '安全一部');
INSERT INTO `p_check` VALUES ('1298', '10', '2201454', '15', 'A0002', '2021-05-11 14:29:38', '2021-05-11 14:29:29', '', null, null, null, null, '0', '', '0', '0', null, '1', '0', '0', null, 'OTHER', '2021-05-11 16:04:34', '0', '', '翟鹏鹏', '1308950460886958081', '安全一部');
INSERT INTO `p_check` VALUES ('1299', '10', '2201454', '15', 'A0002', '2021-05-11 14:30:17', '2021-05-11 14:30:07', '', null, null, null, null, '0', '', '0', '0', null, '1', '0', '0', null, 'OTHER', '2021-05-11 16:04:34', '0', '', '翟鹏鹏', '1308950460886958081', '安全一部');

-- ----------------------------
-- Table structure for p_check_input
-- ----------------------------
DROP TABLE IF EXISTS `p_check_input`;
CREATE TABLE `p_check_input` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检记录检查项id',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `check_id` bigint(20) NOT NULL COMMENT '巡检记录id',
  `input_id` bigint(20) NOT NULL COMMENT '检查项id',
  `order_no` int(11) NOT NULL COMMENT '序号',
  `input_value` varchar(1000) DEFAULT NULL COMMENT '输入值',
  `is_ok` varchar(6) NOT NULL COMMENT '是否合格',
  `score` int(11) NOT NULL COMMENT '评分',
  `route_point_item_id` bigint(20) DEFAULT NULL COMMENT '巡检点检查项id',
  `remark` varchar(500) DEFAULT NULL,
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `point_classify_id` bigint(20) DEFAULT NULL COMMENT '检查点扩展分类id',
  `point_classify_name` varchar(100) DEFAULT NULL COMMENT '检查点扩展分类名称',
  `input_name` varchar(1000) DEFAULT NULL COMMENT '检查项名称',
  `danger_handle_state` tinyint(4) DEFAULT NULL COMMENT '隐患处理状态 0：处理中；1：处理完成',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `check_id` (`check_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_check_input
-- ----------------------------

-- ----------------------------
-- Table structure for p_check_shot
-- ----------------------------
DROP TABLE IF EXISTS `p_check_shot`;
CREATE TABLE `p_check_shot` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录照片编号',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `check_id` bigint(20) NOT NULL COMMENT '巡检记录id',
  `check_input_id` bigint(20) DEFAULT NULL,
  `shot_type` varchar(4) NOT NULL COMMENT '拍照类型',
  `photo_data` text COMMENT '照片内容',
  `point_name` varchar(100) DEFAULT NULL COMMENT '拍照点名称',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `classify_id` bigint(20) DEFAULT NULL COMMENT '扩展分类id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_check_shot
-- ----------------------------

-- ----------------------------
-- Table structure for p_config
-- ----------------------------
DROP TABLE IF EXISTS `p_config`;
CREATE TABLE `p_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '配置接口id',
  `des` varchar(50) DEFAULT NULL COMMENT '描述',
  `name` varchar(100) NOT NULL COMMENT '名称',
  `attribute` varchar(500) NOT NULL COMMENT '属性',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_config
-- ----------------------------
INSERT INTO `p_config` VALUES ('2', '主题颜色', 'theme', 'blue', '2019-07-10 00:00:00');
INSERT INTO `p_config` VALUES ('3', 'logo地址', 'logo', 'http://', '2019-07-10 00:00:00');
INSERT INTO `p_config` VALUES ('4', '最新修改时间', 'timestamp', '1559178441', '2019-07-10 00:00:00');
INSERT INTO `p_config` VALUES ('5', '权限服务器地址', 'securityAddress', 'http://198.120.112.182:8800', '2019-07-10 00:00:00');
INSERT INTO `p_config` VALUES ('6', '业务服务地址', 'businessAddress', 'http://198.120.112.182:8082/', '2019-07-10 00:00:00');
INSERT INTO `p_config` VALUES ('7', '升级地址', 'updateAddress', 'http://198.120.112.182:8080/apk/version.json', '2019-07-10 00:00:00');

-- ----------------------------
-- Table structure for p_input_item
-- ----------------------------
DROP TABLE IF EXISTS `p_input_item`;
CREATE TABLE `p_input_item` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_code` varchar(100) NOT NULL COMMENT '机构编码',
  `name` varchar(200) DEFAULT NULL COMMENT '检查项名称',
  `order_no` int(11) DEFAULT NULL COMMENT '排序字段',
  `item_type` varchar(50) NOT NULL COMMENT '检查项类型:文本,选择,数字',
  `is_must` varchar(2) DEFAULT NULL COMMENT '是否必填',
  `is_score` varchar(2) DEFAULT NULL COMMENT '是否评分',
  `default_value` varchar(100) DEFAULT NULL COMMENT '默认值',
  `is_multiline` varchar(2) DEFAULT NULL COMMENT '是否执行多行输入',
  `catalog_id` bigint(20) DEFAULT NULL COMMENT '类型',
  `input_json` longtext,
  `data_json` longtext COMMENT '检查说明',
  `remark` longtext COMMENT '备注',
  `picture_json` longtext COMMENT '拍照配置',
  `create_by` varchar(255) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
  `level` varchar(10) DEFAULT NULL COMMENT '巡检项等级1-5',
  `item_no` varchar(100) NOT NULL COMMENT '检查项编号',
  `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
  `basis_json` text COMMENT '标准依据',
  `risk_desc` varchar(500) DEFAULT '' COMMENT '风险描述',
  `input_type` int(10) DEFAULT NULL COMMENT '0.表示手动录入，1.表示规则同步',
  `input_classify` varchar(255) DEFAULT NULL COMMENT '检查点分类',
  `equipment_name` varchar(255) DEFAULT NULL COMMENT '装备定义名称',
  `title` varchar(255) DEFAULT NULL COMMENT '内容',
  `unit` varchar(255) DEFAULT NULL COMMENT '数字项默认值单位',
  `check_method` varchar(255) DEFAULT NULL COMMENT '检查方法',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=255 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_input_item
-- ----------------------------
INSERT INTO `p_input_item` VALUES ('243', '10', '火灾报警主机主电源和备用电源自动切换', '0', '选择', '否', '否', null, '否', '0', null, '[{\"score\":0,\"name\":\"合格\",\"isOk\":\"是\",\"isChecked\":\"否\",\"orderNo\":0},{\"score\":0,\"name\":\"不合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":1}]', '', '[{\"isMust\":\"否\",\"name\":\"火灾报警主机电源\",\"orderNo\":0}]', '3024170', '2021-04-26 10:45:38', '\0', '', 'QYZDJCX0002', null, null, '', '0', 'LOAD', null, null, null, '主电切断时备电自动投入运行主电恢复时能从备电源自动转入主电状态主、备电源指示灯显示正常 ');
INSERT INTO `p_input_item` VALUES ('244', '10', '火灾报警主机电源标志检查', '0', '选择', '否', '否', null, '否', '0', null, '[{\"score\":0,\"name\":\"合格\",\"isOk\":\"是\",\"isChecked\":\"否\",\"orderNo\":0},{\"score\":0,\"name\":\"不合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":1}]', '', '[]', '3024170', '2021-04-26 10:39:37', '\0', '', 'QYZDJCX0001', null, null, '', '0', '外观检查', null, null, null, '主电源有明显的标识');
INSERT INTO `p_input_item` VALUES ('245', '10', '火灾报警主机备用电源充放电试验 ', '0', '选择', '否', '否', null, '否', '0', null, '[{\"score\":0,\"name\":\"合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":0},{\"score\":0,\"name\":\"不合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":1}]', '', '[]', '3024170', '2021-04-26 10:44:55', '\0', '', 'QYZDJCX0003', null, null, '', '0', 'LOAD', null, null, null, '备用电源充放电功能正常');
INSERT INTO `p_input_item` VALUES ('246', '10', '火灾报警主机外观检查 ', '0', '选择', '否', '否', null, '否', '0', null, '[{\"score\":0,\"name\":\"合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":0},{\"score\":0,\"name\":\"不合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":1}]', '', '[]', '3024170', '2021-04-26 10:47:22', '\0', '', 'QYZDJCX0004', null, null, '', '0', '外观检查', null, null, null, '无锈蚀及明显机械损伤铭牌标志清晰组 件完整、牢固各指示灯显示正常壳体接 地可靠');
INSERT INTO `p_input_item` VALUES ('247', '10', '火灾报警主机自检功能测试', '0', '选择', '否', '否', null, '否', '0', null, '[{\"score\":0,\"name\":\"合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":0},{\"score\":0,\"name\":\"不合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":1}]', '', '[]', '3024170', '2021-04-26 10:50:36', '\0', '', 'QYZDJCX0005', null, null, '', '0', '功能测试', null, null, null, '按下自检键能对面板上所有的指示灯、显 示器和音响器件进行功能自检。自检期间 如非自检回路有火灾报');
INSERT INTO `p_input_item` VALUES ('248', '10', '火灾报警主机故障、报警信号上传功能测试 ', '0', '选择', '否', '否', null, '否', '0', null, '[{\"score\":0,\"name\":\"合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":0},{\"score\":0,\"name\":\"不合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":1}]', '', '[]', '3024170', '2021-04-26 10:52:54', '\0', '', 'QYZDJCX0006', null, null, '', '0', '功能测试', null, null, null, '触发“装置故障”“火灾报警”两个信号应能向本地后台、调度端正确上传运维人 员配合核对');
INSERT INTO `p_input_item` VALUES ('249', '10', '火灾报警主机消音、复位功能测试', '0', '选择', '否', '否', null, '否', '0', null, '[{\"score\":0,\"name\":\"合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":0},{\"score\":0,\"name\":\"不合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":1}]', '', '[]', '3024170', '2021-04-26 10:55:47', '\0', '', 'QYZDJCX0007', null, null, '', '0', '功能测试', null, null, null, '主机接到报警信号后按下消音键应能消除声信号。对应显示灯应保持常亮按下复位 键后应能复位 ');
INSERT INTO `p_input_item` VALUES ('250', '10', '火灾报警主机火灾记忆、打印功能测试 ', '0', '选择', '否', '否', null, '否', '0', null, '[{\"score\":0,\"name\":\"合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":0},{\"score\":0,\"name\":\"不合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":1}]', '', '[]', '3024170', '2021-04-26 10:57:51', '\0', '', 'QYZDJCX0008', null, null, '', '0', '功能测试', null, null, null, '查看报警控制器报警计时装置情况应能打印出月、日、时、分等信息打印机应正常工作打印纸应充足不足');
INSERT INTO `p_input_item` VALUES ('251', '10', '火灾报警主机主机时间 ', '0', '选择', '否', '否', null, '否', '0', null, '[{\"score\":0,\"name\":\"合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":0},{\"score\":0,\"name\":\"不合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":1}]', '', '[]', '3024170', '2021-04-26 11:02:19', '\0', '', 'QYZDJCX0009', null, null, '', '0', 'LOAD', null, null, null, '主机时间正确');
INSERT INTO `p_input_item` VALUES ('252', '10', '火灾显示盘显示功能测试 ', '0', '选择', '否', '否', null, '否', '0', null, '[{\"score\":0,\"name\":\"合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":0},{\"score\":0,\"name\":\"不合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":1}]', '', '[]', '3024170', '2021-04-26 11:26:42', '\0', '', 'QYZDJCX0010', null, null, '', '0', '功能测试', null, null, null, '火灾显示盘应能接收火灾报警控制器的火灾报警信号、主电源断电、短路及其它故障报警信号发出声、光报警信');
INSERT INTO `p_input_item` VALUES ('253', '10', '非消防电源联动', '0', '选择', '否', '否', null, '否', '0', null, '[{\"score\":0,\"name\":\"合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":0},{\"score\":0,\"name\":\"不合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":1}]', '', '[]', '3024170', '2021-04-26 11:28:45', '\0', '', 'QYZDJCX0011', null, null, '', '0', 'LOAD', null, null, null, '确认火灾后能切断有关部位非消防电源并接通警报装置、应急照明和疏散指示灯 ');
INSERT INTO `p_input_item` VALUES ('254', '10', '控制功能及反馈', '0', '选择', '否', '否', null, '否', '0', null, '[{\"score\":0,\"name\":\"合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":0},{\"score\":0,\"name\":\"不合格\",\"isOk\":\"否\",\"isChecked\":\"否\",\"orderNo\":1}]', '', '[]', '3024170', '2021-04-26 11:41:35', '\0', '', 'QYZDJCX0012', null, null, '', '0', 'LOAD', null, null, null, '除自动控制外，还能手动控制消防水泵防排烟风机的启停，并接受反馈信号');

-- ----------------------------
-- Table structure for p_latent_danger
-- ----------------------------
DROP TABLE IF EXISTS `p_latent_danger`;
CREATE TABLE `p_latent_danger` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `business_key` varchar(255) NOT NULL COMMENT '业务唯一标识',
  `org_code` varchar(255) DEFAULT NULL COMMENT '公司',
  `danger_name` varchar(500) NOT NULL COMMENT '隐患名称',
  `current_flow_record_id` bigint(20) DEFAULT NULL COMMENT '当前工作流记录编号',
  `instance_id` varchar(50) DEFAULT NULL COMMENT '工作流实例编号',
  `danger_level` tinyint(4) NOT NULL DEFAULT '1' COMMENT '隐患等级（1：一般隐患；2：重大隐患；0：安全问题）',
  `danger_position` varchar(255) DEFAULT NULL COMMENT '隐患地点',
  `danger_type` tinyint(4) NOT NULL DEFAULT '1' COMMENT '隐患类型（1：无码无计划隐患；2：巡检隐患；3：有码无计划隐患；4：随手拍）',
  `remark` text COMMENT '备注',
  `overtime_state` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否逾期（0：否；1：是）',
  `reform_type` tinyint(4) DEFAULT NULL COMMENT '整改类型（1：常规整改；2：安措计划；3：延期治理）',
  `reform_limit_date` datetime DEFAULT NULL COMMENT '整改限制时间',
  `reform_json` text COMMENT '整改对象',
  `danger_state` tinyint(4) NOT NULL DEFAULT '1' COMMENT '隐患状态（1：待评审；2：待治理；3：安措计划中；4：待验证；5：治理完毕；6：已撤销；7：延期治理中；8：延期治理待车间部门审核；9：延期治理待公司审核',
  `discoverer_user_id` varchar(255) NOT NULL COMMENT '发现人',
  `discoverer_department_id` varchar(255) DEFAULT NULL COMMENT '发现人部门编号',
  `photo_urls` text COMMENT '图片',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
  `delay_limit_date` datetime DEFAULT NULL COMMENT '延期治理时间',
  `problem_description` varchar(500) DEFAULT NULL COMMENT '问题描述',
  `reason_analysis` varchar(500) DEFAULT NULL COMMENT '原因分析',
  `infer_other_things` varchar(500) DEFAULT NULL COMMENT '举一反三',
  `check_input_id` bigint(20) DEFAULT NULL COMMENT '检查记录创建隐患对应check_input_id',
  `structure_id` bigint(20) DEFAULT NULL COMMENT '建筑ID',
  `structure_name` varchar(255) DEFAULT NULL COMMENT '建筑名称',
  `instance_key` varchar(255) DEFAULT NULL COMMENT '流程实例key',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='隐患表';

-- ----------------------------
-- Records of p_latent_danger
-- ----------------------------

-- ----------------------------
-- Table structure for p_latent_danger_flow_record
-- ----------------------------
DROP TABLE IF EXISTS `p_latent_danger_flow_record`;
CREATE TABLE `p_latent_danger_flow_record` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `danger_id` bigint(20) NOT NULL COMMENT '隐患编号',
  `action_flag` varchar(50) NOT NULL COMMENT '执行标志',
  `flow_task_name` varchar(255) DEFAULT NULL COMMENT '当前节点名称',
  `flow_task_user_ids` text COMMENT '当前节点可执行人（多个逗号分开）',
  `flow_task_id` varchar(255) DEFAULT NULL COMMENT '当前节点编号',
  `excute_state` tinyint(4) NOT NULL DEFAULT '1' COMMENT '执行状态（1：未执行；2：通过；3：驳回）',
  `excute_user_id` varchar(255) DEFAULT NULL COMMENT '执行人',
  `excute_department_id` varchar(255) DEFAULT NULL COMMENT '执行部门编号',
  `excute_result` varchar(255) DEFAULT NULL COMMENT '执行结果',
  `remark` text COMMENT '备注',
  `flow_json` text COMMENT '上传数据',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='隐患工作流记录表';

-- ----------------------------
-- Records of p_latent_danger_flow_record
-- ----------------------------

-- ----------------------------
-- Table structure for p_latent_danger_patrol
-- ----------------------------
DROP TABLE IF EXISTS `p_latent_danger_patrol`;
CREATE TABLE `p_latent_danger_patrol` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `latent_danger_id` bigint(20) DEFAULT NULL COMMENT '隐患编号',
  `point_classify_id` bigint(20) DEFAULT NULL COMMENT '巡检项分类编号',
  `check_id` bigint(20) DEFAULT NULL COMMENT '检查记录编号',
  `item_id` bigint(20) DEFAULT NULL COMMENT '巡检项编号',
  `risk_factor_flow_id` varchar(255) DEFAULT NULL COMMENT '风险因素工作流编号',
  `point_id` bigint(20) DEFAULT NULL COMMENT '巡检点编号',
  `route_id` bigint(20) DEFAULT NULL COMMENT '巡检路线编号',
  `route_point_item_id` bigint(20) DEFAULT NULL COMMENT '路线、点、检查项关联编号',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='隐患巡检关系表';

-- ----------------------------
-- Records of p_latent_danger_patrol
-- ----------------------------

-- ----------------------------
-- Table structure for p_latent_danger_photo
-- ----------------------------
DROP TABLE IF EXISTS `p_latent_danger_photo`;
CREATE TABLE `p_latent_danger_photo` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键自增',
  `biz_code` varchar(255) DEFAULT NULL COMMENT '类型编码',
  `url` varchar(500) DEFAULT NULL COMMENT '图片路径',
  `biz_id` bigint(20) DEFAULT NULL COMMENT '业务编号',
  `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT '是否删除（0：否；1：是）',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '记录创建时间',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '记录修改时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `index_latent_danger_id` (`biz_id`) USING BTREE COMMENT '隐患编号索引'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='隐患图片';

-- ----------------------------
-- Records of p_latent_danger_photo
-- ----------------------------

-- ----------------------------
-- Table structure for p_measures
-- ----------------------------
DROP TABLE IF EXISTS `p_measures`;
CREATE TABLE `p_measures` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '管控措施编号',
  `level` varchar(10) DEFAULT NULL COMMENT '风险等级',
  `accident_type` text COMMENT '事故类型',
  `point_id` bigint(20) DEFAULT NULL COMMENT '风险点id',
  `update_by` varchar(255) DEFAULT NULL COMMENT '更新用户id',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `engineering` text COMMENT '工程措施',
  `management` text COMMENT '管理措施',
  `train` text COMMENT '培训教育',
  `protection` text COMMENT '个体防护',
  `disposal` text COMMENT '应急处置',
  `is_del` int(11) DEFAULT '0' COMMENT '是否删除',
  `risk_factors` text COMMENT '风险因素',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_measures
-- ----------------------------

-- ----------------------------
-- Table structure for p_msg
-- ----------------------------
DROP TABLE IF EXISTS `p_msg`;
CREATE TABLE `p_msg` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '公司orgCode',
  `title` varchar(255) NOT NULL COMMENT '消息标题',
  `body` text NOT NULL COMMENT '内容',
  `msg_type` varchar(255) NOT NULL COMMENT '消息类型',
  `status` int(4) DEFAULT NULL COMMENT '发送状态',
  `send_time` datetime DEFAULT NULL COMMENT '发送时间',
  `relation_id` bigint(20) DEFAULT NULL COMMENT '关联id',
  `is_immediately` bit(1) DEFAULT b'1' COMMENT '是否立即发送',
  `fixed_time` datetime DEFAULT NULL COMMENT '定点发送时间',
  `create_by` varchar(255) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_read` bit(1) DEFAULT b'0' COMMENT '是否已读',
  `target_tel` varchar(500) DEFAULT NULL,
  `reciver_name` varchar(255) DEFAULT NULL COMMENT '接受人名称',
  `user_id` varchar(255) DEFAULT NULL COMMENT '接收人id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_msg
-- ----------------------------

-- ----------------------------
-- Table structure for p_msg_subscribe
-- ----------------------------
DROP TABLE IF EXISTS `p_msg_subscribe`;
CREATE TABLE `p_msg_subscribe` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `org_code` varchar(50) NOT NULL COMMENT '公司code',
  `user_id` varchar(255) NOT NULL COMMENT '用户ID',
  `msg_type` varchar(255) NOT NULL COMMENT '消息类型',
  `attribute1` varchar(255) DEFAULT NULL COMMENT '属性1',
  `attribute2` varchar(255) DEFAULT NULL COMMENT '属性2',
  `attribute3` varchar(255) DEFAULT NULL COMMENT '属性3',
  `attribute4` varchar(255) DEFAULT NULL COMMENT '属性4',
  `attribute5` varchar(255) DEFAULT NULL COMMENT '属性5',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_msg_subscribe
-- ----------------------------

-- ----------------------------
-- Table structure for p_plan
-- ----------------------------
DROP TABLE IF EXISTS `p_plan`;
CREATE TABLE `p_plan` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '计划编号',
  `name` varchar(100) NOT NULL COMMENT '计划名称',
  `org_code` varchar(100) NOT NULL COMMENT '公司Id',
  `dept_id` varchar(225) DEFAULT NULL COMMENT '部门id',
  `route_id` bigint(20) NOT NULL COMMENT '路线编号',
  `plan_type` varchar(50) NOT NULL COMMENT '计划类型：1-日，2-周，3-月，4-年',
  `is_fixed_date` varchar(2) NOT NULL COMMENT '是否固定巡检日期：0-否；1-是',
  `in_order` varchar(2) DEFAULT '0' COMMENT '是否必须按照顺序执行：0-否；1-是',
  `plan_begin` date DEFAULT NULL COMMENT '计划开始日期',
  `plan_end` date DEFAULT NULL COMMENT '计划结束日期',
  `day_rate` int(11) DEFAULT NULL COMMENT '每天频率：0-一次；1-多次',
  `day_time` time DEFAULT NULL COMMENT '开始时间（执行频率为一次时，使用）',
  `day_interval` int(11) DEFAULT NULL COMMENT '执行间隔（每天执行频率为多次时使用）',
  `day_interval_unit` varchar(50) DEFAULT NULL COMMENT '执行间隔单位：1-小时，2-分钟，3-秒',
  `day_begin` time DEFAULT NULL COMMENT '开始时间',
  `day_end` time DEFAULT NULL COMMENT '结束时间',
  `execute_interval` int(11) DEFAULT NULL COMMENT '执行间隔',
  `month_type` varchar(50) DEFAULT NULL COMMENT '月执行类型：1-第，2-在',
  `what_day` varchar(50) DEFAULT NULL COMMENT '哪一天',
  `what_week` int(11) DEFAULT NULL COMMENT '第几周',
  `week_day` int(11) DEFAULT NULL COMMENT '周几',
  `duration` int(11) DEFAULT NULL COMMENT '工作时长（分钟）',
  `user_id` varchar(500) DEFAULT NULL COMMENT '用户编号',
  `execute_rate` int(11) DEFAULT NULL COMMENT '执行频率（年计划使用）',
  `week_begin_num` int(11) DEFAULT NULL COMMENT '开始编号',
  `week_end_num` int(11) DEFAULT NULL COMMENT '结束编号',
  `min_space` int(11) DEFAULT NULL COMMENT '最少间隔',
  `is_score` varchar(2) DEFAULT NULL COMMENT '是否评分',
  `score_formula` varchar(512) DEFAULT NULL COMMENT '评分计算公式',
  `status` tinyint(4) DEFAULT '0' COMMENT '状态:0-正常；1-已停用',
  `error` bigint(10) DEFAULT '0' COMMENT '允许误差(分钟)',
  `next_gen_date` date DEFAULT NULL COMMENT '下次任务生成日期',
  `create_by` int(11) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `last_upd_by` int(11) DEFAULT NULL COMMENT '最近更新者',
  `last_upd_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '最近更新时间',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `remark1` varchar(255) DEFAULT NULL COMMENT '备注1',
  `remark2` varchar(255) DEFAULT NULL COMMENT '备注2',
  `first_flag` int(4) DEFAULT '0' COMMENT '初始状态标识：0-首次 1-其他',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
  `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
  `plan_task_id` bigint(20) DEFAULT '0' COMMENT '最新任务id',
  `is_single_execution` bit(1) DEFAULT b'0' COMMENT '是否单人执行:0多人执行；1单人执行',
  `user_dept` text COMMENT '冗余用户部门',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_org_code_route_id` (`org_code`,`route_id`) USING BTREE,
  KEY `idx_is_stop_next_gen_date` (`status`,`next_gen_date`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_plan
-- ----------------------------
INSERT INTO `p_plan` VALUES ('12', 'A0001', '10', null, '10', '1', '1', '0', '2021-04-23', null, '0', '08:00:00', '1', '1', '08:00:00', '18:00:00', '1', '1', '1', '1', '1', '60', '2723602,1893479,1746069', '1', '1', '7', '0', '1', null, '0', '0', '2021-04-30', '2723602', '2021-04-29 22:00:00', null, '2021-04-29 22:00:00', '每1天的08:00执行。将从2021-04-23开始使用计划。', 'A0001', null, '1', '\0', null, '0', '', '2723602@1263370637087387649,1893479@1232939516555915265,1746069@-1');
INSERT INTO `p_plan` VALUES ('13', 'A0001多次', '10', null, '10', '1', '1', '0', '2021-04-23', null, '1', '08:00:00', '5', '2', '14:00:00', '15:00:00', '1', '1', '1', '1', '1', '5', '2210960,2723602,1893479', '1', '1', '7', '0', '1', null, '0', '0', '2021-04-30', '2723602', '2021-04-29 22:00:01', '2723602', '2021-04-29 22:00:01', '每1天在14:00和 15:00之间、每5分钟执行。将从2021-04-23开始使用计划。', 'A0001', null, '1', '\0', null, '0', '', '2210960@1263370637087387649,2723602@1263370637087387649,1893479@1232939516555915265');
INSERT INTO `p_plan` VALUES ('14', 'A0001多人', '10', null, '10', '1', '1', '0', '2021-04-23', null, '1', '08:00:00', '1', '1', '12:00:00', '20:00:00', '1', '1', '1', '1', '1', '60', '2723602,2064235,2083389', '1', '1', '7', '0', '1', null, '0', '0', '2021-04-30', '2723602', '2021-04-29 22:00:01', '2723602', '2021-04-29 22:00:01', '每1天在12:00和 20:00之间、每1小时执行。将从2021-04-23开始使用计划。', '', null, '1', '\0', null, '0', '\0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1');
INSERT INTO `p_plan` VALUES ('15', 'kkk', '10', null, '10', '1', '1', '0', '2021-04-23', null, '0', '08:00:00', '1', '1', '08:00:00', '18:00:00', '1', '1', '1', '1', '1', '720', '2795766', '1', '1', '7', '0', '1', null, '0', '0', '2021-04-30', '2795766', '2021-04-29 22:00:01', '2795766', '2021-04-29 22:00:01', '每1天的08:00执行。将从2021-04-23开始使用计划。', '', null, '1', '\0', null, '0', '', '2795766@1263370637087387649');
INSERT INTO `p_plan` VALUES ('16', '18：52', '10', null, '11', '1', '1', '0', '2021-04-23', '2021-04-24', '0', '08:00:00', '1', '1', '08:00:00', '18:00:00', '1', '1', '1', '1', '1', '60', '1575363,3058148', '1', '1', '7', '0', '1', null, '1', '0', '2021-04-24', '3045899', '2021-04-24 21:59:58', null, '2021-04-24 21:59:58', '每1天的08:00执行。将从2021-04-23到2021-04-24之间使用计划。', '', null, '1', '\0', null, '0', '\0', '1575363@1263370637087387649,3058148@1263370637087387649');
INSERT INTO `p_plan` VALUES ('17', '18：54', '10', null, '11', '1', '0', '0', '2021-04-23', '2021-04-24', '0', '08:00:00', '1', '1', '08:00:00', '18:00:00', '1', '1', '1', '1', '1', '60', '3059845,3058148', '1', '1', '7', '0', '1', null, '1', '0', '2021-04-24', '3045899', '2021-04-24 21:59:58', null, '2021-04-24 21:59:58', '每1天的08:00执行。将从2021-04-23到2021-04-24之间使用计划。', '', null, '1', '\0', null, '0', '', '3059845@1263370637087387649,3058148@1263370637087387649');
INSERT INTO `p_plan` VALUES ('18', '测试多人', '10', null, '12', '1', '1', '0', '2021-04-25', '2021-04-26', '0', '08:00:00', '1', '1', '08:00:00', '18:00:00', '1', '1', '1', '1', '1', '60', '3059845,3058148', '1', '1', '7', '0', '1', null, '1', '0', '2021-04-26', '3045899', '2021-04-26 21:59:53', '3045899', '2021-04-26 21:59:53', '每1天的08:00执行。将从2021-04-25到2021-04-26之间使用计划。', '', null, '1', '\0', null, '0', '\0', '3059845@1263370637087387649,3058148@1263370637087387649');
INSERT INTO `p_plan` VALUES ('19', 'A0506', '10', null, '13', '1', '1', '0', '2021-05-08', '2021-05-09', '1', '08:00:00', '1', '1', '09:00:00', '20:00:00', '1', '1', '1', '1', '1', '60', '2723602', '1', '1', '7', '0', '1', null, '0', '0', '2021-05-09', '2723602', '2021-05-08 21:59:54', '2723602', '2021-05-08 21:59:54', '每1天在09:00和 20:00之间、每1小时执行。将从2021-05-08到2021-05-09之间使用计划。', '测试', null, '1', '\0', null, '0', '', '2723602@1263370637087387649');

-- ----------------------------
-- Table structure for p_plan_exec_statistics
-- ----------------------------
DROP TABLE IF EXISTS `p_plan_exec_statistics`;
CREATE TABLE `p_plan_exec_statistics` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `check_time` varchar(40) NOT NULL COMMENT '巡检日期',
  `org_code` varchar(255) NOT NULL COMMENT '计划任务执行人orgCode',
  `user_id` varchar(50) NOT NULL COMMENT '用户ID',
  `plan_task_num` int(11) DEFAULT NULL COMMENT '计划执行个数',
  `exec_plan_task_num` int(11) DEFAULT '0' COMMENT '计划执行完成个数',
  `missed_check_num` int(11) DEFAULT '0' COMMENT '漏检个数',
  `outside_plan_num` int(11) DEFAULT '0' COMMENT '计划外执行个数',
  PRIMARY KEY (`id`,`org_code`,`user_id`,`check_time`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of p_plan_exec_statistics
-- ----------------------------

-- ----------------------------
-- Table structure for p_plan_task
-- ----------------------------
DROP TABLE IF EXISTS `p_plan_task`;
CREATE TABLE `p_plan_task` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '批次号',
  `batch_no` bigint(20) NOT NULL COMMENT '计划批次号',
  `org_code` varchar(255) DEFAULT NULL COMMENT '计划任务执行人orgCode',
  `plan_id` bigint(20) NOT NULL COMMENT '计划编号',
  `route_id` bigint(20) DEFAULT NULL COMMENT '路线编号',
  `user_id` varchar(500) DEFAULT NULL COMMENT '用户编号',
  `point_num` int(11) DEFAULT NULL COMMENT '巡检点数',
  `finish_num` int(11) DEFAULT '0' COMMENT '已完成巡检点数',
  `check_date` date DEFAULT NULL COMMENT '巡检日期',
  `begin_time` datetime DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '结束时间',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `finish_status` int(4) DEFAULT '0' COMMENT '完成状态：0-未开始；1-进行中;2-已结束；3-已超时',
  `status` int(4) DEFAULT '0' COMMENT '状态：0-有效；1-无效',
  `in_order` varchar(2) DEFAULT '0' COMMENT '是否必须按照顺序执行：0-否；1-是',
  `user_dept` varchar(255) DEFAULT NULL COMMENT '人员部门信息',
  `user_name` varchar(255) DEFAULT NULL COMMENT '用户姓名',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `plan_id` (`plan_id`) USING BTREE,
  KEY `begin_time` (`begin_time`) USING BTREE,
  KEY `end_time` (`end_time`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2330 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_plan_task
-- ----------------------------
INSERT INTO `p_plan_task` VALUES ('1656', '1619146983486', '10-42', '12', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 08:00:00', '2021-04-23 09:00:00', '2021-04-23 11:03:04', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5,卢阳,王海');
INSERT INTO `p_plan_task` VALUES ('1657', '1619146983486', '10-14', '12', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 08:00:00', '2021-04-23 09:00:00', '2021-04-23 11:03:07', '3', '0', '0', '1893479@1232939516555915265', '吴俊凯5,卢阳,王海');
INSERT INTO `p_plan_task` VALUES ('1658', '1619146983486', '10', '12', '10', '1746069', '1', '0', '2021-04-23', '2021-04-23 08:00:00', '2021-04-23 09:00:00', '2021-04-23 11:03:08', '3', '0', '0', '1746069@-1', '吴俊凯5,卢阳,王海');
INSERT INTO `p_plan_task` VALUES ('1802', '1619149513261', '10-42', '15', '10', '2795766', '1', '0', '2021-04-23', '2021-04-23 08:00:00', '2021-04-23 20:00:00', '2021-04-23 11:45:14', '1', '0', '0', '2795766@1263370637087387649', '田涛');
INSERT INTO `p_plan_task` VALUES ('1843', '1619173045185', '10-42', '0', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 08:00:00', '2021-04-23 09:00:00', '2021-04-23 18:17:26', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1844', '1619173045185', '10-42', '0', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 08:00:00', '2021-04-23 09:00:00', '2021-04-23 18:17:26', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1845', '1619173045185', '10-14', '0', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 08:00:00', '2021-04-23 09:00:00', '2021-04-23 18:17:26', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1846', '1619173045185', '10-42', '0', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 09:00:00', '2021-04-23 10:00:00', '2021-04-23 18:17:27', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1847', '1619173045185', '10-42', '0', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 09:00:00', '2021-04-23 10:00:00', '2021-04-23 18:17:27', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1848', '1619173045185', '10-14', '0', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 09:00:00', '2021-04-23 10:00:00', '2021-04-23 18:17:28', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1849', '1619173045185', '10-42', '0', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 10:00:00', '2021-04-23 11:00:00', '2021-04-23 18:17:28', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1850', '1619173045185', '10-42', '0', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 10:00:00', '2021-04-23 11:00:00', '2021-04-23 18:17:28', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1851', '1619173045185', '10-14', '0', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 10:00:00', '2021-04-23 11:00:00', '2021-04-23 18:17:28', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1852', '1619173045185', '10-42', '0', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 11:00:00', '2021-04-23 12:00:00', '2021-04-23 18:17:29', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1853', '1619173045185', '10-42', '0', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 11:00:00', '2021-04-23 12:00:00', '2021-04-23 18:17:30', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1854', '1619173045185', '10-14', '0', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 11:00:00', '2021-04-23 12:00:00', '2021-04-23 18:17:30', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1855', '1619173045185', '10-42', '0', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 12:00:00', '2021-04-23 13:00:00', '2021-04-23 18:17:30', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1856', '1619173045185', '10-42', '0', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 12:00:00', '2021-04-23 13:00:00', '2021-04-23 18:17:31', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1857', '1619173045185', '10-14', '0', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 12:00:00', '2021-04-23 13:00:00', '2021-04-23 18:17:31', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1858', '1619173045185', '10-42', '0', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 13:00:00', '2021-04-23 14:00:00', '2021-04-23 18:17:31', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1859', '1619173045185', '10-42', '0', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 13:00:00', '2021-04-23 14:00:00', '2021-04-23 18:17:32', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1860', '1619173045185', '10-14', '0', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 13:00:00', '2021-04-23 14:00:00', '2021-04-23 18:17:32', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1861', '1619173045185', '10-42', '0', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 14:00:00', '2021-04-23 15:00:00', '2021-04-23 18:17:33', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1862', '1619173045185', '10-42', '0', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 14:00:00', '2021-04-23 15:00:00', '2021-04-23 18:17:34', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1863', '1619173045185', '10-14', '0', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 14:00:00', '2021-04-23 15:00:00', '2021-04-23 18:17:34', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1864', '1619173045185', '10-42', '0', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 15:00:00', '2021-04-23 16:00:00', '2021-04-23 18:17:35', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1865', '1619173045185', '10-42', '0', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 15:00:00', '2021-04-23 16:00:00', '2021-04-23 18:17:36', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1866', '1619173045185', '10-14', '0', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 15:00:00', '2021-04-23 16:00:00', '2021-04-23 18:17:37', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1867', '1619173045185', '10-42', '0', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 16:00:00', '2021-04-23 17:00:00', '2021-04-23 18:17:38', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1868', '1619173045185', '10-42', '0', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 16:00:00', '2021-04-23 17:00:00', '2021-04-23 18:17:39', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1869', '1619173045185', '10-14', '0', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 16:00:00', '2021-04-23 17:00:00', '2021-04-23 18:17:39', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1870', '1619173045185', '10-42', '0', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 17:00:00', '2021-04-23 18:00:00', '2021-04-23 18:17:39', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1871', '1619173045185', '10-42', '0', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 17:00:00', '2021-04-23 18:00:00', '2021-04-23 18:17:40', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1872', '1619173045185', '10-14', '0', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 17:00:00', '2021-04-23 18:00:00', '2021-04-23 18:17:41', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1873', '1619174086046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 08:00:00', '2021-04-23 09:00:00', '2021-04-23 18:34:50', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1874', '1619174086046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 08:00:00', '2021-04-23 09:00:00', '2021-04-23 18:34:53', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1875', '1619174086046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 08:00:00', '2021-04-23 09:00:00', '2021-04-23 18:34:53', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1876', '1619174086046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 09:00:00', '2021-04-23 10:00:00', '2021-04-23 18:34:55', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1877', '1619174086046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 09:00:00', '2021-04-23 10:00:00', '2021-04-23 18:34:55', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1878', '1619174086046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 09:00:00', '2021-04-23 10:00:00', '2021-04-23 18:34:55', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1879', '1619174086046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 10:00:00', '2021-04-23 11:00:00', '2021-04-23 18:34:56', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1880', '1619174086046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 10:00:00', '2021-04-23 11:00:00', '2021-04-23 18:34:56', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1881', '1619174086046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 10:00:00', '2021-04-23 11:00:00', '2021-04-23 18:34:56', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1882', '1619174086046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 11:00:00', '2021-04-23 12:00:00', '2021-04-23 18:34:57', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1883', '1619174086046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 11:00:00', '2021-04-23 12:00:00', '2021-04-23 18:34:57', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1884', '1619174086046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 11:00:00', '2021-04-23 12:00:00', '2021-04-23 18:34:57', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1885', '1619174086046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 12:00:00', '2021-04-23 13:00:00', '2021-04-23 18:34:58', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1886', '1619174086046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 12:00:00', '2021-04-23 13:00:00', '2021-04-23 18:34:58', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1887', '1619174086046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 12:00:00', '2021-04-23 13:00:00', '2021-04-23 18:34:59', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1888', '1619174086046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 13:00:00', '2021-04-23 14:00:00', '2021-04-23 18:35:00', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1889', '1619174086046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 13:00:00', '2021-04-23 14:00:00', '2021-04-23 18:35:00', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1890', '1619174086046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 13:00:00', '2021-04-23 14:00:00', '2021-04-23 18:35:00', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1891', '1619174086046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 14:00:00', '2021-04-23 15:00:00', '2021-04-23 18:35:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1892', '1619174086046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 14:00:00', '2021-04-23 15:00:00', '2021-04-23 18:35:02', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1893', '1619174086046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 14:00:00', '2021-04-23 15:00:00', '2021-04-23 18:35:02', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1894', '1619174086046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 15:00:00', '2021-04-23 16:00:00', '2021-04-23 18:35:03', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1895', '1619174086046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 15:00:00', '2021-04-23 16:00:00', '2021-04-23 18:35:03', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1896', '1619174086046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 15:00:00', '2021-04-23 16:00:00', '2021-04-23 18:35:03', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1897', '1619174086046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 16:00:00', '2021-04-23 17:00:00', '2021-04-23 18:35:04', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1898', '1619174086046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 16:00:00', '2021-04-23 17:00:00', '2021-04-23 18:35:05', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1899', '1619174086046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 16:00:00', '2021-04-23 17:00:00', '2021-04-23 18:35:06', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1900', '1619174086046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-23', '2021-04-23 17:00:00', '2021-04-23 18:00:00', '2021-04-23 18:35:07', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1901', '1619174086046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-23', '2021-04-23 17:00:00', '2021-04-23 18:00:00', '2021-04-23 18:35:08', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1902', '1619174086046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-23', '2021-04-23 17:00:00', '2021-04-23 18:00:00', '2021-04-23 18:35:08', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1913', '1619174370010', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-23', '2021-04-23 12:00:00', '2021-04-23 13:00:00', '2021-04-23 18:39:35', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1914', '1619174370010', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-23', '2021-04-23 13:00:00', '2021-04-23 14:00:00', '2021-04-23 18:39:36', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1915', '1619174370010', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-23', '2021-04-23 14:00:00', '2021-04-23 15:00:00', '2021-04-23 18:39:37', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1916', '1619174370010', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-23', '2021-04-23 15:00:00', '2021-04-23 16:00:00', '2021-04-23 18:39:38', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1917', '1619174370010', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-23', '2021-04-23 16:00:00', '2021-04-23 17:00:00', '2021-04-23 18:39:39', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1918', '1619174370010', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-23', '2021-04-23 17:00:00', '2021-04-23 18:00:00', '2021-04-23 18:39:40', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1919', '1619174370010', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-23', '2021-04-23 18:00:00', '2021-04-23 19:00:00', '2021-04-23 18:39:41', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1920', '1619174370010', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-23', '2021-04-23 19:00:00', '2021-04-23 20:00:00', '2021-04-23 18:39:41', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1921', '1619186400046', '10-42', '12', '10', '2723602', '1', '0', '2021-04-24', '2021-04-24 08:00:00', '2021-04-24 09:00:00', '2021-04-23 22:00:01', '1', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1922', '1619186400046', '10-14', '12', '10', '1893479', '1', '0', '2021-04-24', '2021-04-24 08:00:00', '2021-04-24 09:00:00', '2021-04-23 22:00:01', '1', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1923', '1619186400046', null, '12', '10', '1746069', '1', '0', '2021-04-24', '2021-04-24 08:00:00', '2021-04-24 09:00:00', '2021-04-23 22:00:01', '1', '0', '0', '1746069@-1', '王海涛');
INSERT INTO `p_plan_task` VALUES ('1924', '1619186400046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-24', '2021-04-24 08:00:00', '2021-04-24 09:00:00', '2021-04-23 22:00:01', '1', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1925', '1619186400046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-24', '2021-04-24 08:00:00', '2021-04-24 09:00:00', '2021-04-23 22:00:01', '1', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1926', '1619186400046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-24', '2021-04-24 08:00:00', '2021-04-24 09:00:00', '2021-04-23 22:00:01', '1', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1927', '1619186400046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-24', '2021-04-24 09:00:00', '2021-04-24 10:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1928', '1619186400046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-24', '2021-04-24 09:00:00', '2021-04-24 10:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1929', '1619186400046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-24', '2021-04-24 09:00:00', '2021-04-24 10:00:00', '2021-04-23 22:00:01', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1930', '1619186400046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-24', '2021-04-24 10:00:00', '2021-04-24 11:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1931', '1619186400046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-24', '2021-04-24 10:00:00', '2021-04-24 11:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1932', '1619186400046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-24', '2021-04-24 10:00:00', '2021-04-24 11:00:00', '2021-04-23 22:00:01', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1933', '1619186400046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-24', '2021-04-24 11:00:00', '2021-04-24 12:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1934', '1619186400046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-24', '2021-04-24 11:00:00', '2021-04-24 12:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1935', '1619186400046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-24', '2021-04-24 11:00:00', '2021-04-24 12:00:00', '2021-04-23 22:00:01', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1936', '1619186400046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-24', '2021-04-24 12:00:00', '2021-04-24 13:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1937', '1619186400046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-24', '2021-04-24 12:00:00', '2021-04-24 13:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1938', '1619186400046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-24', '2021-04-24 12:00:00', '2021-04-24 13:00:00', '2021-04-23 22:00:01', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1939', '1619186400046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-24', '2021-04-24 13:00:00', '2021-04-24 14:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1940', '1619186400046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-24', '2021-04-24 13:00:00', '2021-04-24 14:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1941', '1619186400046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-24', '2021-04-24 13:00:00', '2021-04-24 14:00:00', '2021-04-23 22:00:01', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1942', '1619186400046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-24', '2021-04-24 14:00:00', '2021-04-24 15:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1943', '1619186400046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-24', '2021-04-24 14:00:00', '2021-04-24 15:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1944', '1619186400046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-24', '2021-04-24 14:00:00', '2021-04-24 15:00:00', '2021-04-23 22:00:01', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1945', '1619186400046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-24', '2021-04-24 15:00:00', '2021-04-24 16:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1946', '1619186400046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-24', '2021-04-24 15:00:00', '2021-04-24 16:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1947', '1619186400046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-24', '2021-04-24 15:00:00', '2021-04-24 16:00:00', '2021-04-23 22:00:01', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1948', '1619186400046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-24', '2021-04-24 16:00:00', '2021-04-24 17:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1949', '1619186400046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-24', '2021-04-24 16:00:00', '2021-04-24 17:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1950', '1619186400046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-24', '2021-04-24 16:00:00', '2021-04-24 17:00:00', '2021-04-23 22:00:01', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1951', '1619186400046', '10-42', '13', '10', '2210960', '1', '0', '2021-04-24', '2021-04-24 17:00:00', '2021-04-24 18:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1952', '1619186400046', '10-42', '13', '10', '2723602', '1', '0', '2021-04-24', '2021-04-24 17:00:00', '2021-04-24 18:00:00', '2021-04-23 22:00:01', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1953', '1619186400046', '10-14', '13', '10', '1893479', '1', '0', '2021-04-24', '2021-04-24 17:00:00', '2021-04-24 18:00:00', '2021-04-23 22:00:01', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1954', '1619186400046', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-24', '2021-04-24 12:00:00', '2021-04-24 13:00:00', '2021-04-23 22:00:02', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1955', '1619186400046', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-24', '2021-04-24 13:00:00', '2021-04-24 14:00:00', '2021-04-23 22:00:02', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1956', '1619186400046', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-24', '2021-04-24 14:00:00', '2021-04-24 15:00:00', '2021-04-23 22:00:02', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1957', '1619186400046', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-24', '2021-04-24 15:00:00', '2021-04-24 16:00:00', '2021-04-23 22:00:02', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1958', '1619186400046', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-24', '2021-04-24 16:00:00', '2021-04-24 17:00:00', '2021-04-23 22:00:02', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1959', '1619186400046', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-24', '2021-04-24 17:00:00', '2021-04-24 18:00:00', '2021-04-23 22:00:02', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1960', '1619186400046', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-24', '2021-04-24 18:00:00', '2021-04-24 19:00:00', '2021-04-23 22:00:02', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1961', '1619186400046', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-24', '2021-04-24 19:00:00', '2021-04-24 20:00:00', '2021-04-23 22:00:02', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('1962', '1619186400046', '10-42', '15', '10', '2795766', '1', '0', '2021-04-24', '2021-04-24 08:00:00', '2021-04-24 20:00:00', '2021-04-23 22:00:02', '3', '0', '0', '2795766@1263370637087387649', '田涛');
INSERT INTO `p_plan_task` VALUES ('1963', '1619186400046', '10-42', '16', '11', '1575363,3058148', '1', '0', '2021-04-24', '2021-04-24 08:00:00', '2021-04-24 09:00:00', '2021-04-23 22:00:02', '1', '0', '0', '1575363@1263370637087387649,3058148@1263370637087387649', 'tw6,xxz');
INSERT INTO `p_plan_task` VALUES ('1964', '1619186400046', '10-42', '17', '11', '3059845', '1', '0', '2021-04-24', '2021-04-24 08:00:00', '2021-04-24 09:00:00', '2021-04-23 22:00:03', '1', '0', '0', '3059845@1263370637087387649', 'xxz2');
INSERT INTO `p_plan_task` VALUES ('1965', '1619186400046', '10-42', '17', '11', '3058148', '1', '0', '2021-04-24', '2021-04-24 08:00:00', '2021-04-24 09:00:00', '2021-04-23 22:00:03', '1', '0', '0', '3058148@1263370637087387649', 'xxz');
INSERT INTO `p_plan_task` VALUES ('1966', '1619272801664', '10-42', '12', '10', '2723602', '1', '0', '2021-04-25', '2021-04-25 08:00:00', '2021-04-25 09:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1967', '1619272801664', '10-14', '12', '10', '1893479', '1', '0', '2021-04-25', '2021-04-25 08:00:00', '2021-04-25 09:00:00', '2021-04-24 22:00:02', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1968', '1619272801664', null, '12', '10', '1746069', '1', '0', '2021-04-25', '2021-04-25 08:00:00', '2021-04-25 09:00:00', '2021-04-24 22:00:02', '1', '0', '0', '1746069@-1', '王海涛');
INSERT INTO `p_plan_task` VALUES ('1969', '1619272801664', '10-42', '13', '10', '2210960', '1', '0', '2021-04-25', '2021-04-25 08:00:00', '2021-04-25 09:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1970', '1619272801664', '10-42', '13', '10', '2723602', '1', '0', '2021-04-25', '2021-04-25 08:00:00', '2021-04-25 09:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1971', '1619272801664', '10-14', '13', '10', '1893479', '1', '0', '2021-04-25', '2021-04-25 08:00:00', '2021-04-25 09:00:00', '2021-04-24 22:00:02', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1972', '1619272801664', '10-42', '13', '10', '2210960', '1', '0', '2021-04-25', '2021-04-25 09:00:00', '2021-04-25 10:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1973', '1619272801664', '10-42', '13', '10', '2723602', '1', '0', '2021-04-25', '2021-04-25 09:00:00', '2021-04-25 10:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1974', '1619272801664', '10-14', '13', '10', '1893479', '1', '0', '2021-04-25', '2021-04-25 09:00:00', '2021-04-25 10:00:00', '2021-04-24 22:00:02', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1975', '1619272801664', '10-42', '13', '10', '2210960', '1', '0', '2021-04-25', '2021-04-25 10:00:00', '2021-04-25 11:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1976', '1619272801664', '10-42', '13', '10', '2723602', '1', '1', '2021-04-25', '2021-04-25 10:00:00', '2021-04-25 11:00:00', '2021-04-25 10:12:48', '2', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1977', '1619272801664', '10-14', '13', '10', '1893479', '1', '0', '2021-04-25', '2021-04-25 10:00:00', '2021-04-25 11:00:00', '2021-04-24 22:00:02', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1978', '1619272801664', '10-42', '13', '10', '2210960', '1', '0', '2021-04-25', '2021-04-25 11:00:00', '2021-04-25 12:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1979', '1619272801664', '10-42', '13', '10', '2723602', '1', '0', '2021-04-25', '2021-04-25 11:00:00', '2021-04-25 12:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1980', '1619272801664', '10-14', '13', '10', '1893479', '1', '0', '2021-04-25', '2021-04-25 11:00:00', '2021-04-25 12:00:00', '2021-04-24 22:00:02', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1981', '1619272801664', '10-42', '13', '10', '2210960', '1', '0', '2021-04-25', '2021-04-25 12:00:00', '2021-04-25 13:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1982', '1619272801664', '10-42', '13', '10', '2723602', '1', '0', '2021-04-25', '2021-04-25 12:00:00', '2021-04-25 13:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1983', '1619272801664', '10-14', '13', '10', '1893479', '1', '0', '2021-04-25', '2021-04-25 12:00:00', '2021-04-25 13:00:00', '2021-04-24 22:00:02', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1984', '1619272801664', '10-42', '13', '10', '2210960', '1', '0', '2021-04-25', '2021-04-25 13:00:00', '2021-04-25 14:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1985', '1619272801664', '10-42', '13', '10', '2723602', '1', '0', '2021-04-25', '2021-04-25 13:00:00', '2021-04-25 14:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1986', '1619272801664', '10-14', '13', '10', '1893479', '1', '0', '2021-04-25', '2021-04-25 13:00:00', '2021-04-25 14:00:00', '2021-04-24 22:00:02', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1987', '1619272801664', '10-42', '13', '10', '2210960', '1', '0', '2021-04-25', '2021-04-25 14:00:00', '2021-04-25 15:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1988', '1619272801664', '10-42', '13', '10', '2723602', '1', '0', '2021-04-25', '2021-04-25 14:00:00', '2021-04-25 15:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1989', '1619272801664', '10-14', '13', '10', '1893479', '1', '0', '2021-04-25', '2021-04-25 14:00:00', '2021-04-25 15:00:00', '2021-04-24 22:00:02', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1990', '1619272801664', '10-42', '13', '10', '2210960', '1', '0', '2021-04-25', '2021-04-25 15:00:00', '2021-04-25 16:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1991', '1619272801664', '10-42', '13', '10', '2723602', '1', '0', '2021-04-25', '2021-04-25 15:00:00', '2021-04-25 16:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1992', '1619272801664', '10-14', '13', '10', '1893479', '1', '0', '2021-04-25', '2021-04-25 15:00:00', '2021-04-25 16:00:00', '2021-04-24 22:00:02', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1993', '1619272801664', '10-42', '13', '10', '2210960', '1', '0', '2021-04-25', '2021-04-25 16:00:00', '2021-04-25 17:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1994', '1619272801664', '10-42', '13', '10', '2723602', '1', '0', '2021-04-25', '2021-04-25 16:00:00', '2021-04-25 17:00:00', '2021-04-24 22:00:02', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1995', '1619272801664', '10-14', '13', '10', '1893479', '1', '0', '2021-04-25', '2021-04-25 16:00:00', '2021-04-25 17:00:00', '2021-04-24 22:00:03', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1996', '1619272801664', '10-42', '13', '10', '2210960', '1', '0', '2021-04-25', '2021-04-25 17:00:00', '2021-04-25 18:00:00', '2021-04-24 22:00:03', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('1997', '1619272801664', '10-42', '13', '10', '2723602', '1', '0', '2021-04-25', '2021-04-25 17:00:00', '2021-04-25 18:00:00', '2021-04-24 22:00:03', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('1998', '1619272801664', '10-14', '13', '10', '1893479', '1', '0', '2021-04-25', '2021-04-25 17:00:00', '2021-04-25 18:00:00', '2021-04-24 22:00:03', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('1999', '1619272801664', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-25', '2021-04-25 12:00:00', '2021-04-25 13:00:00', '2021-04-24 22:00:03', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2000', '1619272801664', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-25', '2021-04-25 13:00:00', '2021-04-25 14:00:00', '2021-04-24 22:00:03', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2001', '1619272801664', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-25', '2021-04-25 14:00:00', '2021-04-25 15:00:00', '2021-04-24 22:00:03', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2002', '1619272801664', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-25', '2021-04-25 15:00:00', '2021-04-25 16:00:00', '2021-04-24 22:00:03', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2003', '1619272801664', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-25', '2021-04-25 16:00:00', '2021-04-25 17:00:00', '2021-04-24 22:00:03', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2004', '1619272801664', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-25', '2021-04-25 17:00:00', '2021-04-25 18:00:00', '2021-04-24 22:00:03', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2005', '1619272801664', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-25', '2021-04-25 18:00:00', '2021-04-25 19:00:00', '2021-04-24 22:00:03', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2006', '1619272801664', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-25', '2021-04-25 19:00:00', '2021-04-25 20:00:00', '2021-04-24 22:00:03', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2007', '1619272801664', '10-42', '15', '10', '2795766', '1', '0', '2021-04-25', '2021-04-25 08:00:00', '2021-04-25 20:00:00', '2021-04-24 22:00:03', '3', '0', '0', '2795766@1263370637087387649', '田涛');
INSERT INTO `p_plan_task` VALUES ('2008', '1619359200021', '10-42', '12', '10', '2723602', '1', '0', '2021-04-26', '2021-04-26 08:00:00', '2021-04-26 09:00:00', '2021-04-25 22:00:00', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2009', '1619359200021', '10-14', '12', '10', '1893479', '1', '0', '2021-04-26', '2021-04-26 08:00:00', '2021-04-26 09:00:00', '2021-04-25 22:00:00', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2010', '1619359200021', null, '12', '10', '1746069', '1', '0', '2021-04-26', '2021-04-26 08:00:00', '2021-04-26 09:00:00', '2021-04-25 22:00:00', '1', '0', '0', '1746069@-1', '王海涛');
INSERT INTO `p_plan_task` VALUES ('2011', '1619359200021', '10-42', '13', '10', '2210960', '1', '0', '2021-04-26', '2021-04-26 08:00:00', '2021-04-26 09:00:00', '2021-04-25 22:00:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2012', '1619359200021', '10-42', '13', '10', '2723602', '1', '0', '2021-04-26', '2021-04-26 08:00:00', '2021-04-26 09:00:00', '2021-04-25 22:00:01', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2013', '1619359200021', '10-14', '13', '10', '1893479', '1', '0', '2021-04-26', '2021-04-26 08:00:00', '2021-04-26 09:00:00', '2021-04-25 22:00:01', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2014', '1619359200021', '10-42', '13', '10', '2210960', '1', '0', '2021-04-26', '2021-04-26 09:00:00', '2021-04-26 10:00:00', '2021-04-25 22:00:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2015', '1619359200021', '10-42', '13', '10', '2723602', '1', '0', '2021-04-26', '2021-04-26 09:00:00', '2021-04-26 10:00:00', '2021-04-25 22:00:01', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2016', '1619359200021', '10-14', '13', '10', '1893479', '1', '0', '2021-04-26', '2021-04-26 09:00:00', '2021-04-26 10:00:00', '2021-04-25 22:00:01', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2017', '1619359200021', '10-42', '13', '10', '2210960', '1', '0', '2021-04-26', '2021-04-26 10:00:00', '2021-04-26 11:00:00', '2021-04-25 22:00:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2018', '1619359200021', '10-42', '13', '10', '2723602', '1', '0', '2021-04-26', '2021-04-26 10:00:00', '2021-04-26 11:00:00', '2021-04-25 22:00:01', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2019', '1619359200021', '10-14', '13', '10', '1893479', '1', '0', '2021-04-26', '2021-04-26 10:00:00', '2021-04-26 11:00:00', '2021-04-25 22:00:01', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2020', '1619359200021', '10-42', '13', '10', '2210960', '1', '0', '2021-04-26', '2021-04-26 11:00:00', '2021-04-26 12:00:00', '2021-04-25 22:00:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2021', '1619359200021', '10-42', '13', '10', '2723602', '1', '0', '2021-04-26', '2021-04-26 11:00:00', '2021-04-26 12:00:00', '2021-04-25 22:00:01', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2022', '1619359200021', '10-14', '13', '10', '1893479', '1', '0', '2021-04-26', '2021-04-26 11:00:00', '2021-04-26 12:00:00', '2021-04-25 22:00:01', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2023', '1619359200021', '10-42', '13', '10', '2210960', '1', '0', '2021-04-26', '2021-04-26 12:00:00', '2021-04-26 13:00:00', '2021-04-25 22:00:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2024', '1619359200021', '10-42', '13', '10', '2723602', '1', '0', '2021-04-26', '2021-04-26 12:00:00', '2021-04-26 13:00:00', '2021-04-25 22:00:01', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2025', '1619359200021', '10-14', '13', '10', '1893479', '1', '0', '2021-04-26', '2021-04-26 12:00:00', '2021-04-26 13:00:00', '2021-04-25 22:00:01', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2026', '1619359200021', '10-42', '13', '10', '2210960', '1', '0', '2021-04-26', '2021-04-26 13:00:00', '2021-04-26 14:00:00', '2021-04-25 22:00:01', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2027', '1619359200021', '10-42', '13', '10', '2723602', '1', '0', '2021-04-26', '2021-04-26 13:00:00', '2021-04-26 14:00:00', '2021-04-25 22:00:01', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2028', '1619359200021', '10-14', '13', '10', '1893479', '1', '0', '2021-04-26', '2021-04-26 13:00:00', '2021-04-26 14:00:00', '2021-04-25 22:00:01', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2029', '1619359200021', '10-42', '13', '10', '2210960', '1', '0', '2021-04-26', '2021-04-26 14:00:00', '2021-04-26 15:00:00', '2021-04-25 22:00:01', '1', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2030', '1619359200021', '10-42', '13', '10', '2723602', '1', '0', '2021-04-26', '2021-04-26 14:00:00', '2021-04-26 15:00:00', '2021-04-25 22:00:01', '1', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2031', '1619359200021', '10-14', '13', '10', '1893479', '1', '0', '2021-04-26', '2021-04-26 14:00:00', '2021-04-26 15:00:00', '2021-04-25 22:00:01', '1', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2032', '1619359200021', '10-42', '13', '10', '2210960', '1', '0', '2021-04-26', '2021-04-26 15:00:00', '2021-04-26 16:00:00', '2021-04-25 22:00:01', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2033', '1619359200021', '10-42', '13', '10', '2723602', '1', '0', '2021-04-26', '2021-04-26 15:00:00', '2021-04-26 16:00:00', '2021-04-25 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2034', '1619359200021', '10-14', '13', '10', '1893479', '1', '0', '2021-04-26', '2021-04-26 15:00:00', '2021-04-26 16:00:00', '2021-04-25 22:00:01', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2035', '1619359200021', '10-42', '13', '10', '2210960', '1', '0', '2021-04-26', '2021-04-26 16:00:00', '2021-04-26 17:00:00', '2021-04-25 22:00:01', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2036', '1619359200021', '10-42', '13', '10', '2723602', '1', '0', '2021-04-26', '2021-04-26 16:00:00', '2021-04-26 17:00:00', '2021-04-25 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2037', '1619359200021', '10-14', '13', '10', '1893479', '1', '0', '2021-04-26', '2021-04-26 16:00:00', '2021-04-26 17:00:00', '2021-04-25 22:00:01', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2038', '1619359200021', '10-42', '13', '10', '2210960', '1', '0', '2021-04-26', '2021-04-26 17:00:00', '2021-04-26 18:00:00', '2021-04-25 22:00:01', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2039', '1619359200021', '10-42', '13', '10', '2723602', '1', '0', '2021-04-26', '2021-04-26 17:00:00', '2021-04-26 18:00:00', '2021-04-25 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2040', '1619359200021', '10-14', '13', '10', '1893479', '1', '0', '2021-04-26', '2021-04-26 17:00:00', '2021-04-26 18:00:00', '2021-04-25 22:00:01', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2041', '1619359200021', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-26', '2021-04-26 12:00:00', '2021-04-26 13:00:00', '2021-04-25 22:00:02', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2042', '1619359200021', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-26', '2021-04-26 13:00:00', '2021-04-26 14:00:00', '2021-04-25 22:00:02', '3', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2043', '1619359200021', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-26', '2021-04-26 14:00:00', '2021-04-26 15:00:00', '2021-04-25 22:00:02', '1', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2044', '1619359200021', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-26', '2021-04-26 15:00:00', '2021-04-26 16:00:00', '2021-04-25 22:00:02', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2045', '1619359200021', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-26', '2021-04-26 16:00:00', '2021-04-26 17:00:00', '2021-04-25 22:00:02', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2046', '1619359200021', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-26', '2021-04-26 17:00:00', '2021-04-26 18:00:00', '2021-04-25 22:00:02', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2047', '1619359200021', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-26', '2021-04-26 18:00:00', '2021-04-26 19:00:00', '2021-04-25 22:00:02', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2048', '1619359200021', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '1', '0', '2021-04-26', '2021-04-26 19:00:00', '2021-04-26 20:00:00', '2021-04-25 22:00:02', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2049', '1619359200021', '10-42', '15', '10', '2795766', '1', '0', '2021-04-26', '2021-04-26 08:00:00', '2021-04-26 20:00:00', '2021-04-25 22:00:02', '1', '0', '0', '2795766@1263370637087387649', '田涛');
INSERT INTO `p_plan_task` VALUES ('2050', '1619359200021', '10-42', '18', '12', '3059845,3058148', '1', '0', '2021-04-26', '2021-04-26 08:00:00', '2021-04-26 09:00:00', '2021-04-25 22:00:03', '3', '0', '0', '3059845@1263370637087387649,3058148@1263370637087387649', 'xxz2,xxz');
INSERT INTO `p_plan_task` VALUES ('2051', '1619445600032', '10-42', '12', '10', '2723602', '2', '0', '2021-04-27', '2021-04-27 08:00:00', '2021-04-27 09:00:00', '2021-04-26 22:00:00', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2052', '1619445600032', '10-14', '12', '10', '1893479', '2', '0', '2021-04-27', '2021-04-27 08:00:00', '2021-04-27 09:00:00', '2021-04-26 22:00:00', '1', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2053', '1619445600032', null, '12', '10', '1746069', '2', '0', '2021-04-27', '2021-04-27 08:00:00', '2021-04-27 09:00:00', '2021-04-26 22:00:00', '1', '0', '0', '1746069@-1', '王海涛');
INSERT INTO `p_plan_task` VALUES ('2084', '1619445600032', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-27', '2021-04-27 12:00:00', '2021-04-27 13:00:00', '2021-04-26 22:00:01', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2085', '1619445600032', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-27', '2021-04-27 13:00:00', '2021-04-27 14:00:00', '2021-04-26 22:00:01', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2086', '1619445600032', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-27', '2021-04-27 14:00:00', '2021-04-27 15:00:00', '2021-04-26 22:00:01', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2087', '1619445600032', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-27', '2021-04-27 15:00:00', '2021-04-27 16:00:00', '2021-04-26 22:00:01', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2088', '1619445600032', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-27', '2021-04-27 16:00:00', '2021-04-27 17:00:00', '2021-04-26 22:00:01', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2089', '1619445600032', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-27', '2021-04-27 17:00:00', '2021-04-27 18:00:00', '2021-04-26 22:00:01', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2090', '1619445600032', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-27', '2021-04-27 18:00:00', '2021-04-27 19:00:00', '2021-04-26 22:00:01', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2091', '1619445600032', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-27', '2021-04-27 19:00:00', '2021-04-27 20:00:00', '2021-04-26 22:00:01', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2092', '1619445600032', '10-42', '15', '10', '2795766', '2', '0', '2021-04-27', '2021-04-27 08:00:00', '2021-04-27 20:00:00', '2021-04-26 22:00:01', '1', '0', '0', '2795766@1263370637087387649', '田涛');
INSERT INTO `p_plan_task` VALUES ('2093', '1619503831085', '10-42', '13', '10', '2210960', '2', '0', '2021-04-27', '2021-04-27 14:00:00', '2021-04-27 14:05:00', '2021-04-27 14:10:31', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2094', '1619503831085', '10-42', '13', '10', '2723602', '2', '0', '2021-04-27', '2021-04-27 14:00:00', '2021-04-27 14:05:00', '2021-04-27 14:10:32', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2095', '1619503831085', '10-14', '13', '10', '1893479', '2', '0', '2021-04-27', '2021-04-27 14:00:00', '2021-04-27 14:05:00', '2021-04-27 14:10:32', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2096', '1619503831085', '10-42', '13', '10', '2210960', '2', '0', '2021-04-27', '2021-04-27 14:05:00', '2021-04-27 14:10:00', '2021-04-27 14:10:33', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2097', '1619503831085', '10-42', '13', '10', '2723602', '2', '0', '2021-04-27', '2021-04-27 14:05:00', '2021-04-27 14:10:00', '2021-04-27 14:10:33', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2098', '1619503831085', '10-14', '13', '10', '1893479', '2', '0', '2021-04-27', '2021-04-27 14:05:00', '2021-04-27 14:10:00', '2021-04-27 14:10:34', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2099', '1619503831085', '10-42', '13', '10', '2210960', '2', '0', '2021-04-27', '2021-04-27 14:10:00', '2021-04-27 14:15:00', '2021-04-27 14:10:34', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2100', '1619503831085', '10-42', '13', '10', '2723602', '2', '0', '2021-04-27', '2021-04-27 14:10:00', '2021-04-27 14:15:00', '2021-04-27 14:10:34', '1', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2101', '1619503831085', '10-14', '13', '10', '1893479', '2', '0', '2021-04-27', '2021-04-27 14:10:00', '2021-04-27 14:15:00', '2021-04-27 14:10:34', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2102', '1619503831085', '10-42', '13', '10', '2210960', '2', '0', '2021-04-27', '2021-04-27 14:15:00', '2021-04-27 14:20:00', '2021-04-27 14:10:34', '1', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2103', '1619503831085', '10-42', '13', '10', '2723602', '2', '0', '2021-04-27', '2021-04-27 14:15:00', '2021-04-27 14:20:00', '2021-04-27 14:10:34', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2104', '1619503831085', '10-14', '13', '10', '1893479', '2', '0', '2021-04-27', '2021-04-27 14:15:00', '2021-04-27 14:20:00', '2021-04-27 14:10:34', '1', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2105', '1619503831085', '10-42', '13', '10', '2210960', '2', '0', '2021-04-27', '2021-04-27 14:20:00', '2021-04-27 14:25:00', '2021-04-27 14:10:34', '1', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2106', '1619503831085', '10-42', '13', '10', '2723602', '2', '0', '2021-04-27', '2021-04-27 14:20:00', '2021-04-27 14:25:00', '2021-04-27 14:10:34', '1', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2107', '1619503831085', '10-14', '13', '10', '1893479', '2', '0', '2021-04-27', '2021-04-27 14:20:00', '2021-04-27 14:25:00', '2021-04-27 14:10:34', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2108', '1619503831085', '10-42', '13', '10', '2210960', '2', '0', '2021-04-27', '2021-04-27 14:25:00', '2021-04-27 14:30:00', '2021-04-27 14:10:34', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2109', '1619503831085', '10-42', '13', '10', '2723602', '2', '0', '2021-04-27', '2021-04-27 14:25:00', '2021-04-27 14:30:00', '2021-04-27 14:10:34', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2110', '1619503831085', '10-14', '13', '10', '1893479', '2', '0', '2021-04-27', '2021-04-27 14:25:00', '2021-04-27 14:30:00', '2021-04-27 14:10:34', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2111', '1619503831085', '10-42', '13', '10', '2210960', '2', '0', '2021-04-27', '2021-04-27 14:30:00', '2021-04-27 14:35:00', '2021-04-27 14:10:34', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2112', '1619503831085', '10-42', '13', '10', '2723602', '2', '0', '2021-04-27', '2021-04-27 14:30:00', '2021-04-27 14:35:00', '2021-04-27 14:10:34', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2113', '1619503831085', '10-14', '13', '10', '1893479', '2', '0', '2021-04-27', '2021-04-27 14:30:00', '2021-04-27 14:35:00', '2021-04-27 14:10:34', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2114', '1619503831085', '10-42', '13', '10', '2210960', '2', '0', '2021-04-27', '2021-04-27 14:35:00', '2021-04-27 14:40:00', '2021-04-27 14:10:34', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2115', '1619503831085', '10-42', '13', '10', '2723602', '2', '0', '2021-04-27', '2021-04-27 14:35:00', '2021-04-27 14:40:00', '2021-04-27 14:10:34', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2116', '1619503831085', '10-14', '13', '10', '1893479', '2', '0', '2021-04-27', '2021-04-27 14:35:00', '2021-04-27 14:40:00', '2021-04-27 14:10:34', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2117', '1619503831085', '10-42', '13', '10', '2210960', '2', '0', '2021-04-27', '2021-04-27 14:40:00', '2021-04-27 14:45:00', '2021-04-27 14:10:34', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2118', '1619503831085', '10-42', '13', '10', '2723602', '2', '0', '2021-04-27', '2021-04-27 14:40:00', '2021-04-27 14:45:00', '2021-04-27 14:10:34', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2119', '1619503831085', '10-14', '13', '10', '1893479', '2', '0', '2021-04-27', '2021-04-27 14:40:00', '2021-04-27 14:45:00', '2021-04-27 14:10:34', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2120', '1619503831085', '10-42', '13', '10', '2210960', '2', '0', '2021-04-27', '2021-04-27 14:45:00', '2021-04-27 14:50:00', '2021-04-27 14:10:34', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2121', '1619503831085', '10-42', '13', '10', '2723602', '2', '0', '2021-04-27', '2021-04-27 14:45:00', '2021-04-27 14:50:00', '2021-04-27 14:10:34', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2122', '1619503831085', '10-14', '13', '10', '1893479', '2', '0', '2021-04-27', '2021-04-27 14:45:00', '2021-04-27 14:50:00', '2021-04-27 14:10:34', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2123', '1619503831085', '10-42', '13', '10', '2210960', '2', '0', '2021-04-27', '2021-04-27 14:50:00', '2021-04-27 14:55:00', '2021-04-27 14:10:34', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2124', '1619503831085', '10-42', '13', '10', '2723602', '2', '0', '2021-04-27', '2021-04-27 14:50:00', '2021-04-27 14:55:00', '2021-04-27 14:10:34', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2125', '1619503831085', '10-14', '13', '10', '1893479', '2', '0', '2021-04-27', '2021-04-27 14:50:00', '2021-04-27 14:55:00', '2021-04-27 14:10:34', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2126', '1619503831085', '10-42', '13', '10', '2210960', '2', '0', '2021-04-27', '2021-04-27 14:55:00', '2021-04-27 15:00:00', '2021-04-27 14:10:34', '3', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2127', '1619503831085', '10-42', '13', '10', '2723602', '2', '0', '2021-04-27', '2021-04-27 14:55:00', '2021-04-27 15:00:00', '2021-04-27 14:10:34', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2128', '1619503831085', '10-14', '13', '10', '1893479', '2', '0', '2021-04-27', '2021-04-27 14:55:00', '2021-04-27 15:00:00', '2021-04-27 14:10:34', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2129', '1619532001451', '10-42', '12', '10', '2723602', '2', '0', '2021-04-28', '2021-04-28 08:00:00', '2021-04-28 09:00:00', '2021-04-27 22:00:02', '3', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2130', '1619532001451', '10-14', '12', '10', '1893479', '2', '0', '2021-04-28', '2021-04-28 08:00:00', '2021-04-28 09:00:00', '2021-04-27 22:00:02', '3', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2131', '1619532001451', null, '12', '10', '1746069', '2', '0', '2021-04-28', '2021-04-28 08:00:00', '2021-04-28 09:00:00', '2021-04-27 22:00:02', '1', '0', '0', '1746069@-1', '王海涛');
INSERT INTO `p_plan_task` VALUES ('2132', '1619532001451', '10-42', '13', '10', '2210960', '2', '0', '2021-04-28', '2021-04-28 14:00:00', '2021-04-28 14:05:00', '2021-04-27 22:00:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2133', '1619532001451', '10-42', '13', '10', '2723602', '2', '0', '2021-04-28', '2021-04-28 14:00:00', '2021-04-28 14:05:00', '2021-04-27 22:00:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2134', '1619532001451', '10-14', '13', '10', '1893479', '2', '0', '2021-04-28', '2021-04-28 14:00:00', '2021-04-28 14:05:00', '2021-04-27 22:00:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2135', '1619532001451', '10-42', '13', '10', '2210960', '2', '0', '2021-04-28', '2021-04-28 14:05:00', '2021-04-28 14:10:00', '2021-04-27 22:00:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2136', '1619532001451', '10-42', '13', '10', '2723602', '2', '0', '2021-04-28', '2021-04-28 14:05:00', '2021-04-28 14:10:00', '2021-04-27 22:00:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2137', '1619532001451', '10-14', '13', '10', '1893479', '2', '0', '2021-04-28', '2021-04-28 14:05:00', '2021-04-28 14:10:00', '2021-04-27 22:00:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2138', '1619532001451', '10-42', '13', '10', '2210960', '2', '0', '2021-04-28', '2021-04-28 14:10:00', '2021-04-28 14:15:00', '2021-04-27 22:00:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2139', '1619532001451', '10-42', '13', '10', '2723602', '2', '0', '2021-04-28', '2021-04-28 14:10:00', '2021-04-28 14:15:00', '2021-04-27 22:00:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2140', '1619532001451', '10-14', '13', '10', '1893479', '2', '0', '2021-04-28', '2021-04-28 14:10:00', '2021-04-28 14:15:00', '2021-04-27 22:00:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2141', '1619532001451', '10-42', '13', '10', '2210960', '2', '0', '2021-04-28', '2021-04-28 14:15:00', '2021-04-28 14:20:00', '2021-04-27 22:00:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2142', '1619532001451', '10-42', '13', '10', '2723602', '2', '0', '2021-04-28', '2021-04-28 14:15:00', '2021-04-28 14:20:00', '2021-04-27 22:00:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2143', '1619532001451', '10-14', '13', '10', '1893479', '2', '0', '2021-04-28', '2021-04-28 14:15:00', '2021-04-28 14:20:00', '2021-04-27 22:00:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2144', '1619532001451', '10-42', '13', '10', '2210960', '2', '0', '2021-04-28', '2021-04-28 14:20:00', '2021-04-28 14:25:00', '2021-04-27 22:00:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2145', '1619532001451', '10-42', '13', '10', '2723602', '2', '0', '2021-04-28', '2021-04-28 14:20:00', '2021-04-28 14:25:00', '2021-04-27 22:00:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2146', '1619532001451', '10-14', '13', '10', '1893479', '2', '0', '2021-04-28', '2021-04-28 14:20:00', '2021-04-28 14:25:00', '2021-04-27 22:00:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2147', '1619532001451', '10-42', '13', '10', '2210960', '2', '0', '2021-04-28', '2021-04-28 14:25:00', '2021-04-28 14:30:00', '2021-04-27 22:00:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2148', '1619532001451', '10-42', '13', '10', '2723602', '2', '0', '2021-04-28', '2021-04-28 14:25:00', '2021-04-28 14:30:00', '2021-04-27 22:00:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2149', '1619532001451', '10-14', '13', '10', '1893479', '2', '0', '2021-04-28', '2021-04-28 14:25:00', '2021-04-28 14:30:00', '2021-04-27 22:00:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2150', '1619532001451', '10-42', '13', '10', '2210960', '2', '0', '2021-04-28', '2021-04-28 14:30:00', '2021-04-28 14:35:00', '2021-04-27 22:00:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2151', '1619532001451', '10-42', '13', '10', '2723602', '2', '0', '2021-04-28', '2021-04-28 14:30:00', '2021-04-28 14:35:00', '2021-04-27 22:00:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2152', '1619532001451', '10-14', '13', '10', '1893479', '2', '0', '2021-04-28', '2021-04-28 14:30:00', '2021-04-28 14:35:00', '2021-04-27 22:00:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2153', '1619532001451', '10-42', '13', '10', '2210960', '2', '0', '2021-04-28', '2021-04-28 14:35:00', '2021-04-28 14:40:00', '2021-04-27 22:00:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2154', '1619532001451', '10-42', '13', '10', '2723602', '2', '0', '2021-04-28', '2021-04-28 14:35:00', '2021-04-28 14:40:00', '2021-04-27 22:00:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2155', '1619532001451', '10-14', '13', '10', '1893479', '2', '0', '2021-04-28', '2021-04-28 14:35:00', '2021-04-28 14:40:00', '2021-04-27 22:00:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2156', '1619532001451', '10-42', '13', '10', '2210960', '2', '0', '2021-04-28', '2021-04-28 14:40:00', '2021-04-28 14:45:00', '2021-04-27 22:00:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2157', '1619532001451', '10-42', '13', '10', '2723602', '2', '0', '2021-04-28', '2021-04-28 14:40:00', '2021-04-28 14:45:00', '2021-04-27 22:00:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2158', '1619532001451', '10-14', '13', '10', '1893479', '2', '0', '2021-04-28', '2021-04-28 14:40:00', '2021-04-28 14:45:00', '2021-04-27 22:00:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2159', '1619532001451', '10-42', '13', '10', '2210960', '2', '0', '2021-04-28', '2021-04-28 14:45:00', '2021-04-28 14:50:00', '2021-04-27 22:00:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2160', '1619532001451', '10-42', '13', '10', '2723602', '2', '0', '2021-04-28', '2021-04-28 14:45:00', '2021-04-28 14:50:00', '2021-04-27 22:00:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2161', '1619532001451', '10-14', '13', '10', '1893479', '2', '0', '2021-04-28', '2021-04-28 14:45:00', '2021-04-28 14:50:00', '2021-04-27 22:00:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2162', '1619532001451', '10-42', '13', '10', '2210960', '2', '0', '2021-04-28', '2021-04-28 14:50:00', '2021-04-28 14:55:00', '2021-04-27 22:00:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2163', '1619532001451', '10-42', '13', '10', '2723602', '2', '0', '2021-04-28', '2021-04-28 14:50:00', '2021-04-28 14:55:00', '2021-04-27 22:00:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2164', '1619532001451', '10-14', '13', '10', '1893479', '2', '0', '2021-04-28', '2021-04-28 14:50:00', '2021-04-28 14:55:00', '2021-04-27 22:00:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2165', '1619532001451', '10-42', '13', '10', '2210960', '2', '0', '2021-04-28', '2021-04-28 14:55:00', '2021-04-28 15:00:00', '2021-04-27 22:00:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2166', '1619532001451', '10-42', '13', '10', '2723602', '2', '0', '2021-04-28', '2021-04-28 14:55:00', '2021-04-28 15:00:00', '2021-04-27 22:00:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2167', '1619532001451', '10-14', '13', '10', '1893479', '2', '0', '2021-04-28', '2021-04-28 14:55:00', '2021-04-28 15:00:00', '2021-04-27 22:00:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2168', '1619532001451', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-28', '2021-04-28 12:00:00', '2021-04-28 13:00:00', '2021-04-27 22:00:03', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2169', '1619532001451', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-28', '2021-04-28 13:00:00', '2021-04-28 14:00:00', '2021-04-27 22:00:04', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2170', '1619532001451', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-28', '2021-04-28 14:00:00', '2021-04-28 15:00:00', '2021-04-27 22:00:04', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2171', '1619532001451', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-28', '2021-04-28 15:00:00', '2021-04-28 16:00:00', '2021-04-27 22:00:04', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2172', '1619532001451', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-28', '2021-04-28 16:00:00', '2021-04-28 17:00:00', '2021-04-27 22:00:04', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2173', '1619532001451', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-28', '2021-04-28 17:00:00', '2021-04-28 18:00:00', '2021-04-27 22:00:04', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2174', '1619532001451', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-28', '2021-04-28 18:00:00', '2021-04-28 19:00:00', '2021-04-27 22:00:04', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2175', '1619532001451', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-28', '2021-04-28 19:00:00', '2021-04-28 20:00:00', '2021-04-27 22:00:04', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2176', '1619532001451', '10-42', '15', '10', '2795766', '2', '0', '2021-04-28', '2021-04-28 08:00:00', '2021-04-28 20:00:00', '2021-04-27 22:00:04', '1', '0', '0', '2795766@1263370637087387649', '田涛');
INSERT INTO `p_plan_task` VALUES ('2177', '1619570278138', '10-42', '12', '10', '2723602', '2', '0', '2021-04-29', '2021-04-29 08:00:00', '2021-04-29 09:00:00', '2021-04-28 08:38:02', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2178', '1619570278138', '10-14', '12', '10', '1893479', '2', '0', '2021-04-29', '2021-04-29 08:00:00', '2021-04-29 09:00:00', '2021-04-28 08:38:02', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2179', '1619570278138', null, '12', '10', '1746069', '2', '0', '2021-04-29', '2021-04-29 08:00:00', '2021-04-29 09:00:00', '2021-04-28 08:38:02', '0', '0', '0', '1746069@-1', '王海涛');
INSERT INTO `p_plan_task` VALUES ('2180', '1619570278138', '10-42', '13', '10', '2210960', '2', '0', '2021-04-29', '2021-04-29 14:00:00', '2021-04-29 14:05:00', '2021-04-28 08:38:02', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2181', '1619570278138', '10-42', '13', '10', '2723602', '2', '0', '2021-04-29', '2021-04-29 14:00:00', '2021-04-29 14:05:00', '2021-04-28 08:38:02', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2182', '1619570278138', '10-14', '13', '10', '1893479', '2', '0', '2021-04-29', '2021-04-29 14:00:00', '2021-04-29 14:05:00', '2021-04-28 08:38:02', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2183', '1619570278138', '10-42', '13', '10', '2210960', '2', '0', '2021-04-29', '2021-04-29 14:05:00', '2021-04-29 14:10:00', '2021-04-28 08:38:02', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2184', '1619570278138', '10-42', '13', '10', '2723602', '2', '0', '2021-04-29', '2021-04-29 14:05:00', '2021-04-29 14:10:00', '2021-04-28 08:38:02', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2185', '1619570278138', '10-14', '13', '10', '1893479', '2', '0', '2021-04-29', '2021-04-29 14:05:00', '2021-04-29 14:10:00', '2021-04-28 08:38:02', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2186', '1619570278138', '10-42', '13', '10', '2210960', '2', '0', '2021-04-29', '2021-04-29 14:10:00', '2021-04-29 14:15:00', '2021-04-28 08:38:02', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2187', '1619570278138', '10-42', '13', '10', '2723602', '2', '0', '2021-04-29', '2021-04-29 14:10:00', '2021-04-29 14:15:00', '2021-04-28 08:38:02', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2188', '1619570278138', '10-14', '13', '10', '1893479', '2', '0', '2021-04-29', '2021-04-29 14:10:00', '2021-04-29 14:15:00', '2021-04-28 08:38:02', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2189', '1619570278138', '10-42', '13', '10', '2210960', '2', '0', '2021-04-29', '2021-04-29 14:15:00', '2021-04-29 14:20:00', '2021-04-28 08:38:02', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2190', '1619570278138', '10-42', '13', '10', '2723602', '2', '0', '2021-04-29', '2021-04-29 14:15:00', '2021-04-29 14:20:00', '2021-04-28 08:38:02', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2191', '1619570278138', '10-14', '13', '10', '1893479', '2', '0', '2021-04-29', '2021-04-29 14:15:00', '2021-04-29 14:20:00', '2021-04-28 08:38:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2192', '1619570278138', '10-42', '13', '10', '2210960', '2', '0', '2021-04-29', '2021-04-29 14:20:00', '2021-04-29 14:25:00', '2021-04-28 08:38:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2193', '1619570278138', '10-42', '13', '10', '2723602', '2', '0', '2021-04-29', '2021-04-29 14:20:00', '2021-04-29 14:25:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2194', '1619570278138', '10-14', '13', '10', '1893479', '2', '0', '2021-04-29', '2021-04-29 14:20:00', '2021-04-29 14:25:00', '2021-04-28 08:38:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2195', '1619570278138', '10-42', '13', '10', '2210960', '2', '0', '2021-04-29', '2021-04-29 14:25:00', '2021-04-29 14:30:00', '2021-04-28 08:38:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2196', '1619570278138', '10-42', '13', '10', '2723602', '2', '0', '2021-04-29', '2021-04-29 14:25:00', '2021-04-29 14:30:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2197', '1619570278138', '10-14', '13', '10', '1893479', '2', '0', '2021-04-29', '2021-04-29 14:25:00', '2021-04-29 14:30:00', '2021-04-28 08:38:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2198', '1619570278138', '10-42', '13', '10', '2210960', '2', '0', '2021-04-29', '2021-04-29 14:30:00', '2021-04-29 14:35:00', '2021-04-28 08:38:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2199', '1619570278138', '10-42', '13', '10', '2723602', '2', '0', '2021-04-29', '2021-04-29 14:30:00', '2021-04-29 14:35:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2200', '1619570278138', '10-14', '13', '10', '1893479', '2', '0', '2021-04-29', '2021-04-29 14:30:00', '2021-04-29 14:35:00', '2021-04-28 08:38:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2201', '1619570278138', '10-42', '13', '10', '2210960', '2', '0', '2021-04-29', '2021-04-29 14:35:00', '2021-04-29 14:40:00', '2021-04-28 08:38:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2202', '1619570278138', '10-42', '13', '10', '2723602', '2', '0', '2021-04-29', '2021-04-29 14:35:00', '2021-04-29 14:40:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2203', '1619570278138', '10-14', '13', '10', '1893479', '2', '0', '2021-04-29', '2021-04-29 14:35:00', '2021-04-29 14:40:00', '2021-04-28 08:38:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2204', '1619570278138', '10-42', '13', '10', '2210960', '2', '0', '2021-04-29', '2021-04-29 14:40:00', '2021-04-29 14:45:00', '2021-04-28 08:38:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2205', '1619570278138', '10-42', '13', '10', '2723602', '2', '0', '2021-04-29', '2021-04-29 14:40:00', '2021-04-29 14:45:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2206', '1619570278138', '10-14', '13', '10', '1893479', '2', '0', '2021-04-29', '2021-04-29 14:40:00', '2021-04-29 14:45:00', '2021-04-28 08:38:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2207', '1619570278138', '10-42', '13', '10', '2210960', '2', '0', '2021-04-29', '2021-04-29 14:45:00', '2021-04-29 14:50:00', '2021-04-28 08:38:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2208', '1619570278138', '10-42', '13', '10', '2723602', '2', '0', '2021-04-29', '2021-04-29 14:45:00', '2021-04-29 14:50:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2209', '1619570278138', '10-14', '13', '10', '1893479', '2', '0', '2021-04-29', '2021-04-29 14:45:00', '2021-04-29 14:50:00', '2021-04-28 08:38:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2210', '1619570278138', '10-42', '13', '10', '2210960', '2', '0', '2021-04-29', '2021-04-29 14:50:00', '2021-04-29 14:55:00', '2021-04-28 08:38:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2211', '1619570278138', '10-42', '13', '10', '2723602', '2', '0', '2021-04-29', '2021-04-29 14:50:00', '2021-04-29 14:55:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2212', '1619570278138', '10-14', '13', '10', '1893479', '2', '0', '2021-04-29', '2021-04-29 14:50:00', '2021-04-29 14:55:00', '2021-04-28 08:38:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2213', '1619570278138', '10-42', '13', '10', '2210960', '2', '0', '2021-04-29', '2021-04-29 14:55:00', '2021-04-29 15:00:00', '2021-04-28 08:38:03', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2214', '1619570278138', '10-42', '13', '10', '2723602', '2', '0', '2021-04-29', '2021-04-29 14:55:00', '2021-04-29 15:00:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2215', '1619570278138', '10-14', '13', '10', '1893479', '2', '0', '2021-04-29', '2021-04-29 14:55:00', '2021-04-29 15:00:00', '2021-04-28 08:38:03', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2216', '1619570278138', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-29', '2021-04-29 12:00:00', '2021-04-29 13:00:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2217', '1619570278138', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-29', '2021-04-29 13:00:00', '2021-04-29 14:00:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2218', '1619570278138', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-29', '2021-04-29 14:00:00', '2021-04-29 15:00:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2219', '1619570278138', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-29', '2021-04-29 15:00:00', '2021-04-29 16:00:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2220', '1619570278138', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-29', '2021-04-29 16:00:00', '2021-04-29 17:00:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2221', '1619570278138', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-29', '2021-04-29 17:00:00', '2021-04-29 18:00:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2222', '1619570278138', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-29', '2021-04-29 18:00:00', '2021-04-29 19:00:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2223', '1619570278138', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-29', '2021-04-29 19:00:00', '2021-04-29 20:00:00', '2021-04-28 08:38:03', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2224', '1619570278138', '10-42', '15', '10', '2795766', '2', '0', '2021-04-29', '2021-04-29 08:00:00', '2021-04-29 20:00:00', '2021-04-28 08:38:04', '0', '0', '0', '2795766@1263370637087387649', '田涛');
INSERT INTO `p_plan_task` VALUES ('2225', '1619704800025', '10-42', '12', '10', '2723602', '2', '0', '2021-04-30', '2021-04-30 08:00:00', '2021-04-30 09:00:00', '2021-04-29 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2226', '1619704800025', '10-14', '12', '10', '1893479', '2', '0', '2021-04-30', '2021-04-30 08:00:00', '2021-04-30 09:00:00', '2021-04-29 22:00:01', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2227', '1619704800025', null, '12', '10', '1746069', '2', '0', '2021-04-30', '2021-04-30 08:00:00', '2021-04-30 09:00:00', '2021-04-29 22:00:01', '0', '0', '0', '1746069@-1', '王海涛');
INSERT INTO `p_plan_task` VALUES ('2228', '1619704800025', '10-42', '13', '10', '2210960', '2', '0', '2021-04-30', '2021-04-30 14:00:00', '2021-04-30 14:05:00', '2021-04-29 22:00:01', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2229', '1619704800025', '10-42', '13', '10', '2723602', '2', '0', '2021-04-30', '2021-04-30 14:00:00', '2021-04-30 14:05:00', '2021-04-29 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2230', '1619704800025', '10-14', '13', '10', '1893479', '2', '0', '2021-04-30', '2021-04-30 14:00:00', '2021-04-30 14:05:00', '2021-04-29 22:00:01', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2231', '1619704800025', '10-42', '13', '10', '2210960', '2', '0', '2021-04-30', '2021-04-30 14:05:00', '2021-04-30 14:10:00', '2021-04-29 22:00:01', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2232', '1619704800025', '10-42', '13', '10', '2723602', '2', '0', '2021-04-30', '2021-04-30 14:05:00', '2021-04-30 14:10:00', '2021-04-29 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2233', '1619704800025', '10-14', '13', '10', '1893479', '2', '0', '2021-04-30', '2021-04-30 14:05:00', '2021-04-30 14:10:00', '2021-04-29 22:00:01', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2234', '1619704800025', '10-42', '13', '10', '2210960', '2', '0', '2021-04-30', '2021-04-30 14:10:00', '2021-04-30 14:15:00', '2021-04-29 22:00:01', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2235', '1619704800025', '10-42', '13', '10', '2723602', '2', '0', '2021-04-30', '2021-04-30 14:10:00', '2021-04-30 14:15:00', '2021-04-29 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2236', '1619704800025', '10-14', '13', '10', '1893479', '2', '0', '2021-04-30', '2021-04-30 14:10:00', '2021-04-30 14:15:00', '2021-04-29 22:00:01', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2237', '1619704800025', '10-42', '13', '10', '2210960', '2', '0', '2021-04-30', '2021-04-30 14:15:00', '2021-04-30 14:20:00', '2021-04-29 22:00:01', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2238', '1619704800025', '10-42', '13', '10', '2723602', '2', '0', '2021-04-30', '2021-04-30 14:15:00', '2021-04-30 14:20:00', '2021-04-29 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2239', '1619704800025', '10-14', '13', '10', '1893479', '2', '0', '2021-04-30', '2021-04-30 14:15:00', '2021-04-30 14:20:00', '2021-04-29 22:00:01', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2240', '1619704800025', '10-42', '13', '10', '2210960', '2', '0', '2021-04-30', '2021-04-30 14:20:00', '2021-04-30 14:25:00', '2021-04-29 22:00:01', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2241', '1619704800025', '10-42', '13', '10', '2723602', '2', '0', '2021-04-30', '2021-04-30 14:20:00', '2021-04-30 14:25:00', '2021-04-29 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2242', '1619704800025', '10-14', '13', '10', '1893479', '2', '0', '2021-04-30', '2021-04-30 14:20:00', '2021-04-30 14:25:00', '2021-04-29 22:00:01', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2243', '1619704800025', '10-42', '13', '10', '2210960', '2', '0', '2021-04-30', '2021-04-30 14:25:00', '2021-04-30 14:30:00', '2021-04-29 22:00:01', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2244', '1619704800025', '10-42', '13', '10', '2723602', '2', '0', '2021-04-30', '2021-04-30 14:25:00', '2021-04-30 14:30:00', '2021-04-29 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2245', '1619704800025', '10-14', '13', '10', '1893479', '2', '0', '2021-04-30', '2021-04-30 14:25:00', '2021-04-30 14:30:00', '2021-04-29 22:00:01', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2246', '1619704800025', '10-42', '13', '10', '2210960', '2', '0', '2021-04-30', '2021-04-30 14:30:00', '2021-04-30 14:35:00', '2021-04-29 22:00:01', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2247', '1619704800025', '10-42', '13', '10', '2723602', '2', '0', '2021-04-30', '2021-04-30 14:30:00', '2021-04-30 14:35:00', '2021-04-29 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2248', '1619704800025', '10-14', '13', '10', '1893479', '2', '0', '2021-04-30', '2021-04-30 14:30:00', '2021-04-30 14:35:00', '2021-04-29 22:00:01', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2249', '1619704800025', '10-42', '13', '10', '2210960', '2', '0', '2021-04-30', '2021-04-30 14:35:00', '2021-04-30 14:40:00', '2021-04-29 22:00:01', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2250', '1619704800025', '10-42', '13', '10', '2723602', '2', '0', '2021-04-30', '2021-04-30 14:35:00', '2021-04-30 14:40:00', '2021-04-29 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2251', '1619704800025', '10-14', '13', '10', '1893479', '2', '0', '2021-04-30', '2021-04-30 14:35:00', '2021-04-30 14:40:00', '2021-04-29 22:00:01', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2252', '1619704800025', '10-42', '13', '10', '2210960', '2', '0', '2021-04-30', '2021-04-30 14:40:00', '2021-04-30 14:45:00', '2021-04-29 22:00:01', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2253', '1619704800025', '10-42', '13', '10', '2723602', '2', '0', '2021-04-30', '2021-04-30 14:40:00', '2021-04-30 14:45:00', '2021-04-29 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2254', '1619704800025', '10-14', '13', '10', '1893479', '2', '0', '2021-04-30', '2021-04-30 14:40:00', '2021-04-30 14:45:00', '2021-04-29 22:00:01', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2255', '1619704800025', '10-42', '13', '10', '2210960', '2', '0', '2021-04-30', '2021-04-30 14:45:00', '2021-04-30 14:50:00', '2021-04-29 22:00:01', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2256', '1619704800025', '10-42', '13', '10', '2723602', '2', '0', '2021-04-30', '2021-04-30 14:45:00', '2021-04-30 14:50:00', '2021-04-29 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2257', '1619704800025', '10-14', '13', '10', '1893479', '2', '0', '2021-04-30', '2021-04-30 14:45:00', '2021-04-30 14:50:00', '2021-04-29 22:00:01', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2258', '1619704800025', '10-42', '13', '10', '2210960', '2', '0', '2021-04-30', '2021-04-30 14:50:00', '2021-04-30 14:55:00', '2021-04-29 22:00:01', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2259', '1619704800025', '10-42', '13', '10', '2723602', '2', '0', '2021-04-30', '2021-04-30 14:50:00', '2021-04-30 14:55:00', '2021-04-29 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2260', '1619704800025', '10-14', '13', '10', '1893479', '2', '0', '2021-04-30', '2021-04-30 14:50:00', '2021-04-30 14:55:00', '2021-04-29 22:00:01', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2261', '1619704800025', '10-42', '13', '10', '2210960', '2', '0', '2021-04-30', '2021-04-30 14:55:00', '2021-04-30 15:00:00', '2021-04-29 22:00:01', '0', '0', '0', '2210960@1263370637087387649', '郑家文');
INSERT INTO `p_plan_task` VALUES ('2262', '1619704800025', '10-42', '13', '10', '2723602', '2', '0', '2021-04-30', '2021-04-30 14:55:00', '2021-04-30 15:00:00', '2021-04-29 22:00:02', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2263', '1619704800025', '10-14', '13', '10', '1893479', '2', '0', '2021-04-30', '2021-04-30 14:55:00', '2021-04-30 15:00:00', '2021-04-29 22:00:02', '0', '0', '0', '1893479@1232939516555915265', '卢阳');
INSERT INTO `p_plan_task` VALUES ('2264', '1619704800025', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-30', '2021-04-30 12:00:00', '2021-04-30 13:00:00', '2021-04-29 22:00:02', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2265', '1619704800025', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-30', '2021-04-30 13:00:00', '2021-04-30 14:00:00', '2021-04-29 22:00:02', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2266', '1619704800025', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-30', '2021-04-30 14:00:00', '2021-04-30 15:00:00', '2021-04-29 22:00:02', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2267', '1619704800025', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-30', '2021-04-30 15:00:00', '2021-04-30 16:00:00', '2021-04-29 22:00:02', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2268', '1619704800025', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-30', '2021-04-30 16:00:00', '2021-04-30 17:00:00', '2021-04-29 22:00:02', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2269', '1619704800025', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-30', '2021-04-30 17:00:00', '2021-04-30 18:00:00', '2021-04-29 22:00:02', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2270', '1619704800025', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-30', '2021-04-30 18:00:00', '2021-04-30 19:00:00', '2021-04-29 22:00:02', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2271', '1619704800025', '10-42, 10-14', '14', '10', '2723602,2064235,2083389', '2', '0', '2021-04-30', '2021-04-30 19:00:00', '2021-04-30 20:00:00', '2021-04-29 22:00:02', '0', '0', '0', '2723602@1263370637087387649,2064235@1232939516555915265,2083389@-1', '宁天庆,吴俊凯5,吴江');
INSERT INTO `p_plan_task` VALUES ('2272', '1619704800025', '10-42', '15', '10', '2795766', '2', '0', '2021-04-30', '2021-04-30 08:00:00', '2021-04-30 20:00:00', '2021-04-29 22:00:02', '0', '0', '0', '2795766@1263370637087387649', '田涛');
INSERT INTO `p_plan_task` VALUES ('2289', '1620289315299', '10-42', '19', '13', '2723602', '1', '1', '2021-05-06', '2021-05-06 16:00:00', '2021-05-06 16:30:00', '2021-05-06 16:28:02', '2', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2290', '1620289315299', '10-42', '19', '13', '2723602', '1', '1', '2021-05-06', '2021-05-06 16:30:00', '2021-05-06 17:00:00', '2021-05-06 16:44:17', '2', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2291', '1620289315299', '10-42', '19', '13', '2723602', '1', '0', '2021-05-06', '2021-05-06 17:00:00', '2021-05-06 17:30:00', '2021-05-06 16:21:55', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2292', '1620289315299', '10-42', '19', '13', '2723602', '1', '0', '2021-05-06', '2021-05-06 17:30:00', '2021-05-06 18:00:00', '2021-05-06 16:21:55', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2293', '1620289315299', '10-42', '19', '13', '2723602', '1', '0', '2021-05-06', '2021-05-06 18:00:00', '2021-05-06 18:30:00', '2021-05-06 16:21:55', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2294', '1620289315299', '10-42', '19', '13', '2723602', '1', '0', '2021-05-06', '2021-05-06 18:30:00', '2021-05-06 19:00:00', '2021-05-06 16:21:55', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2295', '1620289315299', '10-42', '19', '13', '2723602', '1', '0', '2021-05-06', '2021-05-06 19:00:00', '2021-05-06 19:30:00', '2021-05-06 16:21:55', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2296', '1620289315299', '10-42', '19', '13', '2723602', '1', '0', '2021-05-06', '2021-05-06 19:30:00', '2021-05-06 20:00:00', '2021-05-06 16:21:55', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2308', '1620438265272', '10-42', '19', '13', '2723602', '1', '0', '2021-05-08', '2021-05-08 09:00:00', '2021-05-08 10:00:00', '2021-05-08 09:44:26', '1', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2309', '1620438265272', '10-42', '19', '13', '2723602', '1', '0', '2021-05-08', '2021-05-08 10:00:00', '2021-05-08 11:00:00', '2021-05-08 09:44:26', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2310', '1620438265272', '10-42', '19', '13', '2723602', '1', '0', '2021-05-08', '2021-05-08 11:00:00', '2021-05-08 12:00:00', '2021-05-08 09:44:26', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2311', '1620438265272', '10-42', '19', '13', '2723602', '1', '0', '2021-05-08', '2021-05-08 12:00:00', '2021-05-08 13:00:00', '2021-05-08 09:44:26', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2312', '1620438265272', '10-42', '19', '13', '2723602', '1', '0', '2021-05-08', '2021-05-08 13:00:00', '2021-05-08 14:00:00', '2021-05-08 09:44:26', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2313', '1620438265272', '10-42', '19', '13', '2723602', '1', '0', '2021-05-08', '2021-05-08 14:00:00', '2021-05-08 15:00:00', '2021-05-08 09:44:26', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2314', '1620438265272', '10-42', '19', '13', '2723602', '1', '0', '2021-05-08', '2021-05-08 15:00:00', '2021-05-08 16:00:00', '2021-05-08 09:44:26', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2315', '1620438265272', '10-42', '19', '13', '2723602', '1', '0', '2021-05-08', '2021-05-08 16:00:00', '2021-05-08 17:00:00', '2021-05-08 09:44:26', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2316', '1620438265272', '10-42', '19', '13', '2723602', '1', '0', '2021-05-08', '2021-05-08 17:00:00', '2021-05-08 18:00:00', '2021-05-08 09:44:26', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2317', '1620438265272', '10-42', '19', '13', '2723602', '1', '0', '2021-05-08', '2021-05-08 18:00:00', '2021-05-08 19:00:00', '2021-05-08 09:44:26', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2318', '1620438265272', '10-42', '19', '13', '2723602', '1', '0', '2021-05-08', '2021-05-08 19:00:00', '2021-05-08 20:00:00', '2021-05-08 09:44:26', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2319', '1620482400014', '10-42', '19', '13', '2723602', '1', '0', '2021-05-09', '2021-05-09 09:00:00', '2021-05-09 10:00:00', '2021-05-08 22:00:01', '1', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2320', '1620482400014', '10-42', '19', '13', '2723602', '1', '0', '2021-05-09', '2021-05-09 10:00:00', '2021-05-09 11:00:00', '2021-05-08 22:00:01', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2321', '1620482400014', '10-42', '19', '13', '2723602', '1', '0', '2021-05-09', '2021-05-09 11:00:00', '2021-05-09 12:00:00', '2021-05-08 22:00:02', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2322', '1620482400014', '10-42', '19', '13', '2723602', '1', '0', '2021-05-09', '2021-05-09 12:00:00', '2021-05-09 13:00:00', '2021-05-08 22:00:02', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2323', '1620482400014', '10-42', '19', '13', '2723602', '1', '0', '2021-05-09', '2021-05-09 13:00:00', '2021-05-09 14:00:00', '2021-05-08 22:00:02', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2324', '1620482400014', '10-42', '19', '13', '2723602', '1', '0', '2021-05-09', '2021-05-09 14:00:00', '2021-05-09 15:00:00', '2021-05-08 22:00:02', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2325', '1620482400014', '10-42', '19', '13', '2723602', '1', '0', '2021-05-09', '2021-05-09 15:00:00', '2021-05-09 16:00:00', '2021-05-08 22:00:02', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2326', '1620482400014', '10-42', '19', '13', '2723602', '1', '0', '2021-05-09', '2021-05-09 16:00:00', '2021-05-09 17:00:00', '2021-05-08 22:00:02', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2327', '1620482400014', '10-42', '19', '13', '2723602', '1', '0', '2021-05-09', '2021-05-09 17:00:00', '2021-05-09 18:00:00', '2021-05-08 22:00:02', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2328', '1620482400014', '10-42', '19', '13', '2723602', '1', '0', '2021-05-09', '2021-05-09 18:00:00', '2021-05-09 19:00:00', '2021-05-08 22:00:02', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');
INSERT INTO `p_plan_task` VALUES ('2329', '1620482400014', '10-42', '19', '13', '2723602', '1', '0', '2021-05-09', '2021-05-09 19:00:00', '2021-05-09 20:00:00', '2021-05-08 22:00:02', '0', '0', '0', '2723602@1263370637087387649', '吴俊凯5');

-- ----------------------------
-- Table structure for p_plan_task_detail
-- ----------------------------
DROP TABLE IF EXISTS `p_plan_task_detail`;
CREATE TABLE `p_plan_task_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '任务明细编号',
  `task_no` bigint(20) NOT NULL COMMENT '批次号',
  `point_id` bigint(20) NOT NULL COMMENT '点编号',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `is_finish` int(11) DEFAULT '0' COMMENT '是否完成：0-未完成，1-已完成，2-超时漏检',
  `status` varchar(50) DEFAULT '合格' COMMENT '状态',
  `executor_id` bigint(20) DEFAULT '0' COMMENT '执行人id',
  `executor_date` datetime DEFAULT NULL COMMENT '执行时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `task_no` (`task_no`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3176 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of p_plan_task_detail
-- ----------------------------
INSERT INTO `p_plan_task_detail` VALUES ('2280', '1656', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2281', '1657', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2282', '1658', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2426', '1802', '15', '2021-05-10 18:42:03', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2467', '1843', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2468', '1844', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2469', '1845', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2470', '1846', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2471', '1847', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2472', '1848', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2473', '1849', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2474', '1850', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2475', '1851', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2476', '1852', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2477', '1853', '15', '2021-05-10 18:41:42', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2478', '1854', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2479', '1855', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2480', '1856', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2481', '1857', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2482', '1858', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2483', '1859', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2484', '1860', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2485', '1861', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2486', '1862', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2487', '1863', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2488', '1864', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2489', '1865', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2490', '1866', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2491', '1867', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2492', '1868', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2493', '1869', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2494', '1870', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2495', '1871', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2496', '1872', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2497', '1873', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2498', '1874', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2499', '1875', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2500', '1876', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2501', '1877', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2502', '1878', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2503', '1879', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2504', '1880', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2505', '1881', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2506', '1882', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2507', '1883', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2508', '1884', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2509', '1885', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2510', '1886', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2511', '1887', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2512', '1888', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2513', '1889', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2514', '1890', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2515', '1891', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2516', '1892', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2517', '1893', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2518', '1894', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2519', '1895', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2520', '1896', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2521', '1897', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2522', '1898', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2523', '1899', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2524', '1900', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2525', '1901', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2526', '1902', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2537', '1913', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2538', '1914', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2539', '1915', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2540', '1916', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2541', '1917', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2542', '1918', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2543', '1919', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2544', '1920', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2545', '1921', '15', '2021-05-10 18:42:03', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2546', '1922', '15', '2021-05-10 18:42:03', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2547', '1923', '15', '2021-05-10 18:42:03', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2548', '1924', '15', '2021-05-10 18:42:03', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2549', '1925', '15', '2021-05-10 18:42:03', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2550', '1926', '15', '2021-05-10 18:42:03', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2551', '1927', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2552', '1928', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2553', '1929', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2554', '1930', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2555', '1931', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2556', '1932', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2557', '1933', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2558', '1934', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2559', '1935', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2560', '1936', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2561', '1937', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2562', '1938', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2563', '1939', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2564', '1940', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2565', '1941', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2566', '1942', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2567', '1943', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2568', '1944', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2569', '1945', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2570', '1946', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2571', '1947', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2572', '1948', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2573', '1949', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2574', '1950', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2575', '1951', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2576', '1952', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2577', '1953', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2578', '1954', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2579', '1955', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2580', '1956', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2581', '1957', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2582', '1958', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2583', '1959', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2584', '1960', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2585', '1961', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2586', '1962', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2587', '1963', '15', '2021-05-10 18:42:03', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2588', '1964', '15', '2021-05-10 18:42:03', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2589', '1965', '15', '2021-05-10 18:42:03', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2590', '1966', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2591', '1967', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2592', '1968', '15', '2021-05-10 18:42:03', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2593', '1969', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2594', '1970', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2595', '1971', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2596', '1972', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2597', '1973', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2598', '1974', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2599', '1975', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2600', '1976', '15', '2021-05-10 18:42:03', '1', '1', '2723602', '2021-04-25 10:12:48');
INSERT INTO `p_plan_task_detail` VALUES ('2601', '1977', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2602', '1978', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2603', '1979', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2604', '1980', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2605', '1981', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2606', '1982', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2607', '1983', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2608', '1984', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2609', '1985', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2610', '1986', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2611', '1987', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2612', '1988', '15', '2021-05-10 18:42:03', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2613', '1989', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2614', '1990', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2615', '1991', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2616', '1992', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2617', '1993', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2618', '1994', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2619', '1995', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2620', '1996', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2621', '1997', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2622', '1998', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2623', '1999', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2624', '2000', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2625', '2001', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2626', '2002', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2627', '2003', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2628', '2004', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2629', '2005', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2630', '2006', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2631', '2007', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2632', '2008', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2633', '2009', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2634', '2010', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2635', '2011', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2636', '2012', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2637', '2013', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2638', '2014', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2639', '2015', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2640', '2016', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2641', '2017', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2642', '2018', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2643', '2019', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2644', '2020', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2645', '2021', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2646', '2022', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2647', '2023', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2648', '2024', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2649', '2025', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2650', '2026', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2651', '2027', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2652', '2028', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2653', '2029', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2654', '2030', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2655', '2031', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2656', '2032', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2657', '2033', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2658', '2034', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2659', '2035', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2660', '2036', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2661', '2037', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2662', '2038', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2663', '2039', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2664', '2040', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2665', '2041', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2666', '2042', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2667', '2043', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2668', '2044', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2669', '2045', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2670', '2046', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2671', '2047', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2672', '2048', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2673', '2049', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2674', '2050', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2675', '2051', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2676', '2051', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2677', '2052', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2678', '2052', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2679', '2053', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2680', '2053', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2741', '2084', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2742', '2084', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2743', '2085', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2744', '2085', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2745', '2086', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2746', '2086', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2747', '2087', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2748', '2087', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2749', '2088', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2750', '2088', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2751', '2089', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2752', '2089', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2753', '2090', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2754', '2090', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2755', '2091', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2756', '2091', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2757', '2092', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2758', '2092', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2759', '2093', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2760', '2093', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2761', '2094', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2762', '2094', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2763', '2095', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2764', '2095', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2765', '2096', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2766', '2096', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2767', '2097', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2768', '2097', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2769', '2098', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2770', '2098', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2771', '2099', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2772', '2099', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2773', '2100', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2774', '2100', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2775', '2101', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2776', '2101', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2777', '2102', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2778', '2102', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2779', '2103', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2780', '2103', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2781', '2104', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2782', '2104', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2783', '2105', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2784', '2105', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2785', '2106', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2786', '2106', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2787', '2107', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2788', '2107', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2789', '2108', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2790', '2108', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2791', '2109', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2792', '2109', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2793', '2110', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2794', '2110', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2795', '2111', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2796', '2111', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2797', '2112', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2798', '2112', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2799', '2113', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2800', '2113', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2801', '2114', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2802', '2114', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2803', '2115', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2804', '2115', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2805', '2116', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2806', '2116', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2807', '2117', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2808', '2117', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2809', '2118', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2810', '2118', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2811', '2119', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2812', '2119', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2813', '2120', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2814', '2120', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2815', '2121', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2816', '2121', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2817', '2122', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2818', '2122', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2819', '2123', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2820', '2123', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2821', '2124', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2822', '2124', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2823', '2125', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2824', '2125', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2825', '2126', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2826', '2126', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2827', '2127', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2828', '2127', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2829', '2128', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2830', '2128', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2831', '2129', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2832', '2129', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2833', '2130', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2834', '2130', '15', '2021-05-10 18:42:04', '2', '3', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2835', '2131', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2836', '2131', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2837', '2132', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2838', '2132', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2839', '2133', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2840', '2133', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2841', '2134', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2842', '2134', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2843', '2135', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2844', '2135', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2845', '2136', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2846', '2136', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2847', '2137', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2848', '2137', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2849', '2138', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2850', '2138', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2851', '2139', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2852', '2139', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2853', '2140', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2854', '2140', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2855', '2141', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2856', '2141', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2857', '2142', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2858', '2142', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2859', '2143', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2860', '2143', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2861', '2144', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2862', '2144', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2863', '2145', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2864', '2145', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2865', '2146', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2866', '2146', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2867', '2147', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2868', '2147', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2869', '2148', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2870', '2148', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2871', '2149', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2872', '2149', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2873', '2150', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2874', '2150', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2875', '2151', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2876', '2151', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2877', '2152', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2878', '2152', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2879', '2153', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2880', '2153', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2881', '2154', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2882', '2154', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2883', '2155', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2884', '2155', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2885', '2156', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2886', '2156', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2887', '2157', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2888', '2157', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2889', '2158', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2890', '2158', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2891', '2159', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2892', '2159', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2893', '2160', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2894', '2160', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2895', '2161', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2896', '2161', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2897', '2162', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2898', '2162', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2899', '2163', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2900', '2163', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2901', '2164', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2902', '2164', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2903', '2165', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2904', '2165', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2905', '2166', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2906', '2166', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2907', '2167', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2908', '2167', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2909', '2168', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2910', '2168', '15', '2021-05-10 18:42:04', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2911', '2169', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2912', '2169', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2913', '2170', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2914', '2170', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2915', '2171', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2916', '2171', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2917', '2172', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2918', '2172', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2919', '2173', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2920', '2173', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2921', '2174', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2922', '2174', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2923', '2175', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2924', '2175', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2925', '2176', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2926', '2176', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2927', '2177', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2928', '2177', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2929', '2178', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2930', '2178', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2931', '2179', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2932', '2179', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2933', '2180', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2934', '2180', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2935', '2181', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2936', '2181', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2937', '2182', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2938', '2182', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2939', '2183', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2940', '2183', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2941', '2184', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2942', '2184', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2943', '2185', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2944', '2185', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2945', '2186', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2946', '2186', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2947', '2187', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2948', '2187', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2949', '2188', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2950', '2188', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2951', '2189', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2952', '2189', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2953', '2190', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2954', '2190', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2955', '2191', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2956', '2191', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2957', '2192', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2958', '2192', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2959', '2193', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2960', '2193', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2961', '2194', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2962', '2194', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2963', '2195', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2964', '2195', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2965', '2196', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2966', '2196', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2967', '2197', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2968', '2197', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2969', '2198', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2970', '2198', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2971', '2199', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2972', '2199', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2973', '2200', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2974', '2200', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2975', '2201', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2976', '2201', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2977', '2202', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2978', '2202', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2979', '2203', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2980', '2203', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2981', '2204', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2982', '2204', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2983', '2205', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2984', '2205', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2985', '2206', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2986', '2206', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2987', '2207', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2988', '2207', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2989', '2208', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2990', '2208', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2991', '2209', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2992', '2209', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2993', '2210', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2994', '2210', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2995', '2211', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2996', '2211', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2997', '2212', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2998', '2212', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('2999', '2213', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3000', '2213', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3001', '2214', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3002', '2214', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3003', '2215', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3004', '2215', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3005', '2216', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3006', '2216', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3007', '2217', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3008', '2217', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3009', '2218', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3010', '2218', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3011', '2219', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3012', '2219', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3013', '2220', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3014', '2220', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3015', '2221', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3016', '2221', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3017', '2222', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3018', '2222', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3019', '2223', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3020', '2223', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3021', '2224', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3022', '2224', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3023', '2225', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3024', '2225', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3025', '2226', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3026', '2226', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3027', '2227', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3028', '2227', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3029', '2228', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3030', '2228', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3031', '2229', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3032', '2229', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3033', '2230', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3034', '2230', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3035', '2231', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3036', '2231', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3037', '2232', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3038', '2232', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3039', '2233', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3040', '2233', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3041', '2234', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3042', '2234', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3043', '2235', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3044', '2235', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3045', '2236', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3046', '2236', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3047', '2237', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3048', '2237', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3049', '2238', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3050', '2238', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3051', '2239', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3052', '2239', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3053', '2240', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3054', '2240', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3055', '2241', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3056', '2241', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3057', '2242', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3058', '2242', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3059', '2243', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3060', '2243', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3061', '2244', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3062', '2244', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3063', '2245', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3064', '2245', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3065', '2246', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3066', '2246', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3067', '2247', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3068', '2247', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3069', '2248', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3070', '2248', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3071', '2249', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3072', '2249', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3073', '2250', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3074', '2250', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3075', '2251', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3076', '2251', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3077', '2252', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3078', '2252', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3079', '2253', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3080', '2253', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3081', '2254', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3082', '2254', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3083', '2255', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3084', '2255', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3085', '2256', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3086', '2256', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3087', '2257', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3088', '2257', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3089', '2258', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3090', '2258', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3091', '2259', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3092', '2259', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3093', '2260', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3094', '2260', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3095', '2261', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3096', '2261', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3097', '2262', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3098', '2262', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3099', '2263', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3100', '2263', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3101', '2264', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3102', '2264', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3103', '2265', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3104', '2265', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3105', '2266', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3106', '2266', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3107', '2267', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3108', '2267', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3109', '2268', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3110', '2268', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3111', '2269', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3112', '2269', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3113', '2270', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3114', '2270', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3115', '2271', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3116', '2271', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3117', '2272', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3118', '2272', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3135', '2289', '15', '2021-05-10 18:42:05', '1', '2', '2723602', '2021-05-06 16:28:02');
INSERT INTO `p_plan_task_detail` VALUES ('3136', '2290', '15', '2021-05-10 18:42:05', '1', '2', '2723602', '2021-05-06 16:44:17');
INSERT INTO `p_plan_task_detail` VALUES ('3137', '2291', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3138', '2292', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3139', '2293', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3140', '2294', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3141', '2295', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3142', '2296', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3154', '2308', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3155', '2309', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3156', '2310', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3157', '2311', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3158', '2312', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3159', '2313', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3160', '2314', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3161', '2315', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3162', '2316', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3163', '2317', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3164', '2318', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3165', '2319', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3166', '2320', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3167', '2321', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3168', '2322', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3169', '2323', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3170', '2324', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3171', '2325', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3172', '2326', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3173', '2327', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3174', '2328', '15', '2021-05-10 18:42:05', '0', '0', null, null);
INSERT INTO `p_plan_task_detail` VALUES ('3175', '2329', '15', '2021-05-10 18:42:05', '0', '0', null, null);

-- ----------------------------
-- Table structure for p_point
-- ----------------------------
DROP TABLE IF EXISTS `p_point`;
CREATE TABLE `p_point` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '点id',
  `route_id` varchar(1000) DEFAULT NULL COMMENT '路线id',
  `route_name` varchar(1000) DEFAULT NULL COMMENT '路线名称',
  `name` varchar(100) NOT NULL COMMENT '点名称',
  `point_no` varchar(100) NOT NULL DEFAULT '0' COMMENT '编号',
  `remark` varchar(1000) DEFAULT NULL COMMENT '备注说明',
  `save_gps` varchar(10) DEFAULT NULL COMMENT '是否保存地理信',
  `distance` int(11) DEFAULT NULL COMMENT '有效巡检距离',
  `usually_shot` varchar(10) DEFAULT NULL COMMENT '是否允许普通拍照',
  `shot_min_number` int(11) NOT NULL COMMENT '最小拍照数',
  `shot_max_number` int(11) NOT NULL COMMENT '最大拍照数',
  `fixed_shot` int(11) NOT NULL COMMENT '定点拍照数',
  `latitude` varchar(50) DEFAULT NULL COMMENT '经度',
  `longitude` varchar(50) DEFAULT NULL COMMENT '纬度',
  `address` varchar(1000) DEFAULT NULL COMMENT '参考地址',
  `offline` bit(1) DEFAULT NULL COMMENT '是否允许离线巡检:0不支持1支持',
  `is_fixed` varchar(50) DEFAULT NULL COMMENT '是否为固定',
  `catalog_id` int(11) DEFAULT NULL COMMENT '分类编号',
  `extend_json` longtext COMMENT '扩展字段',
  `is_score` varchar(50) DEFAULT NULL COMMENT '无计划巡检是否评分',
  `level` varchar(100) NOT NULL DEFAULT '1' COMMENT '风险等级',
  `last_update_time` datetime DEFAULT NULL COMMENT '最新更新时间',
  `creator_id` varchar(255) NOT NULL COMMENT '创建用户id',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `coordinates` varchar(100) DEFAULT NULL COMMENT '3维坐标',
  `ue4_location` text COMMENT 'ue4旋转',
  `ue4_rotation` text COMMENT 'ue4旋转',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
  `charge_dept_id` varchar(255) DEFAULT '0' COMMENT '责任部门id',
  `charge_person_id` varchar(255) DEFAULT NULL COMMENT '负责人id',
  `status` varchar(50) DEFAULT '0' COMMENT '状态：0 未纳入巡检，1 合格；2 不合格；3 漏检',
  `floor` int(4) DEFAULT '1' COMMENT '3维模型楼层',
  `error` varchar(1000) DEFAULT NULL COMMENT '最新不合格信息',
  `check_time` datetime DEFAULT NULL COMMENT '最新检查时间',
  `is_indoor` bit(1) DEFAULT b'0' COMMENT '是否室内：0表示室外，1表示室内',
  `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
  `risk_source_id` varchar(255) DEFAULT NULL COMMENT '风险区域id',
  `area_id` bigint(20) DEFAULT NULL COMMENT '物理区域id（数据来源于装备wl_area）',
  `area_name` varchar(255) DEFAULT NULL COMMENT '物理区域名称（数据来源于装备wl_area）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_point
-- ----------------------------
INSERT INTO `p_point` VALUES ('1', '', '', '主控楼一层', 'XJD0001', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 15:53:52', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '1385154709479944194', null, null);
INSERT INTO `p_point` VALUES ('2', '', '', '主控楼二层', 'XJD0002', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 15:54:52', '10', '', null, null, '\0', '1263370637087387649', null, '0', '2', null, null, '', null, '1385154775552815106', null, null);
INSERT INTO `p_point` VALUES ('3', '', '', '主控楼三层', 'XJD0003', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:02:48', '10', '', null, null, '\0', '1263370637087387649', null, '0', '3', null, null, '', null, '1385154826886901762', null, null);
INSERT INTO `p_point` VALUES ('4', '', '', '主控楼四楼', 'XJD0004', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:06:47', '10', '', null, null, '\0', '1263370637087387649', null, '0', '4', null, null, '\0', null, '1385154826886901762', null, null);
INSERT INTO `p_point` VALUES ('5', '', '', '主控室', 'XJD0005', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:08:00', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '1385153917645680642', null, null);
INSERT INTO `p_point` VALUES ('6', '', '', '极1辅控楼一层', 'XJD0006', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:08:47', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '1385154867693285377', null, null);
INSERT INTO `p_point` VALUES ('7', '', '', '极1辅控楼二层', 'XJD0007', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:09:41', '10', '', null, null, '\0', '1263370637087387649', null, '0', '2', null, null, '', null, '1385154906213773314', null, null);
INSERT INTO `p_point` VALUES ('8', '', '', '极1辅控楼三层', 'XJD0008', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', '2021-04-27 16:13:32', '3013601', '2021-04-27 16:10:38', '10', '', null, null, '\0', '1263370637087387649', null, '0', '3', null, null, '', null, '1385154944759427073', null, null);
INSERT INTO `p_point` VALUES ('9', '', '', '极2辅控楼一层', 'XJD0009', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:14:18', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '1385154993455296514', null, null);
INSERT INTO `p_point` VALUES ('10', '', '', '极2辅控楼二层', 'XJD0010', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:15:12', '10', '', null, null, '\0', '1263370637087387649', null, '0', '2', null, null, '', null, '1385155038057525250', null, null);
INSERT INTO `p_point` VALUES ('11', '', '', '极2辅控楼三层', 'XJD0011', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:16:07', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '1385155094353473537', null, null);
INSERT INTO `p_point` VALUES ('12', '', '', '综合楼一层', 'XJD0012', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', '2021-04-27 16:20:11', '3013601', '2021-04-27 16:17:13', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '1385156012411121666', null, null);
INSERT INTO `p_point` VALUES ('13', '', '', '综合楼二层', 'XJD0013', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:19:59', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '1385156056212238337', null, null);
INSERT INTO `p_point` VALUES ('14', '', '', '极Ⅰ高端阀厅', 'XJD0014', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:34:43', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '1385155470456713217', null, null);
INSERT INTO `p_point` VALUES ('15', '', '', '极Ⅰ低端阀厅', 'XJD0015', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:35:20', '10', '', null, null, '\0', '1263370637087387649', null, '1', '1', '', '2021-05-11 14:30:17', '', null, '1385155560999153666', null, null);
INSERT INTO `p_point` VALUES ('16', '', '', '极Ⅱ高端阀厅', 'XJD0016', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:36:15', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '\0', null, '1385155614413615105', null, null);
INSERT INTO `p_point` VALUES ('17', '', '', '极Ⅱ低端阀厅', 'XJD0017', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:36:54', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '1385155687834906626', null, null);
INSERT INTO `p_point` VALUES ('18', '', '', '极Ⅰ高端换流变6台', 'XJD0018', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:38:40', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '\0', null, '1385154147388682241', null, null);
INSERT INTO `p_point` VALUES ('19', '', '', '极Ⅰ低端换流变6台', 'XJD0019', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:39:18', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '\0', null, '1385154194293583873', null, null);
INSERT INTO `p_point` VALUES ('20', '', '', '极Ⅱ高端换流变6台', 'XJD0020', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:40:05', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '\0', null, '1385154274979409922', null, null);
INSERT INTO `p_point` VALUES ('21', '', '', '极Ⅱ低端换流变6台', 'XJD0021', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:40:49', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '\0', null, '1385154321888505858', null, null);
INSERT INTO `p_point` VALUES ('22', '', '', '综合水泵房', 'XJD0022', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:41:29', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '1385155932769677313', null, null);
INSERT INTO `p_point` VALUES ('23', '', '', '300m²消防水池', 'XJD0023', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:42:41', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '\0', null, '1385154526507626498', null, null);
INSERT INTO `p_point` VALUES ('24', '', '', '换流站500kV GIS室', 'XJD0024', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:45:13', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '1385154373423919106', null, null);
INSERT INTO `p_point` VALUES ('25', '', '', '调相机区一层', 'XJD0025', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:46:52', '10', '', null, null, '\0', '', '', '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('26', '', '', ' 调相机区二层', 'XJD0026', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:47:28', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('27', '', '', '换流站10kV站用电室', 'XJD0027', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:48:13', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('28', '', '', '换流站380/220V交流公用配电室', 'XJD0028', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:48:52', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('29', '', '', '1#2#主变泡沫消防间', 'XJD0029', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:49:39', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('30', '', '', '3#4#主变泡沫消防间', 'XJD0030', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:50:13', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('31', '', '', '#3#4主变水喷淋间', 'XJD0031', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:50:36', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('32', '', '', '1#继电器室', 'XJD0032', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:51:16', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('33', '', '', '2#继电器室', 'XJD0033', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:51:55', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('34', '', '', '3#继电器室', 'XJD0034', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:52:23', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('35', '', '', '4#继电器室', 'XJD0035', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:52:59', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('36', '', '', '5#继电器室', 'XJD0036', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:53:31', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('37', '', '', '6#继电器小室', 'XJD0037', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:53:59', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('38', '', '', '室外消防栓', 'XJD0038', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:54:47', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('39', '', '', '消防小室', 'XJD0039', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:55:26', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('40', '', '', '35kV小室', 'XJD0040', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:55:59', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('41', '', '', '极1高端雨淋阀间', 'XJD0041', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:56:35', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('42', '', '', '极1低端雨淋阀间', 'XJD0042', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:57:06', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('43', '', '', '极2低端雨淋阀间', 'XJD0043', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:57:43', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('44', '', '', '极2高端雨淋阀间', 'XJD0044', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 16:59:43', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('45', '', '', '换流站检修备品库 ', 'XJD0045', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 17:00:55', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('46', '', '', '极1换流变消防炮设备间', 'XJD0046', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 17:01:50', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('47', '', '', '极1换流变消防炮设备间', 'XJD0047', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 17:03:24', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('48', '', '', '极2高箱式雨淋阀室', 'XJD0048', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 17:06:13', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('49', '', '', ' 极2低箱式雨淋阀室', 'XJD0049', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 17:06:46', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('50', '', '', '极1低箱式雨淋阀室', 'XJD0050', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 17:07:19', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);
INSERT INTO `p_point` VALUES ('51', '', '', '极1高箱式雨淋阀室', 'XJD0051', '', '0', '0', '', '0', '10', '0', '', '', '', '', '1', '0', '', '0', '3', null, '3013601', '2021-04-27 17:07:50', '10', '', null, null, '\0', '1263370637087387649', null, '0', '1', null, null, '', null, '', null, null);

-- ----------------------------
-- Table structure for p_point_classify
-- ----------------------------
DROP TABLE IF EXISTS `p_point_classify`;
CREATE TABLE `p_point_classify` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检点分类id',
  `point_id` bigint(20) NOT NULL COMMENT '点id',
  `name` varchar(100) NOT NULL COMMENT '点分类名称',
  `creator_id` varchar(255) NOT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `order_no` int(11) DEFAULT NULL COMMENT '排序号',
  `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
  `equipment_id` varchar(255) DEFAULT NULL COMMENT '装备id',
  `inspection_spec_name` varchar(255) DEFAULT NULL COMMENT '巡查规范名称',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `point_id_index` (`point_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_point_classify
-- ----------------------------
INSERT INTO `p_point_classify` VALUES ('1', '15', 'test数据', '1', '2021-05-11 09:16:37', '1', '1', '1', '1');

-- ----------------------------
-- Table structure for p_point_config
-- ----------------------------
DROP TABLE IF EXISTS `p_point_config`;
CREATE TABLE `p_point_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(1000) DEFAULT NULL COMMENT '转发名称',
  `point_id` bigint(20) DEFAULT NULL COMMENT '巡检点ID',
  `point_code` varchar(255) DEFAULT NULL COMMENT '点编码',
  `infomation_address` int(20) DEFAULT NULL COMMENT '转发信息地址依次递增（唯一）',
  `status` bit(1) DEFAULT NULL COMMENT '巡检点状态（code=0时，status=1漏检，status=0正常；code=1时，status=1不合格，status=0合格）',
  `update_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否已经删除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=631 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_point_config
-- ----------------------------
INSERT INTO `p_point_config` VALUES ('519', '22222漏检', '73', 'N0000000073', '0', '\0', '2021-04-26 14:48:06', '\0');
INSERT INTO `p_point_config` VALUES ('520', '22222合格', '73', 'S0000000073', '0', '\0', '2021-04-26 14:48:06', '\0');
INSERT INTO `p_point_config` VALUES ('521', '主控楼一层漏检', '1', 'N0000000001', '0', '\0', '2021-04-27 15:36:14', '');
INSERT INTO `p_point_config` VALUES ('522', '主控楼一层合格', '1', 'S0000000001', '0', '\0', '2021-04-27 15:36:14', '');
INSERT INTO `p_point_config` VALUES ('523', '主控楼一层漏检', '2', 'N0000000002', '0', '\0', '2021-04-27 15:44:29', '\0');
INSERT INTO `p_point_config` VALUES ('524', '主控楼一层合格', '2', 'S0000000002', '0', '\0', '2021-04-27 15:44:29', '\0');
INSERT INTO `p_point_config` VALUES ('525', '主控楼二层漏检', '3', 'N0000000003', '0', '\0', '2021-04-27 15:47:07', '\0');
INSERT INTO `p_point_config` VALUES ('526', '主控楼二层合格', '3', 'S0000000003', '0', '\0', '2021-04-27 15:47:07', '\0');
INSERT INTO `p_point_config` VALUES ('527', '主控楼三层漏检', '4', 'N0000000004', '0', '\0', '2021-04-27 15:48:22', '\0');
INSERT INTO `p_point_config` VALUES ('528', '主控楼三层合格', '4', 'S0000000004', '0', '\0', '2021-04-27 15:48:22', '\0');
INSERT INTO `p_point_config` VALUES ('529', '主控楼一层漏检', '1', 'N0000000001', '0', '\0', '2021-04-27 15:53:52', '\0');
INSERT INTO `p_point_config` VALUES ('530', '主控楼一层合格', '1', 'S0000000001', '0', '\0', '2021-04-27 15:53:52', '\0');
INSERT INTO `p_point_config` VALUES ('531', '主控楼二层漏检', '2', 'N0000000002', '0', '\0', '2021-04-27 15:54:52', '\0');
INSERT INTO `p_point_config` VALUES ('532', '主控楼二层合格', '2', 'S0000000002', '0', '\0', '2021-04-27 15:54:52', '\0');
INSERT INTO `p_point_config` VALUES ('533', '主控楼三层漏检', '3', 'N0000000003', '0', '\0', '2021-04-27 16:02:47', '\0');
INSERT INTO `p_point_config` VALUES ('534', '主控楼三层合格', '3', 'S0000000003', '0', '\0', '2021-04-27 16:02:47', '\0');
INSERT INTO `p_point_config` VALUES ('535', '主控楼四楼漏检', '4', 'N0000000004', '0', '\0', '2021-04-27 16:06:47', '\0');
INSERT INTO `p_point_config` VALUES ('536', '主控楼四楼合格', '4', 'S0000000004', '0', '\0', '2021-04-27 16:06:47', '\0');
INSERT INTO `p_point_config` VALUES ('537', '主控室漏检', '5', 'N0000000005', '0', '\0', '2021-04-27 16:07:59', '\0');
INSERT INTO `p_point_config` VALUES ('538', '主控室合格', '5', 'S0000000005', '0', '\0', '2021-04-27 16:07:59', '\0');
INSERT INTO `p_point_config` VALUES ('539', '极1辅控楼一层漏检', '6', 'N0000000006', '0', '\0', '2021-04-27 16:08:46', '\0');
INSERT INTO `p_point_config` VALUES ('540', '极1辅控楼一层合格', '6', 'S0000000006', '0', '\0', '2021-04-27 16:08:46', '\0');
INSERT INTO `p_point_config` VALUES ('541', '极1辅控楼二层漏检', '7', 'N0000000007', '0', '\0', '2021-04-27 16:09:40', '\0');
INSERT INTO `p_point_config` VALUES ('542', '极1辅控楼二层合格', '7', 'S0000000007', '0', '\0', '2021-04-27 16:09:40', '\0');
INSERT INTO `p_point_config` VALUES ('543', '极1辅控楼二层漏检', '8', 'N0000000008', '0', '\0', '2021-04-27 16:10:38', '\0');
INSERT INTO `p_point_config` VALUES ('544', '极1辅控楼二层合格', '8', 'S0000000008', '0', '\0', '2021-04-27 16:10:38', '\0');
INSERT INTO `p_point_config` VALUES ('545', '极2辅控楼一层漏检', '9', 'N0000000009', '0', '\0', '2021-04-27 16:14:17', '\0');
INSERT INTO `p_point_config` VALUES ('546', '极2辅控楼一层合格', '9', 'S0000000009', '0', '\0', '2021-04-27 16:14:17', '\0');
INSERT INTO `p_point_config` VALUES ('547', '极2辅控楼二层漏检', '10', 'N0000000010', '0', '\0', '2021-04-27 16:15:11', '\0');
INSERT INTO `p_point_config` VALUES ('548', '极2辅控楼二层合格', '10', 'S0000000010', '0', '\0', '2021-04-27 16:15:11', '\0');
INSERT INTO `p_point_config` VALUES ('549', '极2辅控楼三层漏检', '11', 'N0000000011', '0', '\0', '2021-04-27 16:16:07', '\0');
INSERT INTO `p_point_config` VALUES ('550', '极2辅控楼三层合格', '11', 'S0000000011', '0', '\0', '2021-04-27 16:16:07', '\0');
INSERT INTO `p_point_config` VALUES ('551', '综合楼一层漏检', '12', 'N0000000012', '0', '\0', '2021-04-27 16:17:12', '\0');
INSERT INTO `p_point_config` VALUES ('552', '综合楼一层合格', '12', 'S0000000012', '0', '\0', '2021-04-27 16:17:12', '\0');
INSERT INTO `p_point_config` VALUES ('553', '综合楼二层漏检', '13', 'N0000000013', '0', '\0', '2021-04-27 16:19:59', '\0');
INSERT INTO `p_point_config` VALUES ('554', '综合楼二层合格', '13', 'S0000000013', '0', '\0', '2021-04-27 16:19:59', '\0');
INSERT INTO `p_point_config` VALUES ('555', '极Ⅰ高端阀厅漏检', '14', 'N0000000014', '0', '\0', '2021-04-27 16:34:42', '\0');
INSERT INTO `p_point_config` VALUES ('556', '极Ⅰ高端阀厅合格', '14', 'S0000000014', '0', '\0', '2021-04-27 16:34:42', '\0');
INSERT INTO `p_point_config` VALUES ('557', '极Ⅰ低端阀厅漏检', '15', 'N0000000015', '0', '\0', '2021-04-27 16:35:20', '\0');
INSERT INTO `p_point_config` VALUES ('558', '极Ⅰ低端阀厅合格', '15', 'S0000000015', '0', '\0', '2021-04-27 16:35:20', '\0');
INSERT INTO `p_point_config` VALUES ('559', '极Ⅱ高端阀厅漏检', '16', 'N0000000016', '0', '\0', '2021-04-27 16:36:15', '\0');
INSERT INTO `p_point_config` VALUES ('560', '极Ⅱ高端阀厅合格', '16', 'S0000000016', '0', '\0', '2021-04-27 16:36:15', '\0');
INSERT INTO `p_point_config` VALUES ('561', '极Ⅱ低端阀厅漏检', '17', 'N0000000017', '0', '\0', '2021-04-27 16:36:53', '\0');
INSERT INTO `p_point_config` VALUES ('562', '极Ⅱ低端阀厅合格', '17', 'S0000000017', '0', '\0', '2021-04-27 16:36:53', '\0');
INSERT INTO `p_point_config` VALUES ('563', '极Ⅰ高端换流变6台漏检', '18', 'N0000000018', '0', '\0', '2021-04-27 16:38:39', '\0');
INSERT INTO `p_point_config` VALUES ('564', '极Ⅰ高端换流变6台合格', '18', 'S0000000018', '0', '\0', '2021-04-27 16:38:39', '\0');
INSERT INTO `p_point_config` VALUES ('565', '极Ⅰ低端换流变6台漏检', '19', 'N0000000019', '0', '\0', '2021-04-27 16:39:17', '\0');
INSERT INTO `p_point_config` VALUES ('566', '极Ⅰ低端换流变6台合格', '19', 'S0000000019', '0', '\0', '2021-04-27 16:39:17', '\0');
INSERT INTO `p_point_config` VALUES ('567', '极Ⅱ高端换流变6台漏检', '20', 'N0000000020', '0', '\0', '2021-04-27 16:40:04', '\0');
INSERT INTO `p_point_config` VALUES ('568', '极Ⅱ高端换流变6台合格', '20', 'S0000000020', '0', '\0', '2021-04-27 16:40:04', '\0');
INSERT INTO `p_point_config` VALUES ('569', '极Ⅱ低端换流变6台漏检', '21', 'N0000000021', '0', '\0', '2021-04-27 16:40:48', '\0');
INSERT INTO `p_point_config` VALUES ('570', '极Ⅱ低端换流变6台合格', '21', 'S0000000021', '0', '\0', '2021-04-27 16:40:48', '\0');
INSERT INTO `p_point_config` VALUES ('571', '综合水泵房漏检', '22', 'N0000000022', '0', '\0', '2021-04-27 16:41:29', '\0');
INSERT INTO `p_point_config` VALUES ('572', '综合水泵房合格', '22', 'S0000000022', '0', '\0', '2021-04-27 16:41:29', '\0');
INSERT INTO `p_point_config` VALUES ('573', '300m²消防水池漏检', '23', 'N0000000023', '0', '\0', '2021-04-27 16:42:40', '\0');
INSERT INTO `p_point_config` VALUES ('574', '300m²消防水池合格', '23', 'S0000000023', '0', '\0', '2021-04-27 16:42:40', '\0');
INSERT INTO `p_point_config` VALUES ('575', '换流站500kV GIS室漏检', '24', 'N0000000024', '0', '\0', '2021-04-27 16:45:13', '\0');
INSERT INTO `p_point_config` VALUES ('576', '换流站500kV GIS室合格', '24', 'S0000000024', '0', '\0', '2021-04-27 16:45:13', '\0');
INSERT INTO `p_point_config` VALUES ('577', '调相机区一层漏检', '25', 'N0000000025', '0', '\0', '2021-04-27 16:46:51', '\0');
INSERT INTO `p_point_config` VALUES ('578', '调相机区一层合格', '25', 'S0000000025', '0', '\0', '2021-04-27 16:46:51', '\0');
INSERT INTO `p_point_config` VALUES ('579', ' 调相机区二层漏检', '26', 'N0000000026', '0', '\0', '2021-04-27 16:47:28', '\0');
INSERT INTO `p_point_config` VALUES ('580', ' 调相机区二层合格', '26', 'S0000000026', '0', '\0', '2021-04-27 16:47:28', '\0');
INSERT INTO `p_point_config` VALUES ('581', '换流站10kV站用电室漏检', '27', 'N0000000027', '0', '\0', '2021-04-27 16:48:12', '\0');
INSERT INTO `p_point_config` VALUES ('582', '换流站10kV站用电室合格', '27', 'S0000000027', '0', '\0', '2021-04-27 16:48:12', '\0');
INSERT INTO `p_point_config` VALUES ('583', '换流站380/220V交流公用配电室漏检', '28', 'N0000000028', '0', '\0', '2021-04-27 16:48:52', '\0');
INSERT INTO `p_point_config` VALUES ('584', '换流站380/220V交流公用配电室合格', '28', 'S0000000028', '0', '\0', '2021-04-27 16:48:52', '\0');
INSERT INTO `p_point_config` VALUES ('585', '1#2#主变泡沫消防间漏检', '29', 'N0000000029', '0', '\0', '2021-04-27 16:49:39', '\0');
INSERT INTO `p_point_config` VALUES ('586', '1#2#主变泡沫消防间合格', '29', 'S0000000029', '0', '\0', '2021-04-27 16:49:39', '\0');
INSERT INTO `p_point_config` VALUES ('587', '3#4#主变泡沫消防间漏检', '30', 'N0000000030', '0', '\0', '2021-04-27 16:50:12', '\0');
INSERT INTO `p_point_config` VALUES ('588', '3#4#主变泡沫消防间合格', '30', 'S0000000030', '0', '\0', '2021-04-27 16:50:12', '\0');
INSERT INTO `p_point_config` VALUES ('589', '#3#4主变水喷淋间漏检', '31', 'N0000000031', '0', '\0', '2021-04-27 16:50:36', '\0');
INSERT INTO `p_point_config` VALUES ('590', '#3#4主变水喷淋间合格', '31', 'S0000000031', '0', '\0', '2021-04-27 16:50:36', '\0');
INSERT INTO `p_point_config` VALUES ('591', '1#继电器室漏检', '32', 'N0000000032', '0', '\0', '2021-04-27 16:51:15', '\0');
INSERT INTO `p_point_config` VALUES ('592', '1#继电器室合格', '32', 'S0000000032', '0', '\0', '2021-04-27 16:51:15', '\0');
INSERT INTO `p_point_config` VALUES ('593', '2#继电器室漏检', '33', 'N0000000033', '0', '\0', '2021-04-27 16:51:55', '\0');
INSERT INTO `p_point_config` VALUES ('594', '2#继电器室合格', '33', 'S0000000033', '0', '\0', '2021-04-27 16:51:55', '\0');
INSERT INTO `p_point_config` VALUES ('595', '3#继电器室漏检', '34', 'N0000000034', '0', '\0', '2021-04-27 16:52:23', '\0');
INSERT INTO `p_point_config` VALUES ('596', '3#继电器室合格', '34', 'S0000000034', '0', '\0', '2021-04-27 16:52:23', '\0');
INSERT INTO `p_point_config` VALUES ('597', '4#继电器室漏检', '35', 'N0000000035', '0', '\0', '2021-04-27 16:52:58', '\0');
INSERT INTO `p_point_config` VALUES ('598', '4#继电器室合格', '35', 'S0000000035', '0', '\0', '2021-04-27 16:52:58', '\0');
INSERT INTO `p_point_config` VALUES ('599', '5#继电器室漏检', '36', 'N0000000036', '0', '\0', '2021-04-27 16:53:31', '\0');
INSERT INTO `p_point_config` VALUES ('600', '5#继电器室合格', '36', 'S0000000036', '0', '\0', '2021-04-27 16:53:31', '\0');
INSERT INTO `p_point_config` VALUES ('601', '6#继电器小室漏检', '37', 'N0000000037', '0', '\0', '2021-04-27 16:53:58', '\0');
INSERT INTO `p_point_config` VALUES ('602', '6#继电器小室合格', '37', 'S0000000037', '0', '\0', '2021-04-27 16:53:58', '\0');
INSERT INTO `p_point_config` VALUES ('603', '室外消防栓漏检', '38', 'N0000000038', '0', '\0', '2021-04-27 16:54:47', '\0');
INSERT INTO `p_point_config` VALUES ('604', '室外消防栓合格', '38', 'S0000000038', '0', '\0', '2021-04-27 16:54:47', '\0');
INSERT INTO `p_point_config` VALUES ('605', '消防小室漏检', '39', 'N0000000039', '0', '\0', '2021-04-27 16:55:25', '\0');
INSERT INTO `p_point_config` VALUES ('606', '消防小室合格', '39', 'S0000000039', '0', '\0', '2021-04-27 16:55:25', '\0');
INSERT INTO `p_point_config` VALUES ('607', '35kV小室漏检', '40', 'N0000000040', '0', '\0', '2021-04-27 16:55:59', '\0');
INSERT INTO `p_point_config` VALUES ('608', '35kV小室合格', '40', 'S0000000040', '0', '\0', '2021-04-27 16:55:59', '\0');
INSERT INTO `p_point_config` VALUES ('609', '极1高端雨淋阀间漏检', '41', 'N0000000041', '0', '\0', '2021-04-27 16:56:35', '\0');
INSERT INTO `p_point_config` VALUES ('610', '极1高端雨淋阀间合格', '41', 'S0000000041', '0', '\0', '2021-04-27 16:56:35', '\0');
INSERT INTO `p_point_config` VALUES ('611', '极1低端雨淋阀间漏检', '42', 'N0000000042', '0', '\0', '2021-04-27 16:57:05', '\0');
INSERT INTO `p_point_config` VALUES ('612', '极1低端雨淋阀间合格', '42', 'S0000000042', '0', '\0', '2021-04-27 16:57:05', '\0');
INSERT INTO `p_point_config` VALUES ('613', '极2低端雨淋阀间漏检', '43', 'N0000000043', '0', '\0', '2021-04-27 16:57:43', '\0');
INSERT INTO `p_point_config` VALUES ('614', '极2低端雨淋阀间合格', '43', 'S0000000043', '0', '\0', '2021-04-27 16:57:43', '\0');
INSERT INTO `p_point_config` VALUES ('615', '极2高端雨淋阀间漏检', '44', 'N0000000044', '0', '\0', '2021-04-27 16:59:42', '\0');
INSERT INTO `p_point_config` VALUES ('616', '极2高端雨淋阀间合格', '44', 'S0000000044', '0', '\0', '2021-04-27 16:59:42', '\0');
INSERT INTO `p_point_config` VALUES ('617', '换流站检修备品库 漏检', '45', 'N0000000045', '0', '\0', '2021-04-27 17:00:54', '\0');
INSERT INTO `p_point_config` VALUES ('618', '换流站检修备品库 合格', '45', 'S0000000045', '0', '\0', '2021-04-27 17:00:54', '\0');
INSERT INTO `p_point_config` VALUES ('619', '极1换流变消防炮设备间漏检', '46', 'N0000000046', '0', '\0', '2021-04-27 17:01:49', '\0');
INSERT INTO `p_point_config` VALUES ('620', '极1换流变消防炮设备间合格', '46', 'S0000000046', '0', '\0', '2021-04-27 17:01:49', '\0');
INSERT INTO `p_point_config` VALUES ('621', '极1换流变消防炮设备间漏检', '47', 'N0000000047', '0', '\0', '2021-04-27 17:03:23', '\0');
INSERT INTO `p_point_config` VALUES ('622', '极1换流变消防炮设备间合格', '47', 'S0000000047', '0', '\0', '2021-04-27 17:03:23', '\0');
INSERT INTO `p_point_config` VALUES ('623', '极2高箱式雨淋阀室漏检', '48', 'N0000000048', '0', '\0', '2021-04-27 17:06:12', '\0');
INSERT INTO `p_point_config` VALUES ('624', '极2高箱式雨淋阀室合格', '48', 'S0000000048', '0', '\0', '2021-04-27 17:06:12', '\0');
INSERT INTO `p_point_config` VALUES ('625', ' 极2低箱式雨淋阀室漏检', '49', 'N0000000049', '0', '\0', '2021-04-27 17:06:46', '\0');
INSERT INTO `p_point_config` VALUES ('626', ' 极2低箱式雨淋阀室合格', '49', 'S0000000049', '0', '\0', '2021-04-27 17:06:46', '\0');
INSERT INTO `p_point_config` VALUES ('627', '极1低箱式雨淋阀室漏检', '50', 'N0000000050', '0', '\0', '2021-04-27 17:07:19', '\0');
INSERT INTO `p_point_config` VALUES ('628', '极1低箱式雨淋阀室合格', '50', 'S0000000050', '0', '\0', '2021-04-27 17:07:19', '\0');
INSERT INTO `p_point_config` VALUES ('629', '极1高箱式雨淋阀室漏检', '51', 'N0000000051', '0', '\0', '2021-04-27 17:07:49', '\0');
INSERT INTO `p_point_config` VALUES ('630', '极1高箱式雨淋阀室合格', '51', 'S0000000051', '0', '\0', '2021-04-27 17:07:49', '\0');

-- ----------------------------
-- Table structure for p_point_inputitem
-- ----------------------------
DROP TABLE IF EXISTS `p_point_inputitem`;
CREATE TABLE `p_point_inputitem` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `point_id` bigint(20) NOT NULL COMMENT '巡检点id',
  `input_item_id` bigint(20) NOT NULL COMMENT '巡检项id',
  `classify_ids` varchar(255) DEFAULT NULL COMMENT '点分类id集合',
  `order_no` int(11) DEFAULT NULL COMMENT '排序号',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_point_inputitem
-- ----------------------------

-- ----------------------------
-- Table structure for p_point_photo
-- ----------------------------
DROP TABLE IF EXISTS `p_point_photo`;
CREATE TABLE `p_point_photo` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检点图片编号',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `point_id` bigint(20) NOT NULL COMMENT '巡检点id',
  `order_no` int(11) NOT NULL COMMENT '序号',
  `photo_path` varchar(200) DEFAULT NULL COMMENT '图片路径',
  `file_name` varchar(200) DEFAULT NULL COMMENT '图片名称',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_point_photo
-- ----------------------------

-- ----------------------------
-- Table structure for p_route
-- ----------------------------
DROP TABLE IF EXISTS `p_route`;
CREATE TABLE `p_route` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '巡检路线id',
  `creator_id` varchar(255) NOT NULL COMMENT '创建人id',
  `org_code` varchar(100) NOT NULL COMMENT '权限系统org code',
  `name` varchar(50) NOT NULL COMMENT '路线名称',
  `boss` varchar(255) DEFAULT NULL COMMENT '负责人',
  `tel` varchar(50) DEFAULT NULL COMMENT '联系电话',
  `remark` varchar(1000) DEFAULT NULL COMMENT '备注说明',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `coordinates` varchar(500) DEFAULT NULL COMMENT '路线3维坐标',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除：0表示未删除，1表示已删除',
  `dept_id` varchar(255) DEFAULT '0',
  `user_id` varchar(255) DEFAULT '0',
  `original_id` varchar(50) DEFAULT NULL COMMENT '原始字段',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_route
-- ----------------------------
INSERT INTO `p_route` VALUES ('8', '3024170', '10', '换流变', '', '', '', '2021-04-26 15:09:52', null, '\0', '', '', null);

-- ----------------------------
-- Table structure for p_route_point
-- ----------------------------
DROP TABLE IF EXISTS `p_route_point`;
CREATE TABLE `p_route_point` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_code` varchar(100) NOT NULL COMMENT '权限org code',
  `route_id` bigint(20) NOT NULL COMMENT '路线id',
  `point_id` bigint(20) NOT NULL COMMENT '点id',
  `order_no` int(11) DEFAULT '0' COMMENT '排序',
  `creator_id` varchar(255) NOT NULL COMMENT '创建人id',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `exclude_items` varchar(1000) DEFAULT NULL COMMENT '巡查项排除',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_route_point
-- ----------------------------

-- ----------------------------
-- Table structure for p_route_point_item
-- ----------------------------
DROP TABLE IF EXISTS `p_route_point_item`;
CREATE TABLE `p_route_point_item` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `route_point_id` bigint(20) NOT NULL COMMENT '路线点id',
  `order_no` int(11) DEFAULT NULL COMMENT '排序号',
  `point_input_item_id` bigint(20) DEFAULT NULL COMMENT '检查点-项id',
  `creator_id` varchar(255) DEFAULT NULL,
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `point_classify_id` bigint(20) DEFAULT NULL COMMENT '检查点扩展分类id',
  `basis_json` text COMMENT '标准依据',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_route_point_item
-- ----------------------------

-- ----------------------------
-- Table structure for p_task
-- ----------------------------
DROP TABLE IF EXISTS `p_task`;
CREATE TABLE `p_task` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `org_code` varchar(100) DEFAULT NULL COMMENT '公司id',
  `title` varchar(500) DEFAULT NULL COMMENT '任务标题',
  `publisher` varchar(255) DEFAULT NULL COMMENT '任务发布人id',
  `dep_id` varchar(255) DEFAULT NULL COMMENT '执行人部门',
  `publisher_name` varchar(40) DEFAULT NULL COMMENT '任务发布人名称',
  `publish_time` datetime DEFAULT NULL COMMENT '任务发布时间',
  `finish_time` datetime DEFAULT NULL COMMENT '任务应该完成时间',
  `fact_finish_time` datetime DEFAULT NULL COMMENT '任务实际完成时间',
  `is_warn` varchar(50) DEFAULT NULL COMMENT '是否告警通知（1 通知 ； 2 不通知 ）',
  `status` int(11) DEFAULT NULL COMMENT '任务状态0 处理中，1已完成2取消3超时',
  `warn_time` datetime DEFAULT NULL COMMENT '告警通知时间',
  `feedback_num` int(11) DEFAULT NULL COMMENT '回复个数',
  `executor` varchar(2000) DEFAULT NULL COMMENT '任务执行人',
  `depth` int(11) DEFAULT NULL COMMENT '当前任务发转次数',
  `max_depth` int(11) DEFAULT NULL COMMENT '任务最大转发次数',
  `remark` varchar(1000) DEFAULT NULL COMMENT '说明',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `config` longtext COMMENT '任务拍照配置',
  `executor_id` varchar(255) NOT NULL,
  `check_id` bigint(20) DEFAULT '0' COMMENT '任务关联检查项ID',
  `point_id` bigint(11) DEFAULT '0' COMMENT '任务关联巡检点id',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `check_id_index` (`check_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_task
-- ----------------------------

-- ----------------------------
-- Table structure for p_task_detail
-- ----------------------------
DROP TABLE IF EXISTS `p_task_detail`;
CREATE TABLE `p_task_detail` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) DEFAULT NULL COMMENT '任务id',
  `item_id` bigint(20) DEFAULT NULL COMMENT '检查项ID',
  `check_id` bigint(20) DEFAULT NULL COMMENT '检查记录id',
  `status` int(11) DEFAULT NULL COMMENT '任务相状态（1.完成，2.未完成，3.执行中）',
  `remark` varchar(1000) DEFAULT NULL COMMENT '描述说明',
  `point_id` bigint(20) DEFAULT NULL COMMENT '巡检点ID',
  `route_id` bigint(20) DEFAULT NULL COMMENT '路线ID',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_task_detail
-- ----------------------------

-- ----------------------------
-- Table structure for p_task_feedback
-- ----------------------------
DROP TABLE IF EXISTS `p_task_feedback`;
CREATE TABLE `p_task_feedback` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_code` varchar(100) NOT NULL COMMENT '组织编码',
  `task_id` bigint(20) NOT NULL COMMENT '任务ID',
  `user_id` varchar(255) NOT NULL COMMENT '任务回复人ID',
  `user_name` varchar(50) NOT NULL COMMENT '任务回复人名称',
  `feedback_time` datetime NOT NULL COMMENT '回复时间',
  `message` text COMMENT '任务回复信息',
  `picture_number` int(11) DEFAULT NULL COMMENT '拍照个数',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  `message_type` varchar(20) DEFAULT NULL COMMENT '任务类型',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_task_feedback
-- ----------------------------

-- ----------------------------
-- Table structure for p_task_forward_log
-- ----------------------------
DROP TABLE IF EXISTS `p_task_forward_log`;
CREATE TABLE `p_task_forward_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) DEFAULT NULL COMMENT '任务ID',
  `executor` varchar(255) DEFAULT NULL COMMENT '任务执行人',
  `executor_id` varchar(255) DEFAULT NULL,
  `created_by` bigint(20) DEFAULT NULL COMMENT '记录创建者',
  `content` varchar(2000) DEFAULT NULL COMMENT '任务转发记录详情',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_task_forward_log
-- ----------------------------

-- ----------------------------
-- Table structure for p_task_picture
-- ----------------------------
DROP TABLE IF EXISTS `p_task_picture`;
CREATE TABLE `p_task_picture` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `org_code` varchar(100) NOT NULL COMMENT '组织编码',
  `task_id` bigint(20) NOT NULL COMMENT '任务ID',
  `feedback_id` bigint(20) NOT NULL COMMENT '任务回复ID',
  `photo_data` longtext NOT NULL COMMENT '回复照片',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of p_task_picture
-- ----------------------------

-- ----------------------------
-- Table structure for toip_rm_snapshot
-- ----------------------------
DROP TABLE IF EXISTS `toip_rm_snapshot`;
CREATE TABLE `toip_rm_snapshot` (
  `id` varchar(36) NOT NULL,
  `batch_no` varchar(36) NOT NULL COMMENT '规则执行的批次号',
  `package_id` varchar(36) DEFAULT NULL COMMENT '规则id',
  `method_class` varchar(255) NOT NULL COMMENT 'bean方法的类名',
  `method_name` varchar(255) NOT NULL COMMENT 'bean方法名',
  `equipment_id` varchar(32) DEFAULT NULL COMMENT '设备类型',
  `method_param` varchar(2000) DEFAULT NULL COMMENT '方法参数',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `create_millisecond` varchar(64) NOT NULL COMMENT '当前动作执行时的毫秒数',
  `previous_interval` bigint(20) NOT NULL COMMENT '与上一次的动作执行的时间差',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of toip_rm_snapshot
-- ----------------------------

-- ----------------------------
-- Table structure for toip_sys_log
-- ----------------------------
DROP TABLE IF EXISTS `toip_sys_log`;
CREATE TABLE `toip_sys_log` (
  `id` varchar(36) DEFAULT NULL,
  `time` datetime DEFAULT NULL COMMENT '时间',
  `context` text COMMENT '内容',
  `type` varchar(36) DEFAULT NULL COMMENT '类型',
  `biz_id` varchar(36) DEFAULT NULL COMMENT '业务表id',
  `bizclass_name` varchar(255) DEFAULT NULL COMMENT '实体名，例如com.yeejoin.amos.toip.bizrulebridge.entity.Fire',
  `ip` varchar(20) DEFAULT NULL COMMENT 'ip',
  `result` varchar(255) DEFAULT NULL COMMENT '结果',
  `remark` text COMMENT '备注，预留字段',
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(50) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(50) DEFAULT NULL,
  `action_id` varchar(36) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='日志表';

-- ----------------------------
-- Records of toip_sys_log
-- ----------------------------

-- ----------------------------
-- Table structure for toip_sys_message
-- ----------------------------
DROP TABLE IF EXISTS `toip_sys_message`;
CREATE TABLE `toip_sys_message` (
  `id` varchar(36) DEFAULT NULL,
  `time` datetime DEFAULT NULL COMMENT '时间',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `content` longtext COMMENT '内容',
  `type` varchar(36) DEFAULT NULL COMMENT '类型',
  `sender` varchar(255) DEFAULT NULL COMMENT '发送者',
  `receiver` varchar(255) DEFAULT NULL COMMENT '接受者',
  `reader` varchar(255) DEFAULT NULL COMMENT '阅读者',
  `biz_id` varchar(36) DEFAULT NULL COMMENT '业务关联表id',
  `bizclass_name` varchar(255) DEFAULT NULL COMMENT '实体名，例如com.yeejoin.amos.toip.bizrulebridge.entity.Fire',
  `create_date` datetime DEFAULT NULL,
  `create_user` varchar(50) DEFAULT NULL,
  `update_date` datetime DEFAULT NULL,
  `update_user` varchar(50) DEFAULT NULL,
  `is_delete` bit(1) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消息表';

-- ----------------------------
-- Records of toip_sys_message
-- ----------------------------

-- ----------------------------
-- Table structure for wl_analysis_report_log
-- ----------------------------
DROP TABLE IF EXISTS `wl_analysis_report_log`;
CREATE TABLE `wl_analysis_report_log` (
  `id` bigint(20) NOT NULL COMMENT 'id',
  `org_code` varchar(255) DEFAULT NULL COMMENT '部门code',
  `name` varchar(255) DEFAULT NULL COMMENT '报告名称',
  `report_type` tinyint(4) DEFAULT NULL COMMENT '0日对比，1周分析，2月总结',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `report_date_desc` varchar(255) DEFAULT NULL COMMENT '报告日期描述',
  `start_date` date DEFAULT NULL COMMENT '开始时间',
  `end_date` date DEFAULT NULL COMMENT '结束时间',
  PRIMARY KEY (`id`),
  KEY `index_name` (`start_date`,`end_date`,`report_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='报告流水表';

-- ----------------------------
-- Records of wl_analysis_report_log
-- ----------------------------
INSERT INTO `wl_analysis_report_log` VALUES ('1399757630557278210', null, '消防系统日对比分析报告', '0', '2021-06-02 00:00:00', '2021年6月1日', '2021-06-01', '2021-06-01');
INSERT INTO `wl_analysis_report_log` VALUES ('1400120018435457025', null, '消防系统日对比分析报告', '0', '2021-06-03 00:00:00', '2021年6月2日', '2021-06-02', '2021-06-02');
INSERT INTO `wl_analysis_report_log` VALUES ('1401931957734207490', null, '消防系统日对比分析报告', '0', '2021-06-08 00:00:00', '2021年6月7日', '2021-06-07', '2021-06-07');
INSERT INTO `wl_analysis_report_log` VALUES ('1402294345541083138', null, '消防系统日对比分析报告', '0', '2021-06-09 00:00:00', '2021年6月8日', '2021-06-08', '2021-06-08');

-- ----------------------------
-- Table structure for wl_area
-- ----------------------------
DROP TABLE IF EXISTS `wl_area`;
CREATE TABLE `wl_area` (
  `id` bigint(20) NOT NULL COMMENT '物理主键',
  `name` varchar(50) NOT NULL COMMENT '区域名称',
  `code` varchar(50) DEFAULT NULL COMMENT '区域编码',
  `type` varchar(50) DEFAULT NULL COMMENT '区域类型',
  `parent_id` bigint(20) DEFAULT NULL COMMENT '父id',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `org_code` varchar(255) DEFAULT NULL COMMENT '单位编码',
  `is_delete` bit(1) DEFAULT b'0' COMMENT '是否删除:0-否；1-是',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '创建者id',
  `risk_point_id` bigint(20) NOT NULL COMMENT '风险区域父节点id',
  `create_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_code` (`code`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE,
  KEY `idx_parent_id` (`parent_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='区域';

-- ----------------------------
-- Records of wl_area
-- ----------------------------
INSERT INTO `wl_area` VALUES ('1394214045330100226', '111', '222', '0', '0', null, null, '', null, '87', '2021-05-17 16:51:51');
INSERT INTO `wl_area` VALUES ('1395319936792125441', '综合楼', '1223334488888888', '0', '0', null, null, '', null, '16', '2021-05-20 18:06:25');
INSERT INTO `wl_area` VALUES ('1395653622330712066', '123', '123', '0', '0', '123', '10', '\0', '1805525', '138', '2021-05-24 11:26:55');
INSERT INTO `wl_area` VALUES ('1395654412713746433', '1234', '1234', '0', '1395653622330712066', null, null, '', null, '3', '2021-05-24 11:39:04');
INSERT INTO `wl_area` VALUES ('1402184034238590977', '456', '1234', '0', '0', null, '10', '\0', '1805525', '8', '2021-06-08 16:41:40');

-- ----------------------------
-- Table structure for wl_building
-- ----------------------------
DROP TABLE IF EXISTS `wl_building`;
CREATE TABLE `wl_building` (
  `id` bigint(20) NOT NULL COMMENT '主键',
  `code` char(20) NOT NULL COMMENT '编码',
  `name` char(100) NOT NULL COMMENT '名称',
  `address` char(255) DEFAULT NULL COMMENT '地址',
  `equipment_code` char(20) NOT NULL COMMENT '类型（数据来自于装备定义--其他类消防装备器材--消防重点部位下面的选项）',
  `system_id` bigint(20) DEFAULT NULL COMMENT '数据来自于消防设施系统列表',
  `area_measure` double DEFAULT NULL COMMENT '面积(㎡)',
  `height` double DEFAULT NULL COMMENT '高度/最大液位(㎡)',
  `warn_height` double DEFAULT NULL COMMENT '告警液位(㎡)',
  `region_id` bigint(20) NOT NULL COMMENT '区域id',
  `region_name` char(100) NOT NULL COMMENT '区域名称',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `creator_name` char(100) DEFAULT NULL COMMENT '创建人名',
  `company_name` char(100) DEFAULT NULL COMMENT '公司名称',
  `org_code` char(100) DEFAULT NULL COMMENT '公司code',
  `department_name` char(100) DEFAULT NULL COMMENT '部门名称',
  `department_orgcode` char(100) DEFAULT NULL COMMENT '部门code',
  `equipment_category_name` char(100) DEFAULT NULL COMMENT '分类名称',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of wl_building
-- ----------------------------

-- ----------------------------
-- Table structure for wl_car
-- ----------------------------
DROP TABLE IF EXISTS `wl_car`;
CREATE TABLE `wl_car` (
  `id` bigint(20) NOT NULL,
  `name` varchar(255) DEFAULT NULL COMMENT '名称',
  `car_num` varchar(32) DEFAULT NULL COMMENT '车牌号',
  `equipment_id` bigint(20) DEFAULT NULL COMMENT '车辆类型',
  `standard` varchar(255) DEFAULT NULL COMMENT '规格型号',
  `car_state` char(20) DEFAULT NULL COMMENT '车辆状态',
  `brand` varchar(255) DEFAULT NULL COMMENT '品牌',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `manufacturer_id` bigint(20) DEFAULT NULL COMMENT '厂商id',
  `chassis_country` varchar(50) DEFAULT NULL COMMENT '底盘国别',
  `chassis_brand` varchar(50) DEFAULT NULL COMMENT '底盘品牌',
  `is_import` tinyint(50) DEFAULT NULL COMMENT '进口国产\r\n',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '负责人',
  `country` varchar(255) DEFAULT NULL COMMENT '国别',
  `qr_code` varchar(225) DEFAULT NULL COMMENT '车辆二维码',
  `org_code` varchar(255) DEFAULT NULL COMMENT '组织机构',
  `company_name` varchar(255) DEFAULT NULL COMMENT '公司名',
  `department_orgcode` varchar(255) DEFAULT NULL COMMENT '部门code',
  `department_name` varchar(255) DEFAULT NULL COMMENT '部门名',
  `create_date` datetime DEFAULT NULL,
  `maintenance_cycle` decimal(18,0) DEFAULT NULL COMMENT '保养周期',
  `ccc_auth` tinyint(4) DEFAULT NULL COMMENT '3c认证',
  `iot_code` char(100) DEFAULT NULL COMMENT '物联编码',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `car_state_id` (`car_state`) USING BTREE,
  KEY `country_id` (`country`) USING BTREE,
  KEY `manufacturer_id` (`manufacturer_id`) USING BTREE,
  KEY `ix_car_for_equipment_id` (`equipment_id`) USING BTREE,
  KEY `ix_car_for_charge_user_id` (`creator_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='消防车信息';

-- ----------------------------
-- Records of wl_car
-- ----------------------------
INSERT INTO `wl_car` VALUES ('1394490536068567041', '水罐消防车', '京A123456', '1390575333668966402', 'WHG5160GXFSG55', '1', '云鹤', null, '1394215659751264258', '126', '东风', '0', null, '126', '51891206370262', '10', null, null, null, '2021-05-18 11:10:27', null, '1', null);
INSERT INTO `wl_car` VALUES ('1394491522497564673', '水罐消防车', '京A123450', '1390575333668966402', 'WHG5160GXFPM56', '1', '云鹤', null, '1394215659751264258', '126', '东风', '0', null, '126', '51891206468913', '10', null, null, null, '2021-05-18 11:14:22', null, '1', null);
INSERT INTO `wl_car` VALUES ('1395583886003691522', '泡沫消防车', '豫M23DR6', '1395583336554061825', 'BX5320GXFPM160HT6', '1', '三一', null, '1394215659751264258', '126', '东风', '0', null, '126', '52191315705251', '10', null, null, null, '2021-05-21 11:35:02', null, '1', '5697411233144477');

-- ----------------------------
-- Table structure for wl_car_property
-- ----------------------------
DROP TABLE IF EXISTS `wl_car_property`;
CREATE TABLE `wl_car_property` (
  `id` bigint(20) NOT NULL,
  `create_date` datetime DEFAULT NULL,
  `car_id` bigint(20) NOT NULL COMMENT '车辆id',
  `value` text COMMENT '指标值',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `equipment_index_id` bigint(20) DEFAULT NULL COMMENT '指标id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='车辆性能指标';

-- ----------------------------
-- Records of wl_car_property
-- ----------------------------
INSERT INTO `wl_car_property` VALUES ('1394490752775671809', '2021-05-18 11:11:19', '1394490536068567041', '6', null, '1390575971039596546');
INSERT INTO `wl_car_property` VALUES ('1394490752788254722', '2021-05-18 11:11:19', '1394490536068567041', '10', null, '1390575868568555522');
INSERT INTO `wl_car_property` VALUES ('1394491522589839362', '2021-05-18 11:14:22', '1394491522497564673', '6', null, '1390575971039596546');
INSERT INTO `wl_car_property` VALUES ('1394491522598227970', '2021-05-18 11:14:22', '1394491522497564673', '10', null, '1390575868568555522');
INSERT INTO `wl_car_property` VALUES ('1395584051733225474', '2021-05-21 11:35:41', '1395583886003691522', null, null, '1395584051355738114');
INSERT INTO `wl_car_property` VALUES ('1395584121056681985', '2021-05-21 11:35:58', '1395583886003691522', null, null, '1395584121048293378');
INSERT INTO `wl_car_property` VALUES ('1395584327970086913', '2021-05-21 11:36:47', '1395583886003691522', null, null, '1395584327898783746');

-- ----------------------------
-- Table structure for wl_common_tree
-- ----------------------------
-- DROP TABLE IF EXISTS `wl_common_tree`;
-- CREATE TABLE `wl_common_tree` (
--   `id` bigint(20) NOT NULL,
--   `name` varchar(100) NOT NULL COMMENT '名称',
--   `tree_type` varchar(50) DEFAULT NULL COMMENT '树类型（定义不同的树）',
--   `code` varchar(50) NOT NULL COMMENT '编号(前端绑定风险模型时使用到)',
--   `node_type` varchar(50) DEFAULT NULL COMMENT '节点类型（单位、设备、建筑、区域）',
--   `parent_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '父级id',
--   `icon` varchar(50) DEFAULT NULL COMMENT '图标',
--   `sort` int(11) DEFAULT '1' COMMENT '排序',
--   `create_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建日期',
--   `remark` varchar(255) DEFAULT NULL COMMENT '备注',
--   PRIMARY KEY (`id`) USING BTREE,
--   UNIQUE KEY `unique_idx_tree_node_type_code` (`tree_type`,`node_type`,`code`) USING BTREE,
--   KEY `idx_parent_id` (`parent_id`) USING BTREE
-- ) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='公共树表';

-- ----------------------------
-- Records of wl_common_tree
-- ----------------------------

-- ----------------------------
-- Table structure for wl_dynamic_form_column
-- ----------------------------
DROP TABLE IF EXISTS `wl_dynamic_form_column`;
CREATE TABLE `wl_dynamic_form_column` (
  `id` bigint(20) NOT NULL,
  `field_name` varchar(100) NOT NULL COMMENT '字段名',
  `field_label` varchar(100) NOT NULL COMMENT '中文名',
  `data_type` varchar(100) NOT NULL COMMENT '数据类型：文本，数字，枚举,日期',
  `group_id` bigint(20) NOT NULL COMMENT '字段分组主键',
  `query_strategy` varchar(100) DEFAULT NULL COMMENT '查询策略;全等,模糊,区间',
  `not_null` bit(1) NOT NULL DEFAULT b'0' COMMENT '不能为空',
  `is_must` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否必须：0-否；1-是；控制是否可勾选掉字段，暂时没用到标准版使用',
  `group_type` varchar(20) NOT NULL COMMENT '分组类型',
  `group_code` varchar(50) NOT NULL COMMENT '所属分组编号',
  `data_source` json DEFAULT NULL COMMENT '配置json',
  `remark` varchar(255) DEFAULT NULL COMMENT '提示信息',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `unique_idx_code_type_name` (`group_type`,`group_code`,`field_name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='动态表单树形分组字段表';

-- ----------------------------
-- Records of wl_dynamic_form_column
-- ----------------------------
INSERT INTO `wl_dynamic_form_column` VALUES ('1385141658848522242', '23c5405ba7de41e18ee783fabb4b1930', '消防设备', 'input', '1385141592347832322', null, '\0', '\0', 'fireSystem', '95c211783e75444381a1f6b81ad2a13d', '{\"url\": \"\", \"data\": [], \"type\": \"custom\"}', '', '1718015', '2021-04-22 16:05:30');
INSERT INTO `wl_dynamic_form_column` VALUES ('1385141773239775233', '57f710f977e149c0b8dd5e1af5c0aa73', '消防设备', 'input', '1385141720676757505', null, '\0', '\0', 'fireSystem', 'a04fb3d90fed4d21bb9f848aa18fb393', '{\"url\": \"\", \"data\": [], \"type\": \"custom\"}', '', '1718015', '2021-04-22 16:01:52');
INSERT INTO `wl_dynamic_form_column` VALUES ('1385141830571716610', 'f821f5fd8c94463eb3e0dc48aa05bc6e', '消防设备', 'input', '1385141806316056577', null, '\0', '\0', 'fireSystem', 'e87aa52995354551888c844bc78e706e', '{\"url\": \"\", \"data\": [], \"type\": \"custom\"}', '', '1718015', '2021-04-22 16:02:08');
INSERT INTO `wl_dynamic_form_column` VALUES ('1385141891993104386', '8ff024845d62443f8becb6ae0d196fff', '消防设备', 'input', '1385141872653168641', null, '\0', '\0', 'fireSystem', 'ba3b11c7c4524ac49408b9aa82c827eb', '{\"url\": \"\", \"data\": [], \"type\": \"custom\"}', '', '1718015', '2021-04-22 16:02:20');
INSERT INTO `wl_dynamic_form_column` VALUES ('1385141947416637441', '7842c68131e24a67a5ff9b818cf2573e', '未命名标签', 'input', '1385141924738035713', null, '\0', '\0', 'fireSystem', 'd10b7171610641a99a19888c48e26d6c', '{\"url\": \"\", \"data\": [], \"type\": \"custom\"}', '', '1718015', '2021-04-22 16:02:34');

-- ----------------------------
-- Table structure for wl_dynamic_form_group
-- ----------------------------
DROP TABLE IF EXISTS `wl_dynamic_form_group`;
CREATE TABLE `wl_dynamic_form_group` (
  `id` bigint(20) NOT NULL COMMENT '物理主键',
  `group_name` varchar(100) NOT NULL COMMENT '分组名称',
  `group_code` varchar(50) NOT NULL COMMENT '分组编号',
  `group_type` varchar(20) NOT NULL DEFAULT '' COMMENT '分组类型',
  `parent_id` bigint(20) DEFAULT NULL COMMENT '父级id',
  `relation_id` bigint(20) DEFAULT NULL COMMENT '关联id(在数据有关联关系时使用)',
  `group_config` json DEFAULT NULL COMMENT '分组配置',
  `org_code` varchar(255) DEFAULT NULL COMMENT '组织机构',
  `is_must` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否必须：0-否；1-是；控制前端tab是否可勾选掉',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `creator_id` bigint(20) DEFAULT NULL COMMENT '更新者id',
  `create_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '更新日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `unique_idx_group_code` (`group_type`,`group_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='动态表单树形分组表';

-- ----------------------------
-- Records of wl_dynamic_form_group
-- ----------------------------
INSERT INTO `wl_dynamic_form_group` VALUES ('1385141294619357186', '消防给水系统', '92010000', 'fireSystem', '0', '1302870336149262337', null, '10', '\0', null, '1718015', '2021-04-22 15:59:54');
INSERT INTO `wl_dynamic_form_group` VALUES ('1385141340366630914', '空气压缩泡沫系统（CAFS）', '92030000', 'fireSystem', '0', '1302870567007948801', null, '10', '\0', null, '1718015', '2021-04-22 16:00:05');
INSERT INTO `wl_dynamic_form_group` VALUES ('1385141358179840001', '火灾报警系统', '92040000', 'fireSystem', '0', '1302870628873932802', null, '10', '\0', null, '1718015', '2021-04-22 16:00:09');
INSERT INTO `wl_dynamic_form_group` VALUES ('1385141376613806082', '水喷淋灭火系统', '92050000', 'fireSystem', '0', '1302870675179048962', null, '10', '\0', null, '1718015', '2021-04-22 16:00:14');
INSERT INTO `wl_dynamic_form_group` VALUES ('1385141413515292673', '其他系统', '92990000', 'fireSystem', '0', '1385138035104083969', null, '10', '\0', null, '1718015', '2021-04-22 16:00:22');
INSERT INTO `wl_dynamic_form_group` VALUES ('1385141592050036738', '消防设备', '95c211783e75444381a1f6b81ad2a13d', 'fireSystem', '1385141294619357186', null, '{}', '10', '', null, '1718015', '2021-04-22 16:05:30');
INSERT INTO `wl_dynamic_form_group` VALUES ('1385141592347832322', '消防设备', 'f94fc03a5b2b48a78765507859b76aae', 'fireSystem', '1385141592050036738', null, '{\"row\": {\"column\": 1}, \"isSelect\": true}', '10', '\0', '0', '1718015', '2021-04-22 16:05:30');
INSERT INTO `wl_dynamic_form_group` VALUES ('1385141720492208129', '消防设备', 'a04fb3d90fed4d21bb9f848aa18fb393', 'fireSystem', '1385141340366630914', null, null, '10', '', null, '1718015', '2021-04-22 16:01:52');
INSERT INTO `wl_dynamic_form_group` VALUES ('1385141720676757505', '消防设备', '6bcd9797522a4a77810895dd771cb3e7', 'fireSystem', '1385141720492208129', null, '{\"row\": {\"column\": 1}, \"isSelect\": true}', '10', '\0', '0', '1718015', '2021-04-22 16:01:52');
INSERT INTO `wl_dynamic_form_group` VALUES ('1385141806135701505', '消防设备', 'e87aa52995354551888c844bc78e706e', 'fireSystem', '1385141358179840001', null, null, '10', '', null, '1718015', '2021-04-22 16:02:08');
INSERT INTO `wl_dynamic_form_group` VALUES ('1385141806316056577', '消防设备', 'cc90295a9f184c3e8340646bab2ed025', 'fireSystem', '1385141806135701505', null, '{\"row\": {\"column\": 1}, \"isSelect\": true}', '10', '\0', '0', '1718015', '2021-04-22 16:02:08');
INSERT INTO `wl_dynamic_form_group` VALUES ('1385141872481202177', '消防设备', 'ba3b11c7c4524ac49408b9aa82c827eb', 'fireSystem', '1385141376613806082', null, null, '10', '', null, '1718015', '2021-04-22 16:02:20');
INSERT INTO `wl_dynamic_form_group` VALUES ('1385141872653168641', '消防设备', '5cceef94f4db46bcb19c0ca5271d796e', 'fireSystem', '1385141872481202177', null, '{\"row\": {\"column\": 1}, \"isSelect\": true}', '10', '\0', '0', '1718015', '2021-04-22 16:02:20');
INSERT INTO `wl_dynamic_form_group` VALUES ('1385141924574457857', '消防设备', 'd10b7171610641a99a19888c48e26d6c', 'fireSystem', '1385141413515292673', null, null, '10', '', null, '1718015', '2021-04-22 16:02:34');
INSERT INTO `wl_dynamic_form_group` VALUES ('1385141924738035713', '消防设备', 'c7d5a76ebaef49eb8b9fe405e2164d29', 'fireSystem', '1385141924574457857', null, '{\"row\": {\"column\": 1}, \"isSelect\": true}', '10', '\0', '0', '1718015', '2021-04-22 16:02:34');
INSERT INTO `wl_dynamic_form_group` VALUES ('1390603295336321025', '排油系统', '92100000', 'fireSystem', '0', '1390603248255258625', null, '10', '\0', null, '1740481', '2021-05-07 17:43:56');
INSERT INTO `wl_dynamic_form_group` VALUES ('1390614882323419138', '预混泡沫系统', '92110000', 'fireSystem', '0', '1390614748298629121', null, '10', '\0', null, '1740481', '2021-05-07 18:29:59');

-- ----------------------------
-- Table structure for wl_dynamic_form_instance
-- ----------------------------
DROP TABLE IF EXISTS `wl_dynamic_form_instance`;
CREATE TABLE `wl_dynamic_form_instance` (
  `id` bigint(20) NOT NULL,
  `field_name` varchar(100) NOT NULL COMMENT '字段名',
  `field_label` varchar(100) NOT NULL COMMENT '中文名',
  `data_type` varchar(100) NOT NULL COMMENT '数据类型：文本，数字，枚举,日期',
  `group_type` varchar(20) NOT NULL COMMENT '分组类型(冗余字段便于查询）',
  `group_code` varchar(100) NOT NULL COMMENT '分组编号',
  `group_id` bigint(20) NOT NULL COMMENT '字段分组id',
  `field_value` varchar(1024) DEFAULT NULL COMMENT '动态配置字段的值',
  `instance_id` bigint(20) NOT NULL COMMENT '设备实例id',
  `form_column_id` bigint(20) NOT NULL COMMENT '字段定义信息的主键',
  `query_strategy` varchar(100) DEFAULT NULL COMMENT '查询策略;全等,模糊,区间',
  `creator_id` bigint(20) NOT NULL COMMENT '创建者',
  `create_date` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '创建日期',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE KEY `u_idx_instance_id` (`instance_id`,`group_code`,`field_name`,`group_type`) USING BTREE,
  KEY `idx_group_code` (`group_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='动态表单实例表';

-- ----------------------------
-- Records of wl_dynamic_form_instance
-- ----------------------------
INSERT INTO `wl_dynamic_form_instance` VALUES ('1385142907329245187', '7842c68131e24a67a5ff9b818cf2573e', '未命名标签', 'input', 'fireSystem', 'd10b7171610641a99a19888c48e26d6c', '1385141924738035713', null, '1385142907329245186', '1385141947416637441', null, '1718015', '2021-04-22 16:06:18');
INSERT INTO `wl_dynamic_form_instance` VALUES ('1385173091918999555', '7842c68131e24a67a5ff9b818cf2573e', '未命名标签', 'input', 'fireSystem', 'd10b7171610641a99a19888c48e26d6c', '1385141924738035713', null, '1385173091918999554', '1385141947416637441', null, '1718015', '2021-05-12 18:02:50');
INSERT INTO `wl_dynamic_form_instance` VALUES ('1385173291102302210', '23c5405ba7de41e18ee783fabb4b1930', '消防设备', 'input', 'fireSystem', '95c211783e75444381a1f6b81ad2a13d', '1385141592347832322', null, '1385173291102302209', '1385141658848522242', null, '1718015', '2021-05-12 18:03:39');
INSERT INTO `wl_dynamic_form_instance` VALUES ('1385173631340048387', 'f821f5fd8c94463eb3e0dc48aa05bc6e', '消防设备', 'input', 'fireSystem', 'e87aa52995354551888c844bc78e706e', '1385141806316056577', null, '1385173631340048386', '1385141830571716610', null, '1718015', '2021-05-12 18:02:24');
INSERT INTO `wl_dynamic_form_instance` VALUES ('1385173722083815426', '57f710f977e149c0b8dd5e1af5c0aa73', '消防设备', 'input', 'fireSystem', 'a04fb3d90fed4d21bb9f848aa18fb393', '1385141720676757505', null, '1385173722083815425', '1385141773239775233', null, '1718015', '2021-05-12 18:03:22');

-- ----------------------------
-- Table structure for wl_equipment
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment`;
CREATE TABLE `wl_equipment` (
  `id` bigint(20) NOT NULL,
  `name` varchar(50) NOT NULL COMMENT '名称',
  `code` varchar(50) NOT NULL COMMENT '编码',
  `category_id` bigint(20) NOT NULL COMMENT '装备分类id',
  `country` varchar(20) DEFAULT NULL COMMENT '国别',
  `maintenance_cycle` decimal(12,0) DEFAULT NULL COMMENT '保养周期',
  `check_cycle` decimal(12,0) DEFAULT NULL COMMENT '检查周期（天）',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `management_style` bigint(20) DEFAULT NULL COMMENT '管理方式 单件还是批量管理模式，单件S，批量：P',
  `reviser_id` bigint(20) DEFAULT NULL COMMENT '修改人',
  `date_updated` datetime DEFAULT NULL COMMENT '修改时间',
  `creater_id` bigint(20) DEFAULT NULL COMMENT '创建人',
  `unit_id` bigint(20) DEFAULT NULL COMMENT '单位id',
  `made_in` varchar(50) DEFAULT NULL COMMENT '生产源地 0国产1进口9其他',
  `manufacturer` bigint(20) DEFAULT NULL COMMENT '生产厂家',
  `img` varchar(255) DEFAULT NULL COMMENT '头像图片url',
  `video` varchar(20) DEFAULT NULL,
  `mark_specification` text COMMENT '标识规范',
  `supplier_id` bigint(20) DEFAULT NULL COMMENT '供应商ID',
  `pref_quota` text COMMENT '非核心指标内容',
  `create_date` datetime DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL COMMENT '公司名',
  `department_orgcode` varchar(255) DEFAULT NULL COMMENT '部门code',
  `department_name` varchar(255) DEFAULT NULL COMMENT '部门名',
  `inspection_spec` varchar(100) DEFAULT NULL COMMENT '巡查规范名称',
  `maintenance_spec` varchar(100) DEFAULT NULL COMMENT '维保规范名称',
  `area` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `management_style` (`management_style`) USING BTREE,
  KEY `supplier_id` (`supplier_id`) USING BTREE,
  KEY `unit_id` (`unit_id`) USING BTREE,
  KEY `ix_equipment_for_code` (`code`) USING BTREE,
  KEY `ix_equipment_for_category_id` (`category_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='装备定义';

-- ----------------------------
-- Records of wl_equipment
-- ----------------------------
INSERT INTO `wl_equipment` VALUES ('1390575333668966402', '水罐消防车', '21010101RCG44', '126', null, null, null, null, null, null, '2021-05-18 11:16:04', null, '42', null, null, 'group1/M00/00/06/rBADZGCjMVaAUp_lAABCzayBXVc497.jpg', null, null, null, null, '2021-05-07 15:52:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361044978155522', 'FHS-消火栓泵', '92010300ZX244', '1392322039863558145', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361047142416385', 'FHS-采集装置', '92010400DA244', '1392322047237144578', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361048190992386', 'FHS-控制柜', '92010500GHB44', '1392322052043816961', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361049260539906', 'FHS-消防泵', '920106007GV44', '1392322056846295042', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:38', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361050413973505', 'FAS-火灾报警主机', '92040100AFK44', '1392322065276846082', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:38', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361051122810882', 'FAS-烟雾报警器', '920402009EM44', '1392322071723491329', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:38', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361051743567873', 'FAS-温度报警器', '92040300HKO44', '1392322079898189825', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:38', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361052318187522', 'FAS-手动报警器', '920404002PU44', '1392322085313036290', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:38', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361052926361602', 'FAS-空气采样探测器', '920405002O544', '1392322089993879554', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:38', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361053480009729', 'FAS-消火栓按钮', '92040600ANG44', '1392322094657945601', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:39', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361054348230658', 'FAS-感温电缆', '92040700PEM44', '1392322099158433794', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:39', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361055002542082', 'FAS-红外感光探测器', '92040800CZU44', '1392322103839277057', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:39', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361055849791490', 'FAS-紫外感光探测器', '92040900VUA44', '1392322108704669697', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:39', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361056457965569', 'FAS-声光报警器', '92041000LCW44', '1392322113863663617', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:39', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361057196163073', 'CAFS-主机', '92030100TGX44', '1392324690038734849', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:40', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361057749811202', 'CAFS-炮阀', '92030200DOD44', '1392324696535711746', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:40', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361058299265025', 'CAFS-切换阀', '92030300DI444', '1392324701602430977', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:40', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361058894856194', 'CAFS-卷帘门', '92030400FTV44', '1392324708715970562', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:40', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361059477864450', 'CAFS-产生装置', '92030500MG644', '1392324717469483010', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:40', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361059951820801', 'CAFS-泡沫泵', '92030600QO344', '1392324723681247234', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:40', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361060509663233', 'CAFS-空压机', '92030700SFT44', '1392324730127892482', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:40', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361061012979713', 'CAFS-控制柜', '92030800K2R44', '1392324734880038914', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:40', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361061486936066', 'CAFS-电源柜', '92030900KYD44', '1392324740408131585', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:41', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361062007029761', 'CAFS-设备间', '92031000EXB44', '1392324745730703361', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:41', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361062543900673', 'CAFS-控制按钮', '92031100HQL44', '1392324750889697282', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:41', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361063101743105', 'CAFS-插件', '92031200DMT44', '1392324756061274113', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:41', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361063550533634', 'CAFS-交换机', '92031300WFJ44', '1392324760930861058', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:41', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361064016101378', 'CAFS-光纤', '92031400GMT44', '1392324766127603713', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:41', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361064620081153', 'CAFS-电源', '92031500Z9E44', '1392324771190128641', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:41', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361065161146370', 'CAFS-AD通道', '92031600TQ244', '1392324776982462466', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:41', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361065656074242', 'CAFS-断路器', '92031700EGW44', '1392324782493777921', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:42', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361066213916674', 'CAFS-CPU', '92031800EX644', '1392324788600684546', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:42', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361066734010370', 'CAFS-泡沫罐', '92031900INJ44', '1392324793445105666', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:42', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361067237326849', 'CAFS-水箱', '92032000N4344', '1392324798394384385', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:42', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361067740643330', 'FFS-感温电缆', '92110100QY544', '1392324803603709954', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:42', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361068273319937', 'FFS-电磁阀', '92110200UIU44', '1392324808854978561', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:42', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361068818579458', 'FFS-启动瓶', '92110300SS744', '1392324814001389569', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:42', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361069313507330', 'FFS-断路器', '92110400CRQ44', '1392324819017777153', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:42', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361069829406722', 'FFS-就地盘', '9211050056A44', '1392324824571035649', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361070315945986', 'ONL-交流电源', '921002000JK44', '1392330208098631682', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361070907342850', 'ONL-直流电源', '92100300MNL44', '1392330212754309121', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361071419047937', 'ONL-排油阀', '92100400VWE44', '1392330217556787202', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392361071851061250', 'ONL-排油注氮装置', '92100500RIP44', '1392330222447345665', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-12 14:08:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662024928083970', 'FES-应急电源', '92120100ODE44', '1392658811210416129', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:36', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662025691447297', 'FES-应急照明装置', '92120200XZ444', '1392658816499433473', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:36', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662026278649858', 'FES-消防广播', '92120300CAA44', '1392658821884919809', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:36', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662026962321409', 'WSS-雨淋蝶阀', '92130100GQN44', '1392658827463344130', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:36', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662027662770178', 'WSS-雨淋电磁阀', '92130200WNJ44', '1392658832702029825', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:36', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662028300304385', 'WSS-雨淋阀', '92130300BH644', '1392658837840052226', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662029013336065', 'WSS-水泵', '92130400C1O44', '1392658843191984130', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662029642481665', 'WSS-稳压罐', '92130500KTH44', '1392658848401309698', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662030292598785', 'WSS-感温电缆', '9213060073744', '1392658853677744130', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662031005630465', 'WSS-主机', '92130700LXQ44', '1392658858782212097', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662031647358978', 'WSS-电源', '92130800CTM44', '1392658864025092098', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662033891311618', 'ONL-氮气瓶', '92100800ISP44', '1392658879611125762', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:38', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662034591760386', 'ONL-检修阀', '92100900TQS44', '1392658885189550081', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:38', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662035229294593', 'ONL-氮气释放阀', '92101000TUH44', '1392658890495344641', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:38', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662035829080065', 'ONL-断流阀', '92101100M5U44', '1392658896195403777', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:38', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662036479197185', 'WMS-主机', '9214010022144', '1392658901505392642', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:39', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662037200617474', 'WMS-水泵', '92140200D8A44', '1392658907104788482', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:39', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662037804597250', 'WMS-选择阀', '92140300LEW44', '1392658912838402050', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:39', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662038463102978', 'WMS-电磁阀', '92140400DAV44', '1392658918324551682', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:39', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662039213883393', 'WMS-电动阀', '92140500ZMO44', '1392658923731009538', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:39', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662039926915073', 'GS-主机', '92070100LLT44', '1392658929175216130', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:39', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662040606392322', 'GS-喷淋', '92070200DJT44', '1392658934652977153', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:40', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662041252315137', 'GS-选择阀', '92070300WR444', '1392658940055240705', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:40', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662041910820865', 'PAS-报警阀', '92150100IB844', '1392658945704968193', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:40', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662042552549377', 'PAS-喷淋', '92150200PHX44', '1392658951174340609', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:40', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662043252998146', 'PAS-喷淋泵', '92150300OGG44', '1392658956698238978', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:40', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662043915698177', 'PAS-主机', '9215040081R44', '1392658962079531009', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:40', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662044452569090', 'PAS-电动排气阀', '92150500SW644', '1392658967339188225', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:40', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662045115269121', 'SCS-通风阀', '92160100XJ244', '1392658972791783426', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:41', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662045933158401', 'SCS-防火阀', '92160200J4244', '1392658978340847618', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:41', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662046641995778', 'SCS-排烟阀', '92160300FLD44', '1392658983684390913', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:41', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662047308890113', 'SCS-防火百叶', '92160400UKS44', '1392658989157957634', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:41', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662047938035713', 'SCS-高位百叶', '92160500GPL44', '1392658994627330049', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:41', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662048705593345', 'ES-电梯', '92170100NKI44', '1392658999933124609', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:41', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662049410236417', 'FSS-防火卷帘门', '92180100N1L44', '1392659005322805250', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:42', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662050249097217', 'FFS-主机', '92110600JQG44', '1392659010821537794', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:42', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662051167649794', 'FFS-氮气瓶', '921107002BC44', '1392659016324464641', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:42', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662051830349826', 'FFS-电动阀', '92110800CHG44', '1392659021919666178', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:42', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662052493049858', 'FFS-雨淋蝶阀', '92110900ATW44', '1392659027506479105', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:42', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662053088641026', 'FFS-电源', '92111000LYO44', '1392659033298812930', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662053793284098', 'FMS-涡扇炮', '92190100OVT44', '1392659038889820162', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662054481149954', 'FHS-消防水池装置', '92010700SHY44', '1392659044434690049', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662055093518337', 'FHS-稳压泵', '92010800KAL44', '1392659049795010562', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1392662055710081026', 'CAFS-CMS', '92032100GFF44', '1392659055239217153', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-13 10:04:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1394215338501132289', '灭火类消防车', '21010100P8744', '125', null, null, null, null, null, null, '2021-05-19 16:05:35', null, '42', null, null, 'group1/M00/00/06/rBADZGCiL9CAMKe_AATmlhzlrOI780.jpg', null, null, null, null, '2021-05-17 16:56:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1394220693679427585', 'SCS-送风风机', '921606002E344', '1394217996519657474', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-17 17:18:11', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1394220694618951682', 'SCS-排烟风机', '92160700GQP44', '1394218005814235137', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-17 17:18:12', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1394220695369732097', 'ACS-空调', '92200100BLI44', '1394218013410119682', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-17 17:18:12', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1394220696086958081', 'ACS-暖通', '92200200RQX44', '1394218020670459905', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-17 17:18:12', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1394220696921624577', 'ACS-门禁', '92200300K6G44', '1394218027230351362', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-05-17 17:18:12', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1395583336554061825', '泡沫消防车', '21010102WRL44', '127', null, null, null, null, null, null, null, null, '42', null, null, 'group1/M00/00/07/rBADZGCnKeCAJqFHAAInnIxkikM149.png', null, null, null, null, '2021-05-21 11:32:51', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1399927013359374337', 'FAS-防爆温感', '92040300RJZ44', '1392322079898189825', null, null, null, null, null, null, null, null, '55', null, null, 'group1/M00/00/07/rBADZGC29zqAZfnDAAdEpCKG_ow307.png', null, null, null, null, '2021-06-02 11:13:04', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866673602162690', 'FAS-换流变火警', '92041100KO644', '1401812716204847105', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:35', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866673925124097', 'FAS-感温式火灾探测器', '92041200KNU44', '1401812724652175362', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:35', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866674294222850', 'FAS-火警模块', '92041300WQ744', '1401812732013178881', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:35', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866674575241217', 'FAS-远传模块', '920414009Y844', '1401812739424514050', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:35', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866674734624770', 'FAS-总火警设备', '92041500PO244', '1401812750476505089', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:35', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866674973700098', 'FAS-电源', '92041600J9L44', '1401812758579900417', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:35', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866675162443778', 'FAS-火警装置', '92041700XTB44', '1401812767098531842', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:35', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866675300855810', 'FAS-备用设备', '92041800CK844', '1401834500329304065', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:35', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866675598651393', 'WSS-电磁阀', '92130200RGW44', '1392658832702029825', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:36', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866676907274241', 'SCS-送风口', '92160800FSC44', '1401812784664276993', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:36', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866678102650882', 'FHS-压力开关', '92010900K8G44', '1401812791282888706', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:36', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866678308171778', 'FHS-管网压力探测器', '92011000T5Q44', '1401812798711001090', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:36', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866678450778114', 'FHS-液位探测器', '92011100BIK44', '1401812807472902145', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:36', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866678975066113', 'CAFS-CAFS消防炮', '92032200BUX44', '1401812814078930946', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:36', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866679964921857', 'FCMS-消防车', '92210400MAM44', '1401812821314105345', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866680124305409', 'AIRCS-空调', '92200100VAC44', '1394218013410119682', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866680329826305', 'AIRCS-暖通', '922002006IB44', '1394218020670459905', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866680514375681', 'FMS-涡扇炮机器人', '92190300PI244', '1401812844370194434', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866680640204801', 'FMS-车载', '92190400CNN44', '1401812853467639809', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866680791199745', 'FMS-手动控制柜', '92190500RLK44', '1401812861348737025', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866680963166210', 'FMS-设备舱', '92190600EVZ44', '1401812868890095617', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866681294516226', 'FMS-自动寻的装置', '92190700SF044', '1401812875693256706', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866681437122561', 'FMS-手动报警器', '92190800THD44', '1401812883305918466', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866681575534593', 'FPMS-配电箱', '92220400HOT44', '1401812890209742850', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1401866681701363713', 'FPMS-强切设备', '92220500DDU44', '1401812898271195137', null, null, null, null, null, null, null, null, '55', null, null, '', null, null, null, null, '2021-06-07 19:40:37', null, null, null, null, null, null);
INSERT INTO `wl_equipment` VALUES ('1402522323021672450', 'FMS-机器人', '92190900LY844', '1402518124389150722', null, null, null, null, null, null, null, null, '55', null, null, 'group1/M00/00/07/rBADZGDAaD2Ae0ciAABp7gIMbpM711.jpg', null, null, null, null, '2021-06-09 15:05:54', null, null, null, null, null, null);

-- ----------------------------
-- Table structure for wl_equipment_alarm_report_day
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment_alarm_report_day`;
CREATE TABLE `wl_equipment_alarm_report_day` (
  `id` bigint(20) NOT NULL COMMENT '主键',
  `org_code` varchar(100) NOT NULL COMMENT '机构编号',
  `report_date` date NOT NULL COMMENT '上报日期',
  `equipment_specific_id` bigint(20) NOT NULL COMMENT '设备id',
  `equipment_specific_name` varchar(255) DEFAULT NULL COMMENT '设备名称',
  `equipment_detail_id` bigint(20) DEFAULT NULL COMMENT '装备实例明细id(冗余字段)',
  `equipment_id` bigint(20) DEFAULT NULL COMMENT '装备定义id(冗余字段)',
  `equipment_code` varchar(255) DEFAULT NULL COMMENT '装备定义code(冗余字段)',
  `system_ids` varchar(1000) DEFAULT NULL COMMENT '所属系统名称（多个系统已逗号分隔）',
  `alarm_type` varchar(50) NOT NULL DEFAULT '0' COMMENT '原始报警类型',
  `alarm_type_name` varchar(255) DEFAULT NULL COMMENT '冗余字段（分析报告统计使用）',
  `last_report_date` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '最后一次上报日期',
  `frequency` bigint(20) NOT NULL DEFAULT '1' COMMENT '发生频次',
  `index_true_num` bigint(20) NOT NULL DEFAULT '0' COMMENT '遥信指标true类型指标数量(统计使用)',
  `create_date` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_date` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `index_id` bigint(20) DEFAULT NULL COMMENT '告警指标Id',
  `index_name` varchar(255) DEFAULT NULL COMMENT '告警指标名称',
  `index_type` varchar(255) DEFAULT NULL COMMENT '告警指标key值',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_equip_spe_id` (`equipment_specific_id`) USING BTREE,
  KEY `idx_system_ids` (`system_ids`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='设备报警日报表';

-- ----------------------------
-- Records of wl_equipment_alarm_report_day
-- ----------------------------
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1', '10', '2021-05-17', '1390937439039823874', '设备明名称', null, null, null, '1619086022531,1619086103649', '0', null, '2021-05-17 16:02:26', '12', '0', '2021-05-17 15:58:04', '2021-05-17 16:02:26', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1398198994055884802', '10', '2021-05-28', '1396829041373372417', '1#产生装置', '1396829041356595201', '1392361059477864450', '92030500MG644', '1619086125285', '', null, '2021-05-28 17:17:37', '3', '0', '2021-05-28 16:46:32', '2021-05-28 17:17:37', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1398211111584690178', '10', '2021-05-28', '1396829041373372417', '1#产生装置', '1396829041356595201', '1392361059477864450', '92030500MG644', '1619086125285', 'BREAKDOWN', null, '2021-05-28 17:34:41', '1', '0', '2021-05-28 17:34:41', '2021-05-28 17:34:41', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399254619670011905', '10', '2021-05-31', '1396829044112252929', '1#水箱', '1396829044108058625', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-05-31 14:41:12', '1', '0', '2021-05-31 14:41:13', '2021-05-31 14:52:34', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399259078789783553', '10', '2021-05-31', '1396829044112252929', '1#水箱', '1396829044108058625', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-05-31 14:58:56', '1', '0', '2021-05-31 14:58:56', '2021-05-31 15:10:18', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399260293640577025', '10', '2021-05-31', '1396829044179361793', '2#水箱', '1396829044170973185', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-05-31 15:03:46', '1', '0', '2021-05-31 15:03:46', '2021-05-31 15:15:08', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399262900362764289', '10', '2021-05-31', '1396829044179361793', '2#水箱', '1396829044170973185', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-05-31 15:13:29', '1', '0', '2021-05-31 15:14:07', '2021-05-31 15:25:30', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399264432063864833', '10', '2021-05-31', '1396829044179361793', '2#水箱', '1396829044170973185', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-05-31 15:20:12', '1', '0', '2021-05-31 15:20:12', '2021-05-31 15:31:35', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399265952759111682', '10', '2021-05-31', '1396829044179361793', '2#水箱', '1396829044170973185', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-05-31 15:26:15', '1', '0', '2021-05-31 15:26:15', '2021-05-31 15:37:38', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399266007058571266', '10', '2021-05-31', '1396829044179361793', '2#水箱', '1396829044170973185', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-05-31 15:26:28', '1', '0', '2021-05-31 15:26:28', '2021-05-31 15:37:51', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399266188122480641', '10', '2021-05-31', '1396829044179361793', '2#水箱', '1396829044170973185', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-05-31 15:27:11', '1', '0', '2021-05-31 15:27:11', '2021-05-31 15:38:34', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399267649602543617', '10', '2021-05-31', '1396829044179361793', '2#水箱', '1396829044170973185', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-05-31 15:32:59', '1', '0', '2021-05-31 15:32:59', '2021-05-31 15:44:23', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399273540821278721', '10', '2021-05-31', '1396829044179361793', '2#水箱', '1396829044170973185', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-05-31 15:56:24', '1', '0', '2021-05-31 15:56:24', '2021-05-31 16:07:48', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399273713936982017', '10', '2021-05-31', '1396829044112252929', '1#水箱', '1396829044108058625', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-05-31 15:57:05', '1', '0', '2021-05-31 15:57:05', '2021-05-31 16:08:29', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399274446748999681', '10', '2021-05-31', '1396829044112252929', '1#水箱', '1396829044108058625', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-05-31 15:59:21', '1', '0', '2021-05-31 16:00:00', '2021-05-31 16:11:24', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399286281158004737', '10', '2021-05-31', '1396829044112252929', '1#水箱', '1396829044108058625', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-05-31 16:46:59', '1', '0', '2021-05-31 16:47:02', '2021-05-31 16:58:27', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399288931240906753', '10', '2021-05-31', '1396829044179361793', '2#水箱', '1396829044170973185', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-05-31 16:57:30', '1', '0', '2021-05-31 16:57:33', '2021-05-31 17:08:59', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399291134601072641', '10', '2021-05-31', '1396829041373372417', '1#产生装置', '1396829041356595201', '1392361059477864450', '92030500MG644', '1619086125285', 'BREAKDOWN', null, '2021-05-31 17:06:19', '1', '0', '2021-05-31 17:06:19', '2021-05-31 17:17:45', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399553495132164098', '10', '2021-06-01', '1396829041566310401', '2#产生装置', '1396829041562116097', '1392361059477864450', '92030500MG644', '1619086125285', 'BREAKDOWN', null, '2021-06-01 10:28:50', '1', '0', '2021-06-01 10:28:50', '2021-06-01 10:28:50', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399555044763914242', '10', '2021-06-01', '1396829044112252929', '1#水箱', '1396829044108058625', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-06-01 10:35:00', '1', '0', '2021-06-01 10:35:00', '2021-06-01 10:34:59', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399555292001357826', '10', '2021-06-01', '1396829044179361793', '2#水箱', '1396829044170973185', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-06-01 10:35:59', '1', '0', '2021-06-01 10:35:59', '2021-06-01 10:35:58', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399603930333335554', '10', '2021-06-01', '1396829044179361793', '2#水箱', '1396829044170973185', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-06-01 13:49:15', '1', '0', '2021-06-01 13:49:15', '2021-06-01 13:49:15', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399638292030443522', '10', '2021-06-01', '1399619288561766402', '极1高阀门', '1399619288557572098', '1392361071419047937', '92100400VWE44', '1619085975042', '', null, '2021-06-01 16:41:49', '13', '0', '2021-06-01 16:05:48', '2021-06-01 16:41:49', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399647873523666945', '10', '2021-06-01', '1399619289035722754', '极2低交流电源', '1399619289035722753', '1392361070315945986', '921002000JK44', '1619085975042', 'BREAKDOWN', null, '2021-06-01 18:03:15', '5', '0', '2021-06-01 16:43:52', '2021-06-01 18:03:15', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399665472588369922', '10', '2021-06-01', '1399619288838590467', '极2低直流电源', '1399619288838590466', '1392361070907342850', '92100300MNL44', '1619085975042', 'BREAKDOWN', null, '2021-06-01 18:04:57', '2', '0', '2021-06-01 17:53:48', '2021-06-01 18:04:57', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399665783814115330', '10', '2021-06-01', '1399619288683401217', '极2低阀门', '1399619288679206914', '1392361071419047937', '92100400VWE44', '1619085975042', '', null, '2021-06-01 18:07:08', '6', '0', '2021-06-01 17:55:02', '2021-06-01 18:07:08', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399669046529642497', '10', '2021-06-01', '1399619288603709441', '极2高阀门', '1399619288599515137', '1392361071419047937', '92100400VWE44', '1619085975042', '', null, '2021-06-01 18:12:01', '10', '0', '2021-06-01 18:08:00', '2021-06-01 18:12:01', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399671646712909826', '10', '2021-06-01', '1399619288763092993', '极2高直流电源', '1399619288758898689', '1392361070907342850', '92100300MNL44', '1619085975042', 'BREAKDOWN', null, '2021-06-01 18:22:32', '4', '0', '2021-06-01 18:18:20', '2021-06-01 18:22:32', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399671862841200641', '10', '2021-06-01', '1399619288922476546', '极2高交流电源', '1399619288918282241', '1392361070315945986', '921002000JK44', '1619085975042', 'BREAKDOWN', null, '2021-06-01 18:19:11', '1', '0', '2021-06-01 18:19:11', '2021-06-01 18:19:11', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399672111399849986', '10', '2021-06-01', '1399619288884727810', '极1高交流电源', '1399619288880533505', '1392361070315945986', '921002000JK44', '1619085975042', 'BREAKDOWN', null, '2021-06-01 18:20:11', '1', '0', '2021-06-01 18:20:11', '2021-06-01 18:20:10', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399672151946186754', '10', '2021-06-01', '1399619289002168322', '极1低交流电源', '1399619288997974017', '1392361070315945986', '921002000JK44', '1619085975042', 'BREAKDOWN', null, '2021-06-01 18:20:32', '2', '0', '2021-06-01 18:20:20', '2021-06-01 18:20:32', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399672597385465858', '10', '2021-06-01', '1399619288721149954', '极1高直流电源', '1399619288721149953', '1392361070907342850', '92100300MNL44', '1619085975042', 'BREAKDOWN', null, '2021-06-01 18:22:14', '2', '0', '2021-06-01 18:22:07', '2021-06-01 18:22:14', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399672780789796866', '10', '2021-06-01', '1399619288796647427', '极1低直流电源', '1399619288796647426', '1392361070907342850', '92100300MNL44', '1619085975042', 'BREAKDOWN', null, '2021-06-01 18:23:02', '2', '0', '2021-06-01 18:22:50', '2021-06-01 18:23:02', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1399999521286672385', '10', '2021-06-02', '1399759371415736322', '感温电缆1', '1399759371407347714', '1392361054348230658', '92040700PEM44', '1619086103649', 'FIREALARM', null, '2021-06-02 16:03:29', '2', '0', '2021-06-02 16:01:11', '2021-06-02 16:03:29', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400000150667153410', '10', '2021-06-02', '1399759371575119874', '感温电缆2', '1399759371566731266', '1392361054348230658', '92040700PEM44', '1619086103649', 'FIREALARM', null, '2021-06-02 16:03:41', '1', '0', '2021-06-02 16:03:41', '2021-06-02 16:03:41', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400000176084635649', '10', '2021-06-02', '1399759371684171778', '感温电缆3', '1399759371675783170', '1392361054348230658', '92040700PEM44', '1619086103649', 'FIREALARM', null, '2021-06-02 16:03:47', '1', '0', '2021-06-02 16:03:47', '2021-06-02 16:03:47', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400001073460170754', '10', '2021-06-02', '1399759371684171778', '感温电缆3', '1399759371675783170', '1392361054348230658', '92040700PEM44', '1619086103649', 'SHIELD', null, '2021-06-02 16:07:33', '2', '0', '2021-06-02 16:07:21', '2021-06-02 16:07:33', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400001223712722946', '10', '2021-06-02', '1399759371684171778', '感温电缆3', '1399759371675783170', '1392361054348230658', '92040700PEM44', '1619086103649', 'BREAKDOWN', null, '2021-06-02 16:07:57', '1', '0', '2021-06-02 16:07:57', '2021-06-02 16:07:57', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400003286815363074', '10', '2021-06-02', '1399759372095213570', '烟感3', '1399759372091019265', '1392361051122810882', '920402009EM44', '1619086103649', 'FIREALARM', null, '2021-06-02 16:16:09', '1', '0', '2021-06-02 16:16:09', '2021-06-02 16:16:09', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400003490721452033', '10', '2021-06-02', '1399759372095213570', '烟感3', '1399759372091019265', '1392361051122810882', '920402009EM44', '1619086103649', 'BREAKDOWN', null, '2021-06-02 16:16:58', '1', '0', '2021-06-02 16:16:58', '2021-06-02 16:16:57', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400003540826607618', '10', '2021-06-02', '1399759372095213570', '烟感3', '1399759372091019265', '1392361051122810882', '920402009EM44', '1619086103649', 'SHIELD', null, '2021-06-02 16:17:10', '1', '0', '2021-06-02 16:17:10', '2021-06-02 16:17:09', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400003557738041345', '10', '2021-06-02', '1399759371906469890', '烟感1', '1399759371864526849', '1392361051122810882', '920402009EM44', '1619086103649', 'SHIELD', null, '2021-06-02 16:17:14', '1', '0', '2021-06-02 16:17:14', '2021-06-02 16:17:13', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400003830682374146', '10', '2021-06-02', '1399759372275568642', '手报1', '1399759372267180033', '1392361052318187522', '920404002PU44', '1619086103649', 'FIREALARM', null, '2021-06-02 16:18:19', '1', '0', '2021-06-02 16:18:19', '2021-06-02 16:18:18', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400004006931222529', '10', '2021-06-02', '1399759372275568642', '手报1', '1399759372267180033', '1392361052318187522', '920404002PU44', '1619086103649', 'BREAKDOWN', null, '2021-06-02 16:19:24', '2', '0', '2021-06-02 16:19:01', '2021-06-02 16:19:24', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400004062111485953', '10', '2021-06-02', '1399759372275568642', '手报1', '1399759372267180033', '1392361052318187522', '920404002PU44', '1619086103649', 'SHIELD', null, '2021-06-02 16:19:14', '1', '0', '2021-06-02 16:19:14', '2021-06-02 16:19:13', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400005066911535105', '10', '2021-06-02', '1399759372581752834', '空气采样1', '1399759372573364226', '1392361052926361602', '920405002O544', '1619086103649', '', null, '2021-06-02 16:23:20', '2', '0', '2021-06-02 16:23:13', '2021-06-02 16:23:20', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400006068507136001', '10', '2021-06-02', '1399759372581752834', '空气采样1', '1399759372573364226', '1392361052926361602', '920405002O544', '1619086103649', 'BREAKDOWN', null, '2021-06-02 16:27:12', '1', '0', '2021-06-02 16:27:12', '2021-06-02 16:27:12', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400006261302513665', '10', '2021-06-02', '1399759372581752834', '空气采样1', '1399759372573364226', '1392361052926361602', '920405002O544', '1619086103649', 'SHIELD', null, '2021-06-02 16:27:58', '1', '0', '2021-06-02 16:27:58', '2021-06-02 16:27:58', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400006436423094273', '10', '2021-06-02', '1399759372942462977', '红外光束感烟1', '1399759372938268673', '1392361055002542082', '92040800CZU44', '1619086103649', 'FIREALARM', null, '2021-06-02 16:28:40', '1', '0', '2021-06-02 16:28:40', '2021-06-02 16:28:39', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400006931518738434', '10', '2021-06-02', '1399759373487722498', '紫外火焰1', '1399759373466750978', '1392361055849791490', '92040900VUA44', '1619086103649', 'FIREALARM', null, '2021-06-02 16:30:38', '1', '0', '2021-06-02 16:30:38', '2021-06-02 16:30:38', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400007011290206210', '10', '2021-06-02', '1399759373487722498', '紫外火焰1', '1399759373466750978', '1392361055849791490', '92040900VUA44', '1619086103649', 'SHIELD', null, '2021-06-02 16:30:57', '1', '0', '2021-06-02 16:30:57', '2021-06-02 16:30:57', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400008207589593090', '10', '2021-06-02', '1399759373877792770', '声光报警1', '1399759373873598465', '1392361056457965569', '92041000LCW44', '1619086103649', 'FIREALARM', null, '2021-06-02 16:35:42', '1', '0', '2021-06-02 16:35:42', '2021-06-02 16:35:42', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400008630568374274', '10', '2021-06-02', '1399759373877792770', '声光报警1', '1399759373873598465', '1392361056457965569', '92041000LCW44', '1619086103649', 'BREAKDOWN', null, '2021-06-02 16:37:23', '1', '0', '2021-06-02 16:37:23', '2021-06-02 16:37:23', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400008820125749250', '10', '2021-06-02', '1399990242081132546', '防爆温度报警器1', '1399990242068549633', '1399927013359374337', '92040300RJZ44', '1619086103649', 'FIREALARM', null, '2021-06-02 16:38:23', '2', '0', '2021-06-02 16:38:08', '2021-06-02 16:38:23', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400049851638628354', '10', '2021-06-02', '1399763047412813826', '极1高电磁阀', '1399763047400230914', '1392361068273319937', '92110200UIU44', '1620383459228', 'BREAKDOWN', '故障', '2021-06-02 19:23:54', '4', '3', '2021-06-02 19:21:11', '2021-06-02 19:23:54', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1400050464011206657', '10', '2021-06-02', '1399763047542837249', '极2高电磁阀', '1399763047538642945', '1392361068273319937', '92110200UIU44', '1620383459228', 'BREAKDOWN', '故障', '2021-06-02 19:23:37', '1', '1', '2021-06-02 19:23:37', '2021-06-02 19:23:36', '0', null, null);
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402092137608376321', '10', '2021-06-08', '1399759371575119874', '感温电缆2', '1399759371566731266', '1392361054348230658', '92040700PEM44', '1619086103649', 'FIREALARM', '火灾告警', '2021-06-08 14:04:59', '6', '6', '2021-06-08 10:36:30', '2021-06-08 14:04:59', '1392709773413302274', '火警', 'FAS_TemperatureCable_FireAlarm');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402140224599093249', '10', '2021-06-08', '1399619288641458178', '极1低阀门', '1399619288637263873', '1392361071419047937', '92100400VWE44', '1619085975042', '', '', '2021-06-08 13:48:03', '2', '2', '2021-06-08 13:47:35', '2021-06-08 13:48:03', '1392709791314591746', '全关', 'ONL_DrainOilValve_Close');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402151108306268161', '10', '2021-06-08', '1399763046993383425', '极1高感温电缆', '1399763046984994818', '1392361067740643330', '92110100QY544', '1620383459228', 'FIREALARM', '火灾告警', '2021-06-08 14:36:46', '3', '3', '2021-06-08 14:30:50', '2021-06-08 14:36:46', '1392709808670621697', '火警', 'FFS_TemperatureCable_FireAlarm');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402151599983554561', '10', '2021-06-08', '1399763046993383425', '极1高感温电缆', '1399763046984994818', '1392361067740643330', '92110100QY544', '1620383459228', 'BREAKDOWN', '故障', '2021-06-08 14:34:19', '2', '2', '2021-06-08 14:32:47', '2021-06-08 14:34:19', '1392709808855171073', '故障', 'FFS_TemperatureCable_Fault');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402155070933692417', '10', '2021-06-08', '1399759372363649025', '手报2', '1399759372355260418', '1392361052318187522', '920404002PU44', '1619086103649', 'FIREALARM', '火灾告警', '2021-06-08 14:47:17', '3', '3', '2021-06-08 14:46:34', '2021-06-08 14:47:17', '1392709769311272961', '火警', 'FAS_ManualAlarm_FireAlarm');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402155616914632706', '10', '2021-06-08', '1399763047115018241', '极2高感温电缆', '1399763047102435330', '1392361067740643330', '92110100QY544', '1620383459228', 'BREAKDOWN', '故障', '2021-06-08 14:49:23', '4', '4', '2021-06-08 14:48:45', '2021-06-08 14:49:23', '1392709808855171073', '故障', 'FFS_TemperatureCable_Fault');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402433484118810625', '10', '2021-06-09', '1402199944601001986', 'N006L01D017烟感', '1402199944592613377', '1392361051122810882', '920402009EM44', '1619086103649', 'FIREALARM', '火灾告警', '2021-06-09 10:46:57', '9', '9', '2021-06-09 09:12:53', '2021-06-09 10:46:57', '1392709766421397506', '火警', 'FAS_SmokeAlarm_FireAlarm');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402434862736203777', '10', '2021-06-09', '1402199944601001986', 'N006L01D017烟感', '1402199944592613377', '1392361051122810882', '920402009EM44', '1619086103649', 'BREAKDOWN', '故障', '2021-06-09 09:18:41', '2', '2', '2021-06-09 09:18:22', '2021-06-09 09:18:41', '1392709766857605121', '故障', 'FAS_SmokeAlarm_Fault');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402464295555641345', '10', '2021-06-09', '1402199944554864641', 'N006L01D016烟感', '1402199944500338690', '1392361051122810882', '920402009EM44', '1619086103649', 'FIREALARM', '火灾告警', '2021-06-09 11:15:19', '1', '1', '2021-06-09 11:15:19', '2021-06-09 11:15:19', '1392709766421397506', '火警', 'FAS_SmokeAlarm_FireAlarm');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402466634194694145', '10', '2021-06-09', '1402199944554864641', 'N006L01D016烟感', '1402199944500338690', '1392361051122810882', '920402009EM44', '1619086103649', 'BREAKDOWN', '故障', '2021-06-09 11:24:47', '2', '2', '2021-06-09 11:24:37', '2021-06-09 11:24:47', '1392709766857605121', '故障', 'FAS_SmokeAlarm_Fault');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402472948094414850', '10', '2021-06-09', '1399619241862385665', '4#产生装置', '1399619241853997058', '1392361059477864450', '92030500MG644', '1619086125285', 'BREAKDOWN', '故障', '2021-06-09 14:26:09', '19', '13', '2021-06-09 11:49:42', '2021-06-09 14:26:09', '1392709887997493249', '故障', 'CAFS_FoamProductionDevice_Fault');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402473045481959426', '10', '2021-06-09', '1402199944554864641', 'N006L01D016烟感', '1402199944500338690', '1392361051122810882', '920402009EM44', '1619086103649', 'SHIELD', '屏蔽', '2021-06-09 11:50:13', '3', '3', '2021-06-09 11:50:05', '2021-06-09 11:50:13', '1392709767377698818', '屏蔽', 'FAS_SmokeAlarm_Shield');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402473288147611650', '10', '2021-06-09', '1402199944479367170', 'N006L01D015烟感', '1402199944479367169', '1392361051122810882', '920402009EM44', '1619086103649', 'FIREALARM', '火灾告警', '2021-06-09 11:51:07', '3', '3', '2021-06-09 11:51:03', '2021-06-09 11:51:07', '1392709766421397506', '火警', 'FAS_SmokeAlarm_FireAlarm');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402473386676006914', '10', '2021-06-09', '1402199944479367170', 'N006L01D015烟感', '1402199944479367169', '1392361051122810882', '920402009EM44', '1619086103649', 'BREAKDOWN', '故障', '2021-06-09 11:51:39', '6', '6', '2021-06-09 11:51:27', '2021-06-09 11:51:39', '1392709766857605121', '故障', 'FAS_SmokeAlarm_Fault');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402503567008542722', '10', '2021-06-09', '1399619289035722754', '极2低交流电源', '1399619289035722753', '1392361070315945986', '921002000JK44', '1619085975042', '', '', '2021-06-09 13:52:52', '2', '2', '2021-06-09 13:51:22', '2021-06-09 13:52:52', '1402105661806080001', '投入', 'ONL_ACPower_Throw');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402504262675804162', '10', '2021-06-09', '1399619289035722754', '极2低交流电源', '1399619289035722753', '1392361070315945986', '921002000JK44', '1619085975042', 'BREAKDOWN', '故障', '2021-06-09 13:54:08', '1', '1', '2021-06-09 13:54:08', '2021-06-09 13:54:08', '1399618381275090945', '交流电源故障', 'ONL_ACPower_Fault');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402507974458523650', '10', '2021-06-09', '1402199944601001986', 'N006L01D017烟感', '1402199944592613377', '1392361051122810882', '920402009EM44', '1619086103649', 'SHIELD', '屏蔽', '2021-06-09 14:09:35', '2', '2', '2021-06-09 14:08:53', '2021-06-09 14:09:35', '1392709767377698818', '屏蔽', 'FAS_SmokeAlarm_Shield');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402509001614213122', '10', '2021-06-09', '1402199942881337345', 'N003L03D039烟感', '1402199942864560130', '1392361051122810882', '920402009EM44', '1619086103649', 'FIREALARM', '火灾告警', '2021-06-09 14:26:38', '5', '5', '2021-06-09 14:12:58', '2021-06-09 14:26:38', '1392709766421397506', '火警', 'FAS_SmokeAlarm_FireAlarm');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402509480037658625', '10', '2021-06-09', '1402199944601001986', 'N006L01D017烟感', '1402199944592613377', '1392361051122810882', '920402009EM44', '1619086103649', 'SHIELD', '屏蔽', '2021-06-09 14:17:47', '2', '2', '2021-06-09 14:14:52', '2021-06-09 14:17:47', '1392709767377698818', '屏蔽', 'FAS_SmokeAlarm_Shield');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402510603074977793', '10', '2021-06-09', '1402199942881337345', 'N003L03D039烟感', '1402199942864560130', '1392361051122810882', '920402009EM44', '1619086103649', 'BREAKDOWN', '故障', '2021-06-09 14:55:21', '3', '3', '2021-06-09 14:19:20', '2021-06-09 14:55:21', '1392709766857605121', '故障', 'FAS_SmokeAlarm_Fault');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402511236654116866', '10', '2021-06-09', '1402199942881337345', 'N003L03D039烟感', '1402199942864560130', '1392361051122810882', '920402009EM44', '1619086103649', 'FIREALARM', '火灾告警', '2021-06-09 14:21:51', '1', '1', '2021-06-09 14:21:51', '2021-06-09 14:21:50', '1392709766421397506', '火警', 'FAS_SmokeAlarm_FireAlarm');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402512837041139714', '10', '2021-06-09', '1402199942881337345', 'N003L03D039烟感', '1402199942864560130', '1392361051122810882', '920402009EM44', '1619086103649', 'BREAKDOWN', '故障', '2021-06-09 14:28:12', '1', '1', '2021-06-09 14:28:12', '2021-06-09 14:28:12', '1392709766857605121', '故障', 'FAS_SmokeAlarm_Fault');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402513669971034114', '10', '2021-06-09', '1399619243808542721', '1#水箱', '1399619243804348418', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-06-09 14:48:34', '3', '0', '2021-06-09 14:31:31', '2021-06-09 14:48:34', '1396716339611197442', '水箱液位', 'CAFS_WaterTank_WaterTankLevel');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402514455006330882', '10', '2021-06-09', '1399619242680274945', '1#消防炮', '1399619242676080641', '1392361057749811202', '92030200DOD44', '1619086125285', '', '', '2021-06-09 14:34:38', '1', '1', '2021-06-09 14:34:38', '2021-06-09 14:43:32', '1392709850701742081', '开到位', 'CAFS_GunValve_Open');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402515910367064066', '10', '2021-06-09', '1399619243808542721', '1#水箱', '1399619243804348418', '1392361067237326849', '92032000N4344', '1619086125285', '0', null, '2021-06-09 14:40:25', '1', '0', '2021-06-09 14:40:25', '2021-06-09 14:40:25', '1396716339611197442', '水箱液位', 'CAFS_WaterTank_WaterTankLevel');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402516695767265282', '10', '2021-06-09', '1399619242680274945', '1#消防炮', '1399619242676080641', '1392361057749811202', '92030200DOD44', '1619086125285', '', '', '2021-06-09 14:43:32', '1', '1', '2021-06-09 14:43:32', '2021-06-09 14:43:32', '1392709850701742081', '开到位', 'CAFS_GunValve_Open');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402520209880825857', '10', '2021-06-09', '1399619243905011714', 'CAFS主机A', '1399619243900817410', '1392361057196163073', '92030100TGX44', '1619086125285', '', '', '2021-06-09 15:14:14', '3', '2', '2021-06-09 14:57:30', '2021-06-09 15:14:14', '1392709840186621953', '手动状态', 'CAFS_CompAirFoamHost_Manual');
INSERT INTO `wl_equipment_alarm_report_day` VALUES ('1402522453674242049', '10', '2021-06-09', '1399619243905011714', 'CAFS主机A', '1399619243900817410', '1392361057196163073', '92030100TGX44', '1619086125285', '', '', '2021-06-09 15:06:25', '1', '1', '2021-06-09 15:06:25', '2021-06-09 15:06:25', '1392709840186621953', '手动状态', 'CAFS_CompAirFoamHost_Manual');

-- ----------------------------
-- Table structure for wl_equipment_category
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment_category`;
CREATE TABLE `wl_equipment_category` (
  `id` bigint(20) NOT NULL,
  `parent_id` varchar(32) DEFAULT NULL,
  `code` varchar(50) NOT NULL COMMENT '装备分类编码',
  `name` varchar(50) NOT NULL COMMENT '装备分类名称',
  `is_consumptive` tinyint(4) DEFAULT NULL COMMENT '消耗性装备标志',
  `description` varchar(200) DEFAULT NULL COMMENT '用途或性能',
  `remark` varchar(200) DEFAULT NULL COMMENT '备注',
  `create_date` datetime DEFAULT NULL,
  `industry_code` varchar(50) DEFAULT NULL COMMENT '行业编码',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `ix_equipment_category_for_parent_id` (`parent_id`) USING BTREE,
  KEY `ix_equipment_category_for_code` (`code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='装备分类';

-- ----------------------------
-- Records of wl_equipment_category
-- ----------------------------
INSERT INTO `wl_equipment_category` VALUES ('1', null, '10000000', '消防人员防护装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('2', '1', '11000000', '基本防护装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('3', '2', '11010000', '消防头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('4', '3', '11010100', '全盔式消防头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('5', '3', '11010200', '半盔式消防头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('6', '3', '11019900', '其他消防头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('7', '2', '11020000', '消防员灭火防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('8', '7', '11020100', '消防员灭火防护服下裤', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('9', '2', '11030000', '消防手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('10', '9', '11030100', '1类消防手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('11', '9', '11030200', '2类消防手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('12', '9', '11030300', '3类消防手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('13', '9', '11039900', '其他消防手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('14', '2', '11040000', '消防安全腰带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('15', '2', '11050000', '消防员灭火防护靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('16', '15', '11050100', '灭火防护胶靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('17', '15', '11050200', '灭火防护皮靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('18', '15', '11059900', '其他灭火防护靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('19', '2', '11060000', '正压式消防空气呼吸器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('20', '2', '11070000', '佩戴式防爆照明灯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('21', '2', '11080000', '消防员呼救器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('22', '21', '11080100', '充电式呼救器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('23', '21', '11080200', '非充电式呼救器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('24', '21', '11089900', '其他呼救器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('25', '2', '11090000', '方位灯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('26', '2', '11100000', '消防轻型安全绳', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('27', '2', '11110000', '消防腰斧', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('28', '2', '11120000', '安全钩', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('29', '2', '11130000', '备用气瓶', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('30', '2', '11140000', '消防指挥服', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('31', '2', '11990000', '其他基本防护装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('32', '1', '12000000', '特种防护装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('33', '32', '12010000', '防护头盔及头面部防护装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('34', '33', '12010100', '抢险救援头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('35', '34', '12010101', '全盔式抢险救援头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('36', '34', '12010102', '半盔式抢险救援头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('37', '34', '12010199', '其他抢险救援头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('38', '33', '12010200', '消防员灭火防护头套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('39', '33', '12010300', '消防护目镜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('40', '33', '12019900', '其他防护头盔及头面部防护装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('41', '32', '12020000', '消防员特种防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('42', '41', '12020100', '消防员隔热防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('43', '41', '12020200', '消防员避火防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('44', '41', '12020300', '抢险救援服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('45', '41', '12020400', '化学防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('46', '45', '12020401', '二级化学防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('47', '45', '12020402', '一级化学防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('48', '45', '12020403', '特级化学防护服', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('49', '45', '12020499', '其他化学防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('50', '41', '12020500', '防火防化服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('51', '41', '12029000', '其他消防员特种防护服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('52', '51', '12029001', '防核防化服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('53', '51', '12029002', '防蜂服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('54', '51', '12029003', '防爆服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('55', '51', '12029004', '电绝缘装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('56', '51', '12029005', '防静电服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('57', '51', '12029006', '防静电内衣', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('58', '51', '12029007', '消防专用救生衣', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('59', '51', '12029008', '消防阻燃毛衣', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('60', '51', '12029009', '消防员降温背心', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('61', '51', '12029011', '核沾染防护服', '0', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('62', '32', '12030000', '消防员特种防护手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('63', '62', '12030100', '内置纯棉手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('64', '62', '12030200', '防高温手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('65', '62', '12030300', '防化手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('66', '65', '12030301', 'PVC厚手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('67', '65', '12030302', '天然橡胶手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('68', '65', '12030303', '氯丁橡胶手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('69', '65', '12030304', '聚氨酯手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('70', '65', '12030305', '丁腈橡胶手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('71', '65', '12030306', '氯磺化聚乙烯手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('72', '65', '12030307', 'PVA手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('73', '65', '12030399', '其他防化手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('74', '62', '12030400', '抢险救援手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('75', '62', '12039900', '其他特种防护手套', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('76', '32', '12040000', '消防员特种防护靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('77', '76', '12040100', '抢险救援靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('78', '76', '12040200', '化学防护靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('79', '76', '12040300', '防静电靴', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('80', '76', '12049900', '其他特种防护靴', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('81', '32', '12050000', '特种消防用防坠落装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('82', '81', '12050100', '消防通用安全绳', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('83', '81', '12050200', '消防安全吊带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('84', '83', '12050201', '消防Ⅰ类安全吊带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('85', '83', '12050202', '消防Ⅱ类安全吊带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('86', '83', '12050203', '消防Ⅲ类安全吊带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('87', '83', '12050299', '其他消防安全吊带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('88', '81', '12050300', '消防防坠落辅助部件', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('89', '81', '12059900', '其他特种消防用防坠落装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('90', '32', '12060000', '消防员特种呼吸保护装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('91', '90', '12060100', '长管空气呼吸器（移动供气源）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('92', '90', '12060200', '正压式消防氧气呼吸器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('93', '90', '12060300', '强制送风呼吸器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('94', '90', '12060400', '消防过滤式综合防毒面具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('95', '90', '12060500', '移动供气源', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('96', '90', '12069900', '其他特种呼吸保护装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('97', '32', '12070000', '消防水下保护装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('98', '97', '12070100', '潜水装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('99', '97', '12070200', '潜水服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('100', '99', '12070201', '干式潜水服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('101', '99', '12070202', '湿式潜水服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('102', '99', '12070299', '其他潜水服', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('103', '97', '12070300', '潜水头盔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('104', '97', '12070400', '水下通信设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('105', '97', '12070500', '水下工具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('106', '97', '12070600', '水下照明灯具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('107', '97', '12079900', '其他消防水下保护装具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('108', '32', '12080000', '特种防护装备及器具配件', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('109', '108', '12080100', '救援护膝护肘', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('110', '108', '12080200', '抢险救援腰带', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('111', '32', '12990000', '其他类特种防护装备及器具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('112', '111', '12990100', '消防员特种照明灯具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('113', '112', '12990101', '手提式强光照明灯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('114', '112', '12990102', '消防用荧光棒', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('115', '112', '12990199', '其他特种照明灯具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('116', '111', '12990200', '消防员特种通信装置', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('117', '116', '12990201', '消防员呼救器后场接收装置', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('118', '116', '12990202', '头骨振动式通信装置', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('119', '116', '12990203', '防爆手持电台', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('120', '116', '12990204', '消防员单兵定位装置', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('121', '111', '12999900', '其他特种防护装备及器具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('122', null, '20000000', '消防车、船（艇）、飞行器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('123', '122', '21000000', '消防车辆装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('124', '123', '21010000', '消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('125', '124', '21010100', '灭火类消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('126', '125', '21010101', '水罐消防车（SG）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('127', '125', '21010102', '泡沫消防车（PM）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('128', '125', '21010103', '压缩空气泡沫消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('129', '125', '21010104', '高倍泡沫消防车（GP）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('130', '125', '21010105', '泵浦消防车（BP）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('131', '125', '21010106', '干粉消防车（GF）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('132', '125', '21010107', '干粉泡沫联用消防车（GP）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('133', '125', '21010108', '干粉水联用消防车（GL）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('134', '125', '21010109', '涡喷消防车（WP）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('135', '125', '21010110', '二氧化碳消防车（EY）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('136', '125', '21010111', '细水雾消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('138', '125', '21010113', ' 干粉二氧化碳联用消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('139', '125', '21010199', '其他灭火消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('140', '124', '21010200', '举高类消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('141', '140', '21010201', '登高平台消防车（DG）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('142', '140', '21010202', '云梯消防车（YT）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('143', '140', '21010203', '举高喷射消防车（JP）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('144', '140', '21010299', '其他举高消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('145', '124', '21010300', '专勤类消防', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('146', '145', '21010301', '抢险救援消防车（JY）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('147', '145', '21010302', '排烟消防车（PY）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('148', '145', '21010303', '照明消防车（ZM）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('149', '145', '21010304', '排烟照明消防车（PZ）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('150', '145', '21010305', '高倍泡沫排烟消防车（PP）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('151', '145', '21010306', '水带敷设消防车（DF）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('152', '145', '21010307', '化学事故抢险救援消防车（HJ）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('153', '145', '21010308', '化学洗消消防车（HX）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('154', '145', '21010309', '核生化侦检消防车（ZJ）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('155', '145', '21010310', '勘察消防车（KC）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('156', '145', '21010311', '通讯指挥消防车（TZ）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('157', '145', '21010312', '宣传消防车（XC）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('158', '145', '21010399', '其他专勤消防', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('159', '124', '21010400', '战勤保障消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('160', '159', '21010401', '器材消防车（QC）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('161', '159', '21010402', '供水消防车（GS）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('162', '159', '21010403', '供液消防车（GY）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('163', '159', '21010404', '供气消防车（GQ）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('164', '159', '21010405', '自卸式消防车（ZX）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('165', '159', '21010406', '装备抢修车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('166', '159', '21010407', '饮食保障车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('167', '159', '21010408', '加油车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('168', '159', '21010409', '运兵车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('169', '159', '21010410', '宿营车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('170', '159', '21010411', '卫勤保障车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('171', '159', '21010412', '发电车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('172', '159', '21010413', '淋浴车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('173', '159', '21010414', '挖掘机', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('174', '159', '21010415', '装备拖车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('175', '159', '21010416', '吊车', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('176', '159', '21010499', '其他后援消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('177', '124', '21010500', '机场消防车（JX）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('178', '177', '21010501', '机场快速调动消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('179', '177', '21010502', '机场主力泡沫消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('180', '177', '21010599', '其他机场消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('181', '124', '21010600', '防爆消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('182', '124', '21010700', '轨道消防车（GD）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('183', '124', '21019900', '其他类消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('184', '123', '21020000', '消防摩托车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('185', '184', '21020100', '灭火消防摩托车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('186', '184', '21020200', '抢险救援摩托车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('187', '184', '21029900', '其他消防摩托车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('188', '123', '21990000', '其他消防车辆', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('189', '122', '22000000', '消防船艇', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('190', '189', '22010000', '大型消防艇', '0', null, '排水量800吨以上', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('191', '189', '22020000', '中型消防艇', '0', null, '排水量小于等于800吨，大于100吨', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('192', '189', '22030000', '小型消防艇', '0', null, '排水量小于等于100吨', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('193', '189', '22040000', '冲锋舟', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('194', '189', '22050000', '橡皮艇', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('195', '189', '22990000', '其他消防船艇', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('196', '122', '23000000', '消防飞行器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('197', '196', '23010000', '固定翼飞机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('198', '196', '23020000', '直升机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('199', '196', '23030000', '飞艇', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('200', '196', '23040000', '无人飞行器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('201', '196', '23990000', '其他消防飞行器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('202', null, '30000000', '灭火器材装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('203', '202', '31000000', '消防器具类', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('204', '203', '31010000', '输水器具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('205', '204', '31010100', '吸水管', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('206', '205', '31010101', '胶管', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('207', '205', '31010102', 'PVC管', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('208', '205', '31010199', '其他材料吸水管', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('209', '204', '31010200', '吸水附属器具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('210', '209', '31010201', '吸水管接口', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('211', '209', '31010202', '滤水器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('212', '209', '31010203', '吸水管扳手', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('213', '209', '31010204', '排吸器', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('214', '209', '31010299', '其他吸水附属器具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('215', '204', '31010400', '消防水带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('216', '215', '31010401', '低压消防水带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('217', '215', '31010402', '中压消防水带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('218', '215', '31010403', '高压消防水带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('219', '215', '31010404', 'A类泡沫专用水带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('220', '215', '31010405', '水幕水带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('221', '215', '31010499', '其他水带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('222', '204', '31010500', '分水器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('223', '204', '31010600', '集水器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('224', '204', '31010700', '消防球阀', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('225', '204', '31010800', '水囊（槽）', '0', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('226', '204', '31010900', 'A/B类泡沫比例混合器', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('228', '204', '31011200', '消防水带附属器具', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('229', '228', '31011201', '卡式水带接口', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('230', '228', '31011202', '内扣式水带接口', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('231', '228', '31011203', '螺纹式水带接口', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('232', '228', '31011211', '水带包布', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('233', '228', '31011221', '水带卷盘', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('234', '228', '31011222', '移动式水带卷盘', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('235', '228', '31011231', '水带护桥', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('236', '228', '31011241', '水带挂钩', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('237', '204', '31019900', '其他输水器具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('238', '203', '31020000', '消防枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('239', '238', '31020100', '消防水枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('240', '239', '31020101', '直流水枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('241', '239', '31020102', '喷雾水枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('242', '239', '31020103', '直流喷雾水枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('243', '239', '31020104', '多功能消防水枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('244', '239', '31020105', '脉冲水枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('245', '239', '31020106', '开花水枪', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('246', '239', '31020107', '带架水枪', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('247', '239', '31020199', '其他水枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('248', '238', '31020200', '消防泡沫枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('249', '248', '31020201', '低倍数泡沫枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('250', '248', '31020202', '中倍数泡沫枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('251', '248', '31020203', '低倍数中倍数联用泡沫枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('252', '248', '31020204', '压缩空气泡沫系统专用枪', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('253', '248', '31020299', '其他泡沫枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('254', '238', '31020300', '泡沫钩管', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('255', '238', '31020400', '干粉枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('256', '238', '31029900', '其他消防枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('257', '203', '31030000', '移动消防炮', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('258', '257', '31030100', '消防水炮', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('259', '257', '31030200', '消防泡沫炮', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('260', '257', '31030300', '消防干粉炮', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('261', '257', '31030400', '大流量移动消防炮（拖车式）', '0', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('262', '257', '31030500', '自摆式消防炮', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('263', '257', '31030600', '手动消防炮', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('264', '257', '31030700', '电动遥控炮', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('265', '257', '31030800', '电动泡沫遥控炮', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('266', '257', '31039900', '其他消防炮', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('267', '203', '31040000', '灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('268', '267', '31040100', '水基型灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('269', '268', '31040101', '水型灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('270', '268', '31040102', '泡沫灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('271', '268', '31040199', '其他水基型', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('272', '267', '31040200', '干粉灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('273', '272', '31040201', 'BC干粉灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('274', '272', '31040202', 'ABC干粉灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('275', '272', '31040203', 'D类火灾专用灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('276', '272', '31040299', '其他干粉灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('277', '267', '31040300', '二氧化碳灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('278', '267', '31040400', '清洁气体灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('279', '278', '31040401', '卤代烷烃类', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('280', '278', '31040402', '惰性气体', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('281', '278', '31040499', '其他清洁气体', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('282', '267', '31040500', '移动式细水雾灭火装置', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('283', '267', '31040600', '风力灭火机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('284', '267', '31049900', '其他灭火器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('285', '203', '31990000', '其他消防器具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('286', '285', '31990100', '转换接口', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('287', '286', '31990101', '异径接口', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('288', '286', '31990102', '异形接口', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('289', '202', '32000000', '消防泵类', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('290', '289', '32010000', '低压消防泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('291', '289', '32020000', '中压消防泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('292', '289', '32030000', '中低压消防泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('293', '289', '32040000', '高压消防泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('294', '289', '32050000', '高低压消防泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('295', '289', '32060000', '超高压消防泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('296', '289', '32990000', '其他消防泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('297', '296', '32990100', '手抬机动泵', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('298', '296', '32990200', '浮艇泵', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('299', '296', '32990300', '泡沫泵', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('300', '202', '39000000', '其他灭火器材装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('301', '300', '39010000', '消防锹', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('302', '300', '39020000', '铁挺', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('303', '300', '39030000', '消防镐', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('304', '300', '39040000', '消防斧', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('305', '300', '39050000', '消防锤', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('306', '300', '39060000', '帆布水桶', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('307', '300', '39070000', '地下消火栓钥匙', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('308', '300', '39080000', '地上消火栓钥匙', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('309', '300', '39090000', '消防钩', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('310', null, '40000000', '灭火药剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('311', '310', '41000000', '水灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('312', '311', '41001234', '水灭火剂C', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('313', '311', '41002358', '水灭火剂A', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('314', '311', '41005326', '水灭火剂B', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('315', '310', '42000000', '泡沫灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('316', '315', '42010000', '机械泡沫灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('317', '316', '42010100', '蛋白泡沫灭火剂（P）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('318', '316', '42010200', '氟蛋白泡沫灭火剂（FP）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('319', '316', '42010300', '合成泡沫灭火剂（S）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('320', '316', '42010400', '抗溶泡沫灭火剂（AR）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('321', '316', '42010500', '水成膜泡沫灭火剂（AFFF）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('322', '316', '42010600', '成膜氟蛋白泡沫灭火剂（FFFP）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('323', '316', '42019900', '其他机械泡沫灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('324', '315', '42020000', '压缩空气泡沫灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('325', '315', '42030000', '化学泡沫灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('326', '315', '42040000', '蛋白泡沫（P）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('327', '315', '42050000', '氟蛋白泡沫（FP）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('328', '315', '42060000', '抗溶性氟蛋白泡沫（FP/AR）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('329', '315', '42070000', '成膜氟蛋白泡沫灭火剂（FFFP）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('330', '315', '42080000', '抗溶性成膜氟蛋白泡沫（FFFP/AR）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('331', '315', '42090000', '普通合成泡沫灭火剂（S）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('332', '315', '42100000', '高倍数泡沫或高中低倍通用泡沫', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('333', '315', '42110000', '合成型抗溶泡沫(S/AR)', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('334', '315', '42120000', '水成膜泡沫（AFFF）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('335', '315', '42130000', '抗溶性水成膜泡沫（AFFF/AR）', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('336', '315', '42140000', 'A类泡沫', '1', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('337', '315', '42990000', '其他泡沫灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('338', '310', '43000000', '干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('339', '338', '43010000', '普通干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('340', '339', '43010100', 'BC类干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('341', '339', '43010200', 'ABC类干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('342', '339', '43019900', '其他普通干粉', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('343', '338', '43020000', '超细干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('344', '343', '43020100', 'BC类超细干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('345', '343', '43020200', 'ABC类超细干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('346', '343', '43029900', '其他超细干粉', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('347', '338', '43030000', '金属火灾干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('348', '347', '43030100', '石墨类', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('349', '347', '43030200', '氯化钠类', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('350', '347', '43030300', '碳酸钠类', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('351', '347', '43039900', '其他金属火灾干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('352', '338', '43990000', '其他干粉灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('353', '310', '44000000', '气体灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('354', '353', '44010000', '卤代烷烃灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('355', '354', '44010100', '七氟丙烷（HFC227ea）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('356', '354', '44010200', '三氟丙烷（HFC23）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('357', '354', '44010300', '六氟丙烷（HFC236fa）', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('358', '354', '44010400', '哈龙1301', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('359', '354', '44010500', '哈龙1211', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('360', '354', '44019900', '其他卤代烷烃', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('361', '353', '44020000', '二氧化碳灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('362', '353', '44030000', '惰性气体灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('363', '362', '44030100', 'IG01', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('364', '362', '44030200', 'IG100', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('365', '362', '44030300', 'IG55', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('366', '362', '44030400', 'IG541', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('367', '362', '44039900', '其他惰性气体', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('368', '353', '44990000', '其他气体灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('369', '310', '49000000', '其他灭火剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('370', null, '50000000', '抢险救援器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('371', '370', '51000000', '侦检器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('372', '371', '51010000', '有毒气体探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('373', '371', '51020000', '军事毒剂侦检仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('374', '371', '51030000', '可燃气体检测器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('375', '371', '51040000', '水质分析仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('376', '371', '51050000', '电子气象仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('377', '371', '51060000', '音频生命探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('378', '371', '51070000', '视频生命探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('379', '371', '51080000', '生命探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('380', '379', '51080100', '音频生命探测仪', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('381', '379', '51080200', '视频生命探测仪', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('382', '379', '51080300', '雷达生命探测仪', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('383', '371', '51090000', '消防用红外热像仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('384', '371', '51100000', '漏电探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('385', '371', '51110000', '核放射探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('386', '371', '51120000', '电子酸碱测试仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('387', '371', '51130000', '移动式生物快速侦检仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('388', '371', '51140000', '水深探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('389', '371', '51150000', '无线复合气体探测仪', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('390', '371', '51160000', '测温仪', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('391', '371', '51170000', '激光测距仪', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('392', '371', '51180000', '便携危险化学品检测片', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('393', '371', '51190000', '金属探测仪', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('394', '371', '51990000', '其他侦检器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('395', '370', '52000000', '警戒器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('396', '395', '52010000', '警戒标志杆', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('397', '395', '52020000', '锥型事故标志柱', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('398', '395', '52030000', '隔离警示带', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('399', '395', '52040000', '出入口标志牌', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('400', '395', '52050000', '危险警示牌', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('401', '400', '52050100', '有毒标志', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('402', '400', '52050200', '易燃标志', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('403', '400', '52050300', '泄漏标志', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('404', '400', '52050400', '爆炸标志', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('405', '400', '52050500', '放射标志', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('406', '395', '52060000', '闪光警示灯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('407', '395', '52070000', '手持扩音器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('408', '395', '52990000', '其他警戒器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('409', '370', '53000000', '消防梯及救生器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('410', '409', '53010000', '消防梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('411', '410', '53010100', '单杆梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('412', '410', '53010200', '挂钩梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('413', '410', '53010300', '拉梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('414', '413', '53010301', '二节拉梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('415', '413', '53010302', '三节拉梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('416', '413', '53010399', '其他拉梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('417', '410', '53010400', '折叠式救援梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('418', '410', '53010500', '救生软梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('419', '410', '53019900', '其他消防梯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('420', '409', '53020000', '救生器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('421', '420', '53020100', '躯体固定气囊', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('422', '420', '53020200', '肢体固定气囊', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('423', '420', '53020300', '婴儿呼吸袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('424', '420', '53020400', '逃生面罩', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('425', '420', '53020500', '救生照明线', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('426', '420', '53020600', '折叠式担架', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('427', '420', '53020700', '伤员固定抬板', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('428', '420', '53020800', '多功能担架', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('429', '420', '53020900', '消防救生气垫', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('430', '420', '53021000', '救生缓降器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('431', '420', '53021100', '灭火毯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('432', '420', '53021200', '医药急救箱', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('433', '420', '53021300', '医用简易呼吸器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('434', '420', '53021400', '气动起重气垫', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('435', '420', '53021500', '救援支架', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('436', '420', '53021600', '救生抛投器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('437', '420', '53021700', '水面漂浮救生绳', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('438', '420', '53021800', '机动橡皮舟', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('439', '420', '53021900', '敛尸袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('440', '420', '53022000', '消防过滤式自救呼吸器', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('441', '420', '53022100', '自喷荧光漆', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('442', '420', '53022200', '通讯救生安全绳 ', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('443', '420', '53022300', '打捞网', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('444', '420', '53022400', '救生杆', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('445', '420', '53022500', '水面救援装具', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('446', '420', '53029900', '其他救生器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('447', '409', '53990000', '其他消防梯及救生器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('448', '370', '54000000', '破拆器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('449', '448', '54010000', '电动剪扩钳', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('450', '448', '54020000', '液压剪切器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('451', '448', '54030000', '液压万向剪切钳', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('452', '448', '54040000', '液压剪扩器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('453', '448', '54050000', '双轮异向切割锯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('454', '448', '54060000', '机动链锯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('455', '448', '54070000', '无齿锯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('456', '448', '54080000', '等离子切割器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('457', '448', '54090000', '气动切割刀', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('458', '448', '54100000', '液压扩张器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('459', '448', '54110000', '液压撑顶器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('460', '448', '54120000', '重型支撑套具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('461', '460', '54120100', '液压式', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('462', '460', '54120200', '气压式', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('463', '460', '54120300', '机械手动式', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('464', '448', '54130000', '液压机动泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('465', '464', '54130100', '内燃式液压机动泵', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('466', '464', '54130200', '电池液压机动泵', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('467', '448', '54140000', '手动液压泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('468', '448', '54150000', '开门器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('469', '448', '54160000', '冲击钻', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('470', '448', '54170000', '凿岩机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('471', '448', '54180000', '玻璃破碎器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('472', '448', '54190000', '手持式钢筋速断器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('473', '448', '54200000', '液压破拆工具组', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('474', '448', '54210000', '手动破拆工具组', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('475', '448', '54220000', '混凝土液压破拆工具组', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('476', '448', '54230000', '便携式防盗门破拆工具组', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('477', '448', '54240000', '便携式汽油金属切割器', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('478', '448', '54250000', '液压千斤顶', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('479', '448', '54260000', '多功能刀具', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('480', '448', '54270000', '绝缘剪断钳', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('481', '448', '54280000', '毁锁器', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('482', '448', '54290000', '多功能挠钩', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('483', '448', '54310000', '便携式手动液压剪扩钳', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('484', '448', '54320000', '封管器', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('485', '448', '54990000', '其他破拆器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('486', '370', '55000000', '堵漏器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('487', '486', '55010000', '内封式堵漏袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('488', '487', '55010100', '直径10/20mm', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('489', '487', '55010200', '直径20/40mm', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('490', '487', '55010300', '直径30/60mm', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('491', '487', '55010400', '直径50/100mm', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('492', '486', '55020000', '外封式堵漏袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('493', '486', '55030000', '捆绑式堵漏袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('494', '493', '55030100', '5/20mm', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('495', '493', '55030200', '20/48mm', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('496', '486', '55040000', '下水道阻流袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('497', '486', '55050000', '金属堵漏套管', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('498', '486', '55060000', '堵漏枪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('499', '498', '55060100', '圆锥', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('500', '498', '55060200', '楔型', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('501', '500', '55060201', '1型', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('502', '500', '55060202', '2型', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('503', '500', '55060203', '3型', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('504', '486', '55070000', '阀门堵漏套具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('505', '486', '55080000', '注入式堵漏工具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('506', '486', '55090000', '粘贴式堵漏工具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('507', '486', '55100000', '电磁式堵漏工具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('508', '486', '55110000', '木制堵漏楔', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('509', '486', '55120000', '气动吸盘式堵漏器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('510', '486', '55130000', '管道粘结剂', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('511', '486', '55140000', '无火花工具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('512', '486', '55150000', '强磁堵漏工具', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('513', '486', '55990000', '其他堵漏器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('514', '370', '56000000', '输转器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('515', '514', '56010000', '手动隔膜抽吸泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('516', '514', '56020000', '防爆输转泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('517', '514', '56030000', '粘稠液体抽吸泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('518', '514', '56040000', '排污泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('519', '514', '56050000', '有毒物质密封桶', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('520', '514', '56060000', '围油栏', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('521', '514', '56070000', '吸附垫', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('522', '514', '56080000', '集污袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('523', '514', '56990000', '其他输转器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('524', '370', '57000000', '消防洗消装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('525', '524', '57010000', '洗消剂', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('526', '525', '57010100', '强酸、碱清洗剂', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('527', '525', '57010200', '洗消粉', '1', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('528', '527', '57010201', '三合一强氧化洗消粉', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('529', '527', '57010299', '其他洗消粉', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('530', '525', '57010300', '三合二洗消剂', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('531', '525', '57010400', '有机磷降解酶', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('532', '525', '57010500', '消毒粉', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('533', '525', '57019900', '其他洗消剂', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('534', '524', '57020000', '洗消装置', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('535', '534', '57020100', '强酸、碱洗消器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('536', '534', '57020200', '生化洗消装置', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('537', '534', '57020300', '简易洗消喷淋器', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('538', '534', '57020400', '消防面罩超声波清洗机', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('539', '534', '57020500', '洗消净水池', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('540', '534', '57020600', '洗消污水池', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('541', '534', '57020700', '洗眼器', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('542', '534', '57029900', '其他洗消装置', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('543', '524', '57030000', '洗消站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('544', '543', '57030100', '单人洗消帐篷', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('545', '543', '57030200', '公众洗消站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('546', '543', '57039900', '其他洗消站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('547', '524', '57990000', '其他消防洗消装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('548', '370', '58000000', '照明、排烟器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('549', '548', '58010000', '移动式排烟机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('550', '548', '58020000', '坑道小型空气输送机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('551', '548', '58030000', '移动照明灯组', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('552', '548', '58040000', '移动发电机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('553', '548', '58050000', '水驱动排烟机', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('554', '548', '58990000', '其他照明、排烟器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('555', '370', '59000000', '其他类器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('556', '555', '59010000', '空气充填泵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('557', '555', '59020000', '防化服清洗烘干器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('558', '555', '59030000', '消防移动储水装置', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('559', '555', '59040000', '高倍数泡沫发生器', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('560', '555', '59050000', '电源逆变器', '0', null, '系统推广后调整', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('561', '555', '59060000', '液压动力站', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('562', '555', '59070000', '液压胶管', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('563', '555', '59080000', '装备技师工具箱', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('564', '555', '59990000', '其他特勤器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('565', '564', '59990100', '野外炊事保障单元', '0', null, '2014年第二次代码变更', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('566', null, '60000000', '消防通信指挥装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('567', '566', '61000000', '计算机通信网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('568', '567', '61010000', '路由器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('569', '567', '61020000', '交换机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('570', '567', '61090000', '其他计算机通信网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('571', '566', '62000000', '有线通信网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('572', '571', '62010000', '程控交换机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('573', '571', '62020000', '光电传输设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('574', '571', '62030000', '复用设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('575', '571', '62040000', '电信终端设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('576', '571', '62050000', 'VoIP网关', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('577', '571', '62060000', '附加设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('578', '571', '62090000', '其他有线通信网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('579', '566', '63000000', '无线通信网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('580', '579', '63010000', '无线常规网', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('581', '580', '63010100', '一级网通信基站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('582', '580', '63010200', '一级网移动通信基站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('583', '580', '63010300', '一级网固定电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('584', '580', '63010400', '一级网车载电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('585', '580', '63010500', '二级网手持电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('586', '580', '63010600', '三级网手持电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('587', '580', '63010700', '无线地下中继设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('588', '580', '63010800', '无线数据网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('589', '580', '63019900', '其他无线常规网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('590', '579', '63020000', '无线集群网', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('591', '590', '63020100', '分调度台设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('592', '590', '63020200', '移动通信基站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('593', '590', '63020300', '车载电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('594', '590', '63020400', '手持电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('595', '590', '63020500', '编程器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('596', '590', '63029900', '其他无线集群网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('597', '566', '64000000', '卫星通信网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('598', '597', '64010000', '卫星固定站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('599', '597', '64020000', '卫星移动站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('600', '599', '64020100', '车载站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('601', '599', '64020200', '便携站', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('602', '597', '64030000', '卫星电话终端', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('603', '597', '64990000', '其他卫星通信网设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('604', '566', '65000000', '信息中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('605', '604', '65010000', '服务器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('606', '604', '65020000', '存储设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('607', '604', '65030000', '安全保障设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('608', '607', '65030100', '网络安全设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('609', '608', '65030101', '防火墙', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('610', '608', '65030102', '入侵检测系统（IDS）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('611', '608', '65030103', '入侵防御系统(IPS)', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('612', '608', '65030104', '隔离网闸', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('613', '608', '65030105', '统一威胁管理系统（UTM）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('614', '608', '65030106', '抗分布式拒绝服务攻击网关（DD0S）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('615', '608', '65030107', '防病毒网关', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('616', '608', '65030108', '站防护系统（Web应用防火墙）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('617', '608', '65030109', '漏洞扫描系统', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('618', '608', '65030110', '网络安全管理平台（SQC）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('619', '608', '65030199', '其他信息中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('620', '607', '65030200', '公钥基础设施（PKI）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('621', '620', '65030201', '地注册代理（LRA）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('622', '620', '65030202', 'PKI从目录系统', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('623', '620', '65030203', '集中认证网关', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('624', '620', '65030204', '审计查询系统（AQS）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('625', '620', '65030299', '其他公钥基础设施', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('626', '607', '65030300', '安全接入系统设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('627', '626', '65030301', 'VPN安全网关', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('628', '626', '65030302', '短信安全网关', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('629', '626', '65030303', 'AAA认证服务器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('630', '626', '65030304', '集成CA*LDAP*RA服务器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('631', '626', '65030305', '终端安全加固系统', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('632', '626', '65030306', '应用代理和终端安全管理服务器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('633', '626', '65030307', '安全接入管理平台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('634', '626', '65030399', '其他安全接入系统设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('635', '607', '65039900', '其他安全保障设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('636', '604', '65040000', '电源设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('637', '636', '65040100', '交流电源', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('638', '636', '65040200', 'UPS电源', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('639', '604', '65990000', '其他电源设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('640', '566', '66000000', '指挥中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('641', '640', '66010000', '通信指挥中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('642', '641', '66010100', '接警调度终端', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('643', '641', '66010200', '指挥调度终端', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('644', '641', '66010300', '综合信息管理终端', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('645', '641', '66010400', '电话机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('646', '641', '66010500', '打印、传真机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('647', '641', '66010600', '大屏幕显示设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('648', '647', '66010601', 'DLP', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('649', '647', '66010602', '投影', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('650', '647', '66010603', '液晶', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('651', '647', '66010604', 'LED', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('652', '647', '66010699', '其他', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('653', '641', '66010700', '指挥大厅音响设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('654', '653', '66010701', '调音台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('655', '653', '66010702', '功放机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('656', '653', '66010703', '音箱', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('657', '653', '66010799', '其他', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('658', '641', '66010800', '火警广播设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('659', '658', '66010801', '话筒', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('660', '658', '66010802', '功放机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('661', '658', '66010803', '扬声器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('662', '658', '66010899', '其他火警广播设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('663', '641', '66010900', '指挥会议设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('664', '663', '66010901', '视频会议终端', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('665', '663', '66010902', '数字会议设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('666', '663', '66010903', '音响设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('667', '663', '66010904', '交互电子白板', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('668', '663', '66010999', '其他指挥会议设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('669', '641', '66011000', '视频设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('670', '669', '66011001', '视频会议多点控制单元（MCU）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('671', '669', '66011002', '视频解码器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('672', '669', '66011003', '分配器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('673', '669', '66011004', '切换矩阵', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('674', '669', '66011005', '录像机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('675', '669', '66011099', '其他视频设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('676', '641', '66011100', '综合图像管理平台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('677', '641', '66011200', '综合语音管理平台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('678', '641', '66011300', '集中控制设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('679', '678', '66011301', '控制主机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('680', '678', '66011302', '无线触摸屏', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('681', '678', '66011303', '灯光控制器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('682', '678', '66011304', '以太网控制卡', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('683', '678', '66011305', '视音频切换设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('684', '678', '66011399', '其他集中控制设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('685', '641', '66011400', '录音录时设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('686', '641', '66019900', '其他通信指挥中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('687', '640', '66020000', '消防站设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('688', '687', '66020100', '消防站火警终端', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('689', '687', '66020200', '电话机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('690', '687', '66020300', '打印、传真机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('691', '687', '66020400', '紧急信号接收机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('692', '687', '66020500', '火警广播设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('693', '687', '66020600', '录音录时设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('694', '687', '66020700', '联动控制设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('695', '687', '66020800', '视频监控设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('696', '687', '66020900', '指挥会议设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('697', '687', '66021000', '网络设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('698', '687', '66021100', 'UPS电源', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('699', '687', '66029900', '其他消防站设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('700', '640', '66030000', '移动指挥中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('701', '700', '66030100', '电话交换设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('702', '700', '66030200', '电话机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('703', '700', '66030300', '车外广播扩音设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('704', '700', '66030400', '无线视频传输系统', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('705', '700', '66030500', '短波电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('706', '705', '66030501', '短波固定电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('707', '705', '66030502', '短波背负电台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('708', '700', '66030600', '网络交换机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('709', '700', '66030700', '紧急信号发送设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('710', '700', '66030800', '通信组网管理设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('711', '700', '66030900', '车载计算机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('712', '700', '66031000', '便携式计算机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('713', '700', '66031100', '便携式作战指挥平台', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('714', '700', '66031200', '视音频会议系统终端', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('715', '700', '66031300', '打印、复印、传真机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('716', '700', '66031400', '现场图像采集设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('717', '700', '66031500', '气象采集设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('718', '700', '66031600', '标准时钟', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('719', '700', '66031700', '综合显示屏及附件', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('720', '700', '66031800', '显示控制设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('721', '700', '66031900', '音视频存储设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('722', '700', '66032000', '定制车厢', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('723', '700', '66032100', '会议桌、椅', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('724', '700', '66032200', '指挥通信终端、机柜等', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('725', '700', '66032300', '储物柜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('726', '700', '66032400', '外接口面板仓和接口', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('727', '700', '66032500', '升降杆', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('728', '700', '66032600', '电缆盘、盘架、线缆', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('729', '700', '66032700', '综合布线', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('730', '700', '66032800', '行车设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('731', '700', '66032900', '警示设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('732', '700', '66033000', '供电设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('733', '700', '66033100', '配电盘柜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('734', '700', '66033200', '隔离变压器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('735', '700', '66033300', 'UPS电源', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('736', '700', '66033400', '驻车空调', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('737', '700', '66033500', '车内照明', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('738', '700', '66033600', '车外照明', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('739', '700', '66033700', '卫生间设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('740', '700', '66033800', '饮用水设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('741', '700', '66033900', '食品加热设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('742', '700', '66034000', '食品冷藏设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('743', '700', '66034100', '车内音响系统', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('744', '700', '66034200', '灭火救援指挥箱', '0', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('745', '700', '66039900', '其他移动指挥中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('746', '640', '66990000', '其他指挥中心设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('747', '566', '69000000', '其他消防通信指挥装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('748', '747', '69010000', '水下通信设备', '0', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('749', null, '70000000', '特种消防装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('750', '749', '71000000', '消防灭火机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('751', '750', '71010000', '灭火机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('752', '750', '71020000', '侦察机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('753', '750', '71030000', '救援机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('754', '750', '71040000', '消防排烟机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('755', '750', '71050000', '反恐排爆机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('756', '750', '71060000', '潜水救助机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('757', '750', '71070000', '消防破拆机器人', '0', null, '变更导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('758', '750', '71990000', '其他消防机器人', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('759', '749', '72000000', '消防坦克', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('760', '749', '73000000', '消防装甲车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('761', '749', '74000000', '全地形消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('762', '749', '75000000', '水陆两用消防车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('763', '749', '79000000', '其他特种消防装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('764', null, '80000000', '防火检查与火灾调查装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('765', '764', '81000000', '建筑消防设施现场检测装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('766', '765', '81010000', '点形感烟火灾探测器功能试验器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('767', '765', '81020000', '点形感温火灾探测器功能试验器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('768', '765', '81030000', '线形光束感烟火灾探测器功能试验器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('769', '765', '81040000', '火焰探测器功能试验器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('770', '765', '81050000', '数字照度计', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('771', '765', '81060000', '数字声级计', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('772', '765', '81070000', '数字测距仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('773', '765', '81080000', '数字风速计', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('774', '765', '81090000', '数字微压计', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('775', '765', '81100000', '消火栓测压装置', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('776', '765', '81110000', '喷淋末端试水接头', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('777', '765', '81120000', '超声波流量计', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('778', '765', '81130000', '防火涂料测厚仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('779', '765', '81140000', '接地电阻测量仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('780', '765', '81150000', '绝缘电阻测量仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('781', '765', '81160000', '数字万用表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('782', '765', '81170000', '泡沫称重电子秤', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('783', '765', '81990000', '其他建筑消防设施现场检测装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('784', '764', '82000000', '防火检查装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('785', '784', '82010000', '红外测温仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('786', '784', '82020000', '红外热像仪或红外热电视', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('787', '784', '82030000', '超声波探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('788', '784', '82040000', '普通钳形表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('789', '784', '82050000', '谐波分析仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('790', '784', '82060000', '漏电电流测试仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('791', '784', '82070000', '绝缘电阻测试仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('792', '784', '82080000', '钳式接地电阻测试仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('793', '784', '82090000', '低欧姆表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('794', '784', '82100000', '静电电压表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('795', '784', '82110000', '可燃（毒性）气体检测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('796', '784', '82990000', '其他防火检查装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('797', '764', '83000000', '火灾调查装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('798', '797', '83010000', '望远镜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('799', '797', '83020000', '金属硬度检验仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('800', '797', '83030000', '回弹仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('801', '797', '83040000', '特斯拉计（剩磁测试仪）', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('802', '797', '83050000', '笔式数字多用表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('803', '797', '83060000', '炭化深度测试仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('804', '797', '83070000', '万用表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('805', '797', '83080000', '接地电阻测量仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('806', '797', '83090000', '绝缘电阻测试仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('807', '797', '83100000', '静电电压表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('808', '797', '83110000', '数字测温表', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('809', '797', '83120000', '小型X光检测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('810', '797', '83130000', '金属探测器', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('811', '797', '83140000', '体视显微镜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('812', '797', '83150000', '便携式金相显微镜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('813', '797', '83160000', '便携式气相色谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('814', '797', '83170000', '便携式红外光谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('815', '797', '83180000', '易燃液体探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('816', '797', '83190000', '可燃气体探测仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('817', '797', '83200000', '可燃气体检测管', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('818', '797', '83210000', '薄层色谱分析仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('819', '797', '83220000', '现场勘查灯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('820', '797', '83230000', '碘钨灯', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('821', '797', '83240000', '（数码）照相机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('822', '797', '83250000', '数码摄像机', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('823', '797', '83260000', '现场勘查工具', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('824', '797', '83270000', '电子测距仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('825', '797', '83280000', '尸体袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('826', '797', '83290000', '物证保存袋', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('827', '797', '83300000', '火灾现场勘查专用车', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('828', '797', '83990000', '其他火灾调查装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('829', '764', '84000000', '火灾物证鉴定设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('830', '829', '84010000', '薄层色谱分析装置', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('831', '829', '84020000', '紫外光谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('832', '829', '84030000', '红外光谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('833', '829', '84040000', '高效液相色谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('834', '829', '84050000', '气相色谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('835', '829', '84060000', '气相色谱/质谱联用仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('836', '829', '84070000', '金相显微镜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('837', '829', '84080000', '扫描电子显微镜', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('838', '829', '84090000', 'X射线能谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('839', '829', '84100000', 'X射线衍射仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('840', '829', '84110000', '电子探针', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('841', '829', '84120000', '俄歇电子谱仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('842', '829', '84130000', '差热热重联用分析仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('843', '829', '84140000', '差式扫描量热仪', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('844', '829', '84990000', '其他火灾物证鉴定设备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('845', '764', '89000000', '其他防火检查与火灾调查装备', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('846', null, '90000000', '其他类消防装备器材', '0', null, '初始导入', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('850', '122', '24000000', '船外发动机', '0', null, '船外发动机', '2020-07-03 15:59:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('1001', null, '10000000', '电子围栏', '0', null, '初始导入', '2021-01-13 15:59:42', '1');
INSERT INTO `wl_equipment_category` VALUES ('1002', null, '30000000', '门禁', '0', null, '初始导入', '2021-01-13 15:59:42', '1');
INSERT INTO `wl_equipment_category` VALUES ('1003', null, '50000000', '摄像头', '0', null, '初始导入', '2021-01-13 15:59:42', '1');
INSERT INTO `wl_equipment_category` VALUES ('1285805968926138369', '820', '83230100', '测试数据3', '0', null, '', '2020-07-22 13:16:47', '2');
INSERT INTO `wl_equipment_category` VALUES ('1285806521185951746', '1285805968926138369', '83230101', '测试数据4', '0', null, '', '2020-07-22 13:18:58', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301100791327756289', '204', '31011300', '消防水池', '0', null, null, '2020-09-02 18:12:57', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301101144869834753', '203', '31050000', '消火栓', '0', null, null, '2020-09-02 18:14:21', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301101280379408386', '1301101144869834753', '31050100', '室内消火栓', '0', null, null, '2020-09-02 18:14:53', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301101456850554881', '1301101144869834753', '31050200', '室外消火栓', '0', null, null, '2020-09-02 18:15:35', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301101841233350658', '204', '31011400', '消防水箱', '0', null, null, '2020-09-02 18:17:07', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301102552125935618', '285', '31990200', '消防控制柜', '0', null, null, '2020-09-02 18:19:56', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301103326134407169', '257', '31030900', '塔式泡沫炮', '0', null, null, '2020-09-02 18:23:01', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301103470523322369', '257', '31031000', '挑檐炮', '0', null, null, '2020-09-02 18:23:35', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301104310931820545', '764', '85000000', '火灾报警', '0', null, null, '2020-09-02 18:26:56', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301104460853022721', '1301104310931820545', '85010000', '火灾探测器', '0', null, null, '2020-09-02 18:27:31', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301105214426845186', '1301104460853022721', '85010100', '感温电缆', '0', null, null, '2020-09-02 18:30:31', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301105291379740674', '1301104460853022721', '85010200', '空气采样', '0', null, null, '2020-09-02 18:30:49', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301105357075124226', '1301104460853022721', '85010300', '手动报警', '0', null, null, '2020-09-02 18:31:05', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301105458006855681', '1301104460853022721', '85010400', '声光报警', '0', null, null, '2020-09-02 18:31:29', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301105538612989953', '1301104460853022721', '85010500', '感温探测器', '0', null, null, '2020-09-02 18:31:48', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301105631399383042', '1301104460853022721', '85010600', '红外火焰探测器', '0', null, null, '2020-09-02 18:32:11', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301106032769110017', '272', '31040204', '手提灭火器', '1', null, null, '2020-09-02 18:33:46', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301106142831841282', '272', '31040205', '推车灭火器', '1', null, null, '2020-09-02 18:34:12', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301106554448252929', '300', '39100000', '消防铲', '0', null, null, '2020-09-02 18:35:51', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301107261524021250', '300', '39110000', '消防桶', '0', null, null, '2020-09-02 18:38:39', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301108080868724737', '204', '31011500', '喷头', '0', null, null, '2020-09-02 18:41:55', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301109211015548929', '202', '33000000', '消防泡沫类', '0', null, null, '2020-09-02 18:46:24', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301109389856477186', '1301109211015548929', '33010000', '空气压缩混合器', '0', null, null, '2020-09-02 18:47:07', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301109592315531266', '1301109211015548929', '33030000', '泡沫罐', '0', null, null, '2020-09-02 18:47:55', '2');
INSERT INTO `wl_equipment_category` VALUES ('1301109676713316353', '1301109211015548929', '33040000', '气瓶组', '0', null, null, '2020-09-02 18:48:15', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302863657076658177', '846', '91000000', '电力设备', '0', null, null, '2020-09-07 14:57:57', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302863809086623746', '846', '92000000', '消防系统', '0', null, null, '2020-09-07 14:58:33', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302863809086623747', '1302863809086623746', '92190000', '空气调节系统（AIRCS）', '0', null, 'AirConditioningSystem', '2021-05-17 16:56:46', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302863809086623748', '1302863809086623746', '92200000', '门禁系统（ACS）', '0', null, 'AccessControlSystem', '2021-05-17 16:57:38', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302870336149262337', '1302863809086623746', '92010000', '消防给水及消火栓系统', '0', null, 'FireHydrantSystem', '2020-09-07 15:24:29', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302870567007948801', '1302863809086623746', '92030000', '压缩空气泡沫灭火系统（CAFS）', '0', null, 'CompressedAirFoamSystem', '2020-09-07 15:25:24', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302870628873932802', '1302863809086623746', '92040000', '火灾自动报警系统', '0', null, 'FireAlarmSystem', '2020-09-07 15:25:39', '2');
INSERT INTO `wl_equipment_category` VALUES ('1302870772801474562', '1302863809086623746', '92070000', '气体灭火系统', '0', null, 'GasSystem', '2020-09-07 15:26:13', '2');
INSERT INTO `wl_equipment_category` VALUES ('1326407483682672641', '846', '93000000', '消防设施', '1', null, null, '2020-11-11 14:12:42', '2');
INSERT INTO `wl_equipment_category` VALUES ('1326407970716864514', '1326407483682672641', '93010000', '消防小室', '1', null, null, '2020-11-11 14:14:38', '2');
INSERT INTO `wl_equipment_category` VALUES ('1326408197586767873', '1326407483682672641', '93030000', '雨淋阀间', '1', null, null, '2020-11-11 14:15:32', '2');
INSERT INTO `wl_equipment_category` VALUES ('1326408330906914817', '1326407483682672641', '93040000', '消防主控室', '1', null, null, '2020-11-11 14:16:04', '2');
INSERT INTO `wl_equipment_category` VALUES ('1326408969366215893', '1326407483682672641', '93050000', '消防泡沫间', '1', null, null, '2020-11-11 14:14:38', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332593563273990145', '1301104460853022721', '85010700', '感烟探测器--吸气式', '1', null, null, '2020-11-28 15:53:59', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332593683709235201', '1301104460853022721', '85010800', '感烟探测器', '1', null, null, '2020-11-28 15:54:27', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332593780002066433', '1301104460853022721', '85010900', '感烟探测器-防爆型', '1', null, null, '2020-11-28 15:54:50', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332593894552702977', '1301104460853022721', '85011000', '感烟探测器--反射式红外', '1', null, null, '2020-11-28 15:55:18', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332594082667237378', '1301104460853022721', '85011100', '双波段火焰探测器', '1', null, null, '2020-11-28 15:56:02', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332594245926326274', '1301104460853022721', '85011200', '消火栓按钮', '1', null, null, '2020-11-28 15:56:41', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332594425480286210', '1301104460853022721', '85011300', '70度防火阀', '1', null, null, '2020-11-28 15:57:24', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332594597958455297', '1301104460853022721', '85011400', '监视模块', '1', null, null, '2020-11-28 15:58:05', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332594686730899458', '1301104460853022721', '85011500', '控制模块', '1', null, null, '2020-11-28 15:58:26', '2');
INSERT INTO `wl_equipment_category` VALUES ('1332594767668383746', '1301104460853022721', '85011600', '智能说动报警按钮', '1', null, null, '2020-11-28 15:58:46', '2');
INSERT INTO `wl_equipment_category` VALUES ('1336645736423739393', '1301104310931820545', '85020000', '火灾报警器', '1', null, null, '2020-12-09 20:15:52', '2');
INSERT INTO `wl_equipment_category` VALUES ('1348574108949962753', '2', '11150000', '11', '1', null, null, '2021-01-11 10:14:58', '2');
INSERT INTO `wl_equipment_category` VALUES ('1351351711343636482', '31', '11990100', 'Testtest', '1', null, null, '2021-01-19 02:12:10', '2');
INSERT INTO `wl_equipment_category` VALUES ('1352094073110573057', '1003', '51000000', '海康威视摄像头', '1', null, null, '2021-01-21 03:22:02', '1');
INSERT INTO `wl_equipment_category` VALUES ('1352094160775720962', '1003', '52000000', '大华摄像头', '1', null, null, '2021-01-21 03:22:23', '1');
INSERT INTO `wl_equipment_category` VALUES ('1357516030527729665', '1001', '11000000', '脉冲电子', '1', null, null, '2021-02-05 10:26:58', '1');
INSERT INTO `wl_equipment_category` VALUES ('1357516283561701378', '1001', '12000000', '红外线收发器', '1', null, null, '2021-02-05 10:27:58', '1');
INSERT INTO `wl_equipment_category` VALUES ('1357516638475317250', '1002', '31000000', '门禁控制器', '0', null, null, '2021-02-05 10:29:23', '1');
INSERT INTO `wl_equipment_category` VALUES ('1357516701343739905', '1002', '32000000', '读卡器', '1', null, null, '2021-02-05 10:29:38', '1');
INSERT INTO `wl_equipment_category` VALUES ('1357516751000104961', '1002', '33000000', '电控锁', '1', null, null, '2021-02-05 10:29:50', '1');
INSERT INTO `wl_equipment_category` VALUES ('1357516806696267778', '1002', '34000000', '卡片', '1', null, null, '2021-02-05 10:30:03', '1');
INSERT INTO `wl_equipment_category` VALUES ('1385138035104083969', '1302863809086623746', '92990000', '其他系统', '0', null, 'OtherSystem', '2021-04-22 15:46:57', '2');
INSERT INTO `wl_equipment_category` VALUES ('1390603248255258625', '1302863809086623746', '92100000', '排油注氮系统', '0', null, 'OilNitrogenLinjection', '2021-05-07 17:43:45', '2');
INSERT INTO `wl_equipment_category` VALUES ('1390614748298629121', '1302863809086623746', '92110000', '泡沫灭火', '0', null, 'FoamFireSystem', '2021-05-07 18:29:27', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392322039863558145', '1302870336149262337', '92010300', 'FHS-消火栓泵', '0', null, 'FHS-消火栓泵', '2021-05-12 11:33:37', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392322047237144578', '1302870336149262337', '92010400', 'FHS-采集装置', '0', null, 'FHS-采集装置', '2021-05-12 11:33:39', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392322052043816961', '1302870336149262337', '92010500', 'FHS-控制柜', '0', null, 'FHS-控制柜', '2021-05-12 11:33:40', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392322056846295042', '1302870336149262337', '92010600', 'FHS-消防泵', '0', null, 'FHS-消防泵', '2021-05-12 11:33:41', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392322065276846082', '1302870628873932802', '92040100', 'FAS-火灾报警主机', '0', null, 'FAS-火灾报警主机', '2021-05-12 11:33:43', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392322071723491329', '1302870628873932802', '92040200', 'FAS-烟雾报警器', '0', null, 'FAS-烟雾报警器', '2021-05-12 11:33:45', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392322085313036290', '1302870628873932802', '92040400', 'FAS-手动报警器', '0', null, 'FAS-手动报警器', '2021-05-12 11:33:48', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392322089993879554', '1302870628873932802', '92040500', 'FAS-空气采样探测器', '0', null, 'FAS-空气采样探测器', '2021-05-12 11:33:49', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392322094657945601', '1302870628873932802', '92040600', 'FAS-消火栓按钮', '0', null, 'FAS-消火栓按钮', '2021-05-12 11:33:50', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392322099158433794', '1302870628873932802', '92040700', 'FAS-感温电缆', '0', null, 'FAS-感温电缆', '2021-05-12 11:33:51', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392322103839277057', '1302870628873932802', '92040800', 'FAS-红外感光探测器', '0', null, 'FAS-红外感光探测器', '2021-05-12 11:33:52', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392322108704669697', '1302870628873932802', '92040900', 'FAS-紫外感光探测器', '0', null, 'FAS-紫外感光探测器', '2021-05-12 11:33:53', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392322113863663617', '1302870628873932802', '92041000', 'FAS-声光报警器', '0', null, 'FAS-声光报警器', '2021-05-12 11:33:55', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324690038734849', '1302870567007948801', '92030100', 'CAFS-主机', '0', null, 'CAFS-主机', '2021-05-12 11:44:09', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324696535711746', '1302870567007948801', '92030200', 'CAFS-炮阀', '0', null, 'CAFS-炮阀', '2021-05-12 11:44:10', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324701602430977', '1302870567007948801', '92030300', 'CAFS-切换阀', '0', null, 'CAFS-切换阀', '2021-05-12 11:44:12', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324708715970562', '1302870567007948801', '92030400', 'CAFS-卷帘门', '0', null, 'CAFS-卷帘门', '2021-05-12 11:44:13', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324717469483010', '1302870567007948801', '92030500', 'CAFS-产生装置', '0', null, 'CAFS-产生装置', '2021-05-12 11:44:15', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324723681247234', '1302870567007948801', '92030600', 'CAFS-泡沫泵', '0', null, 'CAFS-泡沫泵', '2021-05-12 11:44:17', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324730127892482', '1302870567007948801', '92030700', 'CAFS-空压机', '0', null, 'CAFS-空压机', '2021-05-12 11:44:18', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324734880038914', '1302870567007948801', '92030800', 'CAFS-控制柜', '0', null, 'CAFS-控制柜', '2021-05-12 11:44:20', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324740408131585', '1302870567007948801', '92030900', 'CAFS-电源柜', '0', null, 'CAFS-电源柜', '2021-05-12 11:44:21', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324745730703361', '1302870567007948801', '92031000', 'CAFS-设备间', '0', null, 'CAFS-设备间', '2021-05-12 11:44:22', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324750889697282', '1302870567007948801', '92031100', 'CAFS-控制按钮', '0', null, 'CAFS-控制按钮', '2021-05-12 11:44:23', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324756061274113', '1302870567007948801', '92031200', 'CAFS-插件', '0', null, 'CAFS-插件', '2021-05-12 11:44:25', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324760930861058', '1302870567007948801', '92031300', 'CAFS-交换机', '0', null, 'CAFS-交换机', '2021-05-12 11:44:26', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324766127603713', '1302870567007948801', '92031400', 'CAFS-光纤', '0', null, 'CAFS-光纤', '2021-05-12 11:44:27', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324771190128641', '1302870567007948801', '92031500', 'CAFS-电源', '0', null, 'CAFS-电源', '2021-05-12 11:44:28', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324776982462466', '1302870567007948801', '92031600', 'CAFS-AD通道', '0', null, 'CAFS-AD通道', '2021-05-12 11:44:30', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324782493777921', '1302870567007948801', '92031700', 'CAFS-断路器', '0', null, 'CAFS-断路器', '2021-05-12 11:44:31', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324788600684546', '1302870567007948801', '92031800', 'CAFS-CPU', '0', null, 'CAFS-CPU', '2021-05-12 11:44:32', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324793445105666', '1302870567007948801', '92031900', 'CAFS-泡沫罐', '0', null, 'CAFS-泡沫罐', '2021-05-12 11:44:34', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324798394384385', '1302870567007948801', '92032000', 'CAFS-水箱', '0', null, 'CAFS-水箱', '2021-05-12 11:44:35', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324803603709954', '1390614748298629121', '92110100', 'FFS-感温电缆', '0', null, 'FFS-感温电缆', '2021-05-12 11:44:36', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324808854978561', '1390614748298629121', '92110200', 'FFS-电磁阀', '0', null, 'FFS-电磁阀', '2021-05-12 11:44:37', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324814001389569', '1390614748298629121', '92110300', 'FFS-启动瓶', '0', null, 'FFS-启动瓶', '2021-05-12 11:44:38', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324819017777153', '1390614748298629121', '92110400', 'FFS-断路器', '0', null, 'FFS-断路器', '2021-05-12 11:44:40', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392324824571035649', '1390614748298629121', '92110500', 'FFS-就地盘', '0', null, 'FFS-就地盘', '2021-05-12 11:44:41', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392330208098631682', '1390603248255258625', '92100200', 'ONL-交流电源', '0', null, 'ONL-交流电源', '2021-05-12 12:06:05', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392330212754309121', '1390603248255258625', '92100300', 'ONL-直流电源', '0', null, 'ONL-直流电源', '2021-05-12 12:06:06', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392330217556787202', '1390603248255258625', '92100400', 'ONL-排油阀', '0', null, 'ONL-排油阀', '2021-05-12 12:06:07', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392330222447345665', '1390603248255258625', '92100500', 'ONL-排油注氮装置', '0', null, 'ONL-排油注氮装置', '2021-05-12 12:06:08', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392421886008475650', '1302863809086623746', '92120000', '消防应急系统', '0', null, 'FireEmergencySystem', '2021-05-12 18:10:22', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392421982204837890', '1302863809086623746', '92130000', '水喷雾灭火系统', '0', null, 'WaterSpraySystem', '2021-05-12 18:10:45', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392422070343942145', '1302863809086623746', '92140000', '细水雾灭火系统', '0', null, 'WaterMistSystem', '2021-05-12 18:11:06', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392422539149688833', '1302863809086623746', '92150000', '预作用系统', '0', null, 'Pre-actionSystem', '2021-05-12 18:12:58', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392423133822304257', '1302863809086623746', '92160000', '防烟排烟系统', '0', null, 'SmokeControlSystem', '2021-05-12 18:15:20', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392423287568711682', '1302863809086623746', '92170000', '消防电梯监控系统', '0', null, 'ElevatorSystem', '2021-05-12 18:15:56', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392423399296581633', '1302863809086623746', '92180000', '防火卷帘监控系统', '0', null, 'FireShutterSystem', '2021-05-12 18:16:23', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392423537888968706', '1302863809086623746', '92190000', '移动式泡沫细水雾窝扇炮', '0', null, 'FoamMistSystem', '2021-05-12 18:16:56', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658811210416129', '1392421886008475650', '92120100', 'FES-应急电源', '0', null, 'FES-应急电源', '2021-05-13 09:51:50', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658816499433473', '1392421886008475650', '92120200', 'FES-应急照明装置', '0', null, 'FES-应急照明装置', '2021-05-13 09:51:51', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658821884919809', '1392421886008475650', '92120300', 'FES-消防广播', '0', null, 'FES-消防广播', '2021-05-13 09:51:52', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658827463344130', '1392421982204837890', '92130100', 'WSS-雨淋蝶阀', '0', null, 'WSS-雨淋蝶阀', '2021-05-13 09:51:53', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658832702029825', '1392421982204837890', '92130200', 'WSS-电磁阀', '0', null, 'WSS-电磁阀', '2021-05-13 09:51:55', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658837840052226', '1392421982204837890', '92130300', 'WSS-雨淋阀', '0', null, 'WSS-雨淋阀', '2021-05-13 09:51:56', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658843191984130', '1392421982204837890', '92130400', 'WSS-水泵', '0', null, 'WSS-水泵', '2021-05-13 09:51:57', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658848401309698', '1392421982204837890', '92130500', 'WSS-稳压罐', '0', null, 'WSS-稳压罐', '2021-05-13 09:51:58', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658853677744130', '1392421982204837890', '92130600', 'WSS-感温电缆', '0', null, 'WSS-感温电缆', '2021-05-13 09:52:00', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658858782212097', '1392421982204837890', '92130700', 'WSS-主机', '0', null, 'WSS-主机', '2021-05-13 09:52:01', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658864025092098', '1392421982204837890', '92130800', 'WSS-电源', '0', null, 'WSS-电源', '2021-05-13 09:52:02', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658879611125762', '1390603248255258625', '92100800', 'ONL-氮气瓶', '0', null, 'ONL-氮气瓶', '2021-05-13 09:52:06', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658885189550081', '1390603248255258625', '92100900', 'ONL-检修阀', '0', null, 'ONL-检修阀', '2021-05-13 09:52:07', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658890495344641', '1390603248255258625', '92101000', 'ONL-氮气释放阀', '0', null, 'ONL-氮气释放阀', '2021-05-13 09:52:09', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658896195403777', '1390603248255258625', '92101100', 'ONL-断流阀', '0', null, 'ONL-断流阀', '2021-05-13 09:52:10', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658901505392642', '1392422070343942145', '92140100', 'WMS-主机', '0', null, 'WMS-主机', '2021-05-13 09:52:11', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658907104788482', '1392422070343942145', '92140200', 'WMS-水泵', '0', null, 'WMS-水泵', '2021-05-13 09:52:12', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658912838402050', '1392422070343942145', '92140300', 'WMS-选择阀', '0', null, 'WMS-选择阀', '2021-05-13 09:52:14', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658918324551682', '1392422070343942145', '92140400', 'WMS-电磁阀', '0', null, 'WMS-电磁阀', '2021-05-13 09:52:15', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658923731009538', '1392422070343942145', '92140500', 'WMS-电动阀', '0', null, 'WMS-电动阀', '2021-05-13 09:52:16', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658929175216130', '1302870772801474562', '92070100', 'GS-主机', '0', null, 'GS-主机', '2021-05-13 09:52:18', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658934652977153', '1302870772801474562', '92070200', 'GS-喷淋', '0', null, 'GS-喷淋', '2021-05-13 09:52:19', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658940055240705', '1302870772801474562', '92070300', 'GS-选择阀', '0', null, 'GS-选择阀', '2021-05-13 09:52:20', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658945704968193', '1392422539149688833', '92150100', 'PAS-报警阀', '0', null, 'PAS-报警阀', '2021-05-13 09:52:22', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658951174340609', '1392422539149688833', '92150200', 'PAS-喷淋', '0', null, 'PAS-喷淋', '2021-05-13 09:52:23', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658956698238978', '1392422539149688833', '92150300', 'PAS-喷淋泵', '0', null, 'PAS-喷淋泵', '2021-05-13 09:52:24', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658962079531009', '1392422539149688833', '92150400', 'PAS-主机', '0', null, 'PAS-主机', '2021-05-13 09:52:26', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658967339188225', '1392422539149688833', '92150500', 'PAS-电动排气阀', '0', null, 'PAS-电动排气阀', '2021-05-13 09:52:27', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658972791783426', '1392423133822304257', '92160100', 'SCS-通风阀', '0', null, 'SCS-通风阀', '2021-05-13 09:52:28', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658978340847618', '1392423133822304257', '92160200', 'SCS-防火阀', '0', null, 'SCS-防火阀', '2021-05-13 09:52:29', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658983684390913', '1392423133822304257', '92160300', 'SCS-排烟阀', '0', null, 'SCS-排烟阀', '2021-05-13 09:52:31', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658989157957634', '1392423133822304257', '92160400', 'SCS-防火百叶', '0', null, 'SCS-防火百叶', '2021-05-13 09:52:32', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658994627330049', '1392423133822304257', '92160500', 'SCS-高位百叶', '0', null, 'SCS-高位百叶', '2021-05-13 09:52:33', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392658999933124609', '1392423287568711682', '92170100', 'ES-电梯', '0', null, 'ES-电梯', '2021-05-13 09:52:35', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392659005322805250', '1392423399296581633', '92180100', 'FSS-防火卷帘门', '0', null, 'FSS-防火卷帘门', '2021-05-13 09:52:36', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392659010821537794', '1390614748298629121', '92110600', 'FFS-主机', '0', null, 'FFS-主机', '2021-05-13 09:52:37', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392659016324464641', '1390614748298629121', '92110700', 'FFS-氮气瓶', '0', null, 'FFS-氮气瓶', '2021-05-13 09:52:39', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392659021919666178', '1390614748298629121', '92110800', 'FFS-电动阀', '0', null, 'FFS-电动阀', '2021-05-13 09:52:40', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392659027506479105', '1390614748298629121', '92110900', 'FFS-雨淋蝶阀', '0', null, 'FFS-雨淋蝶阀', '2021-05-13 09:52:41', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392659033298812930', '1390614748298629121', '92111000', 'FFS-电源', '0', null, 'FFS-电源', '2021-05-13 09:52:43', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392659038889820162', '1392423537888968706', '92190100', 'FMS-涡扇炮', '0', null, 'FMS-涡扇炮', '2021-05-13 09:52:44', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392659044434690049', '1302870336149262337', '92010700', 'FHS-消防水池装置', '0', null, 'FHS-消防水池装置', '2021-05-13 09:52:45', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392659049795010562', '1302870336149262337', '92010800', 'FHS-稳压泵', '0', null, 'FHS-稳压泵', '2021-05-13 09:52:46', '2');
INSERT INTO `wl_equipment_category` VALUES ('1392659055239217153', '1302870567007948801', '92032100', 'CAFS-CMS', '0', null, 'CAFS-CMS', '2021-05-13 09:52:48', '2');
INSERT INTO `wl_equipment_category` VALUES ('1394217996519657474', '1392423133822304257', '92160600', 'SCS-送风风机', '0', null, 'SCS-送风风机', '2021-05-17 17:07:28', '2');
INSERT INTO `wl_equipment_category` VALUES ('1394218005814235137', '1392423133822304257', '92160700', 'SCS-排烟风机', '0', null, 'SCS-排烟风机', '2021-05-17 17:07:31', '2');
INSERT INTO `wl_equipment_category` VALUES ('1394218013410119682', '1302863809086623747', '92200100', 'AIRCS-空调', '0', null, 'AIRCS-空调', '2021-05-17 17:07:32', '2');
INSERT INTO `wl_equipment_category` VALUES ('1394218020670459905', '1302863809086623747', '92200200', 'AIRCS-暖通', '0', null, 'AIRCS-暖通', '2021-05-17 17:07:34', '2');
INSERT INTO `wl_equipment_category` VALUES ('1394218027230351362', '1302863809086623748', '92200300', 'ACS-门禁', '0', null, 'ACS-门禁', '2021-05-17 17:07:36', '2');
INSERT INTO `wl_equipment_category` VALUES ('1400741893121478657', '1392423537888968706', '92190200', 'ces', '0', null, '测试', '2021-06-04 17:11:07', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401808723202273281', '1302863809086623746', '92210300', '消防车监测系统（FCMS）', '0', null, 'FireCarMonitoringSystem', '2021-06-07 15:50:19', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401808933538230274', '1302863809086623746', '92220300', '消防电源监控系统（FPMS）', '0', null, 'FirePowerMonitoringSystem', '2021-06-07 15:51:09', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812716204847105', '1302870628873932802', '92041100', 'FAS-换流变火警', '0', null, 'FAS-换流变火警', '2021-06-07 16:06:11', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812724652175362', '1302870628873932802', '92041200', 'FAS-感温式火灾探测器', '0', null, 'FAS-感温式火灾探测器', '2021-06-07 16:06:13', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812732013178881', '1302870628873932802', '92041300', 'FAS-火警模块', '0', null, 'FAS-火警模块', '2021-06-07 16:06:14', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812739424514050', '1302870628873932802', '92041400', 'FAS-远传模块', '0', null, 'FAS-远传模块', '2021-06-07 16:06:16', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812750476505089', '1302870628873932802', '92041500', 'FAS-总火警设备', '0', null, 'FAS-总火警设备', '2021-06-07 16:06:19', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812758579900417', '1302870628873932802', '92041600', 'FAS-电源', '0', null, 'FAS-电源', '2021-06-07 16:06:21', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812767098531842', '1302870628873932802', '92041700', 'FAS-火警装置', '0', null, 'FAS-火警装置', '2021-06-07 16:06:23', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812784664276993', '1392423133822304257', '92160800', 'SCS-送风口', '0', null, 'SCS-送风口', '2021-06-07 16:06:27', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812791282888706', '1302870336149262337', '92010900', 'FHS-压力开关', '0', null, 'FHS-压力开关', '2021-06-07 16:06:29', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812798711001090', '1302870336149262337', '92011000', 'FHS-管网压力探测器', '0', null, 'FHS-管网压力探测器', '2021-06-07 16:06:30', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812807472902145', '1302870336149262337', '92011100', 'FHS-液位探测器', '0', null, 'FHS-液位探测器', '2021-06-07 16:06:32', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812814078930946', '1302870567007948801', '92032200', 'CAFS-CAFS消防炮', '0', null, 'CAFS-CAFS消防炮', '2021-06-07 16:06:34', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812821314105345', '1401808723202273281', '92210400', 'FCMS-消防车', '0', null, 'FCMS-消防车', '2021-06-07 16:06:36', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812844370194434', '1392423537888968706', '92190300', 'FMS-涡扇炮机器人', '0', null, 'FMS-涡扇炮机器人', '2021-06-07 16:06:41', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812853467639809', '1392423537888968706', '92190400', 'FMS-车载', '0', null, 'FMS-车载', '2021-06-07 16:06:43', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812861348737025', '1392423537888968706', '92190500', 'FMS-手动控制柜', '0', null, 'FMS-手动控制柜', '2021-06-07 16:06:45', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812868890095617', '1392423537888968706', '92190600', 'FMS-设备舱', '0', null, 'FMS-设备舱', '2021-06-07 16:06:47', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812875693256706', '1392423537888968706', '92190700', 'FMS-自动寻的装置', '0', null, 'FMS-自动寻的装置', '2021-06-07 16:06:49', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812883305918466', '1392423537888968706', '92190800', 'FMS-手动报警器', '0', null, 'FMS-手动报警器', '2021-06-07 16:06:50', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812890209742850', '1401808933538230274', '92220400', 'FPMS-配电箱', '0', null, 'FPMS-配电箱', '2021-06-07 16:06:52', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401812898271195137', '1401808933538230274', '92220500', 'FPMS-强切设备', '0', null, 'FPMS-强切设备', '2021-06-07 16:06:54', '2');
INSERT INTO `wl_equipment_category` VALUES ('1401834500329304065', '1302870628873932802', '92041800', 'FAS-备用设备', '0', null, 'FAS-备用设备', '2021-06-07 17:32:44', '2');
INSERT INTO `wl_equipment_category` VALUES ('1402518124389150722', '1392423537888968706', '92190900', 'FMS-机器人', '0', null, 'FMS-机器人', '2021-06-09 14:49:13', '2');

-- ----------------------------
-- Table structure for wl_equipment_detail
-- ----------------------------
DROP TABLE IF EXISTS `wl_equipment_detail`;
CREATE TABLE `wl_equipment_detail` (
  `id` bigint(20) NOT NULL,
  `name` varchar(255) NOT NULL COMMENT '名称',
  `code` varchar(50) DEFAULT NULL COMMENT '编码',
  `equipment_id` bigint(20) DEFAULT NULL COMMENT '装备定义id',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `manufacturer_id` bigint(20) DEFAULT NULL COMMENT '生产厂商id',
  `standard` varchar(255) DEFAULT NULL COMMENT '规格',
  `img` varchar(255) DEFAULT NULL COMMENT '图片',
  `video` varchar(255) DEFAULT NULL COMMENT '视频',
  `maintenance_cycle` decimal(18,0) DEFAULT NULL COMMENT '保养周期',
  `agent` text COMMENT '代理商',
  `brand` text COMMENT '品牌',
  `contract_code` text COMMENT '合同编号',
  `production_date` datetime DEFAULT NULL COMMENT '生产日期',
  `perf_quota_str` text COMMENT '核心参数',
  `expiry_date` varchar(20) DEFAULT NULL COMMENT '有效期限',
  `creator_id` bigint(255) DEFAULT NULL COMMENT '创建人id',
  `org_code` varchar(50) DEFAULT NULL COMMENT '归属组织',
  `company_name` varchar(255) DEFAULT NULL COMMENT '公司名',
  `department_orgcode` varchar(255) DEFAULT NULL COMMENT '部门code',
  `department_name` varchar(255) DEFAULT NULL COMMENT '部门名',
  `price_interregional` varchar(255) DEFAULT NULL COMMENT '价格区间',
  `country` varchar(255) DEFAULT NULL COMMENT '国别',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `is_import` tinyint(255) DEFAULT NULL COMMENT '是否进口',
  `supplier_id` bigint(20) DEFAULT NULL COMMENT '供应商id',
  `certifications` varchar(500) DEFAULT NULL COMMENT '证书文件',
  `instruction_manual` varchar(500) DEFAULT NULL COMMENT '说明文件',
  `batch_num` varchar(40) DEFAULT NULL COMMENT '批次号',
  `area` varchar(100) DEFAULT NULL COMMENT '位置信息',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `manufacturer` (`manufacturer_id`) USING BTREE,
  KEY `equipment_id` (`equipment_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='装备详情定义';

-- ----------------------------
-- Records of wl_equipment_detail
-- ----------------------------
INSERT INTO `wl_equipment_detail` VALUES ('1399619241434566658', '1#产生装置', '92030500MG644', '1392361059477864450', null, null, 'MG644', null, null, null, null, 'cafs产生装置', null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:05', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619241665253377', '2#产生装置', '92030500MG644', '1392361059477864450', null, null, 'MG644', null, null, null, null, 'cafs产生装置', null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619241770110977', '3#产生装置', '92030500MG644', '1392361059477864450', null, null, 'MG644', null, null, null, null, 'cafs产生装置', null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619241853997058', '4#产生装置', '92030500MG644', '1392361059477864450', null, null, 'MG644', null, null, null, null, 'cafs产生装置', null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619241937883137', '1#空气压缩机', '92030700SFT44', '1392361060509663233', null, null, 'SFT44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619241988214785', '2#空气压缩机', '92030700SFT44', '1392361060509663233', null, null, 'SFT44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242034352129', '3#空气压缩机', '92030700SFT44', '1392361060509663233', null, null, 'SFT44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242084683778', '4#空气压缩机', '92030700SFT44', '1392361060509663233', null, null, 'SFT44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242126626818', '1#泡沫泵', '92030600QO344', '1392361059951820801', null, null, 'QO344', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242172764162', '2#泡沫泵', '92030600QO344', '1392361059951820801', null, null, 'QO344', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242214707201', '3#泡沫泵', '92030600QO344', '1392361059951820801', null, null, 'QO344', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242260844546', '4#泡沫泵', '92030600QO344', '1392361059951820801', null, null, 'QO344', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242311176193', '1#切换阀', '92030300DI444', '1392361058299265025', null, null, 'DI444', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242378285057', '2#切换阀', '92030300DI444', '1392361058299265025', null, null, 'DI444', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242441199618', '3#切换阀', '92030300DI444', '1392361058299265025', null, null, 'DI444', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242533474305', '4#切换阀', '92030300DI444', '1392361058299265025', null, null, 'DI444', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242676080641', '1#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242738995201', '2#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242797715458', '3#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242860630018', '4#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242923544578', '5#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619242982264833', '6#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619243040985090', '7#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619243095511042', '8#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619243154231297', '9#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619243212951554', '10#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619243259088898', '11#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619243322003457', '12#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619243384918017', '13#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619243460415489', '14#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619243527524353', '15#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619243582050305', '16#消防炮', '92030200DOD44', '1392361057749811202', null, null, 'DOD44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619243712073730', '1#泡沫罐', '92031900INJ44', '1392361066734010370', null, null, 'INJ44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619243762405378', '2#泡沫罐', '92031900INJ44', '1392361066734010370', null, null, 'INJ44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619243804348418', '1#水箱', '92032000N4344', '1392361067237326849', null, null, 'N4344', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619243854680066', '2#水箱', '92032000N4344', '1392361067237326849', null, null, 'N4344', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619243900817410', 'CAFS主机A', '92030100TGX44', '1392361057196163073', null, null, 'TGX44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619244009869314', 'CAFS主机B', '92030100TGX44', '1392361057196163073', null, null, 'TGX44', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:06', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619288557572098', '极1高阀门', '92100400VWE44', '1392361071419047937', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:17', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619288599515137', '极2高阀门', '92100400VWE44', '1392361071419047937', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:17', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619288637263873', '极1低阀门', '92100400VWE44', '1392361071419047937', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:17', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619288679206914', '极2低阀门', '92100400VWE44', '1392361071419047937', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:17', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619288721149953', '极1高直流电源', '92100300MNL44', '1392361070907342850', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:17', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619288758898689', '极2高直流电源', '92100300MNL44', '1392361070907342850', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:17', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619288796647426', '极1低直流电源', '92100300MNL44', '1392361070907342850', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:17', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619288838590466', '极2低直流电源', '92100300MNL44', '1392361070907342850', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:17', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619288880533505', '极1高交流电源', '921002000JK44', '1392361070315945986', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:17', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619288918282241', '极2高交流电源', '921002000JK44', '1392361070315945986', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:17', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619288997974017', '极1低交流电源', '921002000JK44', '1392361070315945986', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:17', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399619289035722753', '极2低交流电源', '921002000JK44', '1392361070315945986', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-01 14:50:17', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759371407347714', '感温电缆1', '92040700PEM44', '1392361054348230658', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759371566731266', '感温电缆2', '92040700PEM44', '1392361054348230658', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759371675783170', '感温电缆3', '92040700PEM44', '1392361054348230658', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759371776446465', '感温电缆4', '92040700PEM44', '1392361054348230658', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759371864526849', '烟感1', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759371990355969', '烟感2', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759372091019265', '烟感3', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759372187488257', '烟感4', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759372267180033', '手报1', '920404002PU44', '1392361052318187522', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759372355260418', '手报2', '920404002PU44', '1392361052318187522', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759372434952193', '手报3', '920404002PU44', '1392361052318187522', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759372497866753', '手报4', '920404002PU44', '1392361052318187522', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759372573364226', '空气采样1', '920405002O544', '1392361052926361602', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759372644667393', '空气采样2', '920405002O544', '1392361052926361602', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759372757913602', '空气采样3', '920405002O544', '1392361052926361602', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759372837605378', '空气采样4', '920405002O544', '1392361052926361602', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759372938268673', '红外光束感烟1', '92040800CZU44', '1392361055002542082', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759373001183233', '红外光束感烟2', '92040800CZU44', '1392361055002542082', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759373143789570', '红外光束感烟3', '92040800CZU44', '1392361055002542082', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:55', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759373378670594', '红外光束感烟4', '92040800CZU44', '1392361055002542082', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:56', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759373466750978', '紫外火焰1', '92040900VUA44', '1392361055849791490', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:56', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759373579997185', '紫外火焰2', '92040900VUA44', '1392361055849791490', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:56', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759373668077570', '紫外火焰3', '92040900VUA44', '1392361055849791490', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:56', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759373772935170', '紫外火焰4', '92040900VUA44', '1392361055849791490', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:56', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759373873598465', '声光报警1', '92041000LCW44', '1392361056457965569', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:56', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759373965873153', '声光报警2', '92041000LCW44', '1392361056457965569', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:56', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759374045564930', '声光报警3', '92041000LCW44', '1392361056457965569', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:56', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399759374125256705', '声光报警4', '92041000LCW44', '1392361056457965569', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:06:56', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763046984994818', '极1高感温电缆', '92110100QY544', '1392361067740643330', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:31', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763047102435330', '极2高感温电缆', '92110100QY544', '1392361067740643330', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:31', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763047194710017', '极1低感温电缆', '92110100QY544', '1392361067740643330', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:31', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763047312150530', '极2低感温电缆', '92110100QY544', '1392361067740643330', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:31', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763047400230914', '极1高电磁阀', '92110200UIU44', '1392361068273319937', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:31', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763047538642945', '极2高电磁阀', '92110200UIU44', '1392361068273319937', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:32', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763047626723329', '极1低电磁阀', '92110200UIU44', '1392361068273319937', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:32', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763047714803714', '极2低电磁阀', '92110200UIU44', '1392361068273319937', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:32', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763047840632833', '极1高启动瓶', '92110300SS744', '1392361068818579458', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:32', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763047903547394', '极2高启动瓶', '92110300SS744', '1392361068818579458', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:32', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763047983239169', '极1低启动瓶', '92110300SS744', '1392361068818579458', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:32', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763048088096770', '极2低启动瓶', '92110300SS744', '1392361068818579458', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:32', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763048155205634', '极1高断路器', '92110400CRQ44', '1392361069313507330', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:32', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763048226508802', '极2高断路器', '92110400CRQ44', '1392361069313507330', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:32', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763048322977794', '极1低断路器', '92110400CRQ44', '1392361069313507330', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:32', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399763048398475266', '极2低断路器', '92110400CRQ44', '1392361069313507330', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 00:21:32', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399990242068549633', '防爆温度报警器1', '92040300RJZ44', '1399927013359374337', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 15:24:19', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399990242240516097', '防爆温度报警器2', '92040300RJZ44', '1399927013359374337', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 15:24:19', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399990242378928130', '防爆温度报警器3', '92040300RJZ44', '1399927013359374337', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 15:24:19', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1399990242437648385', '防爆温度报警器4', '92040300RJZ44', '1399927013359374337', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-02 15:24:19', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199899847778306', 'N001L01D001烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:42', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199901085097986', 'N001L01D002烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199901248675842', 'N001L01D003烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199901441613825', 'N001L01D004烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199901584220162', 'N001L01D005烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199901722632193', 'N001L01D006烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199902024622082', 'N001L01D007烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199902184005634', 'N001L01D008烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199902376943617', 'N001L01D009烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199902502772737', 'N001L01D010烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199902641184769', 'N001L01D011烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199902758625282', 'N001L01D013烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199902901231617', 'N001L01D014烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199903010283522', 'N001L01D015烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199903106752514', 'N001L01D016烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199903224193025', 'N001L01D017烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199903480045570', 'N001L01D018烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199903605874690', 'N001L01D019烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199903710732290', 'N001L01D020烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199903811395585', 'N001L01D023烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199903912058881', 'N001L01D024烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199904016916482', 'N001L01D025烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199904121774082', 'N001L01D026烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199904209854465', 'N001L01D027烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199904306323457', 'N001L01D028烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:43', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199904688005122', 'N001L01D029烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199904801251329', 'N001L01D030烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199904901914626', 'N001L01D031烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199905010966529', 'N001L01D032烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199905115824129', 'N001L01D033烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199905212293122', 'N001L01D034烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199905371676673', 'N001L01D035烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199905656889346', 'N001L01D036烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199905778524161', 'N001L01D037烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199905900158977', 'N001L01D038烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199906084708353', 'N001L01D039烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199906143428610', 'N001L01D040烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199906214731777', 'N001L01D041烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199906277646337', 'N001L01D042烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199906344755202', 'N001L01D043烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199906399281154', 'N001L01D044烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199906508333057', 'N001L01D045烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199906550276098', 'N001L01D046烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199906613190657', 'N001L01D047烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199906755796993', 'N001L01D048烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199906873237505', 'N001L01D049烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199906944540674', 'N001L01D050烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199907099729921', 'N001L01D051烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199907204587522', 'N001L01D052烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199907326222337', 'N001L01D053烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199907439468546', 'N001L01D054烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199907556909057', 'N001L01D055烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199907678543874', 'N001L01D056烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199907766624258', 'N001L01D057烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199907821150209', 'N001L01D058烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199907875676162', 'N001L01D059烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199908030865410', 'N001L01D060烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199908148305922', 'N001L01D061烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199908529987585', 'N001L01D062烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199908584513537', 'N001L01D063烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:44', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199908701954049', 'N001L01D064烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199908957806594', 'N001L01D065烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199909121384450', 'N001L01D066烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199909255602178', 'N001L01D067烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199909368848386', 'N001L01D068烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199909482094594', 'N001L01D069烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199909591146498', 'N001L01D070烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199909658255362', 'N001L01D071烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199909775695874', 'N001L01D072烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199909863776258', 'N001L01D073烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199909947662338', 'N001L01D074烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199910115434498', 'N001L01D075烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199910220292097', 'N001L01D076烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199910333538306', 'N001L01D077烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199910396452866', 'N001L01D078烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199910568419330', 'N001L01D079烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199910685859841', 'N001L01D080烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199910815883266', 'N001L01D081烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199910882992130', 'N001L01D082烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199910958489602', 'N001L01D083烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199911046569986', 'N001L01D084烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199911130456066', 'N001L01D085烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199911214342146', 'N001L01D086烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199911294033921', 'N001L01D087烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199911373725698', 'N001L01D088烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199911432445953', 'N001L01D089烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199911587635202', 'N001L01D090烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199911671521281', 'N001L01D091烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199911747018753', 'N001L01D092烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199911830904834', 'N001L01D093烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199911910596610', 'N001L01D094烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199912032231425', 'N001L01D095烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199912082563074', 'N001L01D096烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199912149671938', 'N001L01D097烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199912241946625', 'N001L01D098烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199912313249794', 'N001L01D099烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199912367775746', 'N001L01D100烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199912418107394', 'N001L01D101烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199912543936513', 'N001L01D102烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199912657182722', 'N001L01D103烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199912732680193', 'N001L01D104烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199912808177665', 'N001L02D001烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:45', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199912879480833', 'N001L02D002烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199912959172610', 'N001L02D003烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199913030475778', 'N001L02D004烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199913244385282', 'N001L02D005烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199913328271362', 'N001L02D006烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199913378603010', 'N001L02D007烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199913647038465', 'N001L02D008烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199913751896065', 'N001L02D009烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199913839976450', 'N001L02D010烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199913919668226', 'N001L02D012烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199914003554306', 'N001L02D013烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199914079051777', 'N001L02D014烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199914162937858', 'N001L02D015烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199914230046721', 'N001L02D016烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199914318127106', 'N001L02D018烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199914389430273', 'N001L02D019烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199914481704961', 'N001L02D020烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199914573979650', 'N001L02D021烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199914670448642', 'N001L02D022烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199914758529025', 'N001L02D023烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199914854998017', 'N001L02D024烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199914938884097', 'N001L02D025烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199915022770177', 'N001L02D026烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199915127627778', 'N001L02D028烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199915219902465', 'N001L02D030烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199915337342978', 'N001L02D031烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199915492532226', 'N001L02D033烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199915635138561', 'N001L02D034烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199915786133505', 'N001L02D035烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199915874213890', 'N001L02D036烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199915953905665', 'N001L02D037烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199916067151874', 'N001L02D038烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199916180398081', 'N001L02D039烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199916268478465', 'N001L02D040烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199916398501889', 'N001L02D041烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199916566274050', 'N001L02D042烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199916645965825', 'N001L02D043烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199916784377858', 'N001L02D044烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199916859875330', 'N001L02D045烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199916931178498', 'N001L02D046烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199916998287362', 'N001L02D047烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:46', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199917061201922', 'N001L02D048烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199917128310786', 'N001L02D049烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199917199613953', 'N001L02D050烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199917291888642', 'N001L02D051烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199917384163330', 'N001L02D052烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199917480632322', 'N001L02D053烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199917581295617', 'N001L02D054烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199917690347521', 'N001L02D055烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199917811982338', 'N001L02D056烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199917933617154', 'N001L02D057烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199918013308929', 'N001L02D058烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199918088806402', 'N001L02D059烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199918172692481', 'N001L02D060烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199918231412737', 'N001L02D061烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199918315298817', 'N001L02D062烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199918407573506', 'N001L02D063烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199918512431105', 'N001L02D064烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199918655037442', 'N001L02D065烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199918764089346', 'N001L02D066烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199918814420994', 'N001L02D067烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199918856364033', 'N001L02D068烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199918902501378', 'N001L02D069烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199918948638722', 'N001L02D070烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199918990581762', 'N001L02D071烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919053496322', 'N001L02D072烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919099633666', 'N001L02D073烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919141576706', 'N001L02D075烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919179325442', 'N001L02D076烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919250628609', 'N001L02D077烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919326126081', 'N001L02D078烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919376457730', 'N001L02D079烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919443566593', 'N001L02D080烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919498092545', 'N001L02D081烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919531646978', 'N001L02D083烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919561007105', 'N001L02D084烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919632310273', 'N001L02D085烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919691030529', 'N001L02D087烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919745556481', 'N001L02D088烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919825248258', 'N001L02D104烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199919997214721', 'N001L02D106烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199920085295105', 'N001L03D001烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199920156598273', 'N001L03D002烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199920215318529', 'N001L03D003烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199920282427394', 'N001L03D004烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199920353730561', 'N001L03D005烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199920425033729', 'N001L03D006烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199920479559682', 'N001L03D008烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199920542474241', 'N001L03D009烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199920601194497', 'N001L03D011烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199920701857793', 'N001L03D013烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199920760578049', 'N001L03D014烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199920798326786', 'N001L03D015烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199920886407169', 'N001L03D016烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199920966098946', 'N001L03D017烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199921037402114', 'N001L03D018烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199921108705282', 'N001L03D019烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199921175814146', 'N001L03D020烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199921247117313', 'N001L03D022烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:47', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199921318420481', 'N001L03D023烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199921351974913', 'N001L03D024烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199921385529346', 'N001L03D025烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199921465221121', 'N001L03D026烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199921515552770', 'N001L03D027烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199921582661633', 'N001L03D028烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199921653964802', 'N001L03D030烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199921729462273', 'N001L03D031烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199921804959746', 'N001L03D033烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199921884651521', 'N001L03D034烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199921960148993', 'N001L03D035烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199922056617986', 'N001L03D037烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199922115338242', 'N001L03D038烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199922190835714', 'N001L03D039烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199922270527490', 'N001L03D041烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199922488631298', 'N001L03D042烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199922534768641', 'N001L03D043烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199922643820545', 'N001L03D044烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199922698346498', 'N001L03D045烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199922765455362', 'N001L03D046烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199922845147138', 'N001L03D047烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199922933227521', 'N001L03D048烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923004530690', 'N001L03D049烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923088416770', 'N001L03D050烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923159719938', 'N001L03D051烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923210051585', 'N001L03D052烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923247800321', 'N001L03D053烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923285549057', 'N001L03D054烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923340075010', 'N001L03D056烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923386212353', 'N001L03D057烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923428155394', 'N001L03D058烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923470098434', 'N001L03D059烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923512041474', 'N001L03D060烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923549790209', 'N001L03D061烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923600121857', 'N001L04D001烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923667230721', 'N001L04D002烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923738533890', 'N001L04D003烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923801448449', 'N001L04D004烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923868557314', 'N001L04D005烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199923939860481', 'N001L04D006烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199924002775042', 'N001L04D007烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199924074078209', 'N001L05D001烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199924141187074', 'N001L05D002烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199924233461762', 'N001L05D003烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199924325736450', 'N001L05D004烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199924376068098', 'N001L05D005烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199924472537090', 'N001L05D006烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199924522868738', 'N001L05D007烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199924594171905', 'N001L07D001烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199924665475073', 'N001L07D002烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199924736778241', 'N001L07D003烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199924803887106', 'N001L07D004烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199924879384578', 'N001L07D005烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199924938104834', 'N001L07D006烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199925013602305', 'N001L07D007烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199925097488385', 'N001L07D008烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199925172985857', 'N001L07D009烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199925244289025', 'N001L07D010烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199925336563714', 'N001L07D011烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199925416255489', 'N001L07D012烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:48', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199925500141569', 'N001L07D013烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199925563056129', 'N001L07D014烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199925655330817', 'N001L07D015烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199925785354242', 'N001L07D016烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199925844074497', 'N001L07D017烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199925923766273', 'N001L07D018烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199925969903617', 'N001L07D019烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199926016040961', 'N001L07D020烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199926066372609', 'N001L07D021烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199926108315649', 'N001L07D022烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199926171230210', 'N001L07D023烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199926238339073', 'N001L07D024烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199926297059329', 'N001L07D025烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199926380945409', 'N001L07D026烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199926460637186', 'N001L07D027烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199926540328962', 'N001L07D028烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199926594854913', 'N001L07D029烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199926640992257', 'N001L07D030烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199926712295425', 'N001L07D031烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199926817153025', 'N001L07D032烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199926896844801', 'N001L07D033烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199926993313793', 'N001L07D034烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199927098171393', 'N001L07D035烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199927186251778', 'N001L07D036烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199927261749250', 'N001L07D037烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199927337246721', 'N001L07D038烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199927412744193', 'N001L07D039烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199927479853057', 'N001L07D040烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199927538573314', 'N001L07D041烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199927609876481', 'N001L07D046烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199927727316994', 'N001L07D047烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199927777648641', 'N001L07D048烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199927823785985', 'N001L07D049烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199927874117634', 'N001L07D050烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199928020918273', 'N001L07D051烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199928062861314', 'N001L07D052烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199928104804354', 'N001L07D053烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199928146747394', 'N001L07D054烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199928192884737', 'N001L07D055烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199928255799297', 'N001L07D056烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199928331296770', 'N001L07D057烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199928402599937', 'N001L07D058烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199928461320194', 'N001L07D059烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199928524234753', 'N001L07D060烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199928591343617', 'N001L07D061烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199928645869569', 'N001L07D062烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199928746532866', 'N001L07D063烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199928935276545', 'N001L07D064烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199929044328449', 'N001L07D065烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199929157574658', 'N001L07D066烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199929237266434', 'N001L07D067烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199929316958209', 'N001L07D068烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199929388261377', 'N001L07D069烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199929442787330', 'N001L07D070烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199929526673409', 'N001L07D071烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:49', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199929644113921', 'N001L07D072烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199929723805697', 'N002L01D002烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199929828663297', 'N002L01D003烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199929983852545', 'N002L01D004烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199930063544321', 'N002L01D005烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199930185179137', 'N002L01D006烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199930256482306', 'N002L01D007烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199930311008257', 'N002L01D008烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199930369728514', 'N002L01D009烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199930466197506', 'N002L01D011烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199930508140546', 'N002L01D012烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199930562666498', 'N002L01D013烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199930621386754', 'N002L01D014烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199930671718402', 'N002L01D015烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199930730438657', 'N002L01D016烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199930835296257', 'N002L01D017烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199930910793729', 'N002L01D018烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199930994679809', 'N002L01D019烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199931187617794', 'N002L01D020烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199931292475394', 'N002L02D001烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199931355389954', 'N002L02D002烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199931414110210', 'N002L02D003烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199931477024769', 'N002L02D004烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199931535745025', 'N002L02D005烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199931598659586', 'N002L02D006烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199931657379841', 'N002L03D001烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199931716100097', 'N002L03D002烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199931770626049', 'N002L03D003烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199931837734913', 'N002L03D004烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199931909038082', 'N002L03D005烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199931942592514', 'N002L03D006烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199931992924162', 'N002L03D007烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199932122947585', 'N002L03D008烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199932190056450', 'N002L03D009烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199932248776705', 'N002L03D010烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199932315885569', 'N002L03D011烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199932391383042', 'N002L03D012烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199932462686209', 'N002L03D013烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199932521406466', 'N002L03D014烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199932588515329', 'N002L03D015烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199932651429890', 'N002L03D016烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199932718538754', 'N002L03D017烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199932777259009', 'N002L03D018烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199932848562177', 'N002L03D019烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199932911476737', 'N002L03D020烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199933016334338', 'N002L03D021烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199933058277378', 'N002L03D022烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199933158940674', 'N002L03D023烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199933242826753', 'N002L03D024烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199933314129921', 'N002L03D025烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199933393821698', 'N002L03D026烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199933465124865', 'N002L03D027烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, '2021-06-08 17:44:50', null, null, null, null, null, null);
INSERT INTO `wl_equipment_detail` VALUES ('1402199933528039426', 'N002L03D028烟感', '920402009EM44', '1392361051122810882', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null