package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum UploadStatusEnum {
    未上传("未上传","未上传"),
    已上传("上传中","上传中"),
    未生成("未上传","未上传"),
    成功("成功","成功"),
    失败("失败","失败"),
    代扣成功("成功","0"),
    代扣失败("失败","1"),
    代扣中("","99"),
    代扣处理中("代扣处理中","代扣处理中");

    private String name;
    private String code;


    public static UploadStatusEnum getNodeByCode(String code) {
        UploadStatusEnum anEnum = null;
        for (UploadStatusEnum type : UploadStatusEnum.values()) {
            if (type.getCode().equals(code) ) {
                anEnum = type;
                break;
            }
        }
        return anEnum;
    }



}
