package com.yeejoin.amos.boot.module.hygf.api.dto;



import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.module.hygf.api.entity.PeasantHousehold;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

/**
 * (hygf_icbc_record)实体类
 *
 * @author yangyang
 * @description
 * @since 2024-07-18 11:40:46
 */
@Data
@NoArgsConstructor
@ApiModel (value = "HygfIcbcRecordExportDTO", description = "聚富通钱包开户DTO")
public class HygfIcbcRecordExportDTO  {

    @ExcelIgnore
    private static final long serialVersionUID = 1L;
    @ExcelIgnore
    protected Long sequenceNbr;
    @ExcelProperty(value = "户主姓名", index = 0)
    @ApiModelProperty (value = "户主姓名")
    private String custName;
    /**
     * 身份证号
     */
    @ExcelProperty(value = "区域公司", index = 1)
    @ApiModelProperty(value = "区域公司")
    private String regionalCompaniesName;
    /**
     * 手机号码
     */
    @ExcelProperty(value = "手机号", index = 2)
    @ApiModelProperty (value = "手机号码")
    private String phone;

    @ExcelProperty(value = "身份证号", index = 3)
    @ApiModelProperty (value = "身份证号")
    private String idCard;

    /**
     * 聚富通电子账户账号
     */
    @ExcelProperty(value = "聚富通账户", index = 4)
    @ApiModelProperty (value = "聚富通电子账户账号")
    private String mediumId;


    /**
     * 开户状态, 00-初始，01-开户中，02-开户成功，03-开户失败
     */
    @ExcelProperty(value = "开户状态", index = 5)
    @ApiModelProperty (value = "开户状态, 00-初始，01-开户中，02-开户成功，03-开户失败")
    private String openAccountStatus;

    /**
     * 协议状态, 0-未生效，1-已生效，2-过期，3-作废，4-待短信确认
     */
    @ExcelProperty(value = "协议状态", index = 6)
    @ApiModelProperty (value = "协议状态, 0-未生效，1-已生效，2-过期，3-作废，4-待短信确认")
    private String protocolStatus;

    /**
     * 协议状态, 0-未生效，1-已生效，2-过期，3-作废，4-待短信确认
     */
    @ExcelProperty(value = "扣款总金额（元）", index = 7)
    @ApiModelProperty (value = "扣款总金额")
    private Double paymentAmount;
    /**
     * 协议状态, 0-未生效，1-已生效，2-过期，3-作废，4-待短信确认
     */
    @ExcelProperty(value = "最后扣款成功时间", index = 8)
    @ApiModelProperty (value = "最后扣款成功时间")
    private String paymentTime;

    @ExcelProperty(value = "银行卡类型", index = 9)
    @ApiModelProperty (value = "银行卡类型")
    private String type;

    @ExcelProperty(value = "可用余额", index = 10)
    @ApiModelProperty (value = "可用余额")
    private String accountBalance;
}