package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 资料归档
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="InformationDto", description="资料归档")
public class InformationDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "文件编号",example = "WJ002JXSRYG202411073299")
    private String fileNumber;

    @ApiModelProperty(value = "档案编号",example = "DA002JXSRYG202411073242")
    private String archivesNumber;

    @ApiModelProperty(value = "身份证文件标识",example = "[{\"url\": \"/upload/common/B1893353D7C528EE4F68EE2245959D8.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> cardFile;

    @ApiModelProperty(value = " 房产证文件标识",example = "[{\"url\": \"/upload/common/BABC7F938A4FF56B5CAFD9B55F5E50CD.png\"}]")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<Object> houseProve;

    @ApiModelProperty(value = "勘察表id",example = "1854346995112611841")
    private Long surveyInformationId;

}
