package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 施工电站工程信息
 *
 * @author system_generator
 * @date 2024-01-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="PowerStationEngineeringInfoDto", description="施工电站工程信息")
public class PowerStationEngineeringInfoDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "组件规格")
    private String componentSpecification;

    @ApiModelProperty(value = "上网类型")
    private String gridConnectionType;

    @ApiModelProperty(value = "组件数量")
    private Integer componentQuantity;

    @ApiModelProperty(value = "逆变器数量")
    private Integer inverterQuantity;

    @ApiModelProperty(value = "并网箱数量")
    private Integer gridBoxQuantity;

    @ApiModelProperty(value = "电缆规格")
    private String cableSpecification;

    @ApiModelProperty(value = "电站设计方案")
    private String powerStationDesignPlan;

    @ApiModelProperty(value = "屋顶类型")
    private String roofType;

    @ApiModelProperty(value = "组件类型")
    private String componentType;

    @ApiModelProperty(value = "并网箱类型")
    private String gridBoxType;

    @ApiModelProperty(value = "并网箱功能")
    private String gridBoxFunction;

    private Long workOrderId;

    private Long workOrderPowerStationId;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "完工登记日期")
    private Date completionDate;

    /**
     * 施工组件信息
     */
    private List<Object> constructionComponentInfo;

    /**
     * 施工逆变器信息
     */
    private List<Object>  constructionInverterInfo;

    /**
     * 施工采集器信息
     */
    private List<Object>  constructionCollectorBoxInfo;

    /**
     * 施工并网箱信息
     */
    private List<Object>  constructionGridBoxInfo;



    /**
     * 工程负责人
     */
    private String projectRegionManager;

    /**
     * 工程负责人电话
     */
    private String projectRegionManagerPhone;

    /**
     * 施工负责人
     */
    private String constructionRegionManager;

    /**
     * 施工负责人电话
     */
    private String constructionRegionManagerPhone;



}
