package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 并网验收节点
 *
 * @author system_generator
 * @date 2024-08-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_acceptance_check")
public class AcceptanceCheck extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 施工单id
     */
	@TableField("work_order_id")
    @ApiModelProperty(value ="施工单id" ,example = "1703949560172277760")
    private Long workOrderId;

    /**
     * 施工电站id
     */
    @ApiModelProperty(value ="施工电站id" ,example = "1703949560172277760")
    @TableField("work_order_power_station_id")
    private Long workOrderPowerStationId;

    /**
     * 农户id
     */
    @ApiModelProperty(value ="农户id" ,example = "1703949560172277760")
	@TableField("peasant_household_id")
    private Long peasantHouseholdId;

    /**
     * 验收状态
     */
    @ApiModelProperty(value ="验收状态" ,example = "2")
	@TableField("acceptance_check_status")
    private String acceptanceCheckStatus;

    /**
     * 节点标识
     */
    @ApiModelProperty(value ="节点标识" ,example = "jxsAudit")
	@TableField("basic_grid_node")
    private String basicGridNode;

    /**
     * 片区审核
     */
    @ApiModelProperty(value ="片区审核" ,example = "通过")
	@TableField("power_station_area_status")
    private String powerStationAreaStatus;

    /**
     * 法务审核
     */
    @ApiModelProperty(value ="法务审核" ,example = "通过")
	@TableField("power_station_legal_status")
    private String powerStationLegalStatus;

    /**
     * 投融审核
     */
    @ApiModelProperty(value ="投融审核" ,example = "通过")
	@TableField("power_station_financing_status")
    private String powerStationFinancingStatus;
	/**
     * 资产审核
     */
    @ApiModelProperty(value ="资产审核" ,example = "通过")
	@TableField("power_station_assets_status")
    private String powerStationAssetsStatus;

    /**
     * 实例id
     */
    @ApiModelProperty(value ="实例id" ,example = "1254785")
	@TableField("instance_Id")
    private String instanceId;

    /**
     * 整改单状态
     */
    @ApiModelProperty(value ="整改单状态 废弃字段" )
    @TableField("rectification_status")
    private String rectificationStatus;


    /**
     * 验收时间
     */
    @ApiModelProperty(value ="验收时间" ,example = "2021-01-22 00:00:03")
    @TableField("acceptance_time")
    private String acceptanceTime;

    
    /**
     * 片区整改单
     */
    @ApiModelProperty(value ="片区整改单" )
    @TableField(exist = false)
    private List<HygfRectificationOrder>  areaOrders;
    
    /**
     * 投融整改单
     */
    @ApiModelProperty(value ="投融整改单" )
    @TableField(exist = false)
    private List<HygfRectificationOrder>  financeOrders;
    
    /**
     * 法务整改单
     */
    @ApiModelProperty(value ="法务整改单")
    @TableField(exist = false)
    private List<HygfRectificationOrder>  legalOrders;

    /**
     * 资产整改单
     */
    @ApiModelProperty(value ="资产整改单")
    @TableField(exist = false)
    private List<HygfRectificationOrder>  propertyOrders;

    /**
     * 验收创建时间
     */
    @ApiModelProperty(value ="验收创建时间" ,example = "2021-01-21 00:00:03")
    @TableField("ys_create_time")
    private Date ysCreateTime;
    /**
     * 验收结束时间
     */
    @ApiModelProperty(value ="验收结束时间" ,example = "2021-01-22 00:00:03")
    @TableField("ys_end_time")
    private Date ysEndTime;
}
