package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * 施工日志
 *
 * @author system_generator
 * @date 2024-01-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_construction_records")
@ApiModel(value="ConstructionRecords", description="施工日志")
public class ConstructionRecords extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 操作人
     */
    @ApiModelProperty(value = "操作人",example = "余干多")
	@TableField("operator")
    private String operator;

    /**
     * 操作内容
     */
    @ApiModelProperty(value = "操作内容",example = "提交并网资料")
	@TableField("operation_content")
    private String operationContent;

    /**
     * 操作时间
     */
    @ApiModelProperty(value = "操作时间",example = "2024-11-07 15:02:42")
	@TableField("operation_time")
    private Date operationTime;

    /**
     * 操作结果
     */
    @ApiModelProperty(value = "操作结果",example = "通过")
	@TableField("operation_results")
    private String operationResults;

    /**
     * 施工单id
     */
    @ApiModelProperty(value = "施工单id",example = "1854418822019158018")
	@TableField("work_order_id")
    private Long workOrderId;

    /**
     * 施工电站
     */
    @ApiModelProperty(value = "施工电站",example = "1854411671791996929")
	@TableField("work_order_power_station_id")
    private Long workOrderPowerStationId;

    /**
     * 农户id
     */
    @ApiModelProperty(value = "农户id",example = "1854346995242635266")
	@TableField("peasant_household_id")
    private Long peasantHouseholdId;


    @TableField("notes")
    @ApiModelProperty(value = "备注",example = "备注")
    private String  notes;


    public ConstructionRecords(String operator, String operationContent, Date operationTime, String operationResults, Long workOrderId, Long workOrderPowerStationId, Long peasantHouseholdId, String notes) {
        this.operator = operator;
        this.operationContent = operationContent;
        this.operationTime = operationTime;
        this.operationResults = operationResults;
        this.workOrderId = workOrderId;
        this.workOrderPowerStationId = workOrderPowerStationId;
        this.peasantHouseholdId = peasantHouseholdId;
        this.notes = notes;
    }

    public ConstructionRecords() {
    }

    @TableField(exist = false)
    @ApiModelProperty(value = "施工日志")
    List<ConstructionRecords> constructionRecordsList;



}
