package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * 农户信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_peasant_household",autoResultMap = true)
@ApiModel(value = "PeasantHousehold",description = "农户信息")
public class PeasantHousehold extends BaseEntity {

    private static final long serialVersionUID = 1L;


    /**
     * 勘察表id
     */
    @ApiModelProperty(value = "勘察表id",example = "1712050621051310082")
    @TableField("survey_information_id")
    private Long surveyInformationId;
    /**
     * 农户信息编号
     */
    @ApiModelProperty(value = "农户信息编号",example = "NH004GXZZZZYLBL202405164277")
	@TableField("peasant_household_no")
    private String peasantHouseholdNo;

    /**
     * 业主姓名
     */
    @ApiModelProperty(value = "业主姓名",example = "admin")
	@TableField("owners_name")
    private String ownersName;

    /**
     * 联系电话
     */
    @ApiModelProperty(value = "联系电话",example = "13700068571888")
	@TableField("telephone")
    private String telephone;

    /**
     * 开发方名称
     */
    @ApiModelProperty(value = "开发方名称",example = "系统演示专用账号")
	@TableField("developer_name")
    private String developerName;

    /**
     * 开发方code
     */
    @ApiModelProperty(value = "开发方code",example = "86*355*443*479")
	@TableField("developer_code")
    private String developerCode;

    @ApiModelProperty(value = "开发方Id",example = "1711989888259223554")
    @TableField("developer_id")
    private Long developerId;
    /**
     * 定金
     */
    @ApiModelProperty(value = "定金",example = "11.5")
	@TableField("deposit")
    private Float deposit;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间",example = "2023-10-11 18:20:51")
	@TableField("creation_time")
    private Date creationTime;

    /**
     * 项目地址
     */
    @ApiModelProperty(value = "项目地址",example = "[110000,110100,110101]")
	@TableField(value = "project_address",typeHandler = FastjsonTypeHandler.class)
    private List<Integer> projectAddress;

    /**
     * 常住地址
     */
    @ApiModelProperty(value = "常住地址",example = "[110000,110100,110101]")
	@TableField(value = "permanent_address",typeHandler = FastjsonTypeHandler.class)
    private List<Integer> permanentAddress;

    /**
     * 常住地址
     */
    @ApiModelProperty(value = "常住地址",example = "北京市/北京城区/东城")
    @TableField("permanent_address_name")
    private String permanentAddressName;

    /**
     * 项目地址
     */
    @ApiModelProperty(value = "项目地址",example = "北京市/北京城区/东城")
    @TableField("project_address_name")
    private String projectAddressName;

    /**
     * 是否勘察 0,1
     */
    @ApiModelProperty(value = "是否勘察 0,1",example = "0")
	@TableField("survey_or_not")
    private Integer surveyOrNot;

    /**
     * 身份证号
     */
    @ApiModelProperty(value = "身份证号",example = "210702199012010611")
	@TableField("id_card")
    private String idCard;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱",example = "22134124@163.com")
	@TableField("mailbox")
    private String mailbox;

    /**
     *  审核状态 0未审核,1审核中，2审核结束
     */
    @ApiModelProperty(value = "审核状态 0未审核,1审核中，2审核结束",example = "0")
	@TableField("review")
    private Integer review;

    /**
     * 项目详细地址
     */
    @ApiModelProperty(value = "项目详细地址",example = "汝湖镇仍中村委仍中村小组153号")
	@TableField("project_address_detail")
    private String projectAddressDetail;

    /**
     * 常住详细地址
     */
    @ApiModelProperty(value = "常住详细地址",example = "汝湖镇仍中村委仍中村小组153号")
	@TableField("permanent_address_detail")
    private String permanentAddressDetail;

	/*
	* 开发人
	* */
    @ApiModelProperty(value = "开发人",example = "admin")
    @TableField("developer")
    private String developer;

    @ApiModelProperty(value = "开发人Id",example = "1711989888259223554")
    @TableField("developer_user_id")
    private String developerUserId;
    /*
     * 区域公司id
     * */
    @ApiModelProperty(value = "区域公司id",example = "1703949560172277762")
    @TableField("regional_companies_seq")
    private Long regionalCompaniesSeq;
    /*
     * 区域公司code
     * */
    @ApiModelProperty(value = "区域公司code",example = "86*354*344*385*464")
    @TableField("regional_companies_code")
    private String regionalCompaniesCode;
    /*
     * 区域公司名称
     * */
    @ApiModelProperty(value = "区域公司名称",example = "户用光伏测试有限公司")
    @TableField("regional_companies_name")
    private String regionalCompaniesName;
    /*
     * 身份证正面
     * */
    @ApiModelProperty(value = "身份证正面",example = "[{\"url\":\"/upload/common/1A1A581255340AE3E9FC42EE2E3D08F.jpg\"}]")
    @TableField(value = "id_card_front", typeHandler = FastjsonTypeHandler.class)
    private List<Object> idCardFront;
    /*
     * 身份证反面
     * */
    @ApiModelProperty(value = "身份证反面",example = "[{\"url\":\"/upload/common/1A1A581255340AE3E9FC42EE2E3D08F.jpg\"}]")
    @TableField(value = "id_card_opposite", typeHandler = FastjsonTypeHandler.class)
    private List<Object> idCardOpposite;
    /*
     * 微信唯一id
     * */
    @ApiModelProperty(value = "微信唯一id",example = "asdfwe212414")
    @TableField("open_id")
    private String openId;
    /*
     * 是否已认证（0-未认证，1-已认证）
     * */
    @ApiModelProperty(value = "是否已认证（0-未认证，1-已认证）",example = "0")
    @TableField("is_certified")
    private Integer isCertified;
    /*
     * 平台userId
     * */
    @ApiModelProperty(value = "平台userId",example = "5606165")
    @TableField("amos_user_id")
    private String amosUserId;
    /*
     * 是否历史电站
     * */
    @ApiModelProperty(value = "是否历史电站",example = "0")
    @TableField("is_history")
    private String isHistory;
    @ApiModelProperty(value = "场站ID",example = "1706869086106972161")
    @TableField(exist = false)
    protected Long stationId;

    /**施工状态**/

    /**
     *  已发货，已收货，
     */
    @ApiModelProperty(value = "施工状态 已发货，已收货",example = "已发货")
    @TableField("preparation_money_state")
    private String preparationMoneyState;

    /**
     *  备货状态
     */
    @ApiModelProperty(value = "备货状态",example = "备货中")
    @TableField("construction_state")
    private String constructionState;

    @ApiModelProperty(value = "勘察或下个节点",example = "勘察")
    @TableField(exist = false)
    private String surveyOrNotText;

    @ApiModelProperty(value = "常住地址",example = "北京市/北京城区/东城")
    @TableField(exist = false,typeHandler = FastjsonTypeHandler.class)
    private List<String> permanentAddressText;
    @ApiModelProperty(value = "项目地址",example = "北京市/北京城区/东城")
    @TableField(exist = false,typeHandler = FastjsonTypeHandler.class)
    private List<String> projectAddressText;

    /**
     * 当前农户下所有的合同是否已废弃, 1(全部已废弃), 0(未全部废弃)
     */
    @ApiModelProperty(value = "当前农户下所有的合同是否已废弃, 1(全部已废弃), 0(未全部废弃)",example = "0")
    @TableField(exist = false)
    private Integer isAllRevoke;

    /**
     * 电站规模
     */
    @ApiModelProperty(value = "电站规模",example = "25.50")
    @TableField(exist = false)
    private String scale;

    /**
     * 电站规模
     */
    @ApiModelProperty(value = "电站实际规模",example = "23.50")
    @TableField(exist = false)
    private String realScale;
    /**
     放款金额
     */
    @ApiModelProperty(value = "放款金额",example = "23.77")
    @TableField(exist = false)
    private Double disbursementMoney;

    @ApiModelProperty(value = "省份",example = "北京市")
    @TableField(exist = false)
    private String province;

    @TableField(exist = false)
    private String powerStationConstructionStatus;
}
