package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 施工电站施工资料
 *
 * @author system_generator
 * @date 2024-01-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_power_station_construction_data",autoResultMap = true)
@ApiModel(value = "PowerStationConstructionData",description = "施工场站数据")
public class PowerStationConstructionData extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 
     */
    @ApiModelProperty(value = "派工单Id",example = "1712049025391267842")
	@TableField("work_order_id")
    private Long workOrderId;

    /**
     * 施工状态
     */
    @ApiModelProperty(value = "施工状态",example = "已完成")
	@TableField("construction_status")
    private String constructionStatus;

    /**
     * 施工交底文件
     */
    @ApiModelProperty(value = "施工交底文件",example = "[{\"name\":\"35682590685bc1d3070b0f1edcaa78d9.jpg\",\"uid\":\"0.nu47zux2f18\",\"url\":\"/upload/common/E7C55206888E0FEA5D07DF59E1691C9.jpg\"},{\"name\":\"d9a2093b757caf8cfbb9103401df9ee0.jpg\",\"uid\":\"0.qk7gluancl\",\"url\":\"/upload/common/7F5B877186E249CAF304C4D39F0D714.jpg\"},{\"name\":\"be48e3c3cc880ecdba702d0f1d9d589e.jpg\",\"uid\":\"0.cxpgakflm1\",\"url\":\"/upload/common/46FA51DB93B635638EA0AE558C34B7C4.jpg\"},{\"name\":\"f86a00acf9eac24bfbd8f6505d291c72.jpg\",\"uid\":\"0.cqdud7vc70h\",\"url\":\"/upload/common/D1998D14846048FC29D153DA25878330.jpg\"}]")
	@TableField(value ="construction_instructions_file",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  constructionInstructionsFile;

    /**
     * 劳动防护用品配置
     */
    @ApiModelProperty(value = "劳动防护用品配置",example = "[{\"name\":\"be48e3c3cc880ecdba702d0f1d9d589e.jpg\",\"uid\":\"0.hp1k5h2ggs6\",\"url\":\"/upload/common/4F91FA2984B2A9BF18D9CB276439A2B5.jpg\"},{\"name\":\"f86a00acf9eac24bfbd8f6505d291c72.jpg\",\"uid\":\"0.vifped4vu4\",\"url\":\"/upload/common/9FE875A7289DE967BEE87C6F98281DC0.jpg\"}]")
	@TableField(value ="labor_protection_equipment_config",typeHandler = FastjsonTypeHandler.class)
    private List<Object> laborProtectionEquipmentConfig;

    /**
     * 施工前安全措施保障视频
     */
    @ApiModelProperty(value = "施工前安全措施保障视频",example = "[{\"name\":\"2403071507122955.mp4\",\"uid\":\"0.kfwq7b1jbpc\",\"url\":\"/upload/common/82C127CD32DD56BF7D8DC197DB7C7E.mp4\"}]")
    @TableField(value ="safety_precaution_video",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  safetyPrecautionVideo;

    /**
     * 支架整体图一
     */
    @ApiModelProperty(value = "支架整体图一",example = "[{\"name\":\"182c7f9289a72430a19e89836fece049.jpg\",\"uid\":\"0.8de25dwiqb\",\"url\":\"/upload/common/3B8CA83F9F1E5CA926AE6B9AC7DD176.jpg\"}]")
	@TableField(value ="bracket_overall_plan1",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  bracketOverallPlan1;

    /**
     * 支架整体图二
     */
    @ApiModelProperty(value = "支架整体图二",example = "[{\"name\":\"182c7f9289a72430a19e89836fece049.jpg\",\"uid\":\"0.8de25dwiqb\",\"url\":\"/upload/common/3B8CA83F9F1E5CA926AE6B9AC7DD176.jpg\"}]")
	@TableField(value ="bracket_overall_plan2",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  bracketOverallPlan2;

    /**
     * 方阵倾角测试照片/规模
     */
    @ApiModelProperty(value = "方阵倾角测试照片/规模",example = "[{\"name\":\"5359e969804638598acc71d82f344286.jpg\",\"uid\":\"0.6on68id4rk\",\"url\":\"/upload/common/EA5B974F774C3A5A836AC2BB4FD2A87.jpg\"}]")
	@TableField(value ="array_inclination_test_photo",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  arrayInclinationTestPhoto;

    /**
     * 方阵整体图一（全景）
     */
    @ApiModelProperty(value = "方阵整体图一（全景）",example = "[{\"name\":\"c27720dab1624013cb7ed3e52b31fff3.jpg\",\"uid\":\"0.7mse1xwty6c\",\"url\":\"/upload/common/F8EE592D3278690107C8CD33875FBE7.jpg\"}]")
	@TableField(value ="array_overall_plan1",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  arrayOverallPlan1;

    /**
     * 方阵整体图二
     */
    @ApiModelProperty(value = "方阵整体图二",example = "[{\"name\":\"c27720dab1624013cb7ed3e52b31fff3.jpg\",\"uid\":\"0.7mse1xwty6c\",\"url\":\"/upload/common/F8EE592D3278690107C8CD33875FBE7.jpg\"}]")
	@TableField(value ="array_overall_plan2",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  arrayOverallPlan2;

    /**
     * 方阵整体图三
     */
    @ApiModelProperty(value = "方阵整体图三",example = "[{\"name\":\"c27720dab1624013cb7ed3e52b31fff3.jpg\",\"uid\":\"0.7mse1xwty6c\",\"url\":\"/upload/common/F8EE592D3278690107C8CD33875FBE7.jpg\"}]")
	@TableField(value ="array_overall_plan3",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  arrayOverallPlan3;

    /**
     * 逆变器整体图
     */
    @ApiModelProperty(value = "逆变器整体图",example = "[{\"name\":\"b277fdde15da1478450fdc6c168cb56a.jpg\",\"uid\":\"0.f46bz1prpn5\",\"url\":\"/upload/common/8E9562C6E61A12C58A14D3288374A0.jpg\"}]")
	@TableField(value ="inverter_overall_plan",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  inverterOverallPlan;

    /**
     * 光伏电缆走线
     */
    @ApiModelProperty(value = "光伏电缆走线",example = "[{\"name\":\"d1158e4bd623995c451b9b6fa779b7b9.jpg\",\"uid\":\"0.bitdz79qbw7\",\"url\":\"/upload/common/125472671AC65CA8341C8395E8D8FEE.jpg\"}]")
	@TableField(value ="photovoltaic_cable_routing",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  photovoltaicCableRouting;

    /**
     * 电表箱外部整体
     */
    @ApiModelProperty(value = "电表箱外部整体",example = "[{\"name\":\"8eebc5d476b7075425352ee4892058ea.jpg\",\"uid\":\"0.w0pznt9agdh\",\"url\":\"/upload/common/544837A5928C8E58EB1EB2838E73FBFE.jpg\"}]")
	@TableField(value ="electricity_meter_box_exterior",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  electricityMeterBoxExterior;

    /**
     * 电表箱内部整体
     */
    @ApiModelProperty(value = "电表箱内部整体",example = "[{\"name\":\"8eebc5d476b7075425352ee4892058ea.jpg\",\"uid\":\"0.w0pznt9agdh\",\"url\":\"/upload/common/544837A5928C8E58EB1EB2838E73FBFE.jpg\"}]")
	@TableField(value ="electricity_meter_box_interior",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  electricityMeterBoxInterior;

    /**
     * 支架接地
     */
    @ApiModelProperty(value = "支架接地",example = "[{\"name\":\"8eebc5d476b7075425352ee4892058ea.jpg\",\"uid\":\"0.w0pznt9agdh\",\"url\":\"/upload/common/544837A5928C8E58EB1EB2838E73FBFE.jpg\"}]")
	@TableField(value ="bracket_grounding",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  bracketGrounding;

    /**
     * 接地点
     */
    @ApiModelProperty(value = "接地点",example = "[{\"name\":\"8eebc5d476b7075425352ee4892058ea.jpg\",\"uid\":\"0.w0pznt9agdh\",\"url\":\"/upload/common/544837A5928C8E58EB1EB2838E73FBFE.jpg\"}]")
	@TableField(value ="grounding_point",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  groundingPoint;

    /**
     * 交流电缆走线
     */
    @ApiModelProperty(value = "交流电缆走线",example = "[{\"name\":\"8eebc5d476b7075425352ee4892058ea.jpg\",\"uid\":\"0.w0pznt9agdh\",\"url\":\"/upload/common/544837A5928C8E58EB1EB2838E73FBFE.jpg\"}]")
	@TableField(value ="ac_cable_routing",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  acCableRouting;

    /**
     * 其他照片
     */
    @ApiModelProperty(value = "其他照片",example = "[{\"name\":\"e7be720d8cd97c609f4b9b82d0976524.jpg\",\"uid\":\"0.bwed0a07wnm\",\"url\":\"/upload/common/3ED77B2E563E818936F1F94564BE8370.jpg\"}]")
	@TableField(value ="other_photos",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  otherPhotos;

    /**
     * 备案附件
     */
    @ApiModelProperty(value = "备案附件",example = "[{\"uid\":\"0.j2bqoj7b1wm\",\"name\":\"淋山河镇河湾村 陈支援.pdf\",\"url\":\"/upload/common/9E99A7F7D86D34D6AAFEFE821AB61EA8.pdf\"}]")
	@TableField(value ="archive_attachments",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  archiveAttachments;

    /**
     * 安装人员信息
     */
    @ApiModelProperty(value = "安装人员信息",example = "[{\"name\":\"陈刚\",\"phone\":\"18771173397\",\"id\":\"amos-timeuuid-1714198697671-3\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\"}]")
	@TableField(value ="installer_info",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  installerInfo;

    /**
     * 施工组件信息
     */
    @ApiModelProperty(value = "施工组件信息",example = "[{\"id\":\"amos-timeuuid-1714198697671-8\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095722\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-9\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095715\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-10\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095739\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-11\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095735\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-12\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095721\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-13\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095351\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-14\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095220\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-15\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095618\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-16\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095590\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-17\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095767\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-18\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095784\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-22\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095265\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-23\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095438\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-24\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012094925\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-25\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095778\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-26\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095752\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-27\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095153\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-29\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095757\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-30\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095738\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-31\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095270\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-32\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095277\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-33\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095753\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-34\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095755\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-35\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095769\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-36\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2311012095783\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-37\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190333\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-38\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190336\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-39\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190328\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-40\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190356\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-41\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190372\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-42\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190381\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-43\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190500\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-44\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190567\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-45\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190657\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-47\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190528\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-48\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190698\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-49\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190678\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-50\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190702\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-51\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190348\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-52\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190793\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-53\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190730\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-54\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190604\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-55\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190844\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-56\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190895\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-58\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190873\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-59\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190804\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-60\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190894\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"},{\"id\":\"amos-timeuuid-1714198697671-61\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"620W\",\"xlh\":\"2312012190922\",\"wlbm\":\"\",\"wlmc\":\"\",\"dcpgg\":\"\",\"lx\":\"\",\"bk\":\"\",\"dsm\":\"双面\"}]")
	@TableField(value ="construction_component_info",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  constructionComponentInfo;

    /**
     * 施工逆变器信息
     */
    @ApiModelProperty(value = "施工逆变器信息",example = "[{\"id\":\"amos-timeuuid-1714198697671-5\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"50kW\",\"xlh\":\"http://weixin.qq.com/r/6x0YAFDETw0wrRRj90j5\",\"wlbm\":\"\",\"wlmc\":\"\",\"yzm\":\"\",\"xl\":\"\",\"xw\":\"\"}]")
	@TableField(value ="construction_inverter_info",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  constructionInverterInfo;

    /**
     * 施工采集器信息
     */
    @ApiModelProperty(value = "施工采集器信息",example = "[{\"id\":\"amos-timeuuid-1714198697671-4\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"xlh\":\"2112455685\"}]")
	@TableField(value ="construction_collector_box_info",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  constructionCollectorBoxInfo;

    /**
     * 施工并网箱信息
     */
    @ApiModelProperty(value = "施工并网箱信息",example = "[{\"id\":\"amos-timeuuid-1714198697671-7\",\"workOrderId\":\"1783693541411680258\",\"workOrderPowerStationId\":\"1783693541453623297\",\"gl\":\"80A\",\"xlh\":\"04001SF00000042301787831\",\"wlbm\":\"\",\"wlmc\":\"\",\"cz\":\"\",\"lx\":\"带计量表位\",\"gn\":\"一进一出\",\"xw\":\"\",\"swms\":\"\"}]")
	@TableField(value = "construction_grid_box_info",typeHandler = FastjsonTypeHandler.class)
    private List<Object>  constructionGridBoxInfo;

    /**
     * 
     */
    @ApiModelProperty(value = "施工派工单Id",example = "1783693541453623297")
	@TableField("work_order_power_station_id")
    private Long workOrderPowerStationId;

    /**
     * 是否提交流程
     */
    @ApiModelProperty(value = "是否提交流程",example = "false")
    @TableField(exist = false)
    private boolean commitFlow;


    /**
     * 片区整改单
     */
    @ApiModelProperty(value = "派工单Id",example = "1712049025391267842")
    @TableField(exist = false)
    private List<HygfRectificationOrder>  areaOrders;
    /**
     * 工程整改单
     */
    @ApiModelProperty(value = "派工单Id",example = "1712049025391267842")
    @TableField(exist = false)
    private List<HygfRectificationOrder>  engineeringOrders;
    /**
     * 设计整改单
     */
    @ApiModelProperty(value = "派工单Id",example = "1712049025391267842")
    @TableField(exist = false)
    private List<HygfRectificationOrder>  designOrders;

}
