package com.yeejoin.amos.boot.module.hygf.api.tdenginemapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpCollectorHistoryAllDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpCollectorHistoryMonthDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpCollectorHistoryYearDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.TdHygfJpCollectorHistoryDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.TdHygfJpCollectorHistory;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 户用光伏监盘采集器历史表 Mapper 接口
 *
 * @author system_generator
 * @date 2023-09-19
 */
public interface TdHygfJpCollectorHistoryMapper extends BaseMapper<TdHygfJpCollectorHistory> {

	List<TdHygfJpCollectorHistoryDto> dayList(@Param("snCode") String snCode,
			@Param("thirdStationId") String thirdStationId, @Param("startTime") long startTime,
			@Param("endTime") long endTime);

	List<JpCollectorHistoryMonthDto> monthList(@Param("snCode") String snCode,
			@Param("thirdStationId") String thirdStationId, @Param("month") String month);

	List<JpCollectorHistoryYearDto> yearList(@Param("snCode") String snCode,
			@Param("thirdStationId") String thirdStationId, @Param("year") String year);

	List<JpCollectorHistoryAllDto> allList(@Param("snCode") String snCode,
			@Param("thirdStationId") String thirdStationId);

	List<Map<String, Object>> dayToMonth(@Param("startTime") long startTime, @Param("endTime") long endTime);

	List<Map<String, Object>> monthToYear(@Param("month") String month);

	List<Map<String, Object>> yearToAll(@Param("year") String year);

	void updateMonth(@Param("list") List<Map<String, Object>> list);

	void updateYear(@Param("list") List<Map<String, Object>> list);

	void updateAll(@Param("list") List<Map<String, Object>> list);
}
