package com.yeejoin.amos.boot.module.hygf.api.util;

import java.util.ArrayList;
import java.util.List;

/**
 * 处理列表的工具类
 */
public class ListUtils {
    public static  <T> List<List<T>> splitList(List<T> list, int chunkSize) {
        List<List<T>> splitLists = new ArrayList<>();
        int totalSize = list.size();

        for (int i = 0; i < totalSize; i += chunkSize) {
            // 计算结束索引，确保不超过列表的大小
            int end = Math.min(i + chunkSize, totalSize);
            // 使用 subList 方法获取子列表
            List<T> sublist = list.subList(i, end);
            splitLists.add(new ArrayList<>(sublist)); // 创建新的 ArrayList 以避免 ConcurrentModificationException
        }

        return splitLists;
    }
}
