package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.ExceptionLogServiceImpl;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.AcceptanceCheckAuditingServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.AcceptanceCheckAuditingDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 并网审核表
 *
 * @author system_generator
 * @date 2024-08-21
 */
@RestController
@Api(tags = "并网审核表Api")
@RequestMapping(value = "/acceptance-check-auditing")
public class AcceptanceCheckAuditingController extends BaseController {

    @Autowired
    AcceptanceCheckAuditingServiceImpl acceptanceCheckAuditingServiceImpl;

	@Autowired
	ExceptionLogServiceImpl exceptionLogService;

    /**
     * 新增并网审核表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增并网审核表", notes = "新增并网审核表")
	public ResponseModel<AcceptanceCheckAuditingDto> save(HttpServletRequest request,@RequestBody AcceptanceCheckAuditingDto model) {
		try {
			model = acceptanceCheckAuditingServiceImpl.createWithModel(model);
			return ResponseHelper.buildResponse(model);

		} catch (Exception e){
			exceptionLogService.addLog("新增并网审核表", null,e,request);
			return exceptionLogService.errorResponseModel(null,request,e);
		}
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新并网审核表", notes = "根据sequenceNbr更新并网审核表")
	public ResponseModel<AcceptanceCheckAuditingDto> updateBySequenceNbrAcceptanceCheckAuditing(HttpServletRequest request,@RequestBody AcceptanceCheckAuditingDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    try {
			model.setSequenceNbr(sequenceNbr);
			return ResponseHelper.buildResponse(acceptanceCheckAuditingServiceImpl.updateWithModel(model));
		} catch (Exception e){
			exceptionLogService.addLog("根据sequenceNbr更新并网审核表", null,e,request);
			return exceptionLogService.errorResponseModel(null,request,e);
		}
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除并网审核表", notes = "根据sequenceNbr删除并网审核表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(acceptanceCheckAuditingServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个并网审核表",  notes = "根据sequenceNbr查询单个并网审核表")
	public ResponseModel<AcceptanceCheckAuditingDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(acceptanceCheckAuditingServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "并网审核表分页查询",  notes = "并网审核表分页查询")
	public ResponseModel<Page<AcceptanceCheckAuditingDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<AcceptanceCheckAuditingDto> page = new Page<AcceptanceCheckAuditingDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(acceptanceCheckAuditingServiceImpl.queryForAcceptanceCheckAuditingPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "并网审核表列表全部数据查询",   notes = "并网审核表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<AcceptanceCheckAuditingDto>> selectForList() {
	    return ResponseHelper.buildResponse(acceptanceCheckAuditingServiceImpl.queryForAcceptanceCheckAuditingList());
	}
}
