package com.yeejoin.amos.boot.module.hygf.biz.excel.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum ExportPageEnum {
    DZJXZ("0", "电站进行中"),
    DZBTG("1", "电站不通过"),
    DZWC("2", "电站完成"),
    TRDTS("3", "投融待推送"),
    TRWTG("4", "投融未通过"),
    TRYFK("5", "投融已放款"),
    TRDFK("6", "投融待放款"),
    TRYTS("7", "投融已推送"),
    RZDSH("8", "融资待审核"),
    RZDFK("9", "融资待放款"),
    RZYFK("10", "融资已放款"),
    RZWTG("11", "融资未通过"),
    SGYS("12", "施工验收"),
    BWYS("13", "并网验收"),
    YSSH("14", "验收审核"),
    FHDFH("15", "发货待发货"),
    FHYFH("16", "发货已发货"),
    UN_KNOW("","未识别的类型")
    ;
    private String code;
    private String remark;

    public static ExportPageEnum getEnumByCode(String code) {
        for (ExportPageEnum exportPageEnum : ExportPageEnum.values()) {
            if (exportPageEnum.getCode().equals(code)) {
                return exportPageEnum;
            }
        }
        return UN_KNOW;
    }
}
