package com.yeejoin.amos.boot.module.jxiop.biz.mapper2;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.FullViewRecallDataDTO;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanHealthIndex;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanHealthLevel;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanWarningRecord;

/**
 * Mapper 接口
 *
 * @author system_generator
 * @date 2023-08-15
 */
public interface IdxBizFanHealthIndexMapper extends BaseMapper<IdxBizFanHealthIndex> {

	BigDecimal getHealthScoreInfo(@Param("areaCode") String areaCode, @Param("stationCode") String stationCode);
	BigDecimal getHealthScoreInfoByLatest(@Param("areaCode") String areaCode, @Param("stationCode") String stationCode);

	BigDecimal getHealthScoreInfoByStation(@Param("stationCode") String stationCode,
			@Param("tableName") String tableName);

	BigDecimal getHealthScoreInfoByStationByMinute(@Param("stationCode") String stationCode,
										   @Param("tableName") String tableName);
	BigDecimal getHealthScoreInfoByParam(@Param("areaCode") String areaCode, @Param("stationCode") String stationCode,
			@Param("analysisType") String analysisType);

//	List<Map<String, String>> getDateInfoBy15();
//
//	List<Map<String, String>> getDateInfo(Date startTime, Date endTime);
//
//	List<Map<String, String>> getHourInfo(Date startTime, Date endTime);
//
//	List<Map<String, String>> getMomentInfo(Date startTime, Date endTime);

	List<Map<String, Object>> getHealthListInfo(@Param("areaCode") String areaCode,
			@Param("stationCode") String stationCode, @Param("gatewayIds") List<String> gatewayIds);

	List<Map<String, Object>> getAllEquipAlarmInfo(@Param("tableName") String tableName);

	List<Map<String, Object>> getHealthInfoByArea();

	List<Map<String, Object>> getAllEquipAlarmInfoByStation();

	List<Map<String, Object>> getHealthInfoByStation(@Param("areaCode") String areaCode);

	List<Map<String, Object>> equipWarningRadarMap(@Param("stationCode") String stationCode);

	List<Map<String, Object>> getAllEquipAlarmInfoAnalysisByStationType(@Param("tableName") String tableName,
			@Param("areaCode") String areaCode, @Param("stationType") String stationType);

	List<Map<String, Object>> getAllEquipAlarmInfoAnalysisByArea(@Param("areaCode") String areaCode);

	List<Map<String, Object>> getSubSystemInfo(@Param("equipmentName") String equipmentName,
			@Param("gatewayId") String gatewayId,@Param("syzGatewayId") String syzGatewayId);

	List<Map<String, Object>> getFanInfoByPage(@Param("gatewayId") String gatewayId,@Param("syzGatewayId") String syzGatewayId);

	List<Map<String, Object>> getFanHealthInfoList(@Param("gatewayId") String gatewayId,@Param("syzGatewayId") String syzGatewayId);

	List<Map<String, Object>> getSumSystemListByEquipment(@Param("gatewayId") String gatewayId,
			@Param("equipmentName") String equipmentName,@Param("syzGatewayId") String syzGatewayId);

	List<Map<String, Object>> getPointNameListBySumSystem(@Param("gatewayId") String gatewayId,
														  @Param("subSystem") String subSystem,
														  @Param("equipmentName") String equipmentName,
														  @Param("syzGatewayId") String syzGatewayId);

	List<Map<String, Object>> getHealthInfoBySubSystem(@Param("subSystem") String subSystem,
													   @Param("gatewayId") String gatewayId,
													   @Param("equipmentName") String equipmentName,
													   @Param("syzGatewayId") String syzGatewayId);

	List<Map<String, Object>> getWarningInfoBySubSystem(@Param("subSystem") String subSystem,
			@Param("gatewayId") String gatewayId,@Param("syzGatewayId") String syzGatewayId);

	List<Map<String, Object>> getPvInfoByPage(@Param("gatewayId") String gatewayId,@Param("syzGatewayId") String syzGatewayId);

	List<Map<String, Object>> getPvHealthInfoList(@Param("gatewayId") String gatewayId,@Param("syzGatewayId") String syzGatewayId);

	List<Map<String, Object>> getPvSubSystemInfo(@Param("subarray") String subarray,
			@Param("gatewayId") String gatewayId,@Param("syzGatewayId") String syzGatewayId);

	List<Map<String, Object>> getPvSumSystemListByEquipment(@Param("gatewayId") String gatewayId,
			@Param("subarray") String subarray,@Param("syzGatewayId") String syzGatewayId);

	List<Map<String, Object>> getPvHealthInfoBySubSystem(@Param("equipmentName") String equipmentName,
			@Param("gatewayId") String gatewayId,@Param("syzGatewayId") String syzGatewayId);

	List<Map<String, Object>> getPvWarningInfoBySubSystem(@Param("equipmentName") String equipmentName,
			@Param("gatewayId") String gatewayId,@Param("syzGatewayId") String syzGatewayId);

	List<Map<String, Object>> getPvPointNameListBySumSystem(@Param("gatewayId") String gatewayId,
			@Param("equipmentName") String equipmentName,@Param("syzGatewayId") String syzGatewayId);

	String getPointNameByIndexAddress(@Param("varDesc") String varDesc, @Param("tableName") String tableName,
			@Param("gatewayId") String gatewayId);

	List<FullViewRecallDataDTO> getFullViewRecall(@Param("gatewayIds") List<String> gatewayIds);

	List<Map<String, Object>> getStationIndexInfo();

	List<Map<String, Object>> getEquipmentIndexInfo();

	List<Map<String, Object>> getSubSystemIndexInfo();

	List<Map<String, Object>> getPointNameIndexInfo();

	List<Map<String, Object>> getStationIndexInfoByParam(@Param("analysisType") String analysisType, @Param("gatewayIds") List<String> gatewayIds);

	List<Map<String, Object>> getEquipmentIndexInfoByParam(@Param("analysisType") String analysisType, @Param("gatewayIds") List<String> gatewayIds);

	List<Map<String, Object>> getSubSystemIndexInfoByParam(@Param("analysisType") String analysisType, @Param("gatewayIds") List<String> gatewayIds);

	List<Map<String, Object>> getPointNameIndexInfoByParam(@Param("analysisType") String analysisType, @Param("gatewayIds") List<String> gatewayIds);

	List<IdxBizFanHealthLevel> getHealthLevelInfoList(@Param("gatewayIds") List<String> gatewayIds);

	List<String> getAddressInfo();

	List<Map<String, Object>> queryForLeftTableList(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME,
			Integer current, Integer size);

	int queryForLeftTableListCount(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME);

	Map<String, Object> queryForLeftTableListNum(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME);

	List<Map<String, Object>> queryForLeftTableListByPoint(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME,
			String POINTNAME, Integer current, Integer size);

	List<Map<String, Object>> selectPointByANALYSISTYPE(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME,
			String POINTNAME, String startTime, String endTime);

	Map<String, Object> getFanEquipStatusByStation(String STATION);

	int queryForLeftTableListByPointCount(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME, String POINTNAME);

	Map<String, Object> queryForLeftTableListByPointNum(String STATION, String HEALTHLEVEL, String EQUIPMENTNAME,
			String POINTNAME);

	List<IdxBizFanWarningRecord> warningData(String STATION, String SUBARRAY, String EQUIPMENTNAME);

	Integer pointNum(String STATION, String SUBSYSTEM, String EQUIPMENTNAME);

	Map<String, Object> getPvEquipStatusByStation(String station);

	String getRecDateByIndexAddress(@Param("fanGatewayId") String fanGatewayId,
			@Param("indexAddress") String indexAddress, @Param("tableName") String tableName);

	List<Map<String, Object>> getInfoListByTableName(@Param("fanGatewayId") String fanGatewayId,
			@Param("indexAddress") String indexAddress, @Param("tableName") String tableName,
			@Param("recDate") String recDate,@Param("syzGatewayId") String syzGatewayId);

	int getIsWarningByPointId(@Param("indexAddress") String indexAddress, @Param("fanGatewayId") String fanGatewayId,
			@Param("tableName") String tableName,@Param("syzGatewayId") String syzGatewayId);

	List<Map<String, Object>> queryIndexByArae(String ARAE, String ANALYSISTYPE, String startTimeTop,
			String endTimeTop);

	Map<String, Object> getHealthIndexByIndexAddress(@Param("gatewayId") String gatewayId, @Param("indexAddress") String indexAddress);

	Map<String, Object> getHealthIndexByIndexAddressPv(@Param("gatewayId") String gatewayId, @Param("indexAddress") String indexAddress);
}
