package com.yeejoin.amos.boot.module.jxiop.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.module.jxiop.api.entity.CommonFile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;

/**
 * 人员资质
 *
 * @author system_generator
 * @date 2023-04-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="PersonCertificateDto", description="人员资质")
public class PersonCertificateDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "证件类型")
    private String documentType;

    @ApiModelProperty(value = "证书名称")
    private String certificateName;

    @ApiModelProperty(value = "取证时间")
    private Date certificateTime;

    @ApiModelProperty(value = "发证机关")
    private String issuingAuthority;

    @ApiModelProperty(value = "证书编号")
    private String certificateNum;

    @ApiModelProperty(value = "取证项目")
    private String certificateProject;

    @ApiModelProperty(value = "有效期限")
    private String validPeriod;

    @ApiModelProperty(value = "证书等级")
    private String certificateGrade;

    @ApiModelProperty(value = "证书附件")
    @TableField(typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> certificateAttachment;

}
