package com.yeejoin.amos.boot.module.jxiop.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 人员基本信息
 *
 * @author system_generator
 * @date 2023-04-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "person_basic",autoResultMap = true)
public class PersonBasic extends BaseEntity {

    private static final long serialVersionUID = 1L;



    /**
     * 性别( 0-男 1-女 )
     */
	@TableField("sex")
    private String sex;

    /**
     * 生日
     */
	@TableField("birthday")
    private Date birthday;

    /**
     * 年龄
     */
	@TableField("age")
    private Integer age;

    /**
     * 籍贯
     */
	@TableField("native_place")
    private String nativePlace;

    /**
     * 民族
     */
	@TableField("folk_key")
    private String folkKey;

    /**
     * 政治面貌
     */
	@TableField("politic_countenance")
    private String politicCountenance;



    /**
     * 户籍地址
     */
	@TableField("registered_residence_address")
    private String registeredResidenceAddress;

    /**
     * 现住址
     */
	@TableField("present_address")
    private String presentAddress;

    /**
     * 应急电话
     */
	@TableField("emergency_phone")
    private String emergencyPhone;
    @TableField("phone")
    private String phone;
    /**
     * 身高（厘米）
     */
	@TableField("height")
    private Integer height;

    /**
     * 体重（千克）
     */
	@TableField("weight")
    private Integer weight;

    /**
     * 参加工作时间
     */
	@TableField("work_time")
    private Date workTime;




    /**
     * 人员头像
     */
	@TableField(value="head_photo",typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> headPhoto;

    /**
     * 证件照片正面
     */
	@TableField(value = "front_certificate_photo",typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> frontCertificatePhoto;

    /**
     * 证件照片反面
     */
	@TableField(value = "back_certificate_photo",typeHandler = FastjsonTypeHandler.class)
    private List<CommonFile> backCertificatePhoto;

    /**
     * 组织机构id
     */
    @TableField("project_org_code")
    private String projectOrgCode;

    /**
     * 进入本单位工作时间
     */
    @TableField("station_work_time")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date stationWorkTime;

    /**
     * 工作所在地key
     */
    @TableField("work_place_key")
    private String workPlaceKey;


    /**
     * 岗位
     */
    @TableField("post_name")
    private String postName;

    /**
     * 赋码颜色
     */
    @TableField("qrcode_color")
    private String qrcodeColor;

    /**
     * 赋码颜色描述
     */
    @TableField("qrcode_desc")
    private String qrcodeDesc;

    /**
     * 赋码颜色描述
     */
    @TableField("qrcode_date")
    private Date qrcodeDate;

    /**
     * 缺少/过期的证书
     */
    @TableField("missing_certificate")
    private String missingCertificate;
}
