package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.jxiop.api.dto.StationBasicDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.MonitorFanIndicatorMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationPlanMapper;
import com.yeejoin.amos.boot.module.jxiop.api.util.CommonResponse;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESEquipments;
import com.yeejoin.amos.boot.module.jxiop.biz.constants.CommonConstans;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.AppletMonitorServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.MonitorFanIndicatorImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.tdmapper.IndicatorDataMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.*;

@RestController
@Api(tags = "小程序-监盘")
@RequestMapping(value = "/applet")
public class AppletMonitorController {

    @Autowired
    AppletMonitorServiceImpl appletMonitorService;
    @Autowired
    StationBasicMapper stationBasicMapper;

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "座舱")
    @GetMapping("/CockpitData")
    public ResponseModel<Map<String, Object>> getData(@RequestParam(value = "code") String code,
                                                             @RequestParam(value = "level") String level) {
        if ("station".equals(level)){
            StationBasicDto stationBasic = stationBasicMapper.getStationInfoByCode(code);
            if (stationBasic.getStationType().equals("FDZ")) {
                return ResponseHelper.buildResponse(appletMonitorService.getFanStationInfo(stationBasic));
            }else {
                return ResponseHelper.buildResponse(appletMonitorService.getPvStationInfo(stationBasic));

            }

        }else {
            return ResponseHelper.buildResponse(appletMonitorService.getAreaInfo(code));
        }

    }
}
