package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ResultsData;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.AlarmEventServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.EquipAlarmEventServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@Api(tags = "event")
@RequestMapping(value = "/event")
public class EventController {

	@Autowired
	private AlarmEventServiceImpl alarmEventServiceImpl;

	@Autowired
	private EquipAlarmEventServiceImpl equipAlarmEventServiceImpl;

	@Autowired
	private StationBasicMapper stationBasicMapper;
	
	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "故障记录API")
	@GetMapping("/equipDivergenceEventtList")
	public ResponseModel<ResultsData> equipDivergenceEventtList(@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size, @RequestParam(value = "stationId") String stationId) {
		ResultsData resultsData = new ResultsData();
		StationBasic stationBasic = stationBasicMapper.selectById(stationId);
		String fanGatewayId = stationBasic.getFanGatewayId();
		resultsData = equipAlarmEventServiceImpl.getEquipDivergenceEvent(fanGatewayId,current, size );
		return ResponseHelper.buildResponse(resultsData);
	}
	
//	@TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
//	@ApiOperation(value = "刷新字典API")
//	@GetMapping("/dic/refresh")
//	public ResponseModel<String> refresh() {
//		alarmEventServiceImpl.init();
//		return ResponseHelper.buildResponse("success");
//	}
}
