package com.yeejoin.amos.boot.module.jxiop.biz.jxdz.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "jxdz_station_daily_data", autoResultMap = true)
public class StationDailyDataEntity extends BaseEntity {
    @TableField("code")
    private String code;
    @TableField("name")
    private String name;
    /**
     * 毫秒级别时间
     */
    @TableField("date_time")
    private Long dateTime;
    /**
     * 工作票总数
     */
    @TableField("work_ticket_total_nums")
    private Double WorkTicketTotalNums;
    /**
     * 办理中工作票数
     */
    @TableField("work_ticket_processing_nums")
    private Double WorkTicketProcessingNums;
    /**
     * 已作废工作票数
     */
    @TableField("work_ticket_invalidated_nums")
    private Double WorkTicketInvalidatedNums;
    /**
     * 执行中工作票总数
     */
    @TableField("work_ticket_executing_nums")
    private Double WorkTicketExecutingNums;
    /**
     * 已终结的工作票数
     */
    @TableField("work_ticket_terminated_nums")
    private Double WorkTicketTerminatedNums;
    /**
     *定期工作任务
     */
    @TableField("regular_tasks_nums")
    private Double RegularTasksNums;
    /**
     * 巡检任务数量
     */
    @TableField("inspection_tasks_nums")
    private Double InspectionTasksNums;
    /**
     * 工单总数
     */
    @TableField("work_order_total_nums")
    private Double WorkOrderTotalNums;
    /**
     * 工单作废数
     */
    @TableField("work_order_invalidated_nums")
    private Double WorkOrderInvalidatedNums;
    /**
     * 工单待开工数
     */
    @TableField("work_order_to_be_opened_nums")
    private Double WorkOrderToBeOpenedNums;
    /**
     * 工单终结数
     */
    @TableField("work_order_terminated_nums")
    private Double WorkOrderTerminatedNums;
    /**
     * 工单开工数
     */
    @TableField("work_order_start_nums")
    private Double WorkOrderStartNums;
    /**
     * 二氧化碳减排量
     */
    @TableField("co2_emission_reduction")
    private Double Co2EmissionReduction;
    /**
     * 节约标准煤
     */
    @TableField("standard_coal_saving")
    private Double StandardCoalSaving;
    /**
     * 二氧化硫减排量
     */
    @TableField("so2_emission_reduction")
    private Double So2EmissionReduction;
    /**
     * 碳粉尘减排量
     */
    @TableField("carbon_dust_emission_reduction")
    private Double CarbonDustEmissionReduction;
    /**
     * 发电效率
     */
    @TableField("generation_efficiency")
    private Double GenerationEfficiency;
}
