package com.yeejoin.amos.boot.module.ccs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 消防车辆信息
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FireVehicleDto", description = "消防车辆信息")
public class FireVehicleDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "id")
    private String id;

    @ApiModelProperty(value = "消防资产id")
    private String mrid;

    @ApiModelProperty(value = "站点名称")
    private String stationName;

    @ApiModelProperty(value = "站点编码")
    private String stationCode;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "车辆号")
    private String number;

    @ApiModelProperty(value = "车辆类别名称")
    private String type;

    @ApiModelProperty(value = "规格型号")
    private String standard;

    @ApiModelProperty(value = "厂商")
    private String manufacturer;

    @ApiModelProperty(value = "品牌")
    private String brand;

    @ApiModelProperty(value = "国别")
    private String country;

    @ApiModelProperty(value = "底盘国别")
    private String chassisCountry;

    @ApiModelProperty(value = "底盘品牌")
    private String chassisBrand;

    @ApiModelProperty(value = "物联编码")
    private String iotCode;

    @ApiModelProperty(value = "车辆状态")
    private String state;

    @ApiModelProperty(value = "启动状态")
    private String startState;

    @ApiModelProperty(value = "最近启动时间")
    private Date lastStartDate;

    @ApiModelProperty(value = "维保单位")
    private String maintenanceUnit;

    @ApiModelProperty(value = "首次维保日期")
    private Date firstmaintenanceDate;

    @ApiModelProperty(value = "维保频率")
    private String maintenanceFrequency;

    @ApiModelProperty(value = "维保电话")
    private String maintenancePhone;

    @ApiModelProperty(value = "修改时间")
    private Date updatedate;

    @ApiModelProperty(value = "经度")
    private String lng;

    @ApiModelProperty(value = "纬度")
    private String lat;

}
