package com.yeejoin.equipmanage.common.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 
 *
 * @author wujiang
 * @date 2020-07-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_maintain_detail")
@ApiModel(value = "MaintainDetail对象", description = "")
public class MaintainDetail extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "库存明细id")
	private Long stockDetailId;

	@ApiModelProperty(value = "车辆id")
	private Long carId;

	@ApiModelProperty(value = "保养内容")
	private String content;

	@ApiModelProperty(value = "保养的数量")
	private Double amount;

	@ApiModelProperty(value = "保养天数")
	private int cycle;

	@ApiModelProperty(value = "保养周期")
	private Date nextTime;

	@ApiModelProperty(value = "保养单据id")
	private Long maintainId;

	@ApiModelProperty(value = "备注")
	private String remark;

}
