package com.yeejoin.precontrol.common.enums;

import com.alibaba.fastjson.JSONObject;

/**
 * 小程序码颜色
 *
 * @author DELL
 */
public enum SmallProQrColorEum {
    /**
     * 红
     */
    red("红", "{\"r\":\"255\",\"g\":\"0\",\"b\":\"0\"}", 0),
    /**
     * 黄
     */
    yellow("黄", "{\"r\":\"255\",\"g\":\"128\",\"b\":\"0\"}", 1),
    /**
     * 绿
     */
    green("绿", "{\"r\":\"0\",\"g\":\"128\",\"b\":\"0\"}", 2),
    /**
     * 黑
     */
    black("黑", "{\"r\":\"0\",\"g\":\"0\",\"b\":\"0\"}", 99);

    private String name;
    private String code;
    private long sqlCode;

    SmallProQrColorEum(String name, String code, long sqlCode) {
        this.name = name;
        this.code = code;
        this.sqlCode = sqlCode;
    }

    public JSONObject getCode() {
        return JSONObject.parseObject(code);
    }

    public void setPath(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getSqlCode() {
        return sqlCode;
    }
}
