package com.yeejoin.amos.boot.module.common.biz.utils;

import org.springframework.http.HttpStatus;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

public class CommonResponseUtil
{
	public static ResponseModel success()
	{	
		ResponseModel res = new ResponseModel();
        res.setDevMessage("SUCCESS");
        res.setStatus(HttpStatus.OK.value());
		return res;
	}

	public static ResponseModel success(Object obj)
	{	
		ResponseModel res = new ResponseModel();
        res.setResult(obj);
        res.setDevMessage("SUCCESS");
        res.setStatus(HttpStatus.OK.value());
		return res;
	}

	public static ResponseModel success(Object obj, String message)
	{	
		ResponseModel res = new ResponseModel();
        res.setResult(obj);
        res.setDevMessage(message);
        res.setStatus(HttpStatus.OK.value());
		return res;
	}

	public static ResponseModel failure()
	{	
		ResponseModel res = new ResponseModel();
        res.setDevMessage("FAILURE");
        res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
		return res;
	}

	public static ResponseModel failure(String message)
	{
		ResponseModel res = new ResponseModel();
        res.setDevMessage("FAILURE");
        res.setMessage(message);
        res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
		return res;
	}

	public static ResponseModel failure(Object obj, String message)
	{
		ResponseModel res = new ResponseModel();
        res.setResult(obj);
        res.setDevMessage("FAILURE");
        res.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
		return res;
	}
}
