package com.yeejoin.equipmanage.operation.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.dto.BuildSearchDTO;
import com.yeejoin.equipmanage.common.enums.GroupTypeEnum;
import com.yeejoin.equipmanage.context.SpringContextHolder;
import com.yeejoin.equipmanage.operation.PageOperation;
import com.yeejoin.equipmanage.service.IBuilldService;
import com.yeejoin.equipmanage.service.IFormInstanceService;
import com.yeejoin.equipmanage.service.impl.BuildingServiceImpl;
import com.yeejoin.equipmanage.service.impl.FormInstanceServiceImpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Author: songLei
 * @Description: groupType是allBuilding和floor的时候分页器
 * @Date: 2020/12/23 10:31
 * @Version: 1.0
 */
public class BuildBuildingPage implements PageOperation {
    @Override
    public Page apply(Page page, BuildSearchDTO dto) {
        IFormInstanceService formInstanceService = SpringContextHolder.getBean(FormInstanceServiceImpl.class);
        IBuilldService builldService = SpringContextHolder.getBean(BuildingServiceImpl.class);
        Page pageData = formInstanceService.queryPage(page,dto);
        pageData.getRecords().parallelStream().forEach(item ->{
            Map<String,Object> map = (Map<String,Object>)item;
            List<Long> instanceId = new ArrayList<>();
            instanceId.add(Long.parseLong(map.get("instanceId").toString()));
            List<Map<String,Object>> coll = formInstanceService.queryFloorRoom(instanceId);
            int floorNum = coll.parallelStream().filter(o -> o.get("groupType").equals(GroupTypeEnum.FLOOR.getType())).collect(Collectors.toList()).size();
            Long eqTotalNum = builldService.equipmentTotal(Long.valueOf(String.valueOf(map.get("instanceId").toString())),GroupTypeEnum.BUILDING.getType());
            map.put("equipmentTotal",eqTotalNum);
            map.put("floorNum",floorNum);
            builldService.files(map);
            builldService.roomNum(coll,map);
            builldService.sourceBuild(map);
        });
        return pageData;
    }
}
