package com.yeejoin.amos.fas.business.bo;

import java.math.BigDecimal;
import java.util.Date;

import lombok.Data;


/**
 * The persistent class for the fire_equipment database table.
 * 
 */
@Data
public class FireEquipmentBo  {
	private static final long serialVersionUID = 1L;
	
	/**
	 * id
	 */
	private long id;

	private Date createDate;

	private String brand;

	private String code;
	
	/**
	 * 3维坐标
	 */
	private String position3d;
	
	/**
	 * 3维楼层
	 */
	private String floor3d;

	/**
	 * 是否室内 0-否 1-是
	 */
	private Boolean isIndoor;

	private String createBy;

	private Date effectiveDate;

	private int maintenanceCycle;
	
	/**
	 * 装备分类：0-设备类；1-耗材类
	 */
	private int equipClassify;

	private String manufacturer;

	private String model;

	private String name;

	private int number;

	private String orgCode;

	private String productionArea;

	private Date productionDate;

	private String remark;

	private String room;
	
	/**
	 * 装备编码
	 */
	private String equipCode;
	
	/**
	 * 装备类型
	 */
	private String equipType;
	
	/**
	 * 监测设备状态
	 */
	private Integer equipStatus;


	private String unit;


	private String protectObjNames;
	
	/**
	 * 重量
	 */
	private BigDecimal weight;
	
	/**
	 * 动作状态
	 */
	private String actionState;
	
	/**
	 * 喷发状态
	 */
	private String eruptionState;
	
	/**
	 * 所属风险区域id
	 */
	private Long riskSourceId;

	/**
	 * ue4位置
	 */
	private String ue4Location;

	/**
	 * ue4旋转
	 */
	private String ue4Rotation;

	
}