package com.yeejoin.amos.boot.module.jcs.biz.rule.action;


import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCalledRo;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.AlertSubmittedServiceImpl;
import com.yeejoin.amos.component.rule.RuleActionBean;
import com.yeejoin.amos.component.rule.RuleMethod;
import com.yeejoin.amos.feign.systemctl.Systemctl;

/**
 * <pre>
 * 警情报送规则动作
 * </pre>
 *
 * @author gwb
 * @version $Id: AlertCalledAction.java, v 0.1 2021年6月24日 下午4:41:22 gwb Exp $
 */
@Component
@RuleActionBean(beanLabel = "警情报送")
public class AlertCalledAction {

    public static final Logger log = LoggerFactory.getLogger(AlertCalledAction.class);

    @Autowired
    private AlertSubmittedServiceImpl alertSubmittedService;

    public void sendSysMessage(String msgType, AlertCalledRo contingency) {
//        ContingencyRo ro = (ContingencyRo)contingency;
//        ro.setTelemetryMap(null);
//        ro.setTelesignallingMap(null);
//        Constructor<?> constructor;
//        try {
//            constructor = Class.forName(
//                    PACKAGEURL + result.getClass().getSimpleName() + "Message")
//                    .getConstructor(ActionResult.class);
//            AbstractActionResultMessage<?> action = (AbstractActionResultMessage<?>) constructor.newInstance(result);
//            ToipResponse toipResponse = action.buildResponse(msgType, contingency, result.toJson());
//            String topic = String.format("/%s/%s/%s", serviceName, stationName,"numberPlan");
//            log.info(String.format("mqtt[%s]:【 %s 】", topic, toipResponse.toJsonStr()));
//            webMqttComponent.publish(topic, toipResponse.toJsonStr());
//            ContingencyEvent event = new ContingencyEvent(this);
//            event.setMsgBody(toipResponse.toJsonStr());
//            event.setTopic(topic);
//            event.setMsgType(msgType);
//            event.setContingency(contingency);
//            contingencyLogPublisher.publish(event);
//
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
    }

    /**
     * 短信报送
     *
     * @param smsCode  短信模板code
     * @param sendType 发送类型
     * @param object   模板内容对象
     * @throws Exception 异常
     */
    @RuleMethod(methodLabel = "短信报送", project = "西咸机场119接处警规则")
    public void sendcmd(String smsCode, String sendType, List<Map<String,Object>> submittedList, Object object) throws Exception {

        System.out.println("接收到规则调用--------------西咸机场119接处警规则/alertCalledRule");
        alertSubmittedService.ruleCallbackAction(smsCode, submittedList, object);

    }

    public void sendAlertCalleCmd(String smsCode, Set<String> mobiles, HashMap<String, String> smsParams) {

        if (!ValidationUtil.isEmpty(mobiles)) {
            //构建短信参数
            smsParams.put("smsCode", smsCode);
            for (String mobile : mobiles) {
                smsParams.put("mobile", mobile);
                //发送短信
                Systemctl.smsClient.sendCommonSms(smsParams);
            }
        }
    }

}
