package com.yeejoin.precontrol.config;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.SwaggerDefinition;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;


import java.util.ArrayList;
import java.util.List;

/**
 * swagger配置类 模块如果需要引入则引入
 *
 * @author duanwei
 */
@Configuration
//@SwaggerDefinition
public class SwaggerConfig {
    @Bean
    public Docket api() {
        ParameterBuilder tokenPar1 = new ParameterBuilder();
        ParameterBuilder tokenPar2 = new ParameterBuilder();
        ParameterBuilder tokenPar3 = new ParameterBuilder();
        //header中的ticket参数非必填，传空也可以
        //根据每个方法名也知道当前方法在设置什么参数
        List<Parameter> pars = new ArrayList<Parameter>();
        tokenPar1.name("token").description("用户token")
                .modelRef(new ModelRef("string")).parameterType("header")
                .required(false).build();
        tokenPar2.name("appKey").description("appkey").modelRef(new ModelRef("string")).parameterType("header").defaultValue("studio_normalapp_2075166")
                .required(false).build();
        tokenPar3.name("product").description("product").modelRef(new ModelRef("string")).parameterType("header").defaultValue("STUDIO_APP_WEB")
                .required(false).build();

        pars.add(tokenPar1.build());
        pars.add(tokenPar2.build());
        pars.add(tokenPar3.build());


        return new Docket(DocumentationType.SWAGGER_2)
                .enable(true)
                .apiInfo(apiInfo())
                .select()
                .apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class))
                .paths(PathSelectors.any())
                .build().globalOperationParameters(pars);
    }

    /**
     * 构建api文档
     *
     * @return
     */
    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                //页面标题
                .title("RestFul API")
                //创建人
                .contact(new Contact("duanwei", "", ""))
                //版本号
                .version("1.0")
                //描述
                .description("API 描述")
                .build();
    }
}