package com.yeejoin.amos.boot.module.tzs.flc.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 液化气体气瓶充装信息审核
 *
 * @author system_generator
 * @date 2022-03-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_filling_examine")
public class CylinderFillingExamine extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 充装信息审核ID
     */
	@TableField("filling_examine_id")
    private String fillingExamineId;

    /**
     * 充装企业名称
     */
	@TableField("filling_unit_name")
    private String fillingUnitName;

    /**
     * 报表生成时间
     */
	@TableField("filling_audit_date")
    private String fillingAuditDate;

    /**
     * 充装审核报表附件地址
     */
	@TableField("filling_audit_url")
    private String fillingAuditUrl;

    /**
     * 充装审核报表附件名称
     */
	@TableField("filling_audit_name")
    private String fillingAuditName;

    /**
     * 同步时间  yyyy-MM-dd HH24:mi:ss
     */
	@TableField("sync_date")
    private Date syncDate;

    /**
     * 0-新增   1-更新  2-删除
     */
	@TableField("sync_state")
    private Integer syncState;

    /**
     * 对接公司编码
     */
	@TableField("app_id")
    private String appId;

    /**
     * 数据完整度
     */
    @TableField("integrity")
    private Double integrity;

}
