package com.yeejoin.amos.boot.module.tzs.flc.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 气瓶基本信息
 *
 * @author system_generator
 * @date 2021-12-14
 */
@Data

@Accessors(chain = true)
@TableName("tz_cylinder_info")
public class CylinderInfo  {

    private static final long serialVersionUID = 1L;

    @TableId(value = "sequence_nbr", type = IdType.ID_WORKER)
    protected Long sequenceNbr;

    /**
     * 气瓶基本信息ID
     */
	@TableField("cylinder_id")
    private String cylinderId;

    /**
     * 产权单位名称
     */
	@TableField("unit_name")
    private String unitName;

    /**
     * 出厂编号
     */
	@TableField("factory_num")
    private String factoryNum;

    /**
     * 气瓶状态
     */
	@TableField("cylinder_status")
    private Integer cylinderStatus;

    /**
     * 气瓶品种
     */
	@TableField("cylinder_variety")
    private Integer cylinderVariety;

    /**
     * 二维码编号
     */
	@TableField("qrCode")
    private String qrCode;

    /**
     * 电子标签编号
     */
	@TableField("electronic_label_code")
    private String electronicLabelCode;

    /**
     * 充装介质
     */
	@TableField("filling_medium")
    private String fillingMedium;

    /**
     * 公称压力(MPa）
     */
	@TableField("pressure")
    private Double pressure;

    /**
     * 容积（L）
     */
	@TableField("volume")
    private Double volume;

    /**
     * 制造日期
     */
	@TableField("manufacturing_date")
    private Date manufacturingDate;

    /**
     * 制造单位
     */
	@TableField("manufacturing_unit")
    private String manufacturingUnit;

    /**
     * 气瓶制造许可证
     */
	@TableField("license")
    private String license;

    /**
     * 气瓶重量（kg）
     */
	@TableField("cylinder_weight")
    private Double cylinderWeight;

    /**
     * 单位内部编号
     */
	@TableField("unit_inner_code")
    private String unitInnerCode;

    /**
     * 最近一次检验日期
     */
	@TableField("inspection_date")
    private Date inspectionDate;

    /**
     * 下次检验日期
     */
	@TableField("next_inspection_date")
    private Date nextInspectionDate;

    /**
     * 气瓶唯一标识码
     */
	@TableField("sequence_code")
    private String sequenceCode;

    /**
     * 同步时间  yyyy-MM-dd HH24:mi:ss
     */
	@TableField("sync_date")
    private Date syncDate;

    /**
     * 1初次同步数据   2上层系统已同步数据   0已删除数据
     */
	@TableField("sync_state")
    private Boolean syncState;

    /**
     * 对接公司编码
     */
    @TableField("app_id")
    private String appId;

    /**
     * 数据完整度
     */
    @TableField("integrity")
    private Double integrity;

    /**
     * 预警等级
     */
    private String earlyWarningLevel;

    /**
     * 预警等级 计算日期
     */
    private Date earlyWarningLevelCalDate;

	/**
	 * 经度
	 */
	@TableField("longitude")
	private String longitude;

	/**
	 * 纬度
	 */
	@TableField("latitude")
	private String latitude;

	/**
	 * 最近气瓶使用客户编号
	 */
	@TableField("end_custom_code")
	private String endCustomCode;
}
