package com.yeejoin.amos.boot.module.tzs.biz.controller;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.tzs.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.tzs.api.service.ITzBaseEnterpriseInfoService;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RestController;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.Arrays;


/**
 * 企业数据信息
 *
 * @author duanwei
 * @date 2022-08-10
 */
@RestController
@Api(tags = "企业数据信息Api")
@RequestMapping(value = "/baseEnterprise", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class TzBaseEnterpriseInfoController {

  @Autowired
  ITzBaseEnterpriseInfoService iTzBaseEnterpriseInfoService;


    /**
    * 新增企业数据信息
    * @return
    */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增企业数据信息", notes = "新增企业数据信息")
    public boolean saveTzBaseEnterpriseInfo(HttpServletRequest request, @RequestBody TzBaseEnterpriseInfo tzBaseEnterpriseInfo){
    return iTzBaseEnterpriseInfoService.save(tzBaseEnterpriseInfo);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
    return iTzBaseEnterpriseInfoService.removeById(id);
    }




    /**
    * 修改企业数据信息
    * @return
    */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改企业数据信息", notes = "修改企业数据信息")
    public boolean updateByIdTzBaseEnterpriseInfo(HttpServletRequest request, @RequestBody TzBaseEnterpriseInfo tzBaseEnterpriseInfo){
    return iTzBaseEnterpriseInfoService.updateById(tzBaseEnterpriseInfo);
    }



    /**
   * 根据id查询
   * @param id
   * @return
   */
   @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
   @RequestMapping(value = "/{id}", method = RequestMethod.GET)
   @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
   public TzBaseEnterpriseInfo selectById(HttpServletRequest request, @PathVariable Long id){
      return iTzBaseEnterpriseInfoService.getById(id);
   }



  /**
  * 列表分页查询
  * @return
  */
  @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
  @RequestMapping(value = "/list", method = RequestMethod.GET)
  @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
  public IPage<TzBaseEnterpriseInfo> listPage(String pageNum,String pageSize,
    TzBaseEnterpriseInfo tzBaseEnterpriseInfo){

    Page<TzBaseEnterpriseInfo> pageBean;
    QueryWrapper<TzBaseEnterpriseInfo> tzBaseEnterpriseInfoQueryWrapper = new QueryWrapper<>();
    Class<? extends TzBaseEnterpriseInfo> aClass = tzBaseEnterpriseInfo.getClass();
    Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
        try {
            field.setAccessible(true);
            Object o = field.get(tzBaseEnterpriseInfo);
            if (o != null) {
                Class<?> type = field.getType();
                String name = NameUtils.camel2Underline(field.getName());
                if (type.equals(Integer.class)) {
                Integer fileValue = (Integer) field.get(tzBaseEnterpriseInfo);
                tzBaseEnterpriseInfoQueryWrapper.eq(name, fileValue);
                } else if (type.equals(Long.class)) {
                Long fileValue = (Long) field.get(tzBaseEnterpriseInfo);
                tzBaseEnterpriseInfoQueryWrapper.eq(name, fileValue);
                } else if (type.equals(String.class)) {
                String fileValue = (String) field.get(tzBaseEnterpriseInfo);
                tzBaseEnterpriseInfoQueryWrapper.eq(name, fileValue);
                } else {
                String fileValue = (String) field.get(tzBaseEnterpriseInfo);
                tzBaseEnterpriseInfoQueryWrapper.eq(name, fileValue);
            }
          }
        }catch (Exception e) {
        }
    });
    IPage<TzBaseEnterpriseInfo> page;
    if (StringUtils.isBlank(pageNum)  ||StringUtils.isBlank(pageSize)) {
        pageBean = new Page<>(0, Long.MAX_VALUE);
    }else{
        pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
    }
    page = iTzBaseEnterpriseInfoService.page(pageBean, tzBaseEnterpriseInfoQueryWrapper);
    return page;
  }
}


