package com.yeejoin.amos.api.openapi.face.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.enums.EquipTypeEnum;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.EquipTechParamBoilerMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.AbstractEquipBaseEntity;
import com.yeejoin.amos.api.openapi.face.orm.entity.EquipTechParamRopeway;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class TechInfoService {

    @Autowired
    EquipTechParamBoilerService boilerService;
    @Autowired
    EquipTechParamElevatorService elevatorService;
    @Autowired
    EquipTechParamLiftingService liftingService;
    @Autowired
    EquipTechParamPipelineService pipelineService;
    @Autowired
    EquipTechParamRopewayService ropewayService;
    @Autowired
    EquipTechParamRidesService ridesService;
    @Autowired
    EquipTechParamVehicleService vehicleService;
    @Autowired
    EquipTechParamVesselService vesselService;



    public Map<String,Object> getServiceMap() {
        Map<String,Object> serviceMap = new HashMap<>();
        serviceMap.put(EquipTypeEnum.boiler.getType(),boilerService);
        serviceMap.put(EquipTypeEnum.elevator.getType(),elevatorService);
        serviceMap.put(EquipTypeEnum.lifting.getType(),liftingService);
        serviceMap.put(EquipTypeEnum.pipeline.getType(),pipelineService);
        serviceMap.put(EquipTypeEnum.ropeway.getType(),ropewayService);
        serviceMap.put(EquipTypeEnum.rides.getType(),ridesService);
        serviceMap.put(EquipTypeEnum.vehicle.getType(),vehicleService);
        serviceMap.put(EquipTypeEnum.vessel.getType(),vesselService);
        return serviceMap;
    }

    public String saveTechInfo(List<JSONObject> techInfoList){
        Map<String,Object> map = getServiceMap();
        for (JSONObject techInfo: techInfoList) {
            String type = techInfo.getString("type");
            BaseService service = (BaseService)map.get(type);
            String entityClasspath = EquipTypeEnum.classPathmap.get(type);
            try {
                Class entityClazz = Class.forName(entityClasspath);
                AbstractEquipBaseEntity entity = (AbstractEquipBaseEntity) JSON.parseObject(JSON.toJSONString(techInfo),entityClazz);
                entity.setRecDate(new Date());
                entity.setAppId(getAppId());
                service.save(entity);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "ok";
    }


    @Autowired
    private RedisTemplate redisTemplate;

    public String getAppId() {
        String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX, RequestContext.getToken());
        BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
        return bizTokenModel.getAppId();
    }

//    public String getAppId() {
//        return "HSICIOWOC";
//    }
}
