package com.yeejoin.amos.knowledgebase.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 知识库内容交互记录
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("knowledge_interaction_record")
public class KnowledgeInteractionRecord extends BaseEntity {


	/**
	 * 用户id
	 */
	@TableField("USER_ID")
	private String userId;
	/**
	 * 操作类型(点赞，吐槽，收藏)
	 */
	@TableField("OPERATE_TYPE")
	private String operateType;
	/**
	 * 关联对象类型
	 */
	@TableField("ENTITY_TYPE")
	private String entityType;
	/**
	 * 关联对象id
	 */
	@TableField("ENTITY_ID")
	private String entityId;
	/**
	 * 机构编号
	 */
	@TableField("AGENCY_CODE")
	private String agencyCode;
}

