package com.yeejoin.amos.patrol.dao.entity;

import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.annotations.Where;


/**
 * The persistent class for the p_route database table.
 * 
 */
@Entity
@Table(name="p_route")
@NamedQuery(name="Route.findAll", query="SELECT r FROM Route r")
@Where(clause="is_delete=0")//表示未删除的数据
public class Route extends BasicEntity {
	private static final long serialVersionUID = 1L;

	/**
	 * 负责人
	 */
	private String boss;
	
	/**
	 * 路线3维坐标
	 */
	private String coordinates;

	/**
	 * 路线名称
	 */
	private String name;

	/**
	 * 权限系统org code
	 */
	@Column(name="org_code")
	private String orgCode;

	/**
	 * 备注说明
	 */
	private String remark;
	
	/**
     * 创建者
     */
	@Column(name="creator_id")
	private String creatorId;

	/**
	 * 联系电话
	 */
	private String tel;

	/**
	 * 是否删除：0表示未删除，1表示已删除
	 */
	@Column(name="is_delete")
	private boolean isDelete;
	
	/**
	 * 责任部门ID
	 */
	@Column(name="dept_id")
	private String deptId;

	/**
     * 责任人ID
     */
	@Column(name="user_id")
	private String userId;

	/**
	 * 原始字段
	 */
	@Column(name = "original_id", columnDefinition = "varchar(50) COMMENT '原始字段'")
	private String originalId;

	private List<RoutePoint> routePointList;
	public Route() {
	}

	public String getBoss() {
		return this.boss;
	}

	public void setBoss(String boss) {
		this.boss = boss;
	}

	public String getCoordinates() {
		return coordinates;
	}

	public void setCoordinates(String coordinates) {
		this.coordinates = coordinates;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getTel() {
		return this.tel;
	}

	public void setTel(String tel) {
		this.tel = tel;
	}

	public String getCreatorId() {
		return creatorId;
	}

	public void setCreatorId(String creatorId) {
		this.creatorId = creatorId;
	}

	public boolean getIsDelete() {
		return isDelete;
	}

	public void setIsDelete(boolean isDelete) {
		this.isDelete = isDelete;
	}

	public String getDeptId() {
		return deptId;
	}

	public void setDeptId(String deptId) {
		this.deptId = deptId;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}
	
	@OneToMany(mappedBy = "route", cascade = {CascadeType.REMOVE})	
	public List<RoutePoint> getRoutePointList() {
		return routePointList;
	}

	public void setRoutePointList(List<RoutePoint> routePointList) {
		this.routePointList = routePointList;
	}

	public String getOriginalId() {
		return originalId;
	}

	public void setOriginalId(String originalId) {
		this.originalId = originalId;
	}
}