package com.yeejoin.equipmanage.service;

import java.util.Map;

import javax.annotation.Resource;

import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import com.google.common.collect.Maps;
import com.yeejoin.equipmanage.service.impl.CarProductionQRCode;
import com.yeejoin.equipmanage.service.impl.EquipmentProductionQRCode;

/**
 * 
 * 二维码生产
 * 
 * */
@Component
public class ProductionQRCodeFactory {
	    @Resource(name = "carProductionQRCode")
	    private ProductionQRCode carProductionQRCode;

	    @Resource(name = "equipmentProductionQRCode")
	    private ProductionQRCode equipmentProductionQRCode;
	    
	    @Bean(name = "productionQRCodeFactoryMap")
	    public Map<String, ProductionQRCode> initMessageHandMap() {
	        Map<String, ProductionQRCode> handlerMap = Maps.newHashMap();
	        handlerMap.put("car", carProductionQRCode);
	        handlerMap.put("equipment", equipmentProductionQRCode);	       
	        return handlerMap;
	    }
}
