package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.yeejoin.amos.boot.module.jcs.api.entity.Controller;
import com.yeejoin.amos.boot.module.jcs.api.entity.ControllerLog;
import com.yeejoin.amos.boot.module.jcs.api.mapper.ControllerLogMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IControllerLogService;
import com.yeejoin.amos.boot.module.jcs.api.dto.ControllerLogDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2021-12-03
 */
@Service
public class ControllerLogServiceImpl extends BaseService<ControllerLogDto, ControllerLog, ControllerLogMapper> implements IControllerLogService {
    @Autowired
    ControllerLogMapper controllerLogMapper;

    /**
     * 获取今天的记录
     */
    public List<Map<String, Object>> selectToday() {
        return controllerLogMapper.selectToday();
    }

    /**
     * 分页查询
     */
    public Page<ControllerLogDto> queryForControllerLogPage(Page<ControllerLogDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<ControllerLogDto> queryForControllerLogList() {
        return this.queryForList("", false);
    }

}