package com.yeejoin.amos.boot.module.jxiop.api.dto;

import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.CommonFile;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 户用光伏表
 *
 * @author system_generator
 * @date 2023-03-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "HouseholdPvDto", description = "户用光伏表")
public class HouseholdPvDto extends BaseDto {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "户主姓名")
	private String name;

	@ApiModelProperty(value = "户号")
	private String number;

	@ApiModelProperty(value = "厂商")
	private Long platformCompanyId;

	@ApiModelProperty(value = "厂站名称")
	private String platformCompanyName;

	@ApiModelProperty(value = "性别")
	private String sex;

	@ApiModelProperty(value = "身份证号")
	private String idNumber;

	@ApiModelProperty(value = "证件过期时间")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date expiryTime;

	@ApiModelProperty(value = "签发机关")
	private String issuingAuthority;

	@ApiModelProperty(value = "户籍地址")
	private String residenceAddress;

	@ApiModelProperty(value = "手机号码")
	private String phone;

	@ApiModelProperty(value = "居住地")
	private String address;

	@ApiModelProperty(value = "邮编")
	private String postcode;

	@ApiModelProperty(value = "身份证正面")
	@TableField(typeHandler = FastjsonTypeHandler.class)
	private List<CommonFile> idFrontPhoto;

	@ApiModelProperty(value = "身份证背面")
	@TableField(typeHandler = FastjsonTypeHandler.class)
	private List<CommonFile> idBackPhoto;

	@ApiModelProperty(value = "房屋产权证")
	@TableField(typeHandler = FastjsonTypeHandler.class)
	private List<CommonFile> housePropertyCertificate;

	@ApiModelProperty(value = "农户首页照片")
	@TableField(typeHandler = FastjsonTypeHandler.class)
	private List<CommonFile> homepagePhoto;

	@ApiModelProperty(value = "送达地址")
	private String serviceAddress;

	@ApiModelProperty(value = "组织机构code")
	private String bizOrgCode;

	@ApiModelProperty(value = "告警等级")
	private String level;

	@ApiModelProperty(value = "区域id")
	private Long districtId;

	@ApiModelProperty(value = "创建时间")
	private Date createTime;

	/** 合同信息 */
	private HouseholdPvContactDto contactInfo;
	/** 租赁物信息 */
	private HouseholdPvLeaseDto leaseInfo;
	/** 安装信息 */
	private HouseholdPvInstallDto installInfo;
	/** 设备信息 */
	private List<HouseholdPvDeviceDto> devices;

	private List<Long> ids;

	/**
	 * 安装地址
	 */
	private String  installAddress;

	/**
	 * 图片
	 */
	private String img;
}
