package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 分包商和项目交底记录情况
 *
 * @author duanwei
 * @date 2020-08-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_company_project_job_status")
@ApiModel(value = "CompanyProjectJobStatus对象", description = "分包商和项目交底记录情况")
public class CompanyProjectJobStatus extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @ApiModelProperty(value = "分包商id")
    private Long companyId;

    @ApiModelProperty(value = "交底状态")
    private Boolean status;

    @ApiModelProperty(value = "交底任务id")
    private Long taskId;


}
