package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 危险作业结果表
 *
 * @author duanwei
 * @date 2020-08-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_hazardous_work_result")
@ApiModel(value = "HazardousWorkResult对象", description = "危险作业结果表")
public class HazardousWorkResult extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "危险作业id")
    private Long hazardousWorkId;

    @ApiModelProperty(value = "危险作业名称")
    private String hazardousWorkName;

    @ApiModelProperty(value = "检查项id")
    private Long inputItemId;

    @ApiModelProperty(value = "检查项名称")
    private String inputItemName;

    @ApiModelProperty(value = "检查项答案")
    private String value;

    @ApiModelProperty(value = "是否合格 0未选择 1合格 2不合格")
    private Long isOk;

    @ApiModelProperty(value = "不合格原因")
    private String reason;

    @ApiModelProperty(value = "分数")
    private Long score;

    @ApiModelProperty(value = "权重")
    private Long weight;

    @ApiModelProperty(value = "任务ID")
    private Long taskId;

    @ApiModelProperty(value = "创建人")
    private Long cpersonId;


}
