package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

/**
 * 项目视频表
 *
 * @author duanwei
 * @date 2020-08-06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_project_video")
@ApiModel(value = "ProjectVideo对象", description = "项目视频表")
public class ProjectVideo extends BaseEntity {

    private static final long serialVersionUID = 1L;


//    @ImagePrefix
    @ApiModelProperty(value = "视频")
    private String videoUrl;

    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @ApiModelProperty(value = "摄像头用户名")
    private String username;

    @ApiModelProperty(value = "摄像头密码")
    private String password;

    @ApiModelProperty(value = "摄像头ip")
    private String ip;

    @ApiModelProperty(value = "摄像头端口")
    private Integer port;

    private String token;

    private String socket;

    private String protocol;

    @ApiModelProperty(value = "摄像头名称")
    private String alias;

}
