package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 技术文库附件
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_tech_document_attachment")
@ApiModel(value = "TechDocumentAttachment对象", description = "技术文库附件")
public class TechDocumentAttachment extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "技术文库id")
    private Long techDocumentId;
    @ApiModelProperty(value = "附件地址")
    @ImagePrefix
    private String attachment;
}
