package com.yeejoin.precontrol.common.feign;

import java.util.List;
import java.util.Map;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;


/**
 * 知识库feign
 *
 * @author Admin
 */
@FeignClient(name = "AMOS-API-KNOWLEDGEBASE")
//@FeignClient(name = "AMOS-API-KNOWLEDGEBASE", url = "http://39.100.239.237:10005")
//@FeignClient(name = "AMOS-API-KNOWLEDGEBASE", url = "http://47.92.234.253:30009")
public interface KnowledgeBaseFeign {

	@RequestMapping(value = "/knowledgebase/v1/doccontent/outer/{id}", method = RequestMethod.GET)
	ResponseModel<List<Map<String, Object>>> getDocById(@PathVariable Long id);

	@RequestMapping(value = "/knowledgebase/v1/doccontent/doclibrary/page", method = RequestMethod.GET)
	ResponseModel<Object> getDocListByCategoryId(@RequestParam("filterByCollection") boolean filterByCollection,
			@RequestParam("directoryId") Long directoryId, @RequestParam("offset") int offset,
			@RequestParam("end") int end, @RequestParam("industryType") String industryType);

	/**
	 * 知识库知识随机数查询
	 * @param directories 分类
	 * @param total 随机数量
	 * @return List<Map<String, Object>>
	 */
	@GetMapping("/knowledgebase/v1/doccontent/outer/random-list")
	ResponseModel<List<Map<String, Object>>> getRandomList(@RequestParam String directories, @RequestParam(required = false) Integer total);
}
